package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichafirma;

/**
 * FichafirmaDaoImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class FichafirmaDaoImpl implements FichafirmaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Fichafirma> rwMap = new RowMapper<Fichafirma>() {
		public Fichafirma mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Fichafirma(resultSet.getInt("IDFICHA"),
					resultSet.getInt("IDTECNICO"), resultSet.getInt("IDFITEC"),
					resultSet.getBlob("FIRMA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Pagination
	 * @return Fichafirma
	 */
	public Fichafirma add(Fichafirma Fichafirma) {
		String query = "INSERT INTO FICHASGMAOFIRMA (IDFICHA, IDTECNICO, IDFITEC, FIRMA) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, Fichafirma.getIdficha(),
				Fichafirma.getIdtecnico(), Fichafirma.getIdfitec(),
				Fichafirma.getFirmaArray());
		return Fichafirma;
	}

	/**
	 * Updates a single row in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Pagination
	 * @return Fichafirma
	 */
	public Fichafirma update(Fichafirma Fichafirma) {
		String query = "UPDATE FICHASGMAOFIRMA SET FIRMA=? WHERE IDFICHA=? AND IDTECNICO=? AND IDFITEC=?";
		this.jdbcTemplate.update(query, Fichafirma.getFirmaArray(),
				Fichafirma.getIdficha(), Fichafirma.getIdtecnico(),
				Fichafirma.getIdfitec());
		return Fichafirma;
	}

	public byte[] buscaFirma(Fichafirma Fichafirma) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.IDFICHA, t1.IDTECNICO, t1.IDFITEC, t1.FIRMA FIRMA ");
		query.append("FROM FICHASGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Fichafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<Fichafirma> planosList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
		Fichafirma firmaEncontrada = (Fichafirma) DataAccessUtils
				.uniqueResult(planosList);

		byte[] firma = null;
		Blob blob = firmaEncontrada.getFirma();
		if (blob != null)
			try {
				firma = blob.getBytes(1, (int) blob.length());
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		return firma;
	}

	/**
	 * Finds a single row in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Pagination
	 * @return Fichafirma
	 */
	@Transactional(readOnly = true)
	public Fichafirma find(Fichafirma Fichafirma) {
		String query = "SELECT t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.IDFITEC IDFITEC, t1.FIRMA FIRMA FROM FICHASGMAOFIRMA t1  WHERE t1.IDFICHA = ? AND t1.IDTECNICO=? AND t1.IDFITEC=?  ";

		List<Fichafirma> FichafirmaList = this.jdbcTemplate.query(query,
				this.rwMap, Fichafirma.getIdficha(), Fichafirma.getIdtecnico(),
				Fichafirma.getIdfitec());
		return (Fichafirma) DataAccessUtils.uniqueResult(FichafirmaList);
	}

	/**
	 * Removes a single row in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Pagination
	 * @return
	 */
	public void remove(Fichafirma Fichafirma) {
		String query = "DELETE FROM FICHASGMAOFIRMA WHERE IDFICHA=? AND IDTECNICO=? AND IDFITEC=?";
		this.jdbcTemplate.update(query, Fichafirma.getIdficha(),
				Fichafirma.getIdtecnico(), Fichafirma.getIdfitec());
	}

	/**
	 * Finds a List of rows in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichafirma> findAll(Fichafirma Fichafirma, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.IDFITEC IDFITEC, t1.FIRMA FIRMA ");
		query.append("FROM FICHASGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Fichafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichafirma>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fichafirma table.
	 * 
	 * @param Fichafirma
	 *            Fichafirma
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Fichafirma Fichafirma) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHASGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(Fichafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Fichafirma table using like.
	 * 
	 * @param Fichafirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichafirma> findAllLike(Fichafirma Fichafirma,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, t1.IDTECNICO IDTECNICO, t1.IDFITEC IDFITEC, t1.FIRMA FIRMA ");
		query.append("FROM FICHASGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(Fichafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichafirma>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fichafirma table using like.
	 * 
	 * @param Fichafirma
	 *            Fichafirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Fichafirma Fichafirma, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHASGMAOFIRMA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(Fichafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichafirma entity
	 * 
	 * @param Fichafirma
	 *            Fichafirma Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Fichafirma Fichafirma) {

		StringBuilder where = new StringBuilder(
				FichafirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Fichafirma != null && Fichafirma.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(Fichafirma.getIdficha());
		}

		if (Fichafirma != null && Fichafirma.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(Fichafirma.getIdtecnico());
		}

		if (Fichafirma != null && Fichafirma.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(Fichafirma.getIdfitec());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichafirma entity
	 * 
	 * @param Fichafirma
	 *            Fichafirma Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Fichafirma Fichafirma,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				FichafirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Fichafirma != null && Fichafirma.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(Fichafirma.getIdficha());
		}
		if (Fichafirma != null && Fichafirma.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(Fichafirma.getIdtecnico());
		}

		if (Fichafirma != null && Fichafirma.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(Fichafirma.getIdfitec());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
