package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichaejecucion;

/**
 * FichaejecucionDaoImpl generated by UDA, 13-may-2015 16:26:16.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class FichaejecucionDaoImpl implements FichaejecucionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Fichaejecucion> rwMap = new RowMapper<Fichaejecucion>() {
		public Fichaejecucion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Fichaejecucion(resultSet.getInt("IDFICEJE"),
					resultSet.getInt("IDFITEC"),
					resultSet.getTimestamp("FEINI"),
					resultSet.getTimestamp("FEFIN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return Fichaejecucion
	 */
	public Fichaejecucion add(Fichaejecucion fichaejecucion) {
		final Integer nextId = this.jdbcTemplate
				.queryForInt("SELECT FICEJEC_SEQ.NEXTVAL FROM DUAL");

		fichaejecucion.setIdficeje(nextId);

		String query = "INSERT INTO FICHAEJECUCION (IDFICEJE, IDFITEC, FEINI, FEFIN) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, fichaejecucion.getIdficeje(),
				fichaejecucion.getIdfitec(), fichaejecucion.getFeini(),
				fichaejecucion.getFefin());
		return fichaejecucion;
	}

	/**
	 * Updates a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return Fichaejecucion
	 */
	public Fichaejecucion update(Fichaejecucion fichaejecucion) {
		String query = "UPDATE FICHAEJECUCION SET  WHERE IDFITEC=? AND FEINI=? AND FEFIN=?";
		this.jdbcTemplate.update(query, fichaejecucion.getIdfitec(),
				fichaejecucion.getFeini(), fichaejecucion.getFefin());
		return fichaejecucion;
	}

	/**
	 * Finds a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return Fichaejecucion
	 */
	@Transactional(readOnly = true)
	public Fichaejecucion find(Fichaejecucion fichaejecucion) {
		String query = "SELECT t1.IDFICEJE IDFICEJE, t1.IDFITEC IDFITEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM FICHAEJECUCION t1  WHERE t1.IDFICEJE = ? ";

		List<Fichaejecucion> fichaejecucionList = this.jdbcTemplate.query(
				query, this.rwMap, fichaejecucion.getIdficeje());
		return (Fichaejecucion) DataAccessUtils
				.uniqueResult(fichaejecucionList);
	}

	/**
	 * Removes a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return
	 */
	public void remove(Fichaejecucion fichaejecucion) {
		String query = "DELETE FROM FICHAEJECUCION WHERE IDFICEJE=?";
		this.jdbcTemplate.update(query, fichaejecucion.getIdficeje());
	}

	/**
	 * Finds a List of rows in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichaejecucion> findAll(Fichaejecucion fichaejecucion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICEJE IDFICEJE, t1.IDFITEC IDFITEC,t1.FEINI FEINI,t1.FEFIN FEFIN ");
		query.append("FROM FICHAEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichaejecucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichaejecucion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Fichaejecucion fichaejecucion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHAEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fichaejecucion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Fichaejecucion table using like.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fichaejecucion> findAllLike(Fichaejecucion fichaejecucion,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDFICEJE IDFICEJE, t1.IDFITEC IDFITEC,t1.FEINI FEINI,t1.FEFIN FEFIN ");
		query.append("FROM FICHAEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fichaejecucion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fichaejecucion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fichaejecucion table using like.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Fichaejecucion fichaejecucion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHAEJECUCION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fichaejecucion,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return Fichaejecucion
	 */
	public Fichaejecucion fechasEjecCorrectas(Fichaejecucion fichaejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y ficha
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion

		// Comprobacion nueva fecha de inicio
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDFICEJE IDFICEJE, t1.IDFITEC IDFITEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM FICHAEJECUCION t1 ");

		StringBuilder where = new StringBuilder(
				" WHERE IDFITEC=? AND FEINI<? AND FEFIN>? ");
		query.append(where);

		// List<Fichaejecucion> fichasEncontrado = (List<Fichaejecucion>) new
		// Fichaejecucion();

		List<Fichaejecucion> fichasEncontrado = this.jdbcTemplate.query(
				query.toString(), this.rwMap, fichaejecucion.getIdfitec(),
				fichaejecucion.getFeini(), fichaejecucion.getFeini());
		if (fichasEncontrado.size() > 0) {
			// Ha encontrado algun registro. No se puede dar de alta la nueva
			// ejecucion
			return fichasEncontrado.get(0);
		} else {
			// no ha encontrado ningun registro. Se comprueba que nueva fecha de
			// fin.
			query = new StringBuilder(
					"SELECT t1.IDFICEJE IDFICEJE, t1.IDFITEC IDFITEC, t1.FEINI FEINI, t1.FEFIN FEFIN FROM FICHAEJECUCION t1 ");

			where = new StringBuilder(
					" WHERE IDFITEC=? AND FEINI<? AND FEFIN>? ");
			query.append(where);

			fichasEncontrado = this.jdbcTemplate.query(query.toString(),
					this.rwMap, fichaejecucion.getIdfitec(),
					fichaejecucion.getFefin(), fichaejecucion.getFefin());
			if (fichasEncontrado.size() > 0) {
				// Ha encontrado algun registro. No se puede dar de alta la
				// nueva ejecucion
				return fichasEncontrado.get(0);
			} else {
				return null;
			}

		}
	}

	/**
	 * Updates a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Pagination
	 * @return Fichaejecucion
	 */
	public Fichaejecucion modificarFechasEjec(Fichaejecucion fichaejecucion) {
		String query = "UPDATE FICHAEJECUCION SET FEINI=?, FEFIN=? WHERE IDFICEJE=?";
		this.jdbcTemplate.update(query, fichaejecucion.getFeini(),
				fichaejecucion.getFefin(), fichaejecucion.getIdficeje());
		return fichaejecucion;
	}

	/**
	 * Calcula el tiempo total de ejecucion de un ficha tecnico y actualiza el
	 * campo TIEMPOREAL de la tabla FICHATECNICO.
	 * 
	 * @param idFichaTec
	 *            Integer
	 * @return Integer
	 */
	public Boolean recalcularTiempoFichaTecnico(Integer idFichaTec) {

		String query = "SELECT SUM(ROUND((t1.FEFIN - t1.FEINI)*24*60, 2)) Dif FROM FICHAEJECUCION t1  WHERE t1.IDFITEC = ?  ";

		Integer totalMinutos = this.jdbcTemplate.queryForInt(query.toString(),
				idFichaTec);

		query = "UPDATE FICHATECNICO SET TIEMPOREAL=? WHERE IDFITEC=?";
		Integer regAct = this.jdbcTemplate.update(query, totalMinutos,
				idFichaTec);

		if (regAct > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichaejecucion entity
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Fichaejecucion fichaejecucion) {

		StringBuilder where = new StringBuilder(
				FichaejecucionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fichaejecucion != null && fichaejecucion.getIdficeje() != null) {
			where.append(" AND t1.IDFICEJE = ?");
			params.add(fichaejecucion.getIdficeje());
		}
		if (fichaejecucion != null && fichaejecucion.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(fichaejecucion.getIdfitec());
		}
		if (fichaejecucion != null && fichaejecucion.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(fichaejecucion.getFeini());
		}
		if (fichaejecucion != null && fichaejecucion.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(fichaejecucion.getFefin());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fichaejecucion entity
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Fichaejecucion fichaejecucion,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				FichaejecucionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fichaejecucion != null && fichaejecucion.getIdficeje() != null) {
			where.append(" AND t1.IDFICEJE = ?");
			params.add(fichaejecucion.getIdficeje());
		}
		if (fichaejecucion != null && fichaejecucion.getIdfitec() != null) {
			where.append(" AND t1.IDFITEC = ?");
			params.add(fichaejecucion.getIdfitec());
		}
		if (fichaejecucion != null && fichaejecucion.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(fichaejecucion.getFeini());
		}
		if (fichaejecucion != null && fichaejecucion.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(fichaejecucion.getFefin());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
