package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Agenda;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Zonas;

/**
 * FichaDaoImpl generated by UDA, 10-mar-2015 10:12:57.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class FichaDaoImpl implements FichaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Ficha> rwMap = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ficha(resultSet.getInt("IDFICHA"),
					resultSet.getLong("IDMAQUINA"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getDate("FEEJEC"),
					resultSet.getString("EJECUTADO"),
					resultSet.getLong("TIEMPOREAL"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getDate("FEINI"), resultSet.getDate("FEFIN"),
					resultSet.getString("ENVIOMAIL"),
					resultSet.getString("GUIDFICHA"),
					resultSet.getTimestamp("FECHAPLANIF"));
		}
	};
	private RowMapper<Ficha> rwMapDesc = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();
			ficha.setIdficha(resultSet.getInt("IDFICHA"));
			ficha.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			ficha.setMaquina(maquina);

			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA"));
			ficha.setGama(gama);

			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setFeejec(resultSet.getDate("FEEJEC"));
			ficha.setEjecutado(resultSet.getString("EJECUTADO"));
			ficha.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			ficha.setObservaciones(resultSet.getString("OBSERVACIONES"));
			ficha.setFeini(resultSet.getDate("FEINI"));
			ficha.setFefin(resultSet.getDate("FEFIN"));
			ficha.setEnviomail(resultSet.getString("ENVIOMAIL"));
			ficha.setGuidficha(resultSet.getString("GUIDFICHA"));
			ficha.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			return ficha;
		}
	};

	private RowMapper<Ficha> rwMapDescFicha = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();
			ficha.setIdficha(resultSet.getInt("IDFICHA"));
			ficha.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setEdifZonaPlta(resultSet.getString("LOCAL"));
			ficha.setMaquina(maquina);

			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA"));
			ficha.setGama(gama);

			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setFeejec(resultSet.getDate("FEEJEC"));
			ficha.setEjecutado(resultSet.getString("EJECUTADO"));
			ficha.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			ficha.setObservaciones(resultSet.getString("OBSERVACIONES"));
			ficha.setFeini(resultSet.getDate("FEINI"));
			ficha.setFefin(resultSet.getDate("FEFIN"));
			ficha.setEnviomail(resultSet.getString("ENVIOMAIL"));
			ficha.setGuidficha(resultSet.getString("GUIDFICHA"));
			ficha.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			return ficha;
		}
	};

	private RowMapper<Ficha> rwMapConsultaFicha = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();
			ficha.setIdficha(resultSet.getInt("IDFICHA"));
			ficha.setTecnicos(resultSet.getString("TECNICOS"));

			ficha.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setMcodigo(resultSet.getString("MCODIGO"));
			maquina.setEdifZonaPlta(resultSet.getString("LOCAL"));

			Edificios edificio = new Edificios();
			edificio.setCedificio(resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO"));
			maquina.setEdificio(edificio);

			Zonas zona = new Zonas();
			zona.setCzona(resultSet.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA"));
			maquina.setZona(zona);

			Plantas planta = new Plantas();
			planta.setCplanta(resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA"));
			maquina.setPlanta(planta);
			ficha.setMaquina(maquina);

			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA"));
			ficha.setGama(gama);

			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setFeejec(resultSet.getDate("FEEJEC"));
			ficha.setEjecutado(resultSet.getString("EJECUTADO"));
			ficha.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			ficha.setObservaciones(resultSet.getString("OBSERVACIONES"));
			ficha.setFeini(resultSet.getDate("FEINI"));
			ficha.setFefin(resultSet.getDate("FEFIN"));
			ficha.setEnviomail(resultSet.getString("ENVIOMAIL"));
			ficha.setGuidficha(resultSet.getString("GUIDFICHA"));
			ficha.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			return ficha;
		}
	};

	private RowMapper<Ficha> rwMapObtenerDatosAgendaGrid = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();
			ficha.setIdficha(resultSet.getInt("IDFICHA"));
			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setMcodigo(resultSet.getString("MCODIGO"));
			maquina.setEdifZonaPlta(resultSet.getString("LOCAL"));

			Edificios edificio = new Edificios();
			edificio.setCedificio(resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO"));
			maquina.setEdificio(edificio);

			Zonas zona = new Zonas();
			zona.setCzona(resultSet.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA"));
			maquina.setZona(zona);

			Plantas planta = new Plantas();
			planta.setCplanta(resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA"));
			maquina.setPlanta(planta);
			ficha.setMaquina(maquina);

			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA"));
			ficha.setGama(gama);

			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setFeejec(resultSet.getDate("FEEJEC"));
			ficha.setEjecutado(resultSet.getString("EJECUTADO"));
			ficha.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			ficha.setObservaciones(resultSet.getString("OBSERVACIONES"));
			ficha.setFeini(resultSet.getDate("FEINI"));
			ficha.setFefin(resultSet.getDate("FEFIN"));
			ficha.setEnviomail(resultSet.getString("ENVIOMAIL"));
			ficha.setGuidficha(resultSet.getString("GUIDFICHA"));
			ficha.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));

			Agenda agenda = new Agenda();
			agenda.setIdparte(resultSet.getInt("IDFICHA"));
			agenda.setIdtecnico(resultSet.getLong("IDTECNICO"));
			agenda.setIdpartec(resultSet.getInt("IDFITEC"));
			agenda.setFinalizado(resultSet.getString("FINAL"));
			agenda.setMovilgmao(resultSet.getString("MOVILGMAO"));
			agenda.setTecnicocontrata(resultSet.getString("TECNICO_CONTRATA"));
			agenda.setNombretecnico(resultSet.getString("NOMBRE"));
			agenda.setIdpartegmao(resultSet.getInt("IDFICHAGMAO"));
			agenda.setEstadogmao(resultSet.getString("ESTADOGMAO"));
			agenda.setFechaestadogmao(resultSet.getString("FECHAESTADO"));

			ficha.setAgenda(agenda);

			return ficha;
		}
	};

	private RowMapper<Ficha> rwMapObtenerDatosAgendaSinAsignarGrid = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();
			ficha.setIdficha(resultSet.getInt("IDFICHA"));
			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			maquina.setMcodigo(resultSet.getString("MCODIGO"));
			maquina.setEdifZonaPlta(resultSet.getString("LOCAL"));

			Edificios edificio = new Edificios();
			edificio.setCedificio(resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO"));
			maquina.setEdificio(edificio);

			Zonas zona = new Zonas();
			zona.setCzona(resultSet.getString("CZONA"));
			zona.setEzona(resultSet.getString("EZONA"));
			maquina.setZona(zona);

			Plantas planta = new Plantas();
			planta.setCplanta(resultSet.getString("CPLANTA"));
			planta.setEplanta(resultSet.getString("EPLANTA"));
			maquina.setPlanta(planta);
			ficha.setMaquina(maquina);

			Gamas gama = new Gamas();
			gama.setIdgama(resultSet.getLong("IDGAMA"));
			gama.setCgama(resultSet.getString("CGAMA"));
			gama.setEgama(resultSet.getString("EGAMA"));
			ficha.setGama(gama);

			ficha.setDescripcion(resultSet.getString("DESCRIPCION"));
			ficha.setFeejec(resultSet.getDate("FEEJEC"));
			ficha.setEjecutado(resultSet.getString("EJECUTADO"));
			ficha.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			ficha.setObservaciones(resultSet.getString("OBSERVACIONES"));
			ficha.setFeini(resultSet.getDate("FEINI"));
			ficha.setFefin(resultSet.getDate("FEFIN"));
			ficha.setEnviomail(resultSet.getString("ENVIOMAIL"));
			ficha.setGuidficha(resultSet.getString("GUIDFICHA"));
			ficha.setFechaplanif(resultSet.getTimestamp("FECHAPLANIF"));
			return ficha;
		}
	};

	private RowMapper<TablaInformes> rwMapTablaInformes = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdficha(resultSet.getInt("IDFICHA"));
			tablaInformes.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			tablaInformes.setDescripcion(resultSet.getString("DESCRIPCION"));
			tablaInformes.setFeejec(resultSet.getDate("FEEJEC"));
			tablaInformes.setEjecutado(resultSet.getString("EJECUTADO"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			tablaInformes
					.setObservaciones(resultSet.getString("OBSERVACIONES"));
			tablaInformes.setFeini(resultSet.getDate("FEINI"));
			tablaInformes.setFefin(resultSet.getDate("FEFIN"));

			tablaInformes.setRedificio(resultSet.getString("REDIFICIO"));
			tablaInformes.setRzona(resultSet.getString("RZONA"));
			tablaInformes.setRplanta(resultSet.getString("RPLANTA"));
			tablaInformes.setCmaquina(resultSet.getString("CMAQUINA"));
			tablaInformes.setEmaquina(resultSet.getString("EMAQUINA"));
			tablaInformes.setCcodigo(resultSet.getString("MCODIGO"));
			tablaInformes.setCgama(resultSet.getString("CGAMA"));
			tablaInformes.setEgama(resultSet.getString("EGAMA"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			tablaInformes.setEjecutado(resultSet.getString("EJECUTADO"));
			tablaInformes.setOperacion(resultSet.getString("OPERACION"));
			tablaInformes.setSemanas(resultSet.getLong("SEMANAS"));
			tablaInformes.setIdparte(resultSet.getInt("IDPARTE"));

			return tablaInformes;
		}
	};

	private RowMapper<TablaInformes> rwMapPrevTablaInformes = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdficha(resultSet.getInt("IDFICHA"));
			tablaInformes.setTecnico(resultSet.getString("TECNICOS"));
			tablaInformes.setFecha(resultSet.getDate("FEEJEC"));
			tablaInformes.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			tablaInformes.setCmaquina(resultSet.getString("CMAQUINA"));
			tablaInformes.setEmaquina(resultSet.getString("EMAQUINA"));
			tablaInformes.setDescripcion(resultSet.getString("DESCRIPCION"));

			tablaInformes.setFeejec(resultSet.getDate("FEEJEC"));
			tablaInformes.setEjecutado(resultSet.getString("EJECUTADO"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			tablaInformes
					.setObservaciones(resultSet.getString("OBSERVACIONES"));
			tablaInformes.setCedificio(resultSet.getString("CEDIFICIO"));
			tablaInformes.setEedificio(resultSet.getString("EEDIFICIO"));
			tablaInformes.setCzona(resultSet.getString("CZONA"));
			tablaInformes.setEzona(resultSet.getString("EZONA"));
			tablaInformes.setCplanta(resultSet.getString("CPLANTA"));
			tablaInformes.setEplanta(resultSet.getString("EPLANTA"));
			tablaInformes.setCgama(resultSet.getString("CGAMA"));
			tablaInformes.setEgama(resultSet.getString("EGAMA"));

			return tablaInformes;
		}
	};

	private RowMapper<TablaInformes> rwMapDiarioFichasTablaInformes = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setIdficha(resultSet.getInt("IDFICHA"));
			tablaInformes.setTecnico(resultSet.getString("TECNICOS"));
			tablaInformes.setFecha(resultSet.getDate("FEEJEC"));
			tablaInformes.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			tablaInformes.setCcodigo(resultSet.getString("MCODIGO"));
			tablaInformes.setCmaquina(resultSet.getString("CMAQUINA"));
			tablaInformes.setEmaquina(resultSet.getString("EMAQUINA"));
			tablaInformes.setDescripcion(resultSet.getString("DESCRIPCION"));
			tablaInformes.setCclase(resultSet.getString("CCLASE"));
			tablaInformes.setEclase(resultSet.getString("ECLASE"));

			tablaInformes.setFeejec(resultSet.getDate("FEEJEC"));
			tablaInformes.setEjecutado(resultSet.getString("EJECUTADO"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOREAL"));
			tablaInformes
					.setObservaciones(resultSet.getString("OBSERVACIONES"));
			tablaInformes.setCedificio(resultSet.getString("CEDIFICIO"));
			tablaInformes.setEedificio(resultSet.getString("EEDIFICIO"));
			tablaInformes.setCzona(resultSet.getString("CZONA"));
			tablaInformes.setEzona(resultSet.getString("EZONA"));
			tablaInformes.setCplanta(resultSet.getString("CPLANTA"));
			tablaInformes.setEplanta(resultSet.getString("EPLANTA"));
			tablaInformes.setCgama(resultSet.getString("CGAMA"));
			tablaInformes.setEgama(resultSet.getString("EGAMA"));

			return tablaInformes;
		}
	};

	private RowMapper<TablaInformes> rwMapFichasEjecTablaInformes = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setTecnico(resultSet.getString("TECNICOS"));

			tablaInformes.setFeejec(resultSet.getDate("FECHAEJTECFICHAMAX"));
			tablaInformes.setTiempo(resultSet.getLong("TIEMPOTECFICHA"));
			tablaInformes.setIdficha(resultSet.getInt("IDFICHA"));
			tablaInformes.setCcodigo(resultSet.getString("MCODIGO"));
			tablaInformes.setCmaquina(resultSet.getString("CMAQUINA"));
			tablaInformes.setEmaquina(resultSet.getString("EMAQUINA"));
			tablaInformes.setFecre(resultSet.getDate("FEEJEC"));
			tablaInformes.setTiemporeal(resultSet.getLong("TIEMPOFICHA"));
			tablaInformes.setEjecutado(resultSet
					.getString("EJECTECFICHAFINALIZADA"));

			return tablaInformes;
		}
	};

	private RowMapper<TablaInformes> rwMapTablaInformesTecnicos = new RowMapper<TablaInformes>() {
		public TablaInformes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TablaInformes tablaInformes = new TablaInformes();

			tablaInformes.setNombre(resultSet.getString("NOMBRE"));

			return tablaInformes;
		}
	};

	private RowMapper<Ficha> rwMapFechaEjec = new RowMapper<Ficha>() {
		public Ficha mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Ficha ficha = new Ficha();

			ficha.setFeejec(resultSet.getTimestamp("FEFINMAX"));

			return ficha;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return Ficha
	 */
	public Ficha add(Ficha ficha) {

		// Obtener el id correlativo
		Integer idCorrelativo = this.jdbcTemplate
				.queryForInt("SELECT FICHA_SEQ.NEXTVAL FROM DUAL");

		ficha.setIdficha(idCorrelativo);

		String query = "INSERT INTO FICHA (IDFICHA, IDMAQUINA, DESCRIPCION, FEEJEC, EJECUTADO, TIEMPOREAL, OBSERVACIONES, FEINI, FEFIN, ENVIO_MAIL, GUIDFICHA, FECHAPLANIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ficha.getIdficha(),
				ficha.getIdmaquina(), ficha.getDescripcion(),
				ficha.getFeejec(), ficha.getEjecutado(), ficha.getTiemporeal(),
				ficha.getObservaciones(), ficha.getFeini(), ficha.getFefin(),
				ficha.getEnviomail() == null ? "0" : ficha.getEnviomail(),
				ficha.getGuidficha(), ficha.getFechaplanif());
		return ficha;
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return Ficha
	 */
	public Ficha update(Ficha ficha) {
		String query = "UPDATE FICHA SET IDMAQUINA=?, DESCRIPCION=?, FEEJEC=?, EJECUTADO=?, TIEMPOREAL=?, OBSERVACIONES=?, FEINI=?, FEFIN=?, ENVIO_MAIL=?, GUIDFICHA WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getIdmaquina(),
				ficha.getDescripcion(), ficha.getFeejec(),
				ficha.getEjecutado(), ficha.getTiemporeal(),
				ficha.getObservaciones(), ficha.getFeini(), ficha.getFefin(),
				ficha.getEnviomail(), ficha.getGuidficha(), ficha.getIdficha());
		return ficha;
	}

	public Ficha actualizarFechaPlanificacion(Ficha ficha) {
		String query = "UPDATE FICHA SET FECHAPLANIF=? WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getFechaplanif(),
				ficha.getIdficha());
		return ficha;
	}

	public Ficha actualizarUUIDficha(Ficha ficha) {
		String query = "UPDATE FICHA SET GUIDFICHA=? WHERE IDFICHA=? ";
		this.jdbcTemplate.update(query, ficha.getGuidficha(),
				ficha.getIdficha());
		return ficha;
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return Ficha
	 */
	public Ficha modificarObserv(Ficha ficha) {
		String query = "UPDATE FICHA SET OBSERVACIONES=? WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getObservaciones(),
				ficha.getIdficha());
		return ficha;
	}

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return Ficha
	 */
	@Transactional(readOnly = true)
	public Ficha find(Ficha ficha) {
		String query = "SELECT t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF  FROM FICHA t1, MAQUINAS t2, GAMAS t3  WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDGAMA=t3.IDGAMA AND t1.IDFICHA = ?  ";

		List<Ficha> fichaList = this.jdbcTemplate.query(query, this.rwMapDesc,
				ficha.getIdficha());
		return (Ficha) DataAccessUtils.uniqueResult(fichaList);
	}

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return Ficha
	 */
	@Transactional(readOnly = true)
	public Ficha findFichaByGuid(Ficha ficha) {
		String query = "SELECT t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF  FROM FICHA t1 WHERE t1.GUIDFICHA = ?  ";

		List<Ficha> fichaList = this.jdbcTemplate.query(query, this.rwMap,
				ficha.getGuidficha());
		return (Ficha) DataAccessUtils.uniqueResult(fichaList);
	}

	/**
	 * obtener la fecha de la última de ejecucion de una ficha
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Ficha obtenerFechaEjecucion(Ficha ficha) {

		// String query =
		// "SELECT DISTINCT (select max(TRUNC(t1.fefin)) from FICHAEJECUCION t1 WHERE t1.IDFITEC = t2.IDFITEC) as FEFINMAX from FICHATECNICO t2 where t2.idficha =?";
		String query = "SELECT DISTINCT MAX(T2.fefin) AS FEFINMAX from FICHATECNICO T1, FICHAEJECUCION T2 WHERE T1.IDFITEC=T2.IDFITEC AND T1.idficha=?";

		List<Ficha> fichasList = this.jdbcTemplate.query(query,
				this.rwMapFechaEjec, ficha.getIdficha());

		Ficha fichaAux = new Ficha();
		fichaAux = (Ficha) DataAccessUtils.uniqueResult(fichasList);
		if (fichaAux != null && fichaAux.getFeejec() != null) {
			return (Ficha) DataAccessUtils.uniqueResult(fichasList);
		} else {

			String query2 = "SELECT FEEJEC AS FEFINMAX from FICHA T1 WHERE T1.idficha=?";

			List<Ficha> fichasList2 = this.jdbcTemplate.query(query2,
					this.rwMapFechaEjec, ficha.getIdficha());

			return (Ficha) DataAccessUtils.uniqueResult(fichasList2);

		}
	}

	/**
	 * finalizar la ficha Padre
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	public Ficha finalizarFicha(Ficha ficha) {

		// Actualizar la ficha
		String query = "UPDATE FICHA SET EJECUTADO=1, FEEJEC=?, TIEMPOREAL=? WHERE IDFICHA=?";

		this.jdbcTemplate.update(query, ficha.getFeejec(),
				ficha.getTiemporeal(), ficha.getIdficha());
		return ficha;

	}

	/**
	 * abre la ficha.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	public Ficha abrirFicha(Ficha ficha) {

		String query = "UPDATE FICHA SET EJECUTADO=0 WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getIdficha());

		return ficha;

	}

	/**
	 * Removes a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Pagination
	 * @return
	 */
	public void remove(Ficha ficha) {
		String query = "DELETE FROM FICHA WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getIdficha());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ficha> findAll(Ficha ficha, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.DESCRIPCION DESCRIPCION,t1.FEEJEC FEEJEC,t1.EJECUTADO EJECUTADO,t1.TIEMPOREAL TIEMPOREAL,t1.OBSERVACIONES OBSERVACIONES,t1.FEINI FEINI,t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF ");
		query.append("FROM FICHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ficha);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Ficha> findAllpendientes(Ficha ficha, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.DESCRIPCION DESCRIPCION,t1.FEEJEC FEEJEC,t1.EJECUTADO EJECUTADO,t1.TIEMPOREAL TIEMPOREAL,t1.OBSERVACIONES OBSERVACIONES,t1.FEINI FEINI,t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF ");
		query.append("FROM FICHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ficha);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * 
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaFicha(String idioma,
			Ficha filtro) {
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT t1.IDFICHA IDFICHA,  t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA, NVL(t2.EMAQUINA, t2.CMAQUINA) EMAQUINA,  t1.DESCRIPCION DESCRIPCION,  t1.FEEJEC FEEJEC,  t1.EJECUTADO EJECUTADO,  t1.TIEMPOREAL TIEMPOREAL,  t1.OBSERVACIONES OBSERVACIONES,  t1.FEINI FEINI,  t1.FEFIN FEFIN  "
		 * ); query.append(" FROM FICHA t1, MAQUINAS t2 ");
		 */
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDFICHA IDFICHA, t1.idparte idparte, t6.idmaquina, t6.feejec, t6.observaciones, t6.descripcion, t6.tiemporeal, t6.feini, t6.fefin, t6.ejecutado, ");

		query.append(" t2.idmaquina, t2.mcodigo, t2.sig_mto, t2.cmaquina, t2.emaquina, t3.cgama, t3.egama, t8.redificio, t7.rplanta, t4.rzona, t4.czona, t4.ezona, t5.operacion, t5.semanas, t1.descripcion, t1.fecha, t1.tiempo ");
		query.append(" FROM  ((((Actuacion t1 INNER JOIN ((((Maquinas t2 INNER JOIN Gamas t3 ON t2.idgama = t3.idgama) ");
		query.append(" LEFT JOIN Zonas t4 ON t2.idzona = t4.idzona) LEFT JOIN Plantas t7 ON t2.idplanta = t7.idplanta) LEFT JOIN Edificios t8 ON t2.idedificio = t8.idedificio) ON t1.idmaquina = t2.idmaquina) ");
		query.append(" INNER JOIN Cuestionario t5 ON t1.idcuestionario = t5.idcuestionario) ");
		query.append(" INNER JOIN Ficha t6 ON t1.idficha= t6.idficha)) ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(filtro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTablaInformes, params.toArray());
	}

	/**
	 * obtener los tecnicos asociados a una ficha.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * 
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaFichaTecnicos(
			String idioma, Ficha filtro) {
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT t1.IDFICHA IDFICHA,  t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA, NVL(t2.EMAQUINA, t2.CMAQUINA) EMAQUINA,  t1.DESCRIPCION DESCRIPCION,  t1.FEEJEC FEEJEC,  t1.EJECUTADO EJECUTADO,  t1.TIEMPOREAL TIEMPOREAL,  t1.OBSERVACIONES OBSERVACIONES,  t1.FEINI FEINI,  t1.FEFIN FEFIN  "
		 * ); query.append(" FROM FICHA t1, MAQUINAS t2 ");
		 */
		StringBuilder query = new StringBuilder("SELECT t3.nombre NOMBRE ");

		query.append(" FROM Ficha t1 INNER JOIN FICHATECNICO t2 ON t1.idficha = t2.idficha ");
		query.append(" INNER JOIN TECNICOS t3 ON t2.idtecnico  = t3.idtecnico ");

		StringBuilder where = new StringBuilder(" WHERE t1.IDFICHA=? ");
		query.append(where);

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapTablaInformesTecnicos,
				filtro.getIdficha());
	}

	/**
	 * Counts rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ficha ficha) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ficha);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ficha> findAllLike(Ficha ficha, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.DESCRIPCION DESCRIPCION,t1.FEEJEC FEEJEC,t1.EJECUTADO EJECUTADO,t1.TIEMPOREAL TIEMPOREAL,t1.OBSERVACIONES OBSERVACIONES,t1.FEINI FEINI,t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA ");
		query.append("FROM FICHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ficha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ficha ficha, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ficha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@Transactional(readOnly = true)
	public Ficha findFicha(Ficha ficha) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL, t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF ");
		query.append(" , t8.REDIFICIO || '/' ||  CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END as LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8  ");
		query.append(" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO=t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+)AND t1.IDFICHA = ?  ");

		List<Ficha> fichaList = this.jdbcTemplate.query(query.toString(),
				this.rwMapDescFicha, ficha.getIdficha());
		return (Ficha) DataAccessUtils.uniqueResult(fichaList);
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	public void marcarEnvioMail(Ficha ficha) {
		String query = "UPDATE FICHA SET ENVIO_MAIL='1' WHERE IDFICHA=?";
		this.jdbcTemplate.update(query, ficha.getIdficha());
	}

	/**
	 * Calcula el numero de partes preventivos(fichas) pendientes de asignar
	 * tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long calculaPrevPendATC(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT t1.IDFICHA) FROM FICHA t1, MAQUINAS t2, EDIFICIOSVER t3, GAMAS t4  ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA  =t2.IDMAQUINA AND t2.IDEDIFICIO = t3.IDEDIFICIO AND t2.IDGAMA = t4.IDGAMA AND t3.UID_PER=? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t4.IDSERVICIO=? ");
		}

		if (idClase != null && idClase != 0) {
			where.append(" AND t4.IDCLASE= " + idClase);
		}

		where.append(" AND t1.IDFICHA NOT  IN (SELECT DISTINCT t5.IDFICHA FROM FICHATECNICO t5) ");
		query.append(where);
		Long total = (long) 0;

		if (idServicio != null && idServicio != 0) {
			total = this.jdbcTemplate.queryForLong(query.toString(),
					UIDUsuario, idServicio);
		} else {
			total = this.jdbcTemplate
					.queryForLong(query.toString(), UIDUsuario);
		}

		return total;
	}

	/**
	 * Calcula el numero de partes preventivos(fichas) asignados pendientes de
	 * ejecutar
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long calculaPrevAsigPendEjec(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT t1.IDFICHA) FROM FICHA t1, MAQUINAS t2, EDIFICIOSVER t3, GAMAS t4, FICHATECNICO t5  ");

		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA  =t2.IDMAQUINA AND t2.IDEDIFICIO = t3.IDEDIFICIO AND t2.IDGAMA = t4.IDGAMA AND t1.IDFICHA = t5.IDFICHA AND t3.UID_PER=? ");
		if (idServicio != null && idServicio != 0) {
			where.append(" AND t4.IDSERVICIO=? ");
		}
		if (idClase != null && idClase != 0) {
			where.append(" AND t4.IDCLASE= " + idClase);
		}

		where.append(" AND (t1.EJECUTADO=0 OR t1.EJECUTADO IS NULL) ");
		query.append(where);
		Long total = (long) 0;

		if (idServicio != null && idServicio != 0) {
			total = this.jdbcTemplate.queryForLong(query.toString(),
					UIDUsuario, idServicio);
		} else {
			total = this.jdbcTemplate
					.queryForLong(query.toString(), UIDUsuario);
		}

		return total;
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ficha> obtenerPrevPendAsignar(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, '' as TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF, t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(fichas, startsWith);
		StringBuilder where = new StringBuilder(
				"WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND t1.IDFICHA NOT IN (SELECT DISTINCT t10.IDFICHA FROM FICHATECNICO t10) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMapConsultaFicha, params.toArray());
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ficha> obtenerFichasGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF, t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(fichas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario + "' ");

		// Si viene la marca conTecnicos aÃ±adir la tabla FICHATECNICOS
		if (fichas != null && fichas.getConTecnicos() != null
				&& fichas.getConTecnicos().equals("1")) {
			// partes que tienen tecnicos asignados
			where.append(" AND t1.IDFICHA in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		} else if (fichas != null && fichas.getConTecnicos() != null
				&& fichas.getConTecnicos().equals("0")) {
			// partes que no tienen tecnicos asignados
			where.append(" AND t1.IDFICHA not in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN, t1.ENVIO_MAIL, t1.GUIDFICHA,t1.FECHAPLANIF, t8.REDIFICIO, t4.RZONA, t7.RPLANTA ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMapConsultaFicha, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Ficha> obtenerDatosAgendaGrid(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario,
			boolean conTecnicos, List<Tecnicos> listaTecnicosBusq) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, t1.DESCRIPCION DESCRIPCION, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF,  t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");

		if (conTecnicos) {
			query.append(", t11.FINAL FINAL,t11.IDTECNICO IDTECNICO, t11.IDFITEC IDFITEC, t12.MOVILGMAO MOVILGMAO, t12.TECNICO_CONTRATA TECNICO_CONTRATA, t12.NOMBRE NOMBRE ");
			query.append(", t13.IDFICHA IDFICHAGMAO, t13.ESTADOGMAO ESTADOGMAO, t13.FECHAESTADO FECHAESTADO ");
		}
		if (conTecnicos) {
			query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12, FICHATECNICOSGMAO t13 ");
		} else {
			query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9 ");
		}

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMapAgenda(fichas,
				startsWith, conTecnicos);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario + "' ");

		if (conTecnicos) {
			where.append(" AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t11.IDFITEC=t13.IDFITEC(+) AND t12.BAJA = 0 AND t11.IDTECNICO IN ");
			where.append(" (");
			for (int i = 0; i < listaTecnicosBusq.size(); i++) {
				Tecnicos tecnicoAux = new Tecnicos();
				tecnicoAux = listaTecnicosBusq.get(i);
				if (tecnicoAux != null && tecnicoAux.getIdtecnico() != null) {
					if (i != 0) {
						where.append(",");
					}
					where.append(tecnicoAux.getIdtecnico());
				}
			}
			where.append(")");

		} else {
			where.append(" AND t1.IDFICHA not in (Select t16.IDFICHA FROM FICHATECNICO t16) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		if (conTecnicos) {
			query.append(" ORDER BY t11.IDTECNICO asc ");
		} else {
			query.append(" ORDER BY t1.IDFICHA asc ");
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		if (conTecnicos) {
			return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
					this.rwMapObtenerDatosAgendaGrid, params.toArray());
		} else {
			return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
					this.rwMapObtenerDatosAgendaSinAsignarGrid,
					params.toArray());
		}
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerPrevPendAsignarCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(ficha, startsWith);
		StringBuilder where = new StringBuilder(
				"WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND t1.IDFICHA NOT IN (SELECT DISTINCT t10.IDFICHA FROM FICHATECNICO t10) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerFichasGridCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t1.GUIDFICHA GUIDFICHA,t1.FECHAPLANIF FECHAPLANIF, t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(ficha, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario + "' ");

		// Si viene la marca conTecnicos aÃ±adir la tabla FICHATECNICOS
		if (ficha != null && ficha.getConTecnicos() != null
				&& ficha.getConTecnicos().equals("1")) {
			// partes que tienen tecnicos asignados
			where.append(" AND t1.IDFICHA in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		} else if (ficha != null && ficha.getConTecnicos() != null
				&& ficha.getConTecnicos().equals("0")) {
			// partes que no tienen tecnicos asignados
			where.append(" AND t1.IDFICHA not in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN, t1.ENVIO_MAIL,t1.GUIDFICHA,t1.FECHAPLANIF, t8.REDIFICIO, t4.RZONA, t7.RPLANTA) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ficha> obtenerPrevAsigPendEjec(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t1.GUIDFICHA GUIDFICHA, t1.FECHAPLANIF FECHAPLANIF, t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(fichas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND (t1.EJECUTADO=0 OR t1.EJECUTADO IS NULL) ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN,t1.ENVIO_MAIL, t1.GUIDFICHA, t1.FECHAPLANIF, t8.REDIFICIO,  t4.RZONA, t7.RPLANTA ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ficha>) this.jdbcTemplate.query(query.toString(),
				this.rwMapConsultaFicha, params.toArray());
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerPrevAsigPendEjecCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(ficha, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND (t1.EJECUTADO=0 OR t1.EJECUTADO IS NULL) ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN, t1.ENVIO_MAIL, t8.REDIFICIO, t4.RZONA, t7.RPLANTA) ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaPrevPendAsignar(
			String idioma, Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, '' as TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				"WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND t1.IDFICHA NOT IN (SELECT DISTINCT t10.IDFICHA FROM FICHATECNICO t10) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" order by FEEJEC");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate
				.query(query.toString(), this.rwMapPrevTablaInformes,
						params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaPrevAsigPendEjec(
			String idioma, Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario);
		where.append("' AND (t1.EJECUTADO=0 OR t1.EJECUTADO IS NULL) ");

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN, t1.ENVIO_MAIL, t8.REDIFICIO, t4.RZONA, t7.RPLANTA ");

		query.append(" order by FEEJEC");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate
				.query(query.toString(), this.rwMapPrevTablaInformes,
						params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaPreventivos(String idioma,
			Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDFICHA IDFICHA, (RTRIM(XMLAGG(xmlelement(X, t12.NOMBRE || ',') ORDER BY t12.NOMBRE).extract('//text()'), ',')) AS TECNICOS, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario + "' ");

		// Si viene la marca conTecnicos aÃ±adir la tabla FICHATECNICOS
		if (filtro != null && filtro.getConTecnicos() != null
				&& filtro.getConTecnicos().equals("1")) {
			// partes que tienen tecnicos asignados
			where.append(" AND t1.IDFICHA in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		} else if (filtro != null && filtro.getConTecnicos() != null
				&& filtro.getConTecnicos().equals("0")) {
			// partes que no tienen tecnicos asignados
			where.append(" AND t1.IDFICHA not in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" GROUP BY t1.IDFICHA, t1.IDMAQUINA, t2.CMAQUINA, t2.EMAQUINA, t2.MCODIGO, t8.CEDIFICIO, t8.EEDIFICIO, t4.CZONA, t4.EZONA, t7.CPLANTA, t7.EPLANTA,  t3.IDGAMA, t3.CGAMA, t3.EGAMA, t1.DESCRIPCION, t1.FEEJEC, t1.EJECUTADO, t1.TIEMPOREAL, t1.OBSERVACIONES, t1.FEINI, t1.FEFIN, t1.ENVIO_MAIL, t8.REDIFICIO, t4.RZONA, t7.RPLANTA ");

		query.append(" order by FEEJEC");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate
				.query(query.toString(), this.rwMapPrevTablaInformes,
						params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaDiarioFichas(
			String idioma, Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t12.NOMBRE AS TECNICOS, t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t2.MCODIGO MCODIGO, tCLASE.CCLASE CCLASE, tCLASE.ECLASE ECLASE, t8.CEDIFICIO CEDIFICIO, t8.EEDIFICIO EEDIFICIO, t4.CZONA CZONA, t4.EZONA EZONA, t7.CPLANTA CPLANTA, t7.EPLANTA EPLANTA,  t3.IDGAMA IDGAMA, t3.CGAMA CGAMA, t3.EGAMA EGAMA, t1.DESCRIPCION DESCRIPCION, t1.FEEJEC FEEJEC, t1.EJECUTADO EJECUTADO, t1.TIEMPOREAL TIEMPOREAL, t1.OBSERVACIONES OBSERVACIONES, t1.FEINI FEINI, t1.FEFIN FEFIN, t1.ENVIO_MAIL ENVIOMAIL , t8.REDIFICIO || '/' || CASE WHEN t4.RZONA='0' THEN '' ELSE t4.RZONA END || '/' || CASE WHEN t7.RPLANTA='0' THEN '' ELSE t7.RPLANTA END AS LOCAL ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12, CLASE tCLASE ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA(+) AND t3.IDCLASE = tCLASE.IDCLASE(+) AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t9.UID_PER = '"
						+ UIDUsuario + "' ");

		// Si viene la marca conTecnicos aÃ±adir la tabla FICHATECNICOS
		if (filtro != null && filtro.getConTecnicos() != null
				&& filtro.getConTecnicos().equals("1")) {
			// partes que tienen tecnicos asignados
			where.append(" AND t1.IDFICHA in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		} else if (filtro != null && filtro.getConTecnicos() != null
				&& filtro.getConTecnicos().equals("0")) {
			// partes que no tienen tecnicos asignados
			where.append(" AND t1.IDFICHA not in (Select t13.IDFICHA FROM FICHATECNICO t13) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" order by TECNICOS,CEDIFICIO,CZONA,CPLANTA,CGAMA,MCODIGO");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapDiarioFichasTablaInformes,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaFichasEjecutadas(
			String idioma, Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT max(TRUNC(t13.FEFIN)) AS FECHAEJTECFICHAMAX, t11.TIEMPOREAL AS TIEMPOTECFICHA, t12.NOMBRE AS TECNICOS, t1.IDFICHA IDFICHA, t2.MCODIGO MCODIGO, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t1.FEEJEC FEEJEC, t1.TIEMPOREAL TIEMPOFICHA, t11.FINAL EJECTECFICHAFINALIZADA ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12, FICHAEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t11.IDFITEC=t13.IDFITEC(+)");
		where.append(" AND t1.EJECUTADO='1' AND t9.UID_PER = '" + UIDUsuario
				+ "' ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY T11.TIEMPOREAL, t12.NOMBRE ,t1.IDFICHA, t1.IDFICHA, t2.MCODIGO, t2.CMAQUINA, t2.EMAQUINA, t1.FEEJEC, t1.TIEMPOREAL, t11.FINAL ");
		query.append(" having MAX(t13.FEFIN) is not null ");
		query.append(" ORDER BY TECNICOS,IDFICHA ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapFichasEjecTablaInformes,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	@Transactional(readOnly = true)
	public ArrayList<TablaInformes> montarSelectTablaFichasEjecutadasDetalle(
			String idioma, Ficha filtro, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT max(TRUNC(t13.FEFIN)) AS FECHAEJTECFICHAMAX, t11.TIEMPOREAL AS TIEMPOTECFICHA, t12.NOMBRE AS TECNICOS, t1.IDFICHA IDFICHA, t2.MCODIGO MCODIGO, t2.CMAQUINA CMAQUINA, t2.EMAQUINA EMAQUINA, t1.FEEJEC FEEJEC, t1.TIEMPOREAL TIEMPOFICHA, t11.FINAL EJECTECFICHAFINALIZADA ");
		query.append(" FROM FICHA t1, MAQUINAS t2, GAMAS t3, ZONAS t4, PLANTAS t7, EDIFICIOS t8, EDIFICIOSVER t9, FICHATECNICO t11, TECNICOS t12, FICHAEJECUCION t13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereConsultaMap(filtro, false);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDMAQUINA=t2.IDMAQUINA AND t2.IDEDIFICIO=t9.IDEDIFICIO AND t1.IDFICHA=t11.IDFICHA(+) AND t11.IDTECNICO=t12.IDTECNICO(+) AND t2.IDGAMA=t3.IDGAMA AND t2.IDEDIFICIO =t8.IDEDIFICIO(+) AND t2.IDZONA=t4.IDZONA(+) AND t2.IDPLANTA=t7.IDPLANTA(+) AND t11.IDFITEC=t13.IDFITEC(+)");
		where.append(" AND t1.EJECUTADO='1' AND t9.UID_PER = '" + UIDUsuario
				+ "' ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" GROUP BY T11.TIEMPOREAL, t12.NOMBRE ,t1.IDFICHA, t1.IDFICHA, t2.MCODIGO, t2.CMAQUINA, t2.EMAQUINA, t1.FEEJEC, t1.TIEMPOREAL, t11.FINAL ");
		query.append(" having MAX(t13.FEFIN) is not null ");
		query.append(" ORDER BY FECHAEJTECFICHAMAX,TECNICOS ");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (ArrayList<TablaInformes>) this.jdbcTemplate.query(
				query.toString(), this.rwMapFichasEjecTablaInformes,
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ficha entity
	 * 
	 * @param ficha
	 *            Ficha Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Ficha ficha) {

		StringBuilder where = new StringBuilder(
				FichaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ficha != null && ficha.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(ficha.getIdficha());
		}
		if (ficha != null && ficha.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(ficha.getIdmaquina());
		}
		if (ficha != null && ficha.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(ficha.getDescripcion());
		}
		if (ficha != null && ficha.getFeejec() != null) {
			where.append(" AND t1.FEEJEC = ?");
			params.add(ficha.getFeejec());
		}
		if (ficha != null && ficha.getEjecutado() != null) {
			where.append(" AND t1.EJECUTADO = ?");
			params.add(ficha.getEjecutado());
		}
		if (ficha != null && ficha.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(ficha.getTiemporeal());
		}
		if (ficha != null && ficha.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(ficha.getObservaciones());
		}
		if (ficha != null && ficha.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(ficha.getFeini());
		}
		if (ficha != null && ficha.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(ficha.getFefin());
		}
		if (ficha != null && ficha.getEnviomail() != null) {
			if (ficha.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(ficha.getEnviomail());
			} else if (ficha.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}

		if (ficha != null && ficha.getGuidficha() != null) {
			where.append(" AND t1.GUIDFICHA = ?");
			params.add(ficha.getGuidficha());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ficha entity
	 * 
	 * @param ficha
	 *            Ficha Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Ficha ficha, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				FichaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ficha != null && ficha.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(ficha.getIdficha());
		}
		if (ficha != null && ficha.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(ficha.getIdmaquina());
		}
		if (ficha != null && ficha.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getDescripcion().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getDescripcion().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (ficha != null && ficha.getFeejec() != null) {
			where.append(" AND t1.FEEJEC = ?");
			params.add(ficha.getFeejec());
		}
		if (ficha != null && ficha.getEjecutado() != null) {
			where.append(" AND UPPER(t1.EJECUTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getEjecutado().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getEjecutado().toUpperCase() + "%");
			}
			where.append(" AND t1.EJECUTADO IS NOT NULL");
		}
		if (ficha != null && ficha.getTiemporeal() != null) {
			where.append(" AND t1.TIEMPOREAL = ?");
			params.add(ficha.getTiemporeal());
		}
		if (ficha != null && ficha.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (ficha != null && ficha.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(ficha.getFeini());
		}
		if (ficha != null && ficha.getFefin() != null) {
			where.append(" AND t1.FEFIN = ?");
			params.add(ficha.getFefin());
		}
		if (ficha != null && ficha.getEnviomail() != null) {
			if (ficha.getEnviomail().equals("1")) {
				where.append(" AND t1.ENVIO_MAIL = ?");
				params.add(ficha.getEnviomail());
			} else if (ficha.getEnviomail().equals("0")) {
				where.append(" AND t1.ENVIO_MAIL != 1");
			}
		}
		if (ficha != null && ficha.getGama() != null
				&& ficha.getGama().getIdservicio() != null
				&& ficha.getGama().getIdservicio() != 0) {
			where.append(" AND t3.IDSERVICIO = ?");
			params.add(ficha.getGama().getIdservicio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ficha entity
	 * 
	 * @param ficha
	 *            Ficha Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereConsultaMap(Ficha ficha, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				FichaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ficha != null && ficha.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(ficha.getIdficha());
		}
		if (ficha != null && ficha.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(ficha.getIdmaquina());
		}
		if (ficha != null && ficha.getFechaD() != null
				&& !ficha.getFechaD().equals("")) {
			where.append(" AND t1.FEEJEC >= ?");
			params.add(ficha.getFechaD());
		}
		if (ficha != null && ficha.getFechaH() != null
				&& !ficha.getFechaH().equals("")) {
			where.append(" AND t1.FEEJEC < ? + 1");
			params.add(ficha.getFechaH());
		}

		if (ficha != null && ficha.getFechaplanifD() != null
				&& !ficha.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(ficha.getFechaplanifD());
		}
		if (ficha != null && ficha.getFechaplanifH() != null
				&& !ficha.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(ficha.getFechaplanifH());
		}

		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getIdedificio() != null
				&& !ficha.getMaquina().getIdedificio().equals("")) {
			where.append(" AND t8.IDEDIFICIO= ? ");
			params.add(ficha.getMaquina().getIdedificio());
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getZona() != null
				&& ficha.getMaquina().getZona().getCzona() != null
				&& !ficha.getMaquina().getZona().getCzona().equals("")) {
			where.append(" AND UPPER(t4.CZONA) like ? ESCAPE  '\\' AND t4.IDZONA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getZona().getCzona()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.CZONA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getZona() != null
				&& ficha.getMaquina().getZona().getEzona() != null
				&& !ficha.getMaquina().getZona().getEzona().equals("")) {
			where.append(" AND UPPER(t4.EZONA) like ? ESCAPE  '\\' AND t4.IDZONA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getZona().getEzona()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getZona().getEzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EZONA IS NOT NULL");
		}

		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getPlanta() != null
				&& ficha.getMaquina().getPlanta().getCplanta() != null
				&& !ficha.getMaquina().getPlanta().getCplanta().equals("")) {
			where.append(" AND UPPER(t7.CPLANTA) like ? ESCAPE  '\\' AND t7.IDPLANTA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getPlanta().getCplanta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getPlanta().getCplanta()
								.toUpperCase() + "%");
			}
			where.append(" AND t7.CPLANTA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getPlanta() != null
				&& ficha.getMaquina().getPlanta().getEplanta() != null
				&& !ficha.getMaquina().getPlanta().getEplanta().equals("")) {
			where.append(" AND UPPER(t7.EPLANTA) like ? ESCAPE  '\\' AND t7.IDPLANTA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getPlanta().getEplanta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getPlanta().getEplanta()
								.toUpperCase() + "%");
			}
			where.append(" AND t7.EPLANTA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getMcodigo() != null
				&& !ficha.getMaquina().getMcodigo().equals("")) {
			where.append(" AND UPPER(t2.MCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getMaquina().getMcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getMcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.MCODIGO IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getCmaquina() != null
				&& !ficha.getMaquina().getCmaquina().equals("")) {
			where.append(" AND UPPER(t2.CMAQUINA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getCmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getCmaquina().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CMAQUINA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getEmaquina() != null
				&& !ficha.getMaquina().getEmaquina().equals("")) {
			where.append(" AND UPPER(t2.EMAQUINA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getEmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getEmaquina().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EMAQUINA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getGama() != null
				&& ficha.getMaquina().getGama().getCgama() != null
				&& !ficha.getMaquina().getGama().getCgama().equals("")) {
			where.append(" AND UPPER(t3.CGAMA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getGama().getCgama()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getGama().getCgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CGAMA IS NOT NULL");
		}

		if (ficha != null
				&& ficha.getMaquina() != null
				&& ficha.getMaquina().getGama() != null
				&& ficha.getMaquina().getGama().getClase() != null
				&& ficha.getMaquina().getGama().getClase().getIdclase() != null
				&& ficha.getMaquina().getGama().getClase().getIdclase()
						.intValue() != 0) {

			where.append(" AND t3.IDCLASE = ?");
			params.add(ficha.getMaquina().getGama().getClase().getIdclase());
		}

		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getGama() != null
				&& ficha.getMaquina().getGama().getEgama() != null
				&& !ficha.getMaquina().getGama().getEgama().equals("")) {
			where.append(" AND UPPER(t3.EGAMA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getGama().getEgama()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getGama().getEgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EGAMA IS NOT NULL");
		}

		if (ficha != null && ficha.getTecnicos() != null
				&& ficha.getTecnicos().trim().length() > 0) {

			String[] listaTecn = ficha.getTecnicos().split(",");
			int indice = 0;
			for (String idTecnicoStr : listaTecn) {
				if (idTecnicoStr != null && !idTecnicoStr.equals("")) {
					if (indice == 0) {
						where.append(" AND (t12.IDTECNICO = ? ");
						params.add(idTecnicoStr);
					} else {
						where.append(" OR t12.IDTECNICO = ?");
						params.add(idTecnicoStr);
					}
					indice++;
					if (indice == listaTecn.length) {
						where.append(" )");
					}
				}
			}
		}

		/*
		 * if (ficha != null && ficha.getTecnicos() != null &&
		 * ficha.getTecnicos().trim().length() > 0) {
		 * where.append(" AND UPPER(t12.NOMBRE) like ? ESCAPE  '\\'"); if
		 * (startsWith) { params.add(ficha.getTecnicos().toUpperCase() + "%"); }
		 * else { params.add("%" + ficha.getTecnicos().toUpperCase() + "%"); }
		 * where.append(" AND t12.NOMBRE IS NOT NULL"); }
		 */

		if (ficha != null && ficha.getGama() != null
				&& ficha.getGama().getIdservicio() != null
				&& ficha.getGama().getIdservicio() != 0) {
			where.append(" AND t3.IDSERVICIO = ?");
			params.add(ficha.getGama().getIdservicio());
		}

		if (ficha != null) {
			if (ficha.getEjecutado() != null
					&& ficha.getEjecutado().equals("1")) {
				if (ficha.getParado() != null && ficha.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPOREAL<>0 AND t1.TIEMPOREAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (ficha.getParado() != null && ficha.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPOREAL<>0 AND t1.TIEMPOREAL is not null) ");
				}
			}
		}

		if (ficha != null) {
			if (ficha.getPendEjec() != null && ficha.getPendEjec().equals("1")) {
				where.append(" AND (t1.EJECUTADO<>'1' OR t1.EJECUTADO IS NULL) ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereConsultaMapAgenda(Ficha ficha,
			Boolean startsWith, boolean conTecnicos) {

		StringBuilder where = new StringBuilder(
				FichaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ficha != null && ficha.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(ficha.getIdficha());
		}
		if (ficha != null && ficha.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(ficha.getIdmaquina());
		}
		if (ficha != null && ficha.getFechaD() != null
				&& !ficha.getFechaD().equals("")) {
			where.append(" AND t1.FEEJEC >= ?");
			params.add(ficha.getFechaD());
		}
		if (ficha != null && ficha.getFechaH() != null
				&& !ficha.getFechaH().equals("")) {
			where.append(" AND t1.FEEJEC < ? + 1");
			params.add(ficha.getFechaH());
		}

		if (ficha != null && ficha.getFechaplanifD() != null
				&& !ficha.getFechaplanifD().equals("")) {
			where.append(" AND t1.FECHAPLANIF >= ?");
			params.add(ficha.getFechaplanifD());
		}
		if (ficha != null && ficha.getFechaplanifH() != null
				&& !ficha.getFechaplanifH().equals("")) {
			where.append(" AND t1.FECHAPLANIF < ? + 1");
			params.add(ficha.getFechaplanifH());
		}

		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getIdedificio() != null
				&& !ficha.getMaquina().getIdedificio().equals("")) {
			where.append(" AND t8.IDEDIFICIO= ? ");
			params.add(ficha.getMaquina().getIdedificio());
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getZona() != null
				&& ficha.getMaquina().getZona().getCzona() != null
				&& !ficha.getMaquina().getZona().getCzona().equals("")) {
			where.append(" AND UPPER(t4.CZONA) like ? ESCAPE  '\\' AND t4.IDZONA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getZona().getCzona()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getZona().getCzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.CZONA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getZona() != null
				&& ficha.getMaquina().getZona().getEzona() != null
				&& !ficha.getMaquina().getZona().getEzona().equals("")) {
			where.append(" AND UPPER(t4.EZONA) like ? ESCAPE  '\\' AND t4.IDZONA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getZona().getEzona()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getZona().getEzona().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.EZONA IS NOT NULL");
		}

		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getPlanta() != null
				&& ficha.getMaquina().getPlanta().getCplanta() != null
				&& !ficha.getMaquina().getPlanta().getCplanta().equals("")) {
			where.append(" AND UPPER(t7.CPLANTA) like ? ESCAPE  '\\' AND t7.IDPLANTA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getPlanta().getCplanta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getPlanta().getCplanta()
								.toUpperCase() + "%");
			}
			where.append(" AND t7.CPLANTA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getPlanta() != null
				&& ficha.getMaquina().getPlanta().getEplanta() != null
				&& !ficha.getMaquina().getPlanta().getEplanta().equals("")) {
			where.append(" AND UPPER(t7.EPLANTA) like ? ESCAPE  '\\' AND t7.IDPLANTA<>0");
			if (startsWith) {
				params.add(ficha.getMaquina().getPlanta().getEplanta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getPlanta().getEplanta()
								.toUpperCase() + "%");
			}
			where.append(" AND t7.EPLANTA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getMcodigo() != null
				&& !ficha.getMaquina().getMcodigo().equals("")) {
			where.append(" AND UPPER(t2.MCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getMaquina().getMcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getMcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.MCODIGO IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getCmaquina() != null
				&& !ficha.getMaquina().getCmaquina().equals("")) {
			where.append(" AND UPPER(t2.CMAQUINA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getCmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getCmaquina().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CMAQUINA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getEmaquina() != null
				&& !ficha.getMaquina().getEmaquina().equals("")) {
			where.append(" AND UPPER(t2.EMAQUINA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getEmaquina().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getMaquina().getEmaquina().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EMAQUINA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getGama() != null
				&& ficha.getMaquina().getGama().getCgama() != null
				&& !ficha.getMaquina().getGama().getCgama().equals("")) {
			where.append(" AND UPPER(t3.CGAMA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getGama().getCgama()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getGama().getCgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CGAMA IS NOT NULL");
		}
		if (ficha != null && ficha.getMaquina() != null
				&& ficha.getMaquina().getGama() != null
				&& ficha.getMaquina().getGama().getEgama() != null
				&& !ficha.getMaquina().getGama().getEgama().equals("")) {
			where.append(" AND UPPER(t3.EGAMA) like ? ESCAPE  '\\' ");
			if (startsWith) {
				params.add(ficha.getMaquina().getGama().getEgama()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ficha.getMaquina().getGama().getEgama().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EGAMA IS NOT NULL");
		}
		if (ficha != null && ficha.getTecnicos() != null
				&& ficha.getTecnicos().trim().length() > 0) {
			where.append(" AND UPPER(t12.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ficha.getTecnicos().toUpperCase() + "%");
			} else {
				params.add("%" + ficha.getTecnicos().toUpperCase() + "%");
			}
			where.append(" AND t12.NOMBRE IS NOT NULL");
		}

		if (ficha != null && ficha.getGama() != null
				&& ficha.getGama().getIdservicio() != null
				&& ficha.getGama().getIdservicio() != 0) {
			where.append(" AND t3.IDSERVICIO = ?");
			params.add(ficha.getGama().getIdservicio());
		}

		if (ficha != null) {
			if (ficha.getEjecutado() != null
					&& ficha.getEjecutado().equals("1")) {
				if (ficha.getParado() != null && ficha.getParado().equals("1")) {
					where.append(" AND (t1.EJECUTADO='1' OR (t1.EJECUTADO='0' AND (t1.TIEMPOREAL<>0 AND t1.TIEMPOREAL is not null))) ");
				} else {
					where.append(" AND (t1.EJECUTADO='1') ");
				}
			} else {
				if (ficha.getParado() != null && ficha.getParado().equals("1")) {
					where.append(" AND t1.EJECUTADO='0' AND (t1.TIEMPOREAL<>0 AND t1.TIEMPOREAL is not null) ");
				}
			}
		}

		if (ficha != null) {
			if (ficha.getPendEjec() != null && ficha.getPendEjec().equals("1")) {
				where.append(" AND (t1.EJECUTADO<>'1' OR t1.EJECUTADO IS NULL) ");
			}
		}

		if (ficha != null && ficha.getAgenda() != null && conTecnicos) {
			if (ficha.getAgenda().getMovilgmao() != null
					&& !ficha.getAgenda().getMovilgmao().equals("")) {
				where.append(" AND T12.MOVILGMAO = ?");
				params.add(ficha.getAgenda().getMovilgmao());
			}
			if (ficha.getAgenda().getEstadogmao() != null
					&& !ficha.getAgenda().getEstadogmao().equals("")) {
				if (ficha.getAgenda().getEstadogmao().equals("ASIG")) {
					where.append(" AND (T13.ESTADOGMAO = ? OR T13.ESTADOGMAO is null) ");
				} else {
					where.append(" AND T13.ESTADOGMAO = ?");
				}
				params.add(ficha.getAgenda().getEstadogmao());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
