package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;

/**
 * FichaDao generated by UDA, 10-mar-2015 10:12:57.
 * 
 * @author UDA
 */

public interface FichaDao {

	/**
	 * Inserts a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha add(Ficha ficha);

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha update(Ficha ficha);

	Ficha actualizarFechaPlanificacion(Ficha ficha);

	Ficha actualizarUUIDficha(Ficha ficha);

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha find(Ficha ficha);

	Ficha findFichaByGuid(Ficha ficha);

	/**
	 * Deletes a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	void remove(Ficha ficha);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Ficha> findAll(Ficha ficha, Pagination pagination);

	List<Ficha> findAllpendientes(Ficha ficha, Pagination pagination);

	/**
	 * Counts rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Long
	 */
	Long findAllCount(Ficha ficha);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Ficha> findAllLike(Ficha ficha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Ficha ficha, Boolean startsWith);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @return List
	 */
	ArrayList<TablaInformes> montarSelectTablaFicha(String idioma, Ficha filtro);

	/**
	 * obtener los tecnicos asociados a una ficha.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * 
	 * @return ArrayList
	 */
	public ArrayList<TablaInformes> montarSelectTablaFichaTecnicos(
			String idioma, Ficha filtro);

	/**
	 * obtener la fecha de la última ejecución
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha obtenerFechaEjecucion(Ficha ficha);

	/**
	 * finalizar la ficha Padre y los hijos.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha finalizarFicha(Ficha ficha);

	/**
	 * abrir la ficha
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha abrirFicha(Ficha ficha);

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha findFicha(Ficha ficha);

	/**
	 * Calcula el numero de partes preventivos(fichas) pendientes de asignar
	 * tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaPrevPendATC(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * Calcula el numero de partes preventivos(fichas) asignados pendientes de
	 * ejecutar
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaPrevAsigPendEjec(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * marca EnvioMail single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	void marcarEnvioMail(Ficha ficha);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerPrevPendAsignar(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerFichasGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	List<Ficha> obtenerDatosAgendaGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario, boolean conTecnicos,
			List<Tecnicos> listaTecnicosBusq);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerPrevPendAsignarCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerFichasGridCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerPrevAsigPendEjec(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerPrevAsigPendEjecCount(Ficha ficha, Boolean startsWith,
			String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaPrevPendAsignar(String idioma,
			Ficha filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaPrevAsigPendEjec(String idioma,
			Ficha filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaPreventivos(String idioma,
			Ficha filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaDiarioFichas(String idioma,
			Ficha filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaFichasEjecutadas(String idioma,
			Ficha filtro, String UIDUsuario);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param filtro
	 *            Ficha
	 * @param idioma
	 *            String
	 * @param UIDUsuario
	 *            String
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaFichasEjecutadasDetalle(
			String idioma, Ficha filtro, String UIDUsuario);

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha modificarObserv(Ficha ficha);
}
