package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * EspacioDaoImpl generated by UDA, 28-nov-2014 11:49:06.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class EspacioDaoImpl implements EspacioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Espacio> rwMap = new RowMapper<Espacio>() {
		public Espacio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Espacio(resultSet.getLong("IDESPACIO"),
					resultSet.getString("CESPACIO"),
					resultSet.getString("EESPACIO"),
					resultSet.getString("INTEXT"), resultSet.getString("BAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Pagination
	 * @return Espacio
	 */
	public Espacio add(Espacio espacio) {
		final Long nextId = this.jdbcTemplate
				.queryForLong("SELECT ESPACIO_SEQ.NEXTVAL FROM DUAL");

		espacio.setIdespacio(nextId);

		String query = "INSERT INTO ESPACIO (IDESPACIO, CESPACIO, EESPACIO, INT_EXT, BAJA) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, espacio.getIdespacio(),
				espacio.getCespacio(), espacio.getEespacio(),
				espacio.getIntExt(),
				espacio.getBaja() == null ? "0" : espacio.getBaja());
		return espacio;
	}

	/**
	 * Updates a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Pagination
	 * @return Espacio
	 */
	public Espacio update(Espacio espacio) {
		String query = "UPDATE ESPACIO SET CESPACIO=?, EESPACIO=?, INT_EXT=?, BAJA=? WHERE IDESPACIO=?";
		this.jdbcTemplate.update(query, espacio.getCespacio(),
				espacio.getEespacio(), espacio.getIntExt(),
				espacio.getBaja() == null ? "0" : espacio.getBaja(),
				espacio.getIdespacio());
		return espacio;
	}

	/**
	 * Finds a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Pagination
	 * @return Espacio
	 */
	@Transactional(readOnly = true)
	public Espacio find(Espacio espacio) {
		String query = "SELECT t1.IDESPACIO IDESPACIO, t1.CESPACIO CESPACIO, t1.EESPACIO EESPACIO, t1.INT_EXT INTEXT, t1.BAJA BAJA FROM ESPACIO t1  WHERE t1.IDESPACIO = ?  ";

		List<Espacio> espacioList = this.jdbcTemplate.query(query, this.rwMap,
				espacio.getIdespacio());
		return (Espacio) DataAccessUtils.uniqueResult(espacioList);
	}

	/**
	 * Removes a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Pagination
	 * @return
	 */
	public void remove(Espacio espacio) {
		String query = "DELETE FROM ESPACIO WHERE IDESPACIO=?";
		this.jdbcTemplate.update(query, espacio.getIdespacio());
	}

	/**
	 * Finds a List of rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Espacio> findAll(Espacio espacio, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDESPACIO IDESPACIO,t1.CESPACIO CESPACIO,t1.EESPACIO EESPACIO,t1.INT_EXT INTEXT,t1.BAJA BAJA ");
		query.append("FROM ESPACIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(espacio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Espacio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Espacio espacio) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ESPACIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(espacio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Espacio> findAllLike(Espacio espacio, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDESPACIO IDESPACIO,t1.CESPACIO CESPACIO,t1.EESPACIO EESPACIO,t1.INT_EXT INTEXT,t1.BAJA BAJA ");
		query.append("FROM ESPACIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(espacio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Espacio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Espacio espacio, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ESPACIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(espacio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Espacio entity
	 * 
	 * @param espacio
	 *            Espacio Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Espacio espacio) {

		StringBuilder where = new StringBuilder(
				EspacioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (espacio != null && espacio.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(espacio.getIdespacio());
		}
		if (espacio != null && espacio.getCespacio() != null) {
			where.append(" AND t1.CESPACIO = ?");
			params.add(espacio.getCespacio());
		}
		if (espacio != null && espacio.getEespacio() != null) {
			where.append(" AND t1.EESPACIO = ?");
			params.add(espacio.getEespacio());
		}
		if (espacio != null && espacio.getIntExt() != null) {
			where.append(" AND t1.INT_EXT = ?");
			params.add(espacio.getIntExt());
		}
		if (espacio != null && espacio.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(espacio.getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Espacio entity
	 * 
	 * @param espacio
	 *            Espacio Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Espacio espacio, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EspacioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (espacio != null && espacio.getIdespacio() != null) {
			where.append(" AND t1.IDESPACIO = ?");
			params.add(espacio.getIdespacio());
		}
		if (espacio != null && espacio.getCespacio() != null) {
			where.append(" AND UPPER(t1.CESPACIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(espacio.getCespacio().toUpperCase() + "%");
			} else {
				params.add("%" + espacio.getCespacio().toUpperCase() + "%");
			}
			where.append(" AND t1.CESPACIO IS NOT NULL");
		}
		if (espacio != null && espacio.getEespacio() != null) {
			where.append(" AND UPPER(t1.EESPACIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(espacio.getEespacio().toUpperCase() + "%");
			} else {
				params.add("%" + espacio.getEespacio().toUpperCase() + "%");
			}
			where.append(" AND t1.EESPACIO IS NOT NULL");
		}
		if (espacio != null && espacio.getIntExt() != null) {
			where.append(" AND UPPER(t1.INT_EXT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(espacio.getIntExt().toUpperCase() + "%");
			} else {
				params.add("%" + espacio.getIntExt().toUpperCase() + "%");
			}
			where.append(" AND t1.INT_EXT IS NOT NULL");
		}
		if (espacio != null && espacio.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(espacio.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + espacio.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * obtener las espacios que esten en situación de Alta.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Espacio> obtenerEspaciosAlta(Espacio espacio) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDESPACIO IDESPACIO,t1.CESPACIO CESPACIO,t1.EESPACIO EESPACIO,t1.INT_EXT INTEXT,t1.BAJA BAJA ");
		query.append("FROM ESPACIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(espacio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.BAJA=0");
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (LocaleContextHolder.getLocale().getLanguage()
				.equals(Aa20bConstantes.IDIOMA_EUSKERA))
			query.append(" ORDER BY EESPACIO");
		else
			query.append(" ORDER BY CESPACIO");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Espacio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
