package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Espacio;

/**
 * EspacioDao generated by UDA, 28-nov-2014 11:49:06.
 * 
 * @author UDA
 */

public interface EspacioDao {

	/**
	 * Inserts a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	Espacio add(Espacio espacio);

	/**
	 * Updates a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	Espacio update(Espacio espacio);

	/**
	 * Finds a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	Espacio find(Espacio espacio);

	/**
	 * Deletes a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return
	 */
	void remove(Espacio espacio);

	/**
	 * Finds a List of rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Espacio> findAll(Espacio espacio, Pagination pagination);

	/**
	 * Counts rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Long
	 */
	Long findAllCount(Espacio espacio);

	/**
	 * Finds rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Espacio> findAllLike(Espacio espacio, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Espacio espacio, Boolean startsWith);

	/**
	 * obtener las espacios que esten en situación de Alta.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return List
	 */
	List<Espacio> obtenerEspaciosAlta(Espacio espacio);
}
