package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.EdificiosXlnet;

/**
 * EdificiosXlnetDaoImpl generated by UDA, 13-feb-2015 12:34:51.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class EdificiosXlnetDaoImpl implements EdificiosXlnetDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<EdificiosXlnet> rwMap = new RowMapper<EdificiosXlnet>() {
		public EdificiosXlnet mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EdificiosXlnet(resultSet.getString("N38UIDEDIFICIO"),
					resultSet.getString("N38CAEDIFICIO"),
					resultSet.getString("N38EUEDIFICIO"),
					resultSet.getString("POSTALCODE"),
					resultSet.getString("N38PROVINCIA"),
					resultSet.getString("LOCALIDAD"),
					resultSet.getString("STREET"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            Pagination
	 * @return EdificiosXlnet
	 */
	public EdificiosXlnet add(EdificiosXlnet edificiosxlnet) {
		String query = "INSERT INTO EDIFICIOS_XLNET (N38UIDEDIFICIO, N38CAEDIFICIO, N38EUEDIFICIO, POSTALCODE, N38PROVINCIA, LOCALIDAD, STREET) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, edificiosxlnet.getN38uidedificio(),
				edificiosxlnet.getN38caedificio(),
				edificiosxlnet.getN38euedificio(),
				edificiosxlnet.getPostalcode(),
				edificiosxlnet.getN38provincia(),
				edificiosxlnet.getLocalidad(), edificiosxlnet.getStreet());
		return edificiosxlnet;
	}

	/**
	 * Updates a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            Pagination
	 * @return EdificiosXlnet
	 */
	public EdificiosXlnet update(EdificiosXlnet edificiosxlnet) {
		String query = "UPDATE EDIFICIOS_XLNET SET N38CAEDIFICIO=?, N38EUEDIFICIO=?, POSTALCODE=?, N38PROVINCIA=?, LOCALIDAD=?, STREET=? WHERE N38UIDEDIFICIO=?";
		this.jdbcTemplate.update(query, edificiosxlnet.getN38caedificio(),
				edificiosxlnet.getN38euedificio(),
				edificiosxlnet.getPostalcode(),
				edificiosxlnet.getN38provincia(),
				edificiosxlnet.getLocalidad(), edificiosxlnet.getStreet(),
				edificiosxlnet.getN38uidedificio());
		return edificiosxlnet;
	}

	/**
	 * Finds a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            Pagination
	 * @return EdificiosXlnet
	 */
	@Transactional(readOnly = true)
	public EdificiosXlnet find(EdificiosXlnet edificiosxlnet) {
		String query = "SELECT t1.N38UIDEDIFICIO N38UIDEDIFICIO, t1.N38CAEDIFICIO N38CAEDIFICIO, t1.N38EUEDIFICIO N38EUEDIFICIO, t1.POSTALCODE POSTALCODE, t1.N38PROVINCIA N38PROVINCIA, t1.LOCALIDAD LOCALIDAD, t1.STREET STREET FROM EDIFICIOS_XLNET t1  WHERE t1.N38UIDEDIFICIO = ?  ";

		List<EdificiosXlnet> edificiosxlnetList = this.jdbcTemplate.query(
				query, this.rwMap, edificiosxlnet.getN38uidedificio());
		return (EdificiosXlnet) DataAccessUtils
				.uniqueResult(edificiosxlnetList);
	}

	/**
	 * Removes a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            Pagination
	 * @return
	 */
	public void remove(EdificiosXlnet edificiosxlnet) {
		String query = "DELETE FROM EDIFICIOS_XLNET WHERE N38UIDEDIFICIO=?";
		this.jdbcTemplate.update(query, edificiosxlnet.getN38uidedificio());
	}

	/**
	 * Borrar todos los registros de la tabla de Edificios XLNET. Ya que se
	 * volveran a cargar todos obteniendolos de XLNET.
	 * 
	 * @return
	 */
	public void vaciarTablaEdificiosXLNET() {
		// String query = "TRUNCATE TABLE AA2030T00";
		String query = "DELETE FROM EDIFICIOS_XLNET";
		this.jdbcTemplate.update(query);
	}

	/**
	 * Finds a List of rows in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EdificiosXlnet> findAll(EdificiosXlnet edificiosxlnet,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.N38UIDEDIFICIO N38UIDEDIFICIO,t1.N38CAEDIFICIO N38CAEDIFICIO,t1.N38EUEDIFICIO N38EUEDIFICIO,t1.POSTALCODE POSTALCODE,t1.N38PROVINCIA N38PROVINCIA,t1.LOCALIDAD LOCALIDAD,t1.STREET STREET ");
		query.append("FROM EDIFICIOS_XLNET t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edificiosxlnet);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EdificiosXlnet>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EdificiosXlnet table.
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EdificiosXlnet edificiosxlnet) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS_XLNET t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edificiosxlnet);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EdificiosXlnet table using like.
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EdificiosXlnet> findAllLike(EdificiosXlnet edificiosxlnet,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.N38UIDEDIFICIO N38UIDEDIFICIO,t1.N38CAEDIFICIO N38CAEDIFICIO,t1.N38EUEDIFICIO N38EUEDIFICIO,t1.POSTALCODE POSTALCODE,t1.N38PROVINCIA N38PROVINCIA,t1.LOCALIDAD LOCALIDAD,t1.STREET STREET ");
		query.append("FROM EDIFICIOS_XLNET t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificiosxlnet,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EdificiosXlnet>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EdificiosXlnet table using like.
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EdificiosXlnet edificiosxlnet,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS_XLNET t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificiosxlnet,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EdificiosXlnet entity
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EdificiosXlnet edificiosxlnet) {

		StringBuilder where = new StringBuilder(
				EdificiosXlnetDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edificiosxlnet != null
				&& edificiosxlnet.getN38uidedificio() != null) {
			where.append(" AND t1.N38UIDEDIFICIO = ?");
			params.add(edificiosxlnet.getN38uidedificio());
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38caedificio() != null) {
			where.append(" AND t1.N38CAEDIFICIO = ?");
			params.add(edificiosxlnet.getN38caedificio());
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38euedificio() != null) {
			where.append(" AND t1.N38EUEDIFICIO = ?");
			params.add(edificiosxlnet.getN38euedificio());
		}
		if (edificiosxlnet != null && edificiosxlnet.getPostalcode() != null) {
			where.append(" AND t1.POSTALCODE = ?");
			params.add(edificiosxlnet.getPostalcode());
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38provincia() != null) {
			where.append(" AND t1.N38PROVINCIA = ?");
			params.add(edificiosxlnet.getN38provincia());
		}
		if (edificiosxlnet != null && edificiosxlnet.getLocalidad() != null) {
			where.append(" AND t1.LOCALIDAD = ?");
			params.add(edificiosxlnet.getLocalidad());
		}
		if (edificiosxlnet != null && edificiosxlnet.getStreet() != null) {
			where.append(" AND t1.STREET = ?");
			params.add(edificiosxlnet.getStreet());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EdificiosXlnet entity
	 * 
	 * @param edificiosxlnet
	 *            EdificiosXlnet Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(EdificiosXlnet edificiosxlnet,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EdificiosXlnetDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edificiosxlnet != null
				&& edificiosxlnet.getN38uidedificio() != null) {
			where.append(" AND UPPER(t1.N38UIDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getN38uidedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ edificiosxlnet.getN38uidedificio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.N38UIDEDIFICIO IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38caedificio() != null) {
			where.append(" AND UPPER(t1.N38CAEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getN38caedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ edificiosxlnet.getN38caedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.N38CAEDIFICIO IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38euedificio() != null) {
			where.append(" AND UPPER(t1.N38EUEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getN38euedificio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ edificiosxlnet.getN38euedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.N38EUEDIFICIO IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getPostalcode() != null) {
			where.append(" AND UPPER(t1.POSTALCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getPostalcode().toUpperCase() + "%");
			} else {
				params.add("%" + edificiosxlnet.getPostalcode().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.POSTALCODE IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getN38provincia() != null) {
			where.append(" AND UPPER(t1.N38PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getN38provincia().toUpperCase() + "%");
			} else {
				params.add("%" + edificiosxlnet.getN38provincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.N38PROVINCIA IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getLocalidad() != null) {
			where.append(" AND UPPER(t1.LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + edificiosxlnet.getLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.LOCALIDAD IS NOT NULL");
		}
		if (edificiosxlnet != null && edificiosxlnet.getStreet() != null) {
			where.append(" AND UPPER(t1.STREET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificiosxlnet.getStreet().toUpperCase() + "%");
			} else {
				params.add("%" + edificiosxlnet.getStreet().toUpperCase() + "%");
			}
			where.append(" AND t1.STREET IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
