package com.ejie.aa20b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Edificios;
import com.ejie.x38.dto.Pagination;

/**
 * EdificiosDaoImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class EdificiosDaoImpl implements EdificiosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Edificios> rwMap = new RowMapper<Edificios>() {
		public Edificios mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO"));
			edificio.setRedificio(resultSet.getString("REDIFICIO"));
			edificio.setIdterri(resultSet.getInt("IDTERRI"));
			edificio.setBaja(resultSet.getString("BAJA"));
			edificio.setFeini(resultSet.getDate("FEINI"));
			edificio.setGestCentra(resultSet.getString("GESTCENTRA"));
			edificio.setGuidedificio(resultSet.getString("GUIDEDIFICIO"));
			return edificio;
		}
	};

	private RowMapper<Edificios> mapRowEdificiosTecnicos = new RowMapper<Edificios>() {
		public Edificios mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Edificios edificio = new Edificios();
			edificio.setIdedificio(resultSet.getString("IDEDIFICIO"));
			edificio.setCedificio(resultSet.getString("CEDIFICIO"));
			edificio.setEedificio(resultSet.getString("EEDIFICIO"));
			edificio.setRedificio(resultSet.getString("REDIFICIO"));

			return edificio;
		};
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return Edificios
	 */
	public Edificios add(Edificios edificios) {
		String query = "INSERT INTO EDIFICIOS (IDEDIFICIO, CEDIFICIO, EEDIFICIO, REDIFICIO, IDTERRI, BAJA, FEINI, GESTCENTRA, GUIDEDIFICIO) VALUES (?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, edificios.getIdedificio(), edificios
				.getCedificio(), edificios.getEedificio(), edificios
				.getRedificio(), edificios.getIdterri(),
				edificios.getBaja() == null ? "0" : edificios.getBaja(),
				edificios.getFeini(), edificios.getGestCentra() == null ? "0"
						: edificios.getGestCentra(), edificios
						.getGuidedificio());
		return edificios;
	}

	/**
	 * Updates a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return Edificios
	 */
	public Edificios update(Edificios edificios) {
		String query = "UPDATE EDIFICIOS SET CEDIFICIO=?, EEDIFICIO=?, REDIFICIO=?, IDTERRI=?, BAJA=?, FEINI=?, GESTCENTRA=? WHERE IDEDIFICIO=?";
		this.jdbcTemplate.update(query, edificios.getCedificio(), edificios
				.getEedificio(), edificios.getRedificio(), edificios
				.getIdterri(),
				edificios.getBaja() == null ? "0" : edificios.getBaja(),
				edificios.getFeini(), edificios.getGestCentra() == null ? "0"
						: edificios.getGestCentra(), edificios.getIdedificio());
		return edificios;
	}

	/**
	 * Poner el edificio de alta.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return Edificios
	 */
	public Edificios updateAlta(Edificios edificios) {
		String query = "UPDATE EDIFICIOS SET  BAJA='0' WHERE IDEDIFICIO=? ";
		this.jdbcTemplate.update(query, edificios.getIdedificio());
		return edificios;
	}

	public Edificios actualizarUUIDedificio(Edificios edificio) {
		String query = "UPDATE EDIFICIOS SET GUIDEDIFICIO=? WHERE IDEDIFICIO=? ";
		this.jdbcTemplate.update(query, edificio.getGuidedificio(),
				edificio.getIdedificio());
		return edificio;
	}

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return Edificios
	 */
	@Transactional(readOnly = true)
	public Edificios find(Edificios edificios) {
		String query = "SELECT t1.IDEDIFICIO IDEDIFICIO, t1.CEDIFICIO CEDIFICIO, t1.EEDIFICIO EEDIFICIO, t1.REDIFICIO REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  FROM EDIFICIOS t1  WHERE t1.IDEDIFICIO = ?   AND t1.CEDIFICIO = ?   AND t1.EEDIFICIO = ?  AND t1.REDIFICIO = ?  AND t1.IDTERRI = ?  AND t1.BAJA = ?  AND t1.GESTCENTRA = ?  ";

		List<Edificios> edificiosList = this.jdbcTemplate.query(query,
				this.rwMap, edificios.getIdedificio(),
				edificios.getCedificio(), edificios.getEedificio(),
				edificios.getRedificio(), edificios.getIdterri(),
				edificios.getBaja(), edificios.getGestCentra());
		return (Edificios) DataAccessUtils.uniqueResult(edificiosList);
	}

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return Edificios
	 */
	@Transactional(readOnly = true)
	public Edificios findByGUID(Edificios edificios) {
		String query = "SELECT t1.IDEDIFICIO IDEDIFICIO, t1.CEDIFICIO CEDIFICIO, t1.EEDIFICIO EEDIFICIO, t1.REDIFICIO REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  FROM EDIFICIOS t1  WHERE t1.GUIDEDIFICIO = ? ";

		List<Edificios> edificiosList = this.jdbcTemplate.query(query,
				this.rwMap, edificios.getGuidedificio());
		return (Edificios) DataAccessUtils.uniqueResult(edificiosList);
	}

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param idEdificio
	 *            String
	 * @return Edificios
	 */
	@Transactional(readOnly = true)
	public Edificios obtenerEdificio(String idEdificio) {
		String query = "SELECT t1.IDEDIFICIO IDEDIFICIO, t1.CEDIFICIO CEDIFICIO, t1.EEDIFICIO EEDIFICIO, t1.REDIFICIO REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  FROM EDIFICIOS t1  WHERE t1.IDEDIFICIO = ? ";

		List<Edificios> edificiosList = this.jdbcTemplate.query(query,
				this.rwMap, idEdificio);
		return (Edificios) DataAccessUtils.uniqueResult(edificiosList);
	}

	/**
	 * Removes a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Pagination
	 * @return
	 */
	public void remove(Edificios edificios) {
		String query = "DELETE FROM EDIFICIOS WHERE IDEDIFICIO=? AND CEDIFICIO=? AND EEDIFICIO=? AND BAJA=? AND GESTCENTRA=?";
		this.jdbcTemplate.update(query, edificios.getIdedificio(),
				edificios.getCedificio(), edificios.getEedificio(),
				edificios.getBaja(), edificios.getGestCentra());
	}

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> findAll(Edificios edificios, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO,t1.IDTERRI IDTERRI,t1.BAJA BAJA,t1.FEINI FEINI,t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO ");
		query.append("FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edificios);
		StringBuilder where = new StringBuilder(
				" WHERE (t1.BAJA is null or t1.BAJA<>1)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> obtenerEdificiosConPlanos() {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO,t1.IDTERRI IDTERRI,t1.BAJA BAJA,t1.FEINI FEINI,t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO ");
		query.append("FROM EDIFICIOS t1, PLANOS t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE (t2.BAJA is null or t2.BAJA<>1) AND t1.IDEDIFICIO=t2.IDEDIFICIO ");
		query.append(where);

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap);
	}

	/**
	 * Counts rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Edificios edificios) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edificios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> findAllLike(Edificios edificios,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO,t1.IDTERRI IDTERRI,t1.BAJA BAJA,t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  ");
		query.append("FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Obtener los edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> obtenerEdificiosUsuario(Edificios edificios,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO,t1.IDTERRI IDTERRI,t1.BAJA BAJA,t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  ");
		query.append("FROM EDIFICIOS t1, EDIFICIOSVER t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapUsuario(edificios,
				startsWith, UIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO ");
		where.append(mapaWhere.get("query"));

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Obtener los edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> obtenerEdificios(Edificios edificios,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO,t1.IDTERRI IDTERRI,t1.BAJA BAJA,t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA, t1.GUIDEDIFICIO GUIDEDIFICIO  ");
		query.append("FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts Edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerEdificiosUsuarioCount(Edificios edificios,
			Boolean startsWith, String UIDUsuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS t1, EDIFICIOSVER t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapUsuario(edificios,
				startsWith, UIDUsuario);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts Edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerEdificiosCount(Edificios edificios, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Edificios edificios, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIFICIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edificios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Si no existe el edificio lo da de alta.
	 * 
	 * @param codEdificio
	 *            String
	 * @return Boolean
	 */
	@Transactional(readOnly = true)
	public Boolean comprobarExisteEdificio(String codEdificio) {

		Edificios edificio = new Edificios();
		edificio.setIdedificio(codEdificio);

		List<Edificios> listaEdificios = this.findAll(edificio, null);

		if (listaEdificios.size() == 0) {
			// No existe el código de edificio. No se dejará dar de alta el
			// parte
			return false;

		} else {
			return true;
		}
	}

	/**
	 * Obtener de los Edificios asociados al UID PUESTO aquellos que estan
	 * asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @param UIDPuesto
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> obtenerEdificiosTecnicoLibres(Integer idTecnico,
			String UIDPuesto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA ");
		query.append("FROM EDIFICIOS t1, EDIFICIOSVER t2 ");
		query.append("WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t2.UID_PER=? AND (t1.BAJA='0' OR t1.BAJA IS NULL) ");
		query.append(" MINUS ");
		query.append(" SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA ");
		query.append(" FROM EDIFICIOS t1, TECNICO_EDIF t2 ");
		query.append(" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t2.IDTECNICO=?  ");

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.mapRowEdificiosTecnicos, UIDPuesto, idTecnico);

	}

	/**
	 * Obtener los Edificios asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Edificios> obtenerEdificiosTecnicoOcupados(Integer idTecnico) {
		StringBuilder query = new StringBuilder(
				" SELECT DISTINCT t1.IDEDIFICIO IDEDIFICIO,t1.CEDIFICIO CEDIFICIO,t1.EEDIFICIO EEDIFICIO,t1.REDIFICIO, t1.IDTERRI IDTERRI, t1.BAJA BAJA, t1.FEINI FEINI, t1.GESTCENTRA GESTCENTRA ");
		query.append(" FROM EDIFICIOS t1, TECNICO_EDIF t2 ");
		query.append(" WHERE t1.IDEDIFICIO=t2.IDEDIFICIO AND t2.IDTECNICO=?  ");

		return (List<Edificios>) this.jdbcTemplate.query(query.toString(),
				this.mapRowEdificiosTecnicos, idTecnico);

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Edificios entity
	 * 
	 * @param edificios
	 *            Edificios Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Edificios edificios) {

		StringBuilder where = new StringBuilder(
				EdificiosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edificios != null && edificios.getIdedificio() != null) {
			where.append(" AND t1.IDEDIFICIO = ?");
			params.add(edificios.getIdedificio());
		}
		if (edificios != null && edificios.getCedificio() != null) {
			where.append(" AND t1.CEDIFICIO = ?");
			params.add(edificios.getCedificio());
		}
		if (edificios != null && edificios.getEedificio() != null) {
			where.append(" AND t1.EEDIFICIO = ?");
			params.add(edificios.getEedificio());
		}
		if (edificios != null && edificios.getRedificio() != null) {
			where.append(" AND t1.REDIFICIO = ?");
			params.add(edificios.getRedificio());
		}
		if (edificios != null && edificios.getIdterri() != null) {
			where.append(" AND t1.IDTERRI = ?");
			params.add(edificios.getIdterri());
		}
		if (edificios != null && edificios.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(edificios.getBaja());
		}
		if (edificios != null && edificios.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(edificios.getFeini());
		}
		if (edificios != null && edificios.getGestCentra() != null) {
			where.append(" AND t1.GESTCENTRA = ?");
			params.add(edificios.getGestCentra());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Edificios entity
	 * 
	 * @param edificios
	 *            Edificios Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Edificios edificios,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EdificiosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edificios != null && edificios.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getCedificio() != null) {
			where.append(" AND UPPER(t1.CEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getCedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getCedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.CEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getEedificio() != null) {
			where.append(" AND UPPER(t1.EEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getEedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getEedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.EEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getRedificio() != null) {
			where.append(" AND UPPER(t1.REDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getRedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getRedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.REDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getIdterri() != null) {
			if (edificios.getIdterri() == 0) {
				where.append(" AND (t1.IDTERRI = 0 OR t1.IDTERRI is null)");
			} else {
				where.append(" AND t1.IDTERRI = ?");
				params.add(edificios.getIdterri());
			}
		}
		if (edificios != null && edificios.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (edificios != null && edificios.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(edificios.getFeini());
		}
		if (edificios != null && edificios.getGestCentra() != null) {
			where.append(" AND UPPER(t1.GESTCENTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getGestCentra().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getGestCentra().toUpperCase() + "%");
			}
			where.append(" AND t1.GESTCENTRA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Edificios entity
	 * 
	 * @param edificios
	 *            Edificios Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMapUsuario(Edificios edificios,
			Boolean startsWith, String UIDUsuario) {

		StringBuilder where = new StringBuilder(
				EdificiosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// para mostrar unicamente los edificios asociados al usuario (Tabla de
		// EDIFICIOSVER)
		where.append(" AND t2.UID_PER=?");
		params.add(UIDUsuario);

		if (edificios != null && edificios.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getCedificio() != null) {
			where.append(" AND UPPER(t1.CEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getCedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getCedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.CEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getEedificio() != null) {
			where.append(" AND UPPER(t1.EEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getEedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getEedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.EEDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getRedificio() != null) {
			where.append(" AND UPPER(t1.REDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getRedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getRedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.REDIFICIO IS NOT NULL");
		}
		if (edificios != null && edificios.getIdterri() != null) {
			if (edificios.getIdterri() == 0) {
				where.append(" AND (t1.IDTERRI = 0 OR t1.IDTERRI is null)");
			} else {
				where.append(" AND t1.IDTERRI = ?");
				params.add(edificios.getIdterri());
			}
		}
		if (edificios != null && edificios.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith != null && startsWith) {
				params.add(edificios.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (edificios != null && edificios.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(edificios.getFeini());
		}
		if (edificios != null && edificios.getGestCentra() != null) {
			where.append(" AND UPPER(t1.GESTCENTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edificios.getGestCentra().toUpperCase() + "%");
			} else {
				params.add("%" + edificios.getGestCentra().toUpperCase() + "%");
			}
			where.append(" AND t1.GESTCENTRA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
