package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.EdifEstruc;

/**
 * EdifEstrucDaoImpl generated by UDA, 18-feb-2015 9:05:57.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class EdifEstrucDaoImpl implements EdifEstrucDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<EdifEstruc> rwMap = new RowMapper<EdifEstruc>() {
		public EdifEstruc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EdifEstruc(resultSet.getString("IDEDIFICIO"),
					resultSet.getInt("IDZONA"), resultSet.getString("IDPLANTA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            Pagination
	 * @return EdifEstruc
	 */
	public EdifEstruc add(EdifEstruc edifestruc) {
		String query = "INSERT INTO EDIF_ESTRUC (IDEDIFICIO, IDZONA, IDPLANTA) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, edifestruc.getIdedificio(),
				edifestruc.getIdzona(), edifestruc.getIdplanta());
		return edifestruc;
	}

	/**
	 * Updates a single row in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            Pagination
	 * @return EdifEstruc
	 */
	public EdifEstruc update(EdifEstruc edifestruc) {
		String query = "UPDATE EDIF_ESTRUC SET  WHERE IDEDIFICIO=? AND IDZONA=? AND IDPLANTA=?";
		this.jdbcTemplate.update(query, edifestruc.getIdedificio(),
				edifestruc.getIdzona(), edifestruc.getIdplanta());
		return edifestruc;
	}

	/**
	 * Finds a single row in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            Pagination
	 * @return EdifEstruc
	 */
	@Transactional(readOnly = true)
	public EdifEstruc find(EdifEstruc edifestruc) {
		String query = "SELECT t1.IDEDIFICIO IDEDIFICIO, t1.IDZONA IDZONA, t1.IDPLANTA IDPLANTA FROM EDIF_ESTRUC t1  WHERE t1.IDEDIFICIO = ?   AND t1.IDZONA = ?   AND t1.IDPLANTA = ?  ";

		List<EdifEstruc> edifestrucList = this.jdbcTemplate.query(query,
				this.rwMap, edifestruc.getIdedificio(), edifestruc.getIdzona(),
				edifestruc.getIdplanta());
		return (EdifEstruc) DataAccessUtils.uniqueResult(edifestrucList);
	}

	/**
	 * Removes a single row in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            Pagination
	 * @return
	 */
	public void remove(EdifEstruc edifestruc) {
		String query = "DELETE FROM EDIF_ESTRUC WHERE IDEDIFICIO=? AND IDZONA=? AND IDPLANTA=?";
		this.jdbcTemplate.update(query, edifestruc.getIdedificio(),
				edifestruc.getIdzona(), edifestruc.getIdplanta());
	}

	/**
	 * Finds a List of rows in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            EdifEstruc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EdifEstruc> findAll(EdifEstruc edifestruc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA ");
		query.append("FROM EDIF_ESTRUC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edifestruc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EdifEstruc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EdifEstruc table.
	 * 
	 * @param edifestruc
	 *            EdifEstruc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EdifEstruc edifestruc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIF_ESTRUC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(edifestruc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EdifEstruc table using like.
	 * 
	 * @param edifestruc
	 *            EdifEstruc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EdifEstruc> findAllLike(EdifEstruc edifestruc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDEDIFICIO IDEDIFICIO,t1.IDZONA IDZONA,t1.IDPLANTA IDPLANTA ");
		query.append("FROM EDIF_ESTRUC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edifestruc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<EdifEstruc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EdifEstruc table using like.
	 * 
	 * @param edifestruc
	 *            EdifEstruc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EdifEstruc edifestruc, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM EDIF_ESTRUC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(edifestruc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Borra las zonas ( y todas sus plantas)
	 * 
	 * eparam EdifEstruc Pagination
	 * 
	 * @return
	 */
	public void removeZonas(EdifEstruc edifEstruc) {
		String query = "DELETE FROM EDIF_ESTRUC WHERE IDEDIFICIO=? AND IDZONA=?";
		this.jdbcTemplate.update(query, edifEstruc.getIdedificio(),
				edifEstruc.getIdzona());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EdifEstruc entity
	 * 
	 * @param edifestruc
	 *            EdifEstruc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EdifEstruc edifestruc) {

		StringBuilder where = new StringBuilder(
				EdifEstrucDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edifestruc != null && edifestruc.getIdedificio() != null) {
			where.append(" AND t1.IDEDIFICIO = ?");
			params.add(edifestruc.getIdedificio());
		}
		if (edifestruc != null && edifestruc.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(edifestruc.getIdzona());
		}
		if (edifestruc != null && edifestruc.getIdplanta() != null) {
			where.append(" AND t1.IDPLANTA = ?");
			params.add(edifestruc.getIdplanta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the EdifEstruc entity
	 * 
	 * @param edifestruc
	 *            EdifEstruc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(EdifEstruc edifestruc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EdifEstrucDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (edifestruc != null && edifestruc.getIdedificio() != null) {
			where.append(" AND UPPER(t1.IDEDIFICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edifestruc.getIdedificio().toUpperCase() + "%");
			} else {
				params.add("%" + edifestruc.getIdedificio().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEDIFICIO IS NOT NULL");
		}
		if (edifestruc != null && edifestruc.getIdzona() != null) {
			where.append(" AND t1.IDZONA = ?");
			params.add(edifestruc.getIdzona());
		}
		if (edifestruc != null && edifestruc.getIdplanta() != null) {
			where.append(" AND UPPER(t1.IDPLANTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(edifestruc.getIdplanta().toUpperCase() + "%");
			} else {
				params.add("%" + edifestruc.getIdplanta().toUpperCase() + "%");
			}
			where.append(" AND t1.IDPLANTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
