package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * CodigoDaoImpl generated by UDA, 28-nov-2014 12:22:02.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class CodigoDaoImpl implements CodigoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Codigo> rwMap = new RowMapper<Codigo>() {
		public Codigo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Codigo codigo = new Codigo();

			codigo.setIdcodigo(resultSet.getInt("IDCODIGO"));
			codigo.setCodigo(resultSet.getString("CODIGO"));
			codigo.setCcodigo(resultSet.getString("CCODIGO"));
			codigo.setEcodigo(resultSet.getString("ECODIGO"));
			codigo.setIdclase(resultSet.getInt("IDCLASE"));
			codigo.setFeini(resultSet.getDate("FEINI"));
			codigo.setBaja(resultSet.getString("BAJA"));

			Clase clase = new Clase();
			clase.setIdclase(resultSet.getInt("IDCLASE"));
			clase.setCclase(resultSet.getString("CCLASE") == null ? ""
					: resultSet.getString("CCLASE"));
			clase.setEclase(resultSet.getString("ECLASE") == null ? ""
					: resultSet.getString("ECLASE"));
			codigo.setClase(clase);

			codigo.setUsupubli(resultSet.getString("USUPUBLI"));
			codigo.setRecibeinci(resultSet.getString("RECIBEINCI"));
			codigo.setContrata(resultSet.getString("CONTRATA"));

			codigo.setIdservicio(resultSet.getInt("IDSERVICIO"));

			Servicios servicio = new Servicios();
			servicio.setIdservicio(resultSet.getLong("IDSERVICIO"));
			servicio.setCservicio(resultSet.getString("CSERVICIO") == null ? ""
					: resultSet.getString("CSERVICIO"));
			servicio.setEservicio(resultSet.getString("ESERVICIO") == null ? ""
					: resultSet.getString("ESERVICIO"));

			codigo.setServicio(servicio);
			codigo.setUrgente(resultSet.getString("URGENTE"));

			return codigo;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo add(Codigo codigo) {
		// Obtener el id correlativo
		Integer idCorrelativo = this.jdbcTemplate
				.queryForInt("SELECT CODIGO_SEQ.NEXTVAL FROM DUAL");

		String query = "INSERT INTO CODIGO (IDCODIGO, CODIGO, CCODIGO, ECODIGO, IDCLASE, BAJA, FEINI, USUPUBLI, RECIBE_INCI, CONTRATA, IDSERVICIO, URGENTE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, idCorrelativo, codigo.getCodigo(),
				codigo.getCcodigo(), codigo.getEcodigo(), codigo.getIdclase(),
				codigo.getBaja() == null ? "0" : codigo.getBaja(), codigo
						.getFeini(), codigo.getUsupubli() == null ? "0"
						: codigo.getUsupubli(),
				codigo.getRecibeinci() == null ? "0" : codigo.getRecibeinci(),
				codigo.getContrata() == null ? "0" : codigo.getContrata(),
				codigo.getIdservicio(), codigo.getUrgente() == null ? "0"
						: codigo.getUrgente());
		codigo.setIdcodigo(idCorrelativo);
		return codigo;
	}

	/**
	 * Updates a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo update(Codigo codigo) {
		String query = "UPDATE CODIGO SET CODIGO=?, CCODIGO=?, ECODIGO=?, IDCLASE=?, BAJA=?, FEINI=?, USUPUBLI=?, RECIBE_INCI=?, CONTRATA=?, IDSERVICIO=?, URGENTE=?   WHERE IDCODIGO=?";
		this.jdbcTemplate.update(query, codigo.getCodigo(),
				codigo.getCcodigo(), codigo.getEcodigo(), codigo.getIdclase(),
				codigo.getBaja() == null ? "0" : codigo.getBaja(), codigo
						.getFeini(), codigo.getUsupubli() == null ? "0"
						: codigo.getUsupubli(),
				codigo.getRecibeinci() == null ? "0" : codigo.getRecibeinci(),
				codigo.getContrata() == null ? "0" : codigo.getContrata(),
				codigo.getIdservicio(), codigo.getUrgente() == null ? "0"
						: codigo.getUrgente(), codigo.getIdcodigo());
		return codigo;
	}

	/**
	 * Pone a cero el campo UsuPubli a todos los Codigos pertenecientes a una
	 * clase.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo deschequearUsuPubli(Codigo codigo) {
		String query = "UPDATE CODIGO SET USUPUBLI=0 WHERE IDCLASE=?";
		this.jdbcTemplate.update(query, codigo.getIdclase());
		return codigo;
	}

	/**
	 * Pone a 1 el campo UsuPubli a todos los Codigos pertenecientes a una
	 * clase.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo chequearUsuPubli(Codigo codigo) {
		String query = "UPDATE CODIGO SET USUPUBLI=1 WHERE IDCLASE=?";
		this.jdbcTemplate.update(query, codigo.getIdclase());
		return codigo;
	}

	/**
	 * Finds a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	@Transactional(readOnly = true)
	public Codigo find(Codigo codigo) {
		String query = "SELECT t1.IDCODIGO IDCODIGO, t1.CODIGO CODIGO, t1.CCODIGO CCODIGO, t1.ECODIGO ECODIGO, t1.IDCLASE IDCLASE, t2.CCLASE CCLASE, t2.ECLASE ECLASE, t1.BAJA BAJA, t1.FEINI FEINI, t1.USUPUBLI USUPUBLI , t1.RECIBE_INCI RECIBEINCI , t1.CONTRATA CONTRATA, t1.IDSERVICIO IDSERVICIO, t3.CSERVICIO CSERVICIO, t3.ESERVICIO ESERVICIO,  t1.URGENTE URGENTE  FROM CODIGO t1, CLASE t2, SERVICIOS t3  WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) AND t1.IDCODIGO = ?  ";

		List<Codigo> codigoList = this.jdbcTemplate.query(query, this.rwMap,
				codigo.getIdcodigo());
		return (Codigo) DataAccessUtils.uniqueResult(codigoList);
	}

	/**
	 * Removes a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return
	 */
	public void remove(Codigo codigo) {
		String query = "DELETE FROM CODIGO WHERE IDCODIGO=?";
		this.jdbcTemplate.update(query, codigo.getIdcodigo());
	}

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Codigo> findAll(Codigo codigo, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDCODIGO IDCODIGO,t1.CODIGO CODIGO,t1.CCODIGO CCODIGO,t1.ECODIGO ECODIGO,t1.IDCLASE IDCLASE, t2.CCLASE CCLASE, t2.ECLASE ECLASE,t1.BAJA BAJA,t1.FEINI FEINI, t1.USUPUBLI USUPUBLI , t1.RECIBE_INCI RECIBEINCI , t1.CONTRATA CONTRATA, t1.IDSERVICIO IDSERVICIO, t3.CSERVICIO CSERVICIO, t3.ESERVICIO ESERVICIO, t1.URGENTE URGENTE ");
		query.append("FROM CODIGO t1, CLASE t2, SERVICIOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(codigo);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		} else {
			if (LocaleContextHolder.getLocale().getLanguage()
					.equals(Aa20bConstantes.IDIOMA_EUSKERA))
				query.append(" ORDER BY t1.BAJA, t1.ECODIGO");
			else
				query.append(" ORDER BY t1.BAJA, t1.CCODIGO");
		}

		return (List<Codigo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * obtener los activos que esten en situación de Alta.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Codigo> obtenerCodigosAlta(Codigo codigo) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDCODIGO IDCODIGO,t1.CODIGO CODIGO,t1.CCODIGO CCODIGO,t1.ECODIGO ECODIGO,t1.IDCLASE IDCLASE, t2.CCLASE CCLASE, t2.ECLASE ECLASE,t1.BAJA BAJA,t1.FEINI FEINI, t1.USUPUBLI USUPUBLI , t1.RECIBE_INCI RECIBEINCI , t1.CONTRATA CONTRATA, t1.IDSERVICIO IDSERVICIO, t3.CSERVICIO CSERVICIO, t3.ESERVICIO ESERVICIO, t1.URGENTE URGENTE ");
		query.append("FROM CODIGO t1, CLASE t2, SERVICIOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(codigo);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) AND t1.BAJA=0");
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (LocaleContextHolder.getLocale().getLanguage()
				.equals(Aa20bConstantes.IDIOMA_EUSKERA))
			query.append(" ORDER BY ECODIGO");
		else
			query.append(" ORDER BY CCODIGO");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Codigo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Codigo codigo) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CODIGO t1, CLASE t2, SERVICIOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(codigo);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Codigo> findAllLike(Codigo codigo, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDCODIGO IDCODIGO,t1.CODIGO CODIGO,t1.CCODIGO CCODIGO,t1.ECODIGO ECODIGO,t1.IDCLASE IDCLASE, t2.CCLASE CCLASE, t2.ECLASE ECLASE,t1.BAJA BAJA,t1.FEINI FEINI, t1.USUPUBLI USUPUBLI , t1.RECIBE_INCI RECIBEINCI , t1.CONTRATA CONTRATA, t1.IDSERVICIO IDSERVICIO, t3.CSERVICIO CSERVICIO, t3.ESERVICIO ESERVICIO, t1.URGENTE URGENTE ");
		query.append("FROM CODIGO t1, CLASE t2, SERVICIOS t3  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(codigo, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		} else {
			if (LocaleContextHolder.getLocale().getLanguage()
					.equals(Aa20bConstantes.IDIOMA_EUSKERA))
				query.append(" ORDER BY t1.BAJA, t1.ECODIGO");
			else
				query.append(" ORDER BY t1.BAJA, t1.CCODIGO");

		}

		return (List<Codigo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Codigo codigo, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CODIGO t1, CLASE t2, SERVICIOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(codigo, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param idClase
	 *            String
	 * @param language
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Codigo> obtenerActivosClase(String idClase, String language) {

		StringBuilder query = new StringBuilder(
				"SELECT  DISTINCT t1.IDCODIGO IDCODIGO,t1.CODIGO CODIGO,t1.CCODIGO CCODIGO,t1.ECODIGO ECODIGO,t1.IDCLASE IDCLASE, t2.CCLASE CCLASE, t2.ECLASE ECLASE,t1.BAJA BAJA,t1.FEINI FEINI, t1.USUPUBLI USUPUBLI , t1.RECIBE_INCI RECIBEINCI , t1.CONTRATA CONTRATA, t1.IDSERVICIO IDSERVICIO, t3.CSERVICIO CSERVICIO, t3.ESERVICIO ESERVICIO, t1.URGENTE URGENTE ");
		query.append("FROM CODIGO t1, CLASE t2, SERVICIOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapClase(idClase);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCLASE=t2.IDCLASE(+) AND t1.IDSERVICIO = t3.IDSERVICIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (language.equalsIgnoreCase("es"))
			query.append(" ORDER BY t1.BAJA, t1.CCODIGO");
		else
			query.append(" ORDER BY t1.BAJA, t1.ECODIGO");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Codigo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());

	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Codigo entity
	 * 
	 * @param codigo
	 *            Codigo Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Codigo codigo) {

		StringBuilder where = new StringBuilder(
				CodigoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (codigo != null && codigo.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(codigo.getIdcodigo());
		}
		if (codigo != null && codigo.getCodigo() != null) {
			where.append(" AND t1.CODIGO = ?");
			params.add(codigo.getCodigo());
		}
		if (codigo != null && codigo.getCcodigo() != null) {
			where.append(" AND t1.CCODIGO = ?");
			params.add(codigo.getCcodigo());
		}
		if (codigo != null && codigo.getEcodigo() != null) {
			where.append(" AND t1.ECODIGO = ?");
			params.add(codigo.getEcodigo());
		}
		if (codigo != null && codigo.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(codigo.getIdclase());
		}
		if (codigo != null && codigo.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(codigo.getBaja());
		}
		if (codigo != null && codigo.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(codigo.getFeini());
		}
		if (codigo != null && codigo.getUsupubli() != null) {
			where.append(" AND t1.USUPUBLI = ?");
			params.add(codigo.getUsupubli());
		}
		if (codigo != null && codigo.getRecibeinci() != null) {
			where.append(" AND t1.RECIBE_INCI = ?");
			params.add(codigo.getRecibeinci());
		}
		if (codigo != null && codigo.getContrata() != null) {
			where.append(" AND t1.CONTRATA = ?");
			params.add(codigo.getContrata());
		}
		if (codigo != null && codigo.getIdservicio() != null
				&& codigo.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(codigo.getIdservicio());
		}
		if (codigo != null && codigo.getUrgente() != null) {
			where.append(" AND t1.URGENTE = ?");
			params.add(codigo.getUrgente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Codigo entity
	 * 
	 * @param idClase
	 *            String Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */

	private Map<String, ?> getWhereMapClase(String idClase) {

		StringBuilder where = new StringBuilder(
				CodigoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (idClase != null && !(idClase.equals(""))) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(idClase);
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Codigo entity
	 * 
	 * @param codigo
	 *            Codigo Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Codigo codigo, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CodigoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (codigo != null && codigo.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(codigo.getIdcodigo());
		}
		if (codigo != null && codigo.getCodigo() != null) {
			where.append(" AND UPPER(t1.CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getCodigo().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getCodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CODIGO IS NOT NULL");
		}
		if (codigo != null && codigo.getCcodigo() != null) {
			where.append(" AND UPPER(t1.CCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getCcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getCcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CCODIGO IS NOT NULL");
		}
		if (codigo != null && codigo.getEcodigo() != null) {
			where.append(" AND UPPER(t1.ECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getEcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getEcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ECODIGO IS NOT NULL");
		}
		if (codigo != null && codigo.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(codigo.getIdclase());
		}
		if (codigo != null && codigo.getClase() != null
				&& codigo.getClase().getCclase() != null) {
			where.append(" AND UPPER(t2.CCLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getClase().getCclase().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getClase().getCclase().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CCLASE IS NOT NULL");
		}
		if (codigo != null && codigo.getClase() != null
				&& codigo.getClase().getEclase() != null) {
			where.append(" AND UPPER(t2.ECLASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getClase().getEclase().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getClase().getEclase().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ECLASE IS NOT NULL");
		}
		if (codigo != null && codigo.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (codigo != null && codigo.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(codigo.getFeini());
		}
		if (codigo != null && codigo.getUsupubli() != null) {
			where.append(" AND UPPER(t1.USUPUBLI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getUsupubli().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getUsupubli().toUpperCase() + "%");
			}
			where.append(" AND t1.USUPUBLI IS NOT NULL");
		}
		if (codigo != null && codigo.getRecibeinci() != null) {
			where.append(" AND UPPER(t1.RECIBE_INCI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getRecibeinci().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getRecibeinci().toUpperCase() + "%");
			}
			where.append(" AND t1.RECIBE_INCI IS NOT NULL");
		}
		if (codigo != null && codigo.getContrata() != null) {
			where.append(" AND UPPER(t1.CONTRATA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getContrata().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getContrata().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTRATA IS NOT NULL");
		}
		if (codigo != null && codigo.getIdservicio() != null
				&& codigo.getIdservicio() != 0) {
			where.append(" AND t1.IDSERVICIO = ?");
			params.add(codigo.getIdservicio());
		}
		if (codigo != null && codigo.getServicio() != null
				&& codigo.getServicio().getCservicio() != null) {
			where.append(" AND UPPER(t3.CSERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getServicio().getCservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ codigo.getServicio().getCservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.CSERVICIO IS NOT NULL");
		}
		if (codigo != null && codigo.getServicio() != null
				&& codigo.getServicio().getEservicio() != null) {
			where.append(" AND UPPER(t3.ESERVICIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getServicio().getEservicio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ codigo.getServicio().getEservicio().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ESERVICIO IS NOT NULL");
		}
		if (codigo != null && codigo.getUrgente() != null) {
			where.append(" AND UPPER(t1.URGENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(codigo.getUrgente().toUpperCase() + "%");
			} else {
				params.add("%" + codigo.getUrgente().toUpperCase() + "%");
			}
			where.append(" AND t1.URGENTE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
