package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Codigo;

/**
 * CodigoDao generated by UDA, 28-nov-2014 12:22:02.
 * 
 * @author UDA
 */

public interface CodigoDao {

	/**
	 * Inserts a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo add(Codigo codigo);

	/**
	 * Updates a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo update(Codigo codigo);

	/**
	 * Finds a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	Codigo find(Codigo codigo);

	/**
	 * Deletes a single row in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return
	 */
	void remove(Codigo codigo);

	/**
	 * Finds a List of rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Codigo> findAll(Codigo codigo, Pagination pagination);

	/**
	 * obtener los codigos que esten en situación de Alta.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return List
	 */
	List<Codigo> obtenerCodigosAlta(Codigo codigo);

	/**
	 * Counts rows in the Codigo table.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Long
	 */
	Long findAllCount(Codigo codigo);

	/**
	 * Finds rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Codigo> findAllLike(Codigo codigo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Codigo table using like.
	 * 
	 * @param codigo
	 *            Codigo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Codigo codigo, Boolean startsWith);

	List<Codigo> obtenerActivosClase(String idClase, String language);

	/**
	 * Pone a cero el campo UsuPubli a todos los Codigos pertenecientes a una
	 * clase.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo deschequearUsuPubli(Codigo codigo);

	/**
	 * Pone a 1 el campo UsuPubli a todos los Codigos pertenecientes a una
	 * clase.
	 * 
	 * @param codigo
	 *            Pagination
	 * @return Codigo
	 */
	public Codigo chequearUsuPubli(Codigo codigo);
}
