package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clasecontrata;

/**
 * ClasecontrataDaoImpl generated by UDA, 17-abr-2015 11:56:30.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class ClasecontrataDaoImpl implements ClasecontrataDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Clasecontrata> rwMap = new RowMapper<Clasecontrata>() {
		public Clasecontrata mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Clasecontrata clasecontrata = new Clasecontrata();
			clasecontrata.setIdclase(resultSet.getInt("IDCLASE"));
			clasecontrata.setIdtecnico(resultSet.getLong("IDTECNICO"));
			clasecontrata.setFeini(resultSet.getDate("FEINI"));
			clasecontrata.setBaja(resultSet.getString("BAJA"));
			clasecontrata.setIdcodigo(resultSet.getInt("IDCODIGO"));
			clasecontrata.setNombre("");
			return clasecontrata;
		}
	};

	private RowMapper<Clasecontrata> rwMapNombre = new RowMapper<Clasecontrata>() {
		public Clasecontrata mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Clasecontrata clasecontrata = new Clasecontrata();
			clasecontrata.setIdclase(resultSet.getInt("IDCLASE"));
			clasecontrata.setIdtecnico(resultSet.getLong("IDTECNICO"));
			clasecontrata.setFeini(resultSet.getDate("FEINI"));
			clasecontrata.setBaja(resultSet.getString("BAJA"));
			clasecontrata.setIdcodigo(resultSet.getInt("IDCODIGO"));
			clasecontrata.setNombre(resultSet.getString("NOMBRE"));
			return clasecontrata;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	public Clasecontrata add(Clasecontrata clasecontrata) {

		StringBuilder query = new StringBuilder(
				"merge INTO CLASECONTRATA t1 USING dual ON ( t1.IDCLASE=? AND t1.IDTECNICO=? AND t1.IDCODIGO=? ) ");
		query.append(" WHEN matched THEN UPDATE SET t1.BAJA = 0 WHEN NOT matched THEN  ");
		query.append(" INSERT (IDCLASE, IDTECNICO, FEINI, BAJA, IDCODIGO) VALUES (?,?,?,?,?) ");

		// String query =
		// "INSERT INTO CLASECONTRATA (IDCLASE, IDTECNICO, FEINI, BAJA, IDCODIGO) VALUES (?,?,?,?,?)";
		this.jdbcTemplate
				.update(query.toString(),
						clasecontrata.getIdclase(),
						clasecontrata.getIdtecnico(),
						clasecontrata.getIdcodigo(),
						clasecontrata.getIdclase(),
						clasecontrata.getIdtecnico(),
						clasecontrata.getFeini(),
						clasecontrata.getBaja() == null ? "0" : clasecontrata
								.getBaja(),
						clasecontrata.getIdcodigo() == null ? 0 : clasecontrata
								.getIdcodigo());
		return clasecontrata;
	}

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	public Clasecontrata update(Clasecontrata clasecontrata) {
		String query = "UPDATE CLASECONTRATA SET FEINI=?, BAJA=? WHERE IDCLASE=? AND IDTECNICO=? AND IDCODIGO=?";
		this.jdbcTemplate
				.update(query, clasecontrata.getFeini(), clasecontrata
						.getBaja() == null ? "0" : clasecontrata.getBaja(),
						clasecontrata.getIdclase(), clasecontrata
								.getIdtecnico(), clasecontrata.getIdcodigo());
		return clasecontrata;
	}

	/**
	 * Updates a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	public Clasecontrata cambiarCodigo(Clasecontrata clasecontrata) {
		String query = "UPDATE CLASECONTRATA SET IDCODIGO=?, FEINI=?, BAJA=? WHERE IDCLASE=? AND IDTECNICO=? AND IDCODIGO=0";
		this.jdbcTemplate.update(query, clasecontrata.getIdcodigo() == null ? 0
				: clasecontrata.getIdcodigo(), clasecontrata.getFeini(), "0",
				clasecontrata.getIdclase(), clasecontrata.getIdtecnico());
		return clasecontrata;
	}

	/**
	 * poner el codigo de baja.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	public Clasecontrata ponerCodigoBaja(Clasecontrata clasecontrata) {
		String query = "UPDATE CLASECONTRATA SET BAJA=?, FEINI=? WHERE IDCLASE=? AND IDTECNICO=? AND IDCODIGO=?";
		this.jdbcTemplate.update(query, "1", clasecontrata.getFeini(),
				clasecontrata.getIdclase(), clasecontrata.getIdtecnico(),
				clasecontrata.getIdcodigo());
		return clasecontrata;
	}

	/**
	 * actualizar el codigo a cero.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	public Clasecontrata ponerCodigoCero(Clasecontrata clasecontrata) {
		String query = "UPDATE CLASECONTRATA SET IDCODIGO=0, FEINI=? WHERE IDCLASE=? AND IDTECNICO=? AND IDCODIGO=?";
		this.jdbcTemplate.update(query, clasecontrata.getFeini(),
				clasecontrata.getIdclase(), clasecontrata.getIdtecnico(),
				clasecontrata.getIdcodigo());
		return clasecontrata;
	}

	/**
	 * Finds a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return Clasecontrata
	 */
	@Transactional(readOnly = true)
	public Clasecontrata find(Clasecontrata clasecontrata) {
		String query = "SELECT t1.IDCLASE IDCLASE, t1.IDTECNICO IDTECNICO, t1.FEINI FEINI, t1.BAJA BAJA, t1.IDCODIGO IDCODIGO FROM CLASECONTRATA t1  WHERE t1.IDCLASE = ?   AND t1.IDTECNICO = ?  AND t1.IDCODIGO = ? ";

		List<Clasecontrata> clasecontrataList = this.jdbcTemplate.query(query,
				this.rwMap, clasecontrata.getIdclase(),
				clasecontrata.getIdtecnico(), clasecontrata.getIdcodigo());
		return (Clasecontrata) DataAccessUtils.uniqueResult(clasecontrataList);
	}

	/**
	 * Counts tecnicos asociados a una clase.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long tecnicosAsociadosAClase(Clasecontrata clasecontrata) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CLASECONTRATA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(clasecontrata);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Removes a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return
	 */
	public void remove(Clasecontrata clasecontrata) {
		String query = "DELETE FROM CLASECONTRATA WHERE IDCLASE=? AND IDTECNICO=? AND IDCODIGO=?";
		this.jdbcTemplate.update(query, clasecontrata.getIdclase(),
				clasecontrata.getIdtecnico(), clasecontrata.getIdcodigo());
	}

	/**
	 * Removes a single row in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Pagination
	 * @return
	 */
	public void eliminarClaseContrata(Clasecontrata clasecontrata) {
		String query = "DELETE FROM CLASECONTRATA WHERE IDCLASE=? AND IDTECNICO=? ";
		this.jdbcTemplate.update(query, clasecontrata.getIdclase(),
				clasecontrata.getIdtecnico());
	}

	/**
	 * Finds a List of rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Clasecontrata> findAll(Clasecontrata clasecontrata,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDCLASE IDCLASE,t1.IDTECNICO IDTECNICO,t1.FEINI FEINI,t1.BAJA BAJA,t1.IDCODIGO IDCODIGO, t2.NOMBRE NOMBRE ");
		query.append("FROM CLASECONTRATA t1, TECNICOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(clasecontrata);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDTECNICO=t2.IDTECNICO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Clasecontrata>) this.jdbcTemplate.query(query.toString(),
				this.rwMapNombre, params.toArray());
	}

	/**
	 * Counts rows in the Clasecontrata table.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Clasecontrata clasecontrata) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CLASECONTRATA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(clasecontrata);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Clasecontrata> findAllLike(Clasecontrata clasecontrata,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDCLASE IDCLASE,t1.IDTECNICO IDTECNICO,t1.FEINI FEINI,t1.BAJA BAJA,t1.IDCODIGO IDCODIGO ");
		query.append("FROM CLASECONTRATA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(clasecontrata,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Clasecontrata>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Clasecontrata table using like.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Clasecontrata clasecontrata, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CLASECONTRATA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(clasecontrata,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Clasecontrata entity
	 * 
	 * @param clasecontrata
	 *            Clasecontrata Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Clasecontrata clasecontrata) {

		StringBuilder where = new StringBuilder(
				ClasecontrataDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (clasecontrata != null && clasecontrata.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(clasecontrata.getIdclase());
		}
		if (clasecontrata != null && clasecontrata.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(clasecontrata.getIdtecnico());
		}
		if (clasecontrata != null && clasecontrata.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(clasecontrata.getFeini());
		}
		if (clasecontrata != null && clasecontrata.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(clasecontrata.getBaja());
		}
		if (clasecontrata != null && clasecontrata.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(clasecontrata.getIdcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Clasecontrata entity
	 * 
	 * @param clasecontrata
	 *            Clasecontrata Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Clasecontrata clasecontrata,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ClasecontrataDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (clasecontrata != null && clasecontrata.getIdclase() != null) {
			where.append(" AND t1.IDCLASE = ?");
			params.add(clasecontrata.getIdclase());
		}
		if (clasecontrata != null && clasecontrata.getIdtecnico() != null) {
			where.append(" AND t1.IDTECNICO = ?");
			params.add(clasecontrata.getIdtecnico());
		}
		if (clasecontrata != null && clasecontrata.getFeini() != null) {
			where.append(" AND t1.FEINI = ?");
			params.add(clasecontrata.getFeini());
		}
		if (clasecontrata != null && clasecontrata.getBaja() != null) {
			where.append(" AND UPPER(t1.BAJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(clasecontrata.getBaja().toUpperCase() + "%");
			} else {
				params.add("%" + clasecontrata.getBaja().toUpperCase() + "%");
			}
			where.append(" AND t1.BAJA IS NOT NULL");
		}
		if (clasecontrata != null && clasecontrata.getIdcodigo() != null) {
			where.append(" AND t1.IDCODIGO = ?");
			params.add(clasecontrata.getIdcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
