package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Cuestionario;
import com.ejie.aa20b.model.Maquinas;

/**
 * ActuacionDaoImpl generated by UDA, 05-mar-2015 10:57:47.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class ActuacionDaoImpl implements ActuacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Actuacion> rwMap = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Actuacion(resultSet.getInt("IDACTUACION"),
					resultSet.getInt("IDFICHA"),
					resultSet.getLong("IDMAQUINA"),
					resultSet.getInt("IDCUESTIONARIO"),
					resultSet.getInt("IDPARTE"), resultSet.getDate("FECHA"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getLong("TIEMPO"),
					resultSet.getDate("FEPREVISTA"));
		}
	};
	private RowMapper<Actuacion> rwMapGrid = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Actuacion actuacion = new Actuacion();
			actuacion.setIdactuacion(resultSet.getInt("IDACTUACION"));
			actuacion.setIdficha(resultSet.getInt("IDFICHA"));
			actuacion.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			actuacion.setIdcuestionario(resultSet.getInt("IDCUESTIONARIO"));
			actuacion.setAct(resultSet.getString("ACT"));
			Cuestionario cuestionario = new Cuestionario();
			cuestionario.setIdcuestionario(resultSet.getInt("IDCUESTIONARIO"));
			cuestionario.setNroorden(resultSet.getLong("NROORDEN"));
			cuestionario.setOperacion(resultSet.getString("OPERACION"));
			cuestionario.setSemanas(resultSet.getLong("SEMANAS"));
			actuacion.setCuestionario(cuestionario);
			actuacion.setIdparte(resultSet.getInt("IDPARTE"));
			actuacion.setFecha(resultSet.getDate("FECHA"));
			actuacion.setDescripcion(resultSet.getString("DESCRIPCION"));
			actuacion.setTiempo(resultSet.getLong("TIEMPO"));
			actuacion.setFeprevista(resultSet.getDate("FEPREVISTA"));

			return actuacion;
		}
	};

	private RowMapper<Actuacion> rwMapCompleto = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Actuacion actuacion = new Actuacion();
			actuacion.setIdactuacion(resultSet.getInt("IDACTUACION"));
			actuacion.setIdficha(resultSet.getInt("IDFICHA"));
			actuacion.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			Maquinas maquina = new Maquinas();
			maquina.setIdmaquina(resultSet.getLong("IDMAQUINA"));
			maquina.setCmaquina(resultSet.getString("CMAQUINA"));
			maquina.setEmaquina(resultSet.getString("EMAQUINA"));
			actuacion.setMaquina(maquina);
			actuacion.setIdcuestionario(resultSet.getInt("IDCUESTIONARIO"));
			actuacion.setAct(resultSet.getString("ACT"));
			Cuestionario cuestionario = new Cuestionario();
			cuestionario.setIdcuestionario(resultSet.getInt("IDCUESTIONARIO"));
			cuestionario.setNroorden(resultSet.getLong("NROORDEN"));
			cuestionario.setOperacion(resultSet.getString("OPERACION"));
			cuestionario.setSemanas(resultSet.getLong("SEMANAS"));
			actuacion.setCuestionario(cuestionario);
			actuacion.setIdparte(resultSet.getInt("IDPARTE"));
			actuacion.setFecha(resultSet.getDate("FECHA"));
			actuacion.setDescripcion(resultSet.getString("DESCRIPCION"));
			actuacion.setTiempo(resultSet.getLong("TIEMPO"));
			actuacion.setFeprevista(resultSet.getDate("FEPREVISTA"));

			return actuacion;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion add(Actuacion actuacion) {

		// Obtener el id correlativo
		Integer idCorrelativo = this.jdbcTemplate
				.queryForInt("SELECT ACTUACION_SEQ.NEXTVAL FROM DUAL");

		actuacion.setIdactuacion(idCorrelativo);

		String query = "INSERT INTO ACTUACION (IDACTUACION, IDFICHA, IDMAQUINA, IDCUESTIONARIO, IDPARTE, FECHA, DESCRIPCION, TIEMPO, FEPREVISTA) VALUES (?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, actuacion.getIdactuacion(),
				actuacion.getIdficha(), actuacion.getIdmaquina(),
				actuacion.getIdcuestionario(), actuacion.getIdparte(),
				actuacion.getFecha(), actuacion.getDescripcion(),
				actuacion.getTiempo(), actuacion.getFeprevista());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion update(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET IDFICHA=?, IDMAQUINA=?, IDCUESTIONARIO=?, IDPARTE=?, FECHA=?, DESCRIPCION=?, TIEMPO=?, FEPREVISTA=? WHERE IDACTUACION=?";
		this.jdbcTemplate.update(query, actuacion.getIdficha(),
				actuacion.getIdmaquina(), actuacion.getIdcuestionario(),
				actuacion.getIdparte(), actuacion.getFecha(),
				actuacion.getDescripcion(), actuacion.getTiempo(),
				actuacion.getFeprevista(), actuacion.getIdactuacion());
		return actuacion;
	}

	/**
	 * poner a null el campo idParte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Integer
	 */
	public Integer vaciarIdparte(Integer idParte) {
		String query = "UPDATE ACTUACION SET IDPARTE=NULL WHERE IDPARTE=?";
		return this.jdbcTemplate.update(query, idParte);
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion actualizarIdparte(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET IDPARTE=? WHERE IDACTUACION=?";
		this.jdbcTemplate.update(query, actuacion.getIdparte(),
				actuacion.getIdactuacion());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion modificaActuacion(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET FECHA=?, DESCRIPCION=?, FEPREVISTA=? WHERE IDACTUACION=?";
		this.jdbcTemplate.update(query, actuacion.getFecha(),
				actuacion.getDescripcion(), actuacion.getFeprevista(),
				actuacion.getIdactuacion());
		return actuacion;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion find(Actuacion actuacion) {
		String query = "SELECT t1.IDACTUACION IDACTUACION, t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t1.IDCUESTIONARIO IDCUESTIONARIO, t1.IDPARTE IDPARTE, t1.FECHA FECHA, t1.DESCRIPCION DESCRIPCION, t1.TIEMPO TIEMPO, t1.FEPREVISTA FEPREVISTA FROM ACTUACION t1  WHERE t1.IDACTUACION = ?  ";

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query,
				this.rwMap, actuacion.getIdactuacion());
		return (Actuacion) DataAccessUtils.uniqueResult(actuacionList);
	}

	/**
	 * ¿el cuestionario tiene actuaciones?.
	 * 
	 * @param idcuestionario
	 *            Integer
	 * @return Boolean
	 */
	@Transactional(readOnly = true)
	public Boolean cuestionarioTieneActuaciones(Integer idcuestionario) {
		String query = "SELECT  t1.IDACTUACION IDACTUACION, t1.IDFICHA IDFICHA, t1.IDMAQUINA IDMAQUINA, t1.IDCUESTIONARIO IDCUESTIONARIO, t1.IDPARTE IDPARTE, t1.FECHA FECHA, t1.DESCRIPCION DESCRIPCION, t1.TIEMPO TIEMPO, t1.FEPREVISTA FEPREVISTA FROM ACTUACION t1 WHERE t1.IDCUESTIONARIO = ?  ";

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query,
				this.rwMap, idcuestionario);
		if (actuacionList.size() > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Removes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return
	 */
	public void remove(Actuacion actuacion) {
		String query = "DELETE FROM ACTUACION WHERE IDACTUACION=?";
		this.jdbcTemplate.update(query, actuacion.getIdactuacion());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDACTUACION IDACTUACION,t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.IDCUESTIONARIO IDCUESTIONARIO,t1.IDPARTE IDPARTE,t1.FECHA FECHA,t1.DESCRIPCION DESCRIPCION,t1.TIEMPO TIEMPO,t1.FEPREVISTA FEPREVISTA ");
		query.append("FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion obtenerActuacion(Actuacion actuacion) {
		String query = "SELECT  t1.IDACTUACION IDACTUACION,t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t3.CMAQUINA CMAQUINA,t3.EMAQUINA EMAQUINA,t1.IDCUESTIONARIO IDCUESTIONARIO, t2.NROORDEN NROORDEN, t2.OPERACION OPERACION, (t2.nroorden || ' - ' || t2.operacion) as ACT,"
				+ " t2.SEMANAS SEMANAS, t1.IDPARTE IDPARTE,t1.FECHA FECHA,t1.DESCRIPCION DESCRIPCION,t1.TIEMPO TIEMPO,t1.FEPREVISTA FEPREVISTA"
				+ " FROM ACTUACION t1, CUESTIONARIO t2, MAQUINAS t3  WHERE t1.IDCUESTIONARIO=t2.IDCUESTIONARIO AND t1.IDMAQUINA=t3.IDMAQUINA AND t1.IDACTUACION = ?  ";

		List<Actuacion> actuacionList = this.jdbcTemplate.query(query,
				this.rwMapCompleto, actuacion.getIdactuacion());
		return (Actuacion) DataAccessUtils.uniqueResult(actuacionList);
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> obtenerActuaciones(Actuacion actuacion,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDACTUACION IDACTUACION,t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.IDCUESTIONARIO IDCUESTIONARIO, t2.NROORDEN NROORDEN, t2.OPERACION OPERACION, (t2.nroorden || ' - ' || t2.operacion) as ACT, t2.SEMANAS SEMANAS, t1.IDPARTE IDPARTE,t1.FECHA FECHA,t1.DESCRIPCION DESCRIPCION,t1.TIEMPO TIEMPO,t1.FEPREVISTA FEPREVISTA ");
		query.append("FROM ACTUACION t1, CUESTIONARIO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCUESTIONARIO=t2.IDCUESTIONARIO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				this.rwMapGrid, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long obtenerActuacionesCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTUACION t1, CUESTIONARIO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(actuacion);
		StringBuilder where = new StringBuilder(
				" WHERE t1.IDCUESTIONARIO=t2.IDCUESTIONARIO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAllLike(Actuacion actuacion,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDACTUACION IDACTUACION,t1.IDFICHA IDFICHA,t1.IDMAQUINA IDMAQUINA,t1.IDCUESTIONARIO IDCUESTIONARIO,t1.IDPARTE IDPARTE,t1.FECHA FECHA,t1.DESCRIPCION DESCRIPCION,t1.TIEMPO TIEMPO,t1.FEPREVISTA FEPREVISTA ");
		query.append("FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actuacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Actuacion actuacion, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ACTUACION t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(actuacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Actuacion actuacion) {

		StringBuilder where = new StringBuilder(
				ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getIdactuacion() != null) {
			where.append(" AND t1.IDACTUACION = ?");
			params.add(actuacion.getIdactuacion());
		}
		if (actuacion != null && actuacion.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(actuacion.getIdficha());
		}
		if (actuacion != null && actuacion.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(actuacion.getIdmaquina());
		}
		if (actuacion != null && actuacion.getIdcuestionario() != null) {
			where.append(" AND t1.IDCUESTIONARIO = ?");
			params.add(actuacion.getIdcuestionario());
		}
		if (actuacion != null && actuacion.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(actuacion.getIdparte());
		}
		if (actuacion != null && actuacion.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(actuacion.getFecha());
		}
		if (actuacion != null && actuacion.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(actuacion.getDescripcion());
		}
		if (actuacion != null && actuacion.getTiempo() != null) {
			where.append(" AND t1.TIEMPO = ?");
			params.add(actuacion.getTiempo());
		}
		if (actuacion != null && actuacion.getFeprevista() != null) {
			where.append(" AND t1.FEPREVISTA = ?");
			params.add(actuacion.getFeprevista());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Actuacion entity
	 * 
	 * @param actuacion
	 *            Actuacion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Actuacion actuacion,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ActuacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (actuacion != null && actuacion.getIdactuacion() != null) {
			where.append(" AND t1.IDACTUACION = ?");
			params.add(actuacion.getIdactuacion());
		}
		if (actuacion != null && actuacion.getIdficha() != null) {
			where.append(" AND t1.IDFICHA = ?");
			params.add(actuacion.getIdficha());
		}
		if (actuacion != null && actuacion.getIdmaquina() != null) {
			where.append(" AND t1.IDMAQUINA = ?");
			params.add(actuacion.getIdmaquina());
		}
		if (actuacion != null && actuacion.getIdcuestionario() != null) {
			where.append(" AND t1.IDCUESTIONARIO = ?");
			params.add(actuacion.getIdcuestionario());
		}
		if (actuacion != null && actuacion.getIdparte() != null) {
			where.append(" AND t1.IDPARTE = ?");
			params.add(actuacion.getIdparte());
		}
		if (actuacion != null && actuacion.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(actuacion.getFecha());
		}
		if (actuacion != null && actuacion.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDescripcion().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getDescripcion().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTiempo() != null) {
			where.append(" AND t1.TIEMPO = ?");
			params.add(actuacion.getTiempo());
		}
		if (actuacion != null && actuacion.getFeprevista() != null) {
			where.append(" AND t1.FEPREVISTA = ?");
			params.add(actuacion.getFeprevista());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
