package com.ejie.aa20b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Actuacion;

/**
 * ActuacionDao generated by UDA, 05-mar-2015 10:57:47.
 * 
 * @author UDA
 */

public interface ActuacionDao {

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion add(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion update(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion find(Actuacion actuacion);

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void remove(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAll(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long findAllCount(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> obtenerActuaciones(Actuacion actuacion,
			Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	Long obtenerActuacionesCount(Actuacion actuacion);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Actuacion actuacion, Boolean startsWith);

	/**
	 * ¿el cuestionario tiene actuaciones?.
	 * 
	 * @param idcuestionario
	 *            Integer
	 * @return Boolean
	 */
	Boolean cuestionarioTieneActuaciones(Integer idcuestionario);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion obtenerActuacion(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion modificaActuacion(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion actualizarIdparte(Actuacion actuacion);

	/**
	 * poner a null el campo idParte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Integer
	 */
	Integer vaciarIdparte(Integer idParte);
}
