package com.ejie.aa20b.classes;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa20b.util.Aa20bConstantes;

public abstract class FormatearFecha {
	public static String formatearFechaHora(Timestamp fechaHora) {

		if (fechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOFECHACASTELLANO;

			if (LocaleContextHolder.getLocale().getLanguage()
					.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {

				formatoFechaHora = Aa20bConstantes.FORMATOFECHAEUSKERA;
			}

			return new SimpleDateFormat(formatoFechaHora).format(fechaHora);
		} else {
			return "";
		}
	}

	public static String formatearFechaHoraCAS(Timestamp fechaHora) {

		if (fechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOFECHACASTELLANO;

			return new SimpleDateFormat(formatoFechaHora).format(fechaHora);
		} else {
			return "";
		}
	}

	public static String formatearHora(Timestamp fechaHora) {

		if (fechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOHORA;

			if (LocaleContextHolder.getLocale().getLanguage()
					.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {

				formatoFechaHora = Aa20bConstantes.FORMATOHORA;
			}

			return new SimpleDateFormat(formatoFechaHora).format(fechaHora);
		} else {
			return "";
		}
	}

	public static Timestamp obtenerTimestamp(String strFechaHora) {

		if (strFechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOFECHACASTELLANO;

			if (LocaleContextHolder.getLocale().getLanguage()
					.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {

				formatoFechaHora = Aa20bConstantes.FORMATOFECHAEUSKERA;
			}

			try {
				return new java.sql.Timestamp(new SimpleDateFormat(
						formatoFechaHora).parse(strFechaHora).getTime());
			} catch (Exception ex) {
				return null;
			}
		} else {
			return null;
		}
	}

	public static String obtenerFechaHoraCAS(Date fechaHora) {

		if (fechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOFECHACASTELLANO_BD;

			return new SimpleDateFormat(formatoFechaHora).format(fechaHora);
		} else {
			return "";
		}
	}

	public static String obtenerFechaHoraEUS(Date fechaHora) {

		if (fechaHora != null) {
			String formatoFechaHora = Aa20bConstantes.FORMATOFECHAEUSKERA_BD;

			return new SimpleDateFormat(formatoFechaHora).format(fechaHora);
		} else {
			return "";
		}
	}

}