/*
 * t07b/exe/util/t07bFecha.java
 *
 * AGB,11/09/2006
 * 
 */

package com.ejie.aa20b.classes;

import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Calendar;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa20b.util.Aa20bConstantes;

//import error.t07bCError;
//import error.t07bEFechaErronea;

/**
 * Esta clase representa un conjunto de m�todos para el manejo de fechas y
 * horas.
 */
public class Aa20bFecha extends Aa20bFormatoFecha {
	public final static String SEPARADOR = "/";

	public final static String FECHA = "dd/MM/yyyy";
	public final static String FECHAEU = "yyyy/MM/dd";
	public final static String FECHA2 = "yyyyMMdd";
	public final static String FECHA3 = "yyyy/MM/dd";
	public final static String HORA_COMPLETA = "HH:mm:ss";
	public final static String HORA_MINUTOS = "HH:mm";

	/**
	 * Obtiene una nueva fecha con el formato dd-MM-yyyy a partir de una fecha
	 * date
	 * 
	 * @param dia
	 *            dia de fecha que queremos formatear
	 * @param mes
	 *            mes de fecha que queremos formatear
	 * @param anno
	 *            anno de fecha que queremos formatear
	 * @return Date fecha con el formato dd-MM-yyyy
	 */
	public static java.util.Date getFecha(String dia, String mes, String anno)
			throws Exception {
		String lauxFecha = dia + SEPARADOR + mes + SEPARADOR + anno;
		Locale lLocaleES = new Locale("es", "es");

		return string2Date(lauxFecha, lLocaleES);
	}

	public static String getFechaFormateada(Date date, Locale lLocale)
			throws Exception {
		SimpleDateFormat simpleDateFormat = null;

		if (lLocale.getLanguage().equals("es")) {
			simpleDateFormat = new SimpleDateFormat(FECHA);
		} else {
			simpleDateFormat = new SimpleDateFormat(FECHA3);
		}
		return simpleDateFormat.format(date);
	}

	public String convertirDeEuaEs(String fechaEu) {
		String fecha = "";
		String dia = "";
		String mes = "";
		String anio = "";

		dia = fechaEu.substring(8, 10);
		mes = fechaEu.substring(5, 7);
		anio = fechaEu.substring(0, 4);

		fecha = dia + SEPARADOR + mes + SEPARADOR + anio;

		return fecha;
	}

	public String convertirDeEsaEu(String fechaEs) {
		String fecha = "";
		String dia = "";
		String mes = "";
		String anio = "";

		dia = fechaEs.substring(0, 2);
		mes = fechaEs.substring(3, 5);
		anio = fechaEs.substring(6, 10);

		fecha = anio + SEPARADOR + mes + SEPARADOR + dia;

		return fecha;
	}

	/**
	 * Obtiene un String correspondiente a una nueva fecha con el formato
	 * dd-MM-yyyy
	 * 
	 * @param date
	 *            fecha que queremos formatear.
	 * @return String fecha con el formato dd-MM-yyyy
	 */
	public static String getFecha(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FECHA);
		return simpleDateFormat.format(date);
	}

	/**
	 * Obtiene un String correspondiente a una nueva fecha con el formato
	 * yyyyMMdd
	 * 
	 * @param date
	 *            fecha que queremos formatear.
	 * @return String fecha con el formato yyyyMMdd
	 */
	public static String getFecha2(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FECHA2);
		return simpleDateFormat.format(date);
	}

	/**
	 * Obtiene un Date correspondiente a una nueva fecha con el formato yyyyMMdd
	 * 
	 * @param String
	 *            fecha que queremos formatear.
	 * @return Date fecha obtenida
	 */
	public Date getFecha2(String date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FECHA2);
		return simpleDateFormat.parse(date, new ParsePosition(0));
	}

	/**
	 * Obtiene el d�a contenido en una fecha date
	 * 
	 * @param date
	 *            fecha a partir de la cual queremos obtener el d�a.
	 * @return int d�a contenido en la fecha.
	 * @throws t07bEFechaErronea
	 *             si se produce un error en el manejo de fechas.
	 */
	public static int getDia(Date date) throws Exception {
		if (date == null)
			return 0;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d");
		String s = simpleDateFormat.format(date);
		try {
			return Integer.valueOf(s).intValue();
		} catch (IllegalArgumentException e) {
			// System.out.println("Error de obtenci�n de d�a: "+e);

			throw new Exception(e);
		}
	}

	/**
	 * Obtiene el mes contenido en una fecha date
	 * 
	 * @param date
	 *            fecha a partir de la cual queremos obtener el mes.
	 * @return int mes contenido en la fecha.
	 * @throws t07bEFechaErronea
	 *             si se produce un error en el manejo de fechas.
	 */
	public int getMes(Date date) throws Exception {
		if (date == null)
			return 0;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M");
		String s = simpleDateFormat.format(date);
		try {
			return Integer.valueOf(s).intValue();
		} catch (IllegalArgumentException e) {
			// System.out.println("Error de obtenci�n de mes: "+e);

			throw new Exception(e);
		}

	}

	/**
	 * Obtiene el nombre del mes de una fecha date
	 * 
	 * @param date
	 *            fecha a partir de la cual queremos obtener el mes.
	 * @return String nombre del mes obtenido desde la fecha.
	 */
	public String getMesAsString(Date date) {
		if (date == null)
			return "";
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMMMMMMMM");
		return simpleDateFormat.format(date);
	}

	/**
	 * Obtiene el a�o contenido en una fecha date
	 * 
	 * @param date
	 *            fecha a partir de la cual queremos obtener el a�o.
	 * @return int a�o contenido en la fecha.
	 * @throws t07bEFechaErronea
	 *             si se produce un error en el manejo de fechas.
	 */
	public int getAno(Date date) throws Exception {
		if (date == null)
			return 0;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
		String s = simpleDateFormat.format(date);
		try {
			return Integer.valueOf(s).intValue();
		} catch (IllegalArgumentException e) {
			// System.out.println("Error de obtenci�n de a�o: "+e);

			throw new Exception(e);
		}
	}

	/**
	 * Obtiene un String correspondiente a una nueva hora con el formato
	 * HH:mm:ss
	 * 
	 * @return String hora con el formato HH:mm:ss
	 */
	public String getHoraCompleta() {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HORA_COMPLETA);
		return simpleDateFormat.format(new Date());
	}

	/**
	 * Obtiene un String correspondiente a una nueva hora con el formato
	 * HH:mm:ss
	 * 
	 * @param date
	 *            hora que queremos formatear
	 * @return String hora con el formato HH:mm:ss
	 */
	public String getHoraCompleta(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HORA_COMPLETA);
		return simpleDateFormat.format(date);
	}

	public String getHoraMinutos(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HORA_MINUTOS);
		return simpleDateFormat.format(date);
	}

	public int getNumDiasMes(int aintMes, int aintAnio) {
		GregorianCalendar gc = new GregorianCalendar(aintAnio, aintMes - 1, 1);
		return gc.getActualMaximum(GregorianCalendar.DAY_OF_MONTH);
	}

	// Recibida una fecha en formato dd/mm/aaaa le suma el numero de Dias
	// indicado en la variable numDias y la devuelve
	// en el mismo formato dd/mm/aaaa
	public String sumaDias(String fecha, int numDias) {

		String fechaLarga = "";

		if ((fecha != null) && (!fecha.equals(""))) {

			Locale lLocaleES = new Locale("es", "es");
			GregorianCalendar gc1 = new GregorianCalendar();
			SimpleDateFormat simpleDateFormat = null;

			try {
				gc1.setTime(string2Date(fecha, lLocaleES));
				gc1.clear(Calendar.MILLISECOND);
				gc1.clear(Calendar.SECOND);
				gc1.clear(Calendar.MINUTE);
				gc1.clear(Calendar.HOUR_OF_DAY);
				gc1.add(Calendar.DATE, numDias);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			Date fechaSiguiente = gc1.getTime();

			simpleDateFormat = new SimpleDateFormat(FECHA);
			fechaLarga = simpleDateFormat.format(fechaSiguiente);
		}
		return fechaLarga;
	}

	public Date getAyer() {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(new Date());
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.add(Calendar.DATE, -1);
		return gc1.getTime();
	}

	public static Date getHoy() {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(new Date());
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.add(Calendar.DATE, 0);
		return gc1.getTime();
	}

	public Date getManiana() {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(new Date());
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.add(Calendar.DATE, +1);
		return gc1.getTime();
	}

	public Date getFechasSiguientes(int numDiaMas) {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(new Date());
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.add(Calendar.DATE, +numDiaMas);
		return gc1.getTime();
	}

	public Date getFechasAnteriores(int numDiaMenos) {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(new Date());
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.add(Calendar.DATE, -numDiaMenos);
		return gc1.getTime();
	}

	public Date getPrimerDiaMes(Date adatFecha) {
		GregorianCalendar gc1 = new GregorianCalendar();
		gc1.setTime(adatFecha);
		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);
		gc1.set(Calendar.DAY_OF_MONTH, 1);
		return gc1.getTime();
	}

	public int getNumDiaSemana(String diaStr) {
		int numDia = 0;
		if (diaStr.equals("Mon")) {
			numDia = 2;
		} else if (diaStr.equals("Tue")) {
			numDia = 3;
		} else if (diaStr.equals("Wed")) {
			numDia = 4;
		} else if (diaStr.equals("Thu")) {
			numDia = 5;
		} else if (diaStr.equals("Fri")) {
			numDia = 6;
		} else if (diaStr.equals("Sat")) {
			numDia = 7;
		} else if (diaStr.equals("Sun")) {
			numDia = 1;
		}

		return numDia;
	}

	public int getDiasEntre(Date d1, Date d2) {
		GregorianCalendar g1 = new GregorianCalendar();
		g1.setTime(d1);
		GregorianCalendar g2 = new GregorianCalendar();
		g2.setTime(d2);

		int elapsed = 0;
		GregorianCalendar gc1, gc2;

		if (g2.after(g1)) {
			gc2 = (GregorianCalendar) g2.clone();
			gc1 = (GregorianCalendar) g1.clone();
		} else {
			gc2 = (GregorianCalendar) g1.clone();
			gc1 = (GregorianCalendar) g2.clone();
		}

		gc1.clear(Calendar.MILLISECOND);
		gc1.clear(Calendar.SECOND);
		gc1.clear(Calendar.MINUTE);
		gc1.clear(Calendar.HOUR_OF_DAY);

		gc2.clear(Calendar.MILLISECOND);
		gc2.clear(Calendar.SECOND);
		gc2.clear(Calendar.MINUTE);
		gc2.clear(Calendar.HOUR_OF_DAY);

		while (gc1.before(gc2)) {
			gc1.add(Calendar.DATE, 1);
			elapsed++;
		}
		return elapsed;
	}

	/*
	 * Devuelve el ejercicio del mes anterior
	 */
	public int getEjerMesAnterior(Date aDate) {
		GregorianCalendar lcal = new GregorianCalendar();
		lcal.setTime(aDate);
		lcal.add(Calendar.MONTH, -1);
		return lcal.get(Calendar.YEAR);
	}

	/*
	 * Devuelve el mes anterior
	 */
	public int getMesAnterior(Date aDate) {
		GregorianCalendar lcal = new GregorianCalendar();
		lcal.setTime(aDate);
		lcal.add(Calendar.MONTH, -1);
		return lcal.get(Calendar.MONTH) + 1;
	}

	/*
	 * Devuelve la diferencia en semanas entre dos fecjas
	 */
	public static int difSemanas(Date fechaDesde, Date fechaHasta) {
		GregorianCalendar lcalDesde = new GregorianCalendar();
		GregorianCalendar lcalHasta = new GregorianCalendar();
		lcalDesde.setTime(fechaDesde);
		lcalHasta.setTime(fechaHasta);

		// int diff = (int) ((lcalHasta.getTimeInMillis() - lcalDesde
		// .getTimeInMillis()) / (1000 * 60 * 60 * 24)) / 7;

		/**
		 * 27/10/2016 Se cambia ceil por round para que coja bien el día Si el
		 * número de días es 3 o menor se utilza el ceil para que cuente unas
		 * semana (redondea hacia arriba)
		 */

		int diff1 = (int) (double) ((lcalHasta.getTimeInMillis() - lcalDesde
				.getTimeInMillis()) / (1000 * 60 * 60 * 24));

		int diff = 0;
		if (diff1 <= 3) {
			diff = (int) Math
					.ceil((double) ((lcalHasta.getTimeInMillis() - lcalDesde
							.getTimeInMillis()) / (1000 * 60 * 60 * 24))
							/ (double) 7);
		} else {
			diff = (int) Math
					.round((double) ((lcalHasta.getTimeInMillis() - lcalDesde
							.getTimeInMillis()) / (1000 * 60 * 60 * 24))
							/ (double) 7);
		}

		return diff;
	}

	/*
	 * Devuelve la fecha sumados los dias
	 */
	public static Date addDias(Date fechaDesde, Integer diasMas) {
		GregorianCalendar lcalDesde = new GregorianCalendar();
		lcalDesde.setTime(fechaDesde);

		lcalDesde.add(Calendar.DAY_OF_YEAR, diasMas);

		return lcalDesde.getTime();
	}

	/*
	 * Devuelve la fecha sumadas las semanas
	 */
	public static Date addSemanas(Date fechaDesde, Integer semanasMas) {
		GregorianCalendar lcalDesde = new GregorianCalendar();
		lcalDesde.setTime(fechaDesde);

		lcalDesde.add(Calendar.DAY_OF_YEAR, semanasMas * 7);
		// lcalDesde.add(Calendar.WEEK_OF_YEAR, semanasMas);

		return lcalDesde.getTime();
	}

	public void main(String a[]) throws Exception {
		// Date d1 = t07bCFecha.getFecha("01", "01", "2002");
		// Date d2 = t07bCFecha.getFecha("01", "02", "2002");
		//
		// System.out.println(d1);
		// System.out.println(d2);
		//
		// t07bCLog.send(2,"t07bCFecha",t07bCFecha.getPrimerDiaMes(new
		// Date())+"");

		// int aintPorPsu = 50;
		// long alngImporte = 1005;
		//
		// System.out.println( ((double)aintPorPsu)/100.0);
		// System.out.println( 1-(((double)aintPorPsu)/100.0) );
		// System.out.println((double)alngImporte*(1-((double)aintPorPsu/100)));
		//
		// System.out.println(Math.round((double)alngImporte*(1-((double)aintPorPsu/100))));
		// String fecha = convertirFecha ("25/02/2007");
		// System.out.println("Fecha convertida 25/02/2007 : " + fecha);
	}

	public static String convertirFecha(String fecha) {

		String fechaLarga = "";

		if ((fecha != null) && (!fecha.equals(""))) {
			String dia = fecha.substring(0, 2);
			int diaInt = Integer.parseInt(dia);
			dia = Integer.toString(diaInt);

			String mes = fecha.substring(3, 5);
			String anio = fecha.substring(6);

			int mesInt = Integer.parseInt(mes);
			switch (mesInt) {
			case 1:
				mes = "enero";
				break;
			case 2:
				mes = "febrero";
				break;
			case 3:
				mes = "marzo";
				break;
			case 4:
				mes = "abril";
				break;
			case 5:
				mes = "mayo";
				break;
			case 6:
				mes = "junio";
				break;
			case 7:
				mes = "julio";
				break;
			case 8:
				mes = "agosto";
				break;
			case 9:
				mes = "septiembre";
				break;
			case 10:
				mes = "octubre";
				break;
			case 11:
				mes = "noviembre";
				break;
			case 12:
				mes = "diciembre";
				break;
			}
			fechaLarga = dia + " de " + mes + " de " + anio;
		}
		return fechaLarga;
	}

	public static String convertirFechaEu(String fecha) {

		String fechaLarga = "";
		String mesEu = "";

		if ((fecha != null) && (!fecha.equals(""))) {
			String dia = fecha.substring(0, 2);
			int diaInt = Integer.parseInt(dia);
			dia = Integer.toString(diaInt);

			String mes = fecha.substring(3, 5);

			String anio = fecha.substring(6);

			int mesInt = Integer.parseInt(mes);
			switch (mesInt) {
			case 1:
				mes = "enero";
				mesEu = "urtarrila";
				break;
			case 2:
				mes = "febrero";
				mesEu = "otsaila";
				break;
			case 3:
				mes = "marzo";
				mesEu = "martxoa";
				break;
			case 4:
				mes = "abril";
				mesEu = "apirila";
				break;
			case 5:
				mes = "mayo";
				mesEu = "maiatza";
				break;
			case 6:
				mes = "junio";
				mesEu = "ekaina";
				break;
			case 7:
				mes = "julio";
				mesEu = "uztaila";
				break;
			case 8:
				mes = "agosto";
				mesEu = "abuztua";
				break;
			case 9:
				mes = "septiembre";
				mesEu = "iraila";
				break;
			case 10:
				mes = "octubre";
				mesEu = "urria";
				break;
			case 11:
				mes = "noviembre";
				mesEu = "azaroa";
				break;
			case 12:
				mes = "diciembre";
				mesEu = "abendua";
				break;
			}

			fechaLarga = anio + " (e)ko " + mesEu + "ren " + dia + "(e)an";

		}
		return fechaLarga;
	}

	public static String getStringDiaSemana(Integer diaInt) {
		String strDia = "";
		if (diaInt.equals(1)) {
			strDia = "domingo";
		} else if (diaInt.equals(2)) {
			strDia = "lunes";
		} else if (diaInt.equals(3)) {
			strDia = "martes";
		} else if (diaInt.equals(4)) {
			strDia = "miercoles";
		} else if (diaInt.equals(5)) {
			strDia = "jueves";
		} else if (diaInt.equals(6)) {
			strDia = "viernes";
		} else if (diaInt.equals(7)) {
			strDia = "sabado";
		}

		return strDia;
	}

	public static String getStringDiaSemanaEu(Integer diaInt) {
		String strDia = "";
		if (diaInt.equals(1)) {
			strDia = "igandea";
		} else if (diaInt.equals(2)) {
			strDia = "astelehena";
		} else if (diaInt.equals(3)) {
			strDia = "asterartea";
		} else if (diaInt.equals(4)) {
			strDia = "asteazkena";
		} else if (diaInt.equals(5)) {
			strDia = "osteguna";
		} else if (diaInt.equals(6)) {
			strDia = "ostirala";
		} else if (diaInt.equals(7)) {
			strDia = "larunbata";
		}

		return strDia;
	}

	public static String convertirFechaCompleta(String fecha, Integer díaSemana) {

		String fechaLarga = "";

		if ((fecha != null) && (!fecha.equals(""))) {
			String dia = fecha.substring(0, 2);
			int diaInt = Integer.parseInt(dia);
			dia = Integer.toString(diaInt);

			String mes = fecha.substring(3, 5);
			String anio = fecha.substring(6);

			int mesInt = Integer.parseInt(mes);
			switch (mesInt) {
			case 1:
				mes = "enero";
				break;
			case 2:
				mes = "febrero";
				break;
			case 3:
				mes = "marzo";
				break;
			case 4:
				mes = "abril";
				break;
			case 5:
				mes = "mayo";
				break;
			case 6:
				mes = "junio";
				break;
			case 7:
				mes = "julio";
				break;
			case 8:
				mes = "agosto";
				break;
			case 9:
				mes = "septiembre";
				break;
			case 10:
				mes = "octubre";
				break;
			case 11:
				mes = "noviembre";
				break;
			case 12:
				mes = "diciembre";
				break;
			}
			fechaLarga = getStringDiaSemana(díaSemana) + ", " + dia + " de "
					+ mes + " de " + anio;
		}
		return fechaLarga;
	}

	public static String convertirFechaCompletaEu(String fecha,
			Integer díaSemana) {

		String fechaLarga = "";
		String mesEu = "";

		if ((fecha != null) && (!fecha.equals(""))) {
			String dia = fecha.substring(0, 2);
			int diaInt = Integer.parseInt(dia);
			dia = Integer.toString(diaInt);

			String mes = fecha.substring(3, 5);

			String anio = fecha.substring(6);

			int mesInt = Integer.parseInt(mes);
			switch (mesInt) {
			case 1:
				mes = "enero";
				mesEu = "urtarrila";
				break;
			case 2:
				mes = "febrero";
				mesEu = "otsaila";
				break;
			case 3:
				mes = "marzo";
				mesEu = "martxoa";
				break;
			case 4:
				mes = "abril";
				mesEu = "apirila";
				break;
			case 5:
				mes = "mayo";
				mesEu = "maiatza";
				break;
			case 6:
				mes = "junio";
				mesEu = "ekaina";
				break;
			case 7:
				mes = "julio";
				mesEu = "uztaila";
				break;
			case 8:
				mes = "agosto";
				mesEu = "abuztua";
				break;
			case 9:
				mes = "septiembre";
				mesEu = "iraila";
				break;
			case 10:
				mes = "octubre";
				mesEu = "urria";
				break;
			case 11:
				mes = "noviembre";
				mesEu = "azaroa";
				break;
			case 12:
				mes = "diciembre";
				mesEu = "abendua";
				break;
			}

			fechaLarga = anio + " (e)ko " + mesEu + "ren " + dia + ", "
					+ getStringDiaSemanaEu(díaSemana);

		}

		return fechaLarga;
	}

	public static String[] letraMesSemana(int anio) throws Exception {
		String sem[] = new String[54];
		for (int i = 0; i < 54; i++) {
			Calendar fechaCalendar = lunesSemana(anio, i);
			String mesEnLetra = mesLetra(fechaCalendar.get(Calendar.MONTH) + 1);
			// Sumo 1 al mes porque para calendar los meses van del 0 a 11
			sem[i] = mesEnLetra;
		}
		return sem;
	}

	public static Calendar lunesSemana(int anio, int semana) throws Exception {

		int numDias = 7 * semana; // Multiplicamo 7 días por el numero de
									// semanas

		Calendar miCalendar = Calendar.getInstance();

		Date miFecha = getFecha("01", "01", anio + "");
		miCalendar.setTime(miFecha);// Cogemos la fecha del 1 de enero del año
									// recibido . Para Calendar los meses van de
									// 0 a 11
		miCalendar.add(Calendar.DATE, numDias); // Sumamos los dias calculados

		Integer numDiasLunes = miCalendar.get(Calendar.DAY_OF_WEEK) - 2; // Dia
																			// de
																			// la
																			// semana
		miCalendar.add(Calendar.DATE, -numDiasLunes); // Restamos el día de la
														// semana para obetner
														// la
														// fecha del lunes de
														// esa
														// semana

		return miCalendar;
	}

	public static String mesLetra(int mesNumero) {
		String mesEu = "";
		String mes = "";

		switch (mesNumero) {
		case 1:
			mes = "E";
			mesEu = "U";
			break;
		case 2:
			mes = "F";
			mesEu = "O";
			break;
		case 3:
			mes = "M";
			mesEu = "M";
			break;
		case 4:
			mes = "A";
			mesEu = "A";
			break;
		case 5:
			mes = "M";
			mesEu = "M";
			break;
		case 6:
			mes = "Jn";
			mesEu = "E";
			break;
		case 7:
			mes = "Jl";
			mesEu = "U";
			break;
		case 8:
			mes = "A";
			mesEu = "A";
			break;
		case 9:
			mes = "S";
			mesEu = "I";
			break;
		case 10:
			mes = "O";
			mesEu = "U";
			break;
		case 11:
			mes = "N";
			mesEu = "A";
			break;
		case 12:
			mes = "D";
			mesEu = "Ab";
			break;
		}

		String idioma = LocaleContextHolder.getLocale().getLanguage();
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			return mesEu;
		} else {
			return mes;
		}
	}
}