package com.ejie.y41b.ws.arbitraje;

import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41b.service.EstablecimientoWSService;

/**
 * <p>
 * Titulo: Y41bArbitrajeService
 * </p>
 * <p>
 * Descripcion: Web Service de Y41B para recuperar informacion de
 * establecimientos adheridos
 * </p>
 * 
 */
@Stateless
@WebService(portName = "Y41bArbitrajeServicePort", serviceName = "Y41bArbitrajeService", targetNamespace = "http://com.ejie.y41b.arbitrajeservice", endpointInterface = "com.ejie.y41b.ws.arbitraje.Y41bArbitrajeService")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "handler.xml")
public class Y41bArbitrajeService extends SpringBeanAutowiringSupport {

	@Autowired()
	private EstablecimientoWSService establecimientoWSService;

	/**
	 * Metodo recuperar los datos de los establecimientos en base a un filtro de
	 * cif
	 * 
	 * @param cif
	 *            String
	 * @return String
	 * @throws Exception
	 *             e
	 */
	@WebMethod
	public String buscarEstablecimientosPorCif(
			@WebParam(name = "cif") String cif) throws Exception {
		return establecimientoWSService.buscarEstablecimientosPorCif(cif);
	}

	/**
	 * Metodo recuperar los datos de los establecimientos en base a un filtro de
	 * nombre
	 * 
	 * @param nombre
	 *            String
	 * @return String
	 * @throws Exception
	 *             e
	 */
	@WebMethod
	public String buscarEstablecimientosPorNombre(
			@WebParam(name = "nombre") String nombre) throws Exception {
		return establecimientoWSService.buscarEstablecimientosPorNombre(nombre);
	}
}
