package com.ejie.y41b.ws;

import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41b.service.CensoMonitorService;

/**
 * <p>
 * Titulo: Y41bWebService
 * </p>
 * <p>
 * Descipcion: Web Service de Y41B
 * </p>
 * <p>
 * Copyright: Copyright (c) 2016
 * </p>
 * <p>
 * Empresa: Bilbomatica
 * </p>
 * 
 *  
 * @version 1.0
 */
@Stateless
@WebService(portName = "Y41bWebServicePort", serviceName = "Y41bWebService", targetNamespace = "http://com.ejie.y41b.webservice", endpointInterface = "com.ejie.y41b.ws.Y41bWebService")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "handler.xml")
public class Y41bWebService extends SpringBeanAutowiringSupport {

	@Autowired
	private CensoMonitorService censoMonitorService;

	/**
	 * Metodo que actualiza el estado de Aa66
	 * 
	 * 
	 */
	@WebMethod
	public String actualizarEstadoAa66() {
		return censoMonitorService.enviarMensajeAColaPorCadaRemesa();
	}

}
