package com.ejie.y41b.validacionestoolkit;

import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41b.service.Y41bValidacionesToolkitService;

/**
 * <p>
 * Titulo: Y41bValidacionesToolkit
 * </p>
 * <p>
 * Descipcion: Web Service de Y41B para realizar validaciones en el toolkit
 * </p>
 * 
 */
@Stateless
@WebService(portName = "Y41bValidacionesToolkitPort", serviceName = "Y41bValidacionesToolkit", targetNamespace = "http://com.ejie.y41b.validacionestoolkit", endpointInterface = "com.ejie.y41b.validacionestoolkit.Y41bValidacionesToolkit")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "handler.xml")
public class Y41bValidacionesToolkit extends SpringBeanAutowiringSupport {

	@Autowired
	private Y41bValidacionesToolkitService y41bValidacionesToolkitService;

	/**
	 * Metodo para validar la reclamacion previa a partir del NIF del reclamante
	 * y el codigo del expediente
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	@WebMethod
	public boolean validarNifSolicitudes(@WebParam(name = "nif") String nif) throws Exception {
		return y41bValidacionesToolkitService.validarNifSolicitudes(nif);
	}

	/**
	 * Metodo para coger los datos de la reclamacion previa a partir del NIF del
	 * reclamante y el codigo del expediente
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	@WebMethod
	public String obtenerTipoSolicitud(@WebParam(name = "nif") String nif) throws Exception {
		return y41bValidacionesToolkitService.obtenerTipoSolicitud(nif);
	}

}
