package com.ejie.y41b.toolkit;

import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import javax.jws.WebParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41b.service.ArbsolteleService;

/**
 * <p>
 * Titulo: Y41bGestionReclamacionPrevia
 * </p>
 * <p>
 * Descipcion: Web Service de Y41B para validar y coger los datos de la
 * reclamacion desde el toolkit de formularios
 * </p>
 * 
 */
@Stateless
@WebService(portName = "Y41bGestionReclamacionPreviaPort", serviceName = "Y41bGestionReclamacionPrevia", targetNamespace = "http://com.ejie.y41b.gestionreclamacionprevia", endpointInterface = "com.ejie.y41b.toolkit.Y41bGestionReclamacionPrevia")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "handler.xml")
public class Y41bGestionReclamacionPrevia extends SpringBeanAutowiringSupport {

	@Autowired
	private ArbsolteleService arbsolteleService;

	/**
	 * Metodo para validar la reclamacion previa a partir del NIF del reclamante
	 * y el codigo del expediente
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	@WebMethod
	public boolean validarReclamacionPrevia(@WebParam(name = "nif") String nif,
			@WebParam(name = "codexpediente") String codexpediente)
			throws Exception {
		return arbsolteleService.validarReclamacionPrevia(nif, codexpediente);
	}

	/**
	 * Metodo para coger los datos de la reclamacion previa a partir del NIF del
	 * reclamante y el codigo del expediente
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	@WebMethod
	public String cogerDatosReclamacionPrevia(
			@WebParam(name = "nif") String nif,
			@WebParam(name = "codexpediente") String codexpediente,
			@WebParam(name = "campo") String campo) throws Exception {
		return (String) (arbsolteleService.cogerDatosReclamacionPrevia(nif,
				codexpediente)).get(campo);
	}

}
