package com.ejie.y41b.control.testing;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.StackTraceManager;

/**
 * Clase de Testing Padre para todos los controller de Test
 * 
 *  
 * 
 */
public class TestController {

	private static final long serialVersionUID = 1L;

	/**
	 * Method 'sendError'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @throws IOException
	 */
	protected void sendError(HttpServletResponse response, Throwable th)
			throws IOException {
		// th.printStackTrace();
		response.setContentType("text/javascript;charset=UTF-8");
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
		response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		response.getWriter().write(
				"ERROR:" + StackTraceManager.getStackTrace(th));
	}

	/**
	 * Method 'sendOK'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @throws IOException
	 */
	protected void sendOK(HttpServletResponse response) throws IOException {
		response.setContentType("text/javascript;charset=UTF-8");
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
		response.setStatus(HttpServletResponse.SC_OK);
		response.getWriter().write("Y41bDokusiServiceTest -> OK");
	}

	/**
	 * Method 'sendOK'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param msg
	 *            String
	 * @throws IOException
	 */
	protected void sendOK(HttpServletResponse response, String msg)
			throws IOException {
		response.setContentType("text/javascript;charset=UTF-8");
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
		response.setStatus(HttpServletResponse.SC_OK);
		response.getWriter().write("Y41bDokusiServiceTest -> OK. Rdo: " + msg);
	}
}
