package com.ejie.y41b.control.testing;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.CrearEJGV;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosCertificado;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.EnvioEJGV;
import com.ejie.y41b.model.platea.EnvioNotifEJGV;
import com.ejie.y41b.model.platea.Espera;
import com.ejie.y41b.model.platea.ExpedienteOficio;
import com.ejie.y41b.model.platea.Historico;
import com.ejie.y41b.model.platea.NotificacionPostal;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentSolicitud;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.RespuestaProcesarEspera;
import com.ejie.y41b.model.platea.RespuestaRegistrarHistorico;
import com.ejie.y41b.model.platea.RespuestaSolicitudTelematica;
import com.ejie.y41b.model.platea.SolicitudOficio;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.ws.cliente.x43notificaciones.AExtensionPoint;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocField;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocFieldList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TDocumentList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationFilter;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotificationList;
import com.ejie.y41b.ws.cliente.x43notificaciones.TStringList;

/**
 * Clase de Testing de Y41bPlateaAdapterService (Adaptador PLATEA)
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/y41bPlateaAdapterServiceTest")
public class PlateaServiceTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(PlateaServiceTestController.class);

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private SoltramexpService soltramexpService;

	/**
	 * Method 'testObtenerDatosCatalogoProcedimientos'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "obtenerDatosCatalogoProcedimientos", method = RequestMethod.GET)
	public ModelAndView testObtenerDatosCatalogoProcedimientos(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			ProcedureDocument procedureDocument = y41bPlateaAdapterService
					.obtenerDatosCatalogoProcedimientos(procedure);
			// Fin Bloque del Test
			sendOK(response, procedureDocument.toString());
			logger.debug("PlateaServiceTestController.testObtenerDatosCatalogoProcedimientos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testObtenerDatosCatalogoProcedimientos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testCrearSolicitudPresencial'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearSolicitudPresencialSinDocumentos", method = RequestMethod.GET)
	public ModelAndView testCrearSolicitudPresencialSinDocumentos(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");

			solicitudPresencial.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni("72739384K");
			datosPersona.setNombre("BILBOMATICA");

			solicitudPresencial.setSolicitante(datosPersona);

			solicitudPresencial.setNumeroExpediente("SAN-48L021/135/2000/1");

			solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			y41bPlateaAdapterService
					.crearSolicitudPresencial(solicitudPresencial);

			// Fin Bloque del Test
			sendOK(response, "");
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testAbrirExpedienteOficio'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "abrirExpedienteOficio", method = RequestMethod.GET)
	public ModelAndView testAbrirExpedienteOficio(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			/*
			 * METODO VIEJO
			 */
			// Inicio Bloque del Test
			ExpedienteOficio expedienteOficio = new ExpedienteOficio();

			expedienteOficio.setAperturaTimeStamp(Calendar.getInstance()
					.getTime().getTime()
					+ "");
			expedienteOficio.setBuzonId("V0V0AB1");
			expedienteOficio.setBuzonName("V0V0AB1");
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("v33aa_SANCIONADOR");
			expedienteOficio.setProcedure(procedure);

			DatosPersona solicitante = new DatosPersona();
			solicitante.setDni("72739384K");
			solicitante.setNombre("BILBOMATICA");
			expedienteOficio.setSolicitante(solicitante);
			NotificacionPostal notificacionPostal = new NotificacionPostal(
					"España", "Bizkaia", "Portugalete", "Portugalete",
					"Avenida Peñota", "1", "B", "48920");
			expedienteOficio.setNotificacionPostal(notificacionPostal);

			DatosPersona sancionado = new DatosPersona();
			sancionado.setDni("72739384K");
			sancionado.setNombre("BILBOMATICA");

			expedienteOficio.setSolicitante(sancionado);

			expedienteOficio = y41bPlateaAdapterService
					.abrirExpedienteOficio(expedienteOficio);

			// Fin Bloque del Test
			sendOK(response, expedienteOficio.toString());
			logger.debug("PlateaServiceTestController.testAbrirExpedienteOficio -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testAbrirExpedienteOficio -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testAbrirExpedienteOficio'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "abrirExpedienteOficioSanciones", method = RequestMethod.GET)
	public ModelAndView testAbrirExpedienteOficioSanciones(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			ExpedienteOficio expedienteOficio = new ExpedienteOficio();

			logger.info("ExpedienteServiceImpl. - Add. Preparar Llamada a Platea");

			SolicitudOficio solicitudOficio = new SolicitudOficio();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");

			solicitudOficio.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni("72739383C");
			datosPersona.setNombre("INSTRUCTOR");
			solicitudOficio.setSender(datosPersona);

			/* SANCIONADO */

			DatosPersona datosEstablecimientoSancionado = new DatosPersona();
			datosEstablecimientoSancionado.setDni("72739384K");
			datosEstablecimientoSancionado.setNombre("EL CORTE ALEMAN");
			datosEstablecimientoSancionado.setTelefono("945228260");
			datosEstablecimientoSancionado.setMail("amaiaa@odei.es");

			solicitudOficio.setSancionado(datosEstablecimientoSancionado);

			String idExpediente = "SAN-EJEMPLO" + (new Date()).toString();
			solicitudOficio.setNumeroExpediente(idExpediente);

			logger.debug("CREADO" + idExpediente);
			solicitudOficio.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			this.y41bPlateaAdapterService.crearSolicitudOficio(solicitudOficio);

			sendOK(response, expedienteOficio.toString());
			logger.debug("PlateaServiceTestController.testAbrirExpedienteOficio -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testAbrirExpedienteOficio -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testCrearSolicitudPresencial'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearSolicitudPresencialConUnDocumento", method = RequestMethod.GET)
	public ModelAndView testCrearSolicitudPresencialConUnDocumento(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");

			solicitudPresencial.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni("91919191J");
			datosPersona.setNombre("BILBOMATICA");

			solicitudPresencial.setSolicitante(datosPersona);

			solicitudPresencial.setNumeroExpediente("SOL-48L021/135/2013/1");

			solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			// Documento de solicitud
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("V08AB");
			user.setDni("V08AB");
			documento.setUser(user);
			// 2.Tipo Documental
			documento.setTipoDocumental("ejgv_d_archivo");
			// documento.setTipoDocumental("ejgv_d_solicitud");

			documento.setIdDocumento("1");
			documento.setNombre("prueba");
			documento.setExtension("rtf");

			documento.setBytes(Y41bUtilsDokusi.encode(Y41bDocumento
					.leerArchivoOrigen("/datos/y41b/file/test/prueba.rtf")));

			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
			documento.setProcedure(procedure);

			List<Documento> listDocumentos = new ArrayList<Documento>();
			listDocumentos.add(documento);

			solicitudPresencial.setDocumentosAdjuntos(listDocumentos);

			y41bPlateaAdapterService
					.crearSolicitudPresencial(solicitudPresencial);

			// Fin Bloque del Test
			sendOK(response, "");
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testCrearSolicitudPresencial'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearSolicitudOficioSinDocumentos", method = RequestMethod.GET)
	public ModelAndView testCrearSolicitudOficioSinDocumento(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			SolicitudOficio solicitudOficio = new SolicitudOficio();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");

			solicitudOficio.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni("72739384K");
			datosPersona.setNombre("BILBOMATICA");

			solicitudOficio.setSancionado(datosPersona);

			DatosPersona datosPersona2 = new DatosPersona();
			datosPersona2.setDni("72739383C");
			datosPersona2.setNombre("BILBOMATICA");

			solicitudOficio.setSender(datosPersona2);

			solicitudOficio.setNumeroExpediente("SAN-48L021/135/2000/1");

			solicitudOficio.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			y41bPlateaAdapterService.crearSolicitudOficio(solicitudOficio);

			// Fin Bloque del Test
			sendOK(response, "");
			logger.debug("PlateaServiceTestController.testCrearSolicitudOficioSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudOficioSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testCerrarExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "cerrarExpediente", method = RequestMethod.GET)
	public ModelAndView testCerrarExpediente(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			String nombres[] = { "SOL-01A001-63-2016-1" };

			for (String exp : nombres) {
				// Inicio Bloque del Test
				CierreExpediente cierreExpediente = new CierreExpediente();

				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento("Y41B_RECLAMACION");

				cierreExpediente.setProcedure(procedure);

				cierreExpediente.setNumeroExpediente(exp);

				cierreExpediente.setEjercicio("2016");
				try {
					y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
				} catch (Throwable th) {
				}
			}

			// Fin Bloque del Test
			sendOK(response, "");
			logger.debug("PlateaServiceTestController.testCerrarExpediente -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCerrarExpediente -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testObtenerRegistroEntrada'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "obtenerRegistroEntrada", method = RequestMethod.GET)
	public ModelAndView testObtenerRegistroEntrada(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

			// datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			// datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARABA);

			// datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			// datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);

			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);

			ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

			WSParamPerson wSParamPerson = new WSParamPerson();
			wSParamPerson.setPersonName("BILBOMATICA (91919191J)");

			persons.getWSParamPerson().add(wSParamPerson);

			datas.setPersons(persons);

			datas.setMatter("Solicitud Presencial");

			N61ServiceImpl n61Service = new N61ServiceImpl();
			WSInputRegister wSInputRegister = n61Service
					.wsNewInputRegister(datas);

			// Fin Bloque del Test
			sendOK(response, wSInputRegister.getNumber());
			logger.debug("PlateaServiceTestController.testObtenerRegistroEntrada -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testObtenerRegistroEntrada -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testObtenerRegistroSalida'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "obtenerRegistroSalida", method = RequestMethod.GET)
	public ModelAndView testObtenerRegistroSalida(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

			// datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			// datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);

			// datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			// datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);

			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);

			ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

			WSParamPerson wSParamPerson = new WSParamPerson();
			wSParamPerson.setPersonName("BILBOMATICA (91919191J)");

			persons.getWSParamPerson().add(wSParamPerson);

			datas.setPersons(persons);

			datas.setMatter("Notificacin postal");

			N61ServiceImpl n61Service = new N61ServiceImpl();
			WSOutputRegister wSOutputRegister = n61Service
					.wsNewOutputRegister(datas);

			// Fin Bloque del Test
			sendOK(response, wSOutputRegister.getNumber());
			logger.debug("PlateaServiceTestController.testObtenerRegistroSalida -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testObtenerRegistroSalida -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testObtenerRegistroSalida'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "obtenerDatosCertificadoFirma", method = RequestMethod.GET)
	public ModelAndView testObtenerDatosCertificadoFirma(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			DatosCertificado datosCertificado = new DatosCertificado();

			String firma = "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";

			datosCertificado = y41bPlateaAdapterService
					.obtenerDatosCertificadoFirma(firma);

			// Fin Bloque del Test
			sendOK(response, datosCertificado.toString());
			logger.debug("PlateaServiceTestController.testObtenerRegistroSalida -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testObtenerRegistroSalida -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDatosEJGVDocumentSolicitud'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosEJGVDocumentSolicitud", method = RequestMethod.GET)
	public ModelAndView testDatosEJGVDocumentSolicitud(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_datos_ejgv", "model", model);
	}

	/**
	 * Method 'testActualizarUltimoTramite'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "actualizarUltimoTramite", method = RequestMethod.GET)
	public ModelAndView testActualizarUltimoTramite(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");

		String rdo = this.soltramexpService.actualizarUltimoTramite(
				request.getParameter("codTramiteEjecutado"),
				request.getParameter("codUltimoTramiteGenerado"),
				request.getParameter("idExpediente"));
		sendOK(response, rdo);
		logger.debug("The request is a test. Test end.");
		return null;
	}

	/**
	 * Method 'testCrearEJGVDocumentSolicitud'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearEJGVDocumentSolicitud", method = RequestMethod.POST)
	public ModelAndView testCrearEJGVDocumentSolicitud(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String procedimiento_id = request.getParameter("procedimiento_id") == null ? ""
					: request.getParameter("procedimiento_id");
			String solicitante_nombre = request
					.getParameter("solicitante_nombre") == null ? "" : request
					.getParameter("solicitante_nombre");
			String solicitante_dni = request.getParameter("solicitante_dni") == null ? ""
					: request.getParameter("solicitante_dni");
			String solicitante_mail = request.getParameter("solicitante_mail") == null ? ""
					: request.getParameter("solicitante_mail");
			String solicitante_sms = request.getParameter("solicitante_sms") == null ? ""
					: request.getParameter("solicitante_sms");

			String notificacion_tipo = request
					.getParameter("notificacion_tipo") == null ? "" : request
					.getParameter("notificacion_tipo");
			String notificacion_idioma = request
					.getParameter("notificacion_idioma") == null ? "" : request
					.getParameter("notificacion_idioma");
			String negocio_idiomaXsl = request
					.getParameter("negocio_idiomaXsl") == null ? "" : request
					.getParameter("negocio_idiomaXsl");
			String negocio_numReclamacion = request
					.getParameter("negocio_numReclamacion") == null ? ""
					: request.getParameter("negocio_numReclamacion");
			String negocio_descReclamacion = request
					.getParameter("negocio_descReclamacion") == null ? ""
					: request.getParameter("negocio_descReclamacion");
			String negocio_fechaInicio = request
					.getParameter("negocio_fechaInicio") == null ? "" : request
					.getParameter("negocio_fechaInicio");
			String negocio_fechaFin = request.getParameter("negocio_fechaFin") == null ? ""
					: request.getParameter("negocio_fechaFin");

			String documento1_userName = request
					.getParameter("documento1_userName") == null ? "" : request
					.getParameter("documento1_userName");
			String documento1_userDni = request
					.getParameter("documento1_userDni") == null ? "" : request
					.getParameter("documento1_userDni");
			String documento1_idDoc = request.getParameter("documento1_idDoc") == null ? ""
					: request.getParameter("documento1_idDoc");
			String documento1_origen = request
					.getParameter("documento1_origen") == null ? "" : request
					.getParameter("documento1_origen");
			String documento1_nombre = request
					.getParameter("documento1_nombre") == null ? "" : request
					.getParameter("documento1_nombre");
			String documento1_extension = request
					.getParameter("documento1_extension") == null ? ""
					: request.getParameter("documento1_extension");
			String documento1_path = request.getParameter("documento1_path") == null ? ""
					: request.getParameter("documento1_path");
			String documento1_tipoDoc = request
					.getParameter("documento1_tipoDoc") == null ? "" : request
					.getParameter("documento1_tipoDoc");
			String expediente_id = request.getParameter("expediente_id") == null ? ""
					: request.getParameter("expediente_id");
			String isDocumentos = request.getParameter("isDocumentos") == null ? ""
					: request.getParameter("isDocumentos");
			String documentos_numero = request
					.getParameter("documentos_numero") == null ? "" : request
					.getParameter("documentos_numero");

			// Inicio Bloque del Test
			CrearEJGV crearEJGV = new CrearEJGV();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedimiento_id);

			crearEJGV.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(solicitante_dni);
			datosPersona.setNombre(solicitante_nombre);
			datosPersona.setMail(solicitante_mail);
			datosPersona.setTelefono(solicitante_sms);

			crearEJGV.setSolicitante(datosPersona);

			crearEJGV.setTipoNotificacion(notificacion_tipo);
			crearEJGV.setIdiomaNotificacion(notificacion_idioma);

			Map mapaSolicitud = new HashMap();
			mapaSolicitud.put("xslIdioma", negocio_idiomaXsl);
			mapaSolicitud.put("Desc_Reclamacion", negocio_descReclamacion);
			mapaSolicitud.put("Num_Reclamacion", negocio_numReclamacion);
			mapaSolicitud.put("Fecha_Inicio", negocio_fechaInicio);
			mapaSolicitud.put("Fecha_Fin", negocio_fechaFin);

			crearEJGV.setMapaSolicitud(mapaSolicitud);

			crearEJGV.setNumeroExpediente(expediente_id);
			// Documentos de la solicitud
			if ("S".equals(isDocumentos)) {
				List<Documento> listDocumentos = new ArrayList<Documento>();
				Documento documento = null;
				for (int i = 0; i < Integer.parseInt(documentos_numero); i++) {
					documento = new Documento();
					User user = new User();
					user.setNombre(documento1_userName);
					user.setDni(documento1_userDni);
					documento.setUser(user);
					documento.setTipoDocumental(documento1_tipoDoc);
					documento.setIdDocumento(documento1_idDoc);
					documento.setNombre(documento1_nombre);
					documento.setExtension(documento1_extension);
					documento.setBytes(Y41bUtilsDokusi.encode(Y41bDocumento
							.leerArchivoOrigen(documento1_path)));
					documento.setOrigenDocumento(documento1_origen);
					documento.setProcedure(procedure);
					listDocumentos.add(documento);
				}
				crearEJGV.setDocumentosAdjuntos(listDocumentos);
			}
			RespuestaCrearEJGVDocumentSolicitud respuestaEjgv = y41bPlateaAdapterService
					.crearEJGVDocumentSolicitud(crearEJGV);
			StringBuffer listaOIDs = new StringBuffer();
			if (respuestaEjgv.getDocumentosAdjuntos() != null) {
				for (int i = 0; i < respuestaEjgv.getDocumentosAdjuntos()
						.size(); i++) {
					if (i != 0) {
						listaOIDs.append("|");
					}
					listaOIDs.append(respuestaEjgv.getDocumentosAdjuntos()
							.get(0).getOidDokusi());
				}
			}
			// Fin Bloque del Test
			// sendOK(response, ejgvDocument);
			request.setAttribute("ejgvDocument", respuestaEjgv);
			request.setAttribute("listaOIDs", listaOIDs);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_firma_ejgv", "model", model);
	}

	/**
	 * Method 'testEnviarEJGVDocumentSolicitud'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "enviarEJGVDocumentSolicitud", method = RequestMethod.POST)
	public ModelAndView testEnviarEJGVDocumentSolicitud(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String procedimiento_id = request.getParameter("procedimiento_id") == null ? ""
					: request.getParameter("procedimiento_id");
			String solicitante_nombre = request
					.getParameter("solicitante_nombre") == null ? "" : request
					.getParameter("solicitante_nombre");
			String solicitante_dni = request.getParameter("solicitante_dni") == null ? ""
					: request.getParameter("solicitante_dni");
			String solicitante_mail = request.getParameter("solicitante_mail") == null ? ""
					: request.getParameter("solicitante_mail");
			String solicitante_sms = request.getParameter("solicitante_sms") == null ? ""
					: request.getParameter("solicitante_sms");

			String notificacion_tipo = request
					.getParameter("notificacion_tipo") == null ? "" : request
					.getParameter("notificacion_tipo");
			String notificacion_idioma = request
					.getParameter("notificacion_idioma") == null ? "" : request
					.getParameter("notificacion_idioma");
			String listaOIDs = request.getParameter("listaOIDs") == null ? ""
					: request.getParameter("listaOIDs");
			String documento1_nombre = request
					.getParameter("documento1_nombre") == null ? "" : request
					.getParameter("documento1_nombre");
			String documento1_extension = request
					.getParameter("documento1_extension") == null ? ""
					: request.getParameter("documento1_extension");
			String documento1_tipoDoc = request
					.getParameter("documento1_tipoDoc") == null ? "" : request
					.getParameter("documento1_tipoDoc");

			String ejgvDocument = request.getParameter("ejgvDocument");
			String firmaEjgvDocument = request.getParameter("firma");
			EnvioEJGV envioEJGV = new EnvioEJGV();

			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedimiento_id);
			envioEJGV.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni(solicitante_dni);
			datosPersona.setNombre(solicitante_nombre);
			datosPersona.setMail(solicitante_mail);
			datosPersona.setTelefono(solicitante_sms);

			envioEJGV.setSolicitante(datosPersona);

			envioEJGV.setTipoNotificacion(notificacion_tipo);
			envioEJGV.setIdiomaNotificacion(notificacion_idioma);

			envioEJGV.setEjgvDocument(ejgvDocument);
			envioEJGV.setFirma(firmaEjgvDocument);

			// Anyadimos documentos con OIDs
			if (!"".equals(listaOIDs)) {
				List<Documento> listaDocumentosAdjuntos = new ArrayList<Documento>();
				StringTokenizer listaOIDsTokenizer = new StringTokenizer(
						listaOIDs, "|");
				Documento documento = null;
				while (listaOIDsTokenizer.hasMoreTokens()) {
					documento = new Documento();
					documento.setOidDokusi(listaOIDsTokenizer.nextToken());
					documento.setExtension(documento1_extension);
					documento.setNombre(documento1_nombre);
					documento.setTipoDocumental(documento1_tipoDoc);
					listaDocumentosAdjuntos.add(documento);
				}
				envioEJGV.setDocumentosAdjuntos(listaDocumentosAdjuntos);
			}
			RespuestaSolicitudTelematica respuestaEjgv = y41bPlateaAdapterService
					.procesarEnviarSolicitud(envioEJGV);
			request.setAttribute("respuestaEnvioEjgv", respuestaEjgv);
			logger.debug("respuestaEjgv -> " + respuestaEjgv);
			logger.debug("PlateaServiceTestController.procesarEnviarSolicitud -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_enviado_ejgv", "model", model);
	}

	/**
	 * Method 'testDatosEJGVDocumentNotificacion'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosEJGVDocumentNotificacion", method = RequestMethod.GET)
	public ModelAndView testDatosEJGVDocumentNotificacion(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_notificacion_datos_ejgv", "model", model);
	}

	/**
	 * Method 'testGetNotificacionByIdIni'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "getNotificacionByIdIni", method = RequestMethod.GET)
	public ModelAndView testGetNotificacionByIdIni(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_get_notificacion", "model", model);
	}

	/**
	 * Method 'testGetNotificacionById'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "getNotificacionById", method = RequestMethod.POST)
	public ModelAndView testGetNotificacionById(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String idNotificacion = request.getParameter("idNotificacion") == null ? ""
				: request.getParameter("idNotificacion");
		try {
			logger.debug("idNotificacion:" + idNotificacion);
			RegistroSalida registroSalida = y41bPlateaAdapterService
					.getRegistroSalidaFromIdNotificacion(idNotificacion);
			// Fin Bloque del Test
			sendOK(response, registroSalida.toString());
			logger.debug("PlateaServiceTestController.testGetNotificacionById -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testGetNotificacionById -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDatosAcuseReciba'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosAcuseRecibo", method = RequestMethod.GET)
	public ModelAndView testDatosAcuseReciba(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_acuse_recibo", "model", model);
	}

	/**
	 * Method 'testCrearEJGVDocumentNotificacion'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearEJGVDocumentNotificacion", method = RequestMethod.POST)
	public ModelAndView testCrearEJGVDocumentNotificacion(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String procedimiento_id = request.getParameter("procedimiento_id") == null ? ""
					: request.getParameter("procedimiento_id");
			String expediente_id = request.getParameter("expediente_id") == null ? ""
					: request.getParameter("expediente_id");

			String notificacion_idTipo = request
					.getParameter("notificacion_idTipo") == null ? "" : request
					.getParameter("notificacion_idTipo");
			String notificacion_texto = request
					.getParameter("notificacion_texto") == null ? "" : request
					.getParameter("notificacion_texto");

			String notificacion_idioma = request
					.getParameter("notificacion_idioma") == null ? "" : request
					.getParameter("notificacion_idioma");

			String notificacion_ejercicio = request
					.getParameter("notificacion_ejercicio") == null ? ""
					: request.getParameter("notificacion_ejercicio");

			String solicitante_nombre = request
					.getParameter("solicitante_nombre") == null ? "" : request
					.getParameter("solicitante_nombre");
			String solicitante_dni = request.getParameter("solicitante_dni") == null ? ""
					: request.getParameter("solicitante_dni");
			String solicitante_mail = request.getParameter("solicitante_mail") == null ? ""
					: request.getParameter("solicitante_mail");
			String solicitante_sms = request.getParameter("solicitante_sms") == null ? ""
					: request.getParameter("solicitante_sms");

			String sender_nombre = request.getParameter("sender_nombre") == null ? ""
					: request.getParameter("sender_nombre");
			String sender_dni = request.getParameter("sender_dni") == null ? ""
					: request.getParameter("sender_dni");

			String documento1_idDoc = request.getParameter("documento1_idDoc") == null ? ""
					: request.getParameter("documento1_idDoc");
			String documento1_nombre = request
					.getParameter("documento1_nombre") == null ? "" : request
					.getParameter("documento1_nombre");
			String documento1_extension = request
					.getParameter("documento1_extension") == null ? ""
					: request.getParameter("documento1_extension");
			String documento1_origen = request
					.getParameter("documento1_origen") == null ? "" : request
					.getParameter("documento1_origen");
			String documento1_tipoDocumental = request
					.getParameter("documento1_tipoDoc") == null ? "" : request
					.getParameter("documento1_tipoDoc");
			String documento1_tipoDocumento = request
					.getParameter("documento1_tipoDocumento") == null ? ""
					: request.getParameter("documento1_tipoDocumento");
			String isDocumentos = request.getParameter("isDocumentos") == null ? ""
					: request.getParameter("isDocumentos");
			String isOID = request.getParameter("isOID") == null ? "" : request
					.getParameter("isOID");

			// Inicio Bloque del Test
			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(procedimiento_id);
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setIdTipoNotificacion(notificacion_idTipo);
			crearNotifEJGV.setTextoNotificacion(notificacion_texto);
			crearNotifEJGV.setEjercicio(notificacion_ejercicio);
			crearNotifEJGV.setIdiomaNotificacion(notificacion_idioma);

			DatosPersona datosPersonaSolicitante = new DatosPersona();
			datosPersonaSolicitante.setDni(solicitante_dni);
			datosPersonaSolicitante.setNombre(solicitante_nombre);
			datosPersonaSolicitante.setMail(solicitante_mail);
			datosPersonaSolicitante.setTelefono(solicitante_sms);

			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(sender_dni);
			datosPersonaSender.setNombre(sender_nombre);

			crearNotifEJGV.setSender(datosPersonaSender);
			crearNotifEJGV.setNumeroExpediente(expediente_id);

			// Documentos de la solicitud
			if ("S".equals(isDocumentos)) {
				List<Documento> listDocumentos = new ArrayList<Documento>();
				Documento documento = new Documento();
				if ("S".equals(isOID)) {
					documento.setTipoDocumental(documento1_tipoDocumental);
					documento.setOidDokusi(documento1_idDoc);
					// Para que sepa PLATEA que es un RTF (obligatorio)
					documento.setNombre(documento1_nombre + "."
							+ documento1_extension);
					documento.setExtension(documento1_extension);
					documento.setProcedure(procedure);
					documento.setTipoDocumento(documento1_tipoDocumento);
				} else {
					User user = new User();
					user.setNombre("SUSANA GOMEZ SAINZ");
					user.setDni("44975828H");
					documento.setUser(user);
					documento.setTipoDocumental(documento1_tipoDocumental);
					documento.setIdDocumento("19912");
					// Para que sepa PLATEA que es un RTF (obligatorio)
					documento.setNombre(documento1_nombre + "."
							+ documento1_extension);
					documento.setExtension(documento1_extension);
					documento
							.setBytes(Y41bUtilsDokusi.encode(Y41bDocumento
									.leerArchivoOrigen("/datos/y41b/file/test/prueba.rtf")));
					documento.setOrigenDocumento(documento1_origen);
					documento.setProcedure(procedure);
				}
				listDocumentos.add(documento);
				crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);
			}
			RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = y41bPlateaAdapterService
					.crearEJGVDocumentNotificacion(crearNotifEJGV);
			StringBuffer listaOIDs = new StringBuffer();
			if (respuestaEjgv.getDocumentosAdjuntos() != null) {
				for (int i = 0; i < respuestaEjgv.getDocumentosAdjuntos()
						.size(); i++) {
					if (i != 0) {
						listaOIDs.append("|");
					}
					listaOIDs.append(respuestaEjgv.getDocumentosAdjuntos()
							.get(0).getOidDokusi());
				}
			}
			// Fin Bloque del Test
			// sendOK(response, ejgvDocument);
			request.setAttribute("ejgvDocument", respuestaEjgv);
			request.setAttribute("listaOIDs", listaOIDs);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_notificacion_firma_ejgv", "model", model);
	}

	/**
	 * Method 'testEnviarEJGVDocumentNotificacion'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "enviarEJGVDocumentNotificacion", method = RequestMethod.POST)
	public ModelAndView testEnviarEJGVDocumentNotificacion(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			String ejgvDocument = request.getParameter("ejgvDocument");
			String firmaEjgvDocument = request.getParameter("firma");
			EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
			envioNotifEJGV.setEjgvDocument(ejgvDocument);
			envioNotifEJGV.setFirma(firmaEjgvDocument);

			RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
					.procesarEnviarNotificacion(envioNotifEJGV);
			request.setAttribute("respuestaEnvioEjgv", respuestaNotif);
			logger.debug("respuestaEjgv -> " + respuestaNotif);
			logger.debug("PlateaServiceTestController.procesarEnviarSolicitud -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_notificacion_enviado_ejgv", "model",
				model);
	}

	/**
	 * Method 'testProcesarEsperas'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "procesarEsperas", method = RequestMethod.GET)
	public ModelAndView testProcesarEsperas(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_esperas", "model", model);
	}

	/**
	 * Method 'testCrearEspera'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "crearEspera", method = RequestMethod.POST)
	public ModelAndView testCrearEspera(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String crear_espera_procedimiento_id = request
					.getParameter("crear_espera_procedimiento_id") == null ? ""
					: request.getParameter("crear_espera_procedimiento_id");
			String crear_espera_expediente_id = request
					.getParameter("crear_espera_expediente_id") == null ? ""
					: request.getParameter("crear_espera_expediente_id");
			String crear_espera_tipo = request
					.getParameter("crear_espera_tipo") == null ? "" : request
					.getParameter("crear_espera_tipo");
			String crear_espera_ejercicio = request
					.getParameter("crear_espera_ejercicio") == null ? ""
					: request.getParameter("crear_espera_ejercicio");
			String crear_espera_nombre = request
					.getParameter("crear_espera_nombre") == null ? "" : request
					.getParameter("crear_espera_nombre");
			String crear_espera_dni = request.getParameter("crear_espera_dni") == null ? ""
					: request.getParameter("crear_espera_dni");

			Espera crearEspera = new Espera();
			crearEspera.setEjercicio(crear_espera_ejercicio);
			crearEspera.setNumeroExpediente(crear_espera_expediente_id);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(crear_espera_procedimiento_id);
			crearEspera.setProcedure(procedure);
			crearEspera.setTipoEspera(crear_espera_tipo);
			DatosPersona solicitante = new DatosPersona();
			solicitante.setDni(crear_espera_dni);
			solicitante.setNombre(crear_espera_nombre);
			crearEspera.setSolicitante(solicitante);
			RespuestaProcesarEspera respuestaProcesarEspera = y41bPlateaAdapterService
					.crearEspera(crearEspera);

			sendOK(response, respuestaProcesarEspera.toString());
			logger.debug("PlateaServiceTestController.testCrearEspera -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearEspera -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testMatarEspera'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "matarEspera", method = RequestMethod.POST)
	public ModelAndView testMatarEspera(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String matar_espera_procedimiento_id = request
					.getParameter("matar_espera_procedimiento_id") == null ? ""
					: request.getParameter("matar_espera_procedimiento_id");
			String matar_espera_expediente_id = request
					.getParameter("matar_espera_expediente_id") == null ? ""
					: request.getParameter("matar_espera_expediente_id");
			String matar_espera_tipo = request
					.getParameter("matar_espera_tipo") == null ? "" : request
					.getParameter("matar_espera_tipo");
			String matar_espera_ejercicio = request
					.getParameter("matar_espera_ejercicio") == null ? ""
					: request.getParameter("matar_espera_ejercicio");
			String matar_espera_nombre = request
					.getParameter("matar_espera_nombre") == null ? "" : request
					.getParameter("matar_espera_nombre");
			String matar_espera_dni = request.getParameter("matar_espera_dni") == null ? ""
					: request.getParameter("matar_espera_dni");
			String matar_espera_oid = request.getParameter("matar_espera_oid") == null ? ""
					: request.getParameter("matar_espera_oid");

			Espera matarEspera = new Espera();
			matarEspera.setEjercicio(matar_espera_ejercicio);
			matarEspera.setNumeroExpediente(matar_espera_expediente_id);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(matar_espera_procedimiento_id);
			matarEspera.setProcedure(procedure);
			matarEspera.setTipoEspera(matar_espera_tipo);
			DatosPersona solicitante = new DatosPersona();
			solicitante.setDni(matar_espera_dni);
			solicitante.setNombre(matar_espera_nombre);
			matarEspera.setSolicitante(solicitante);
			matarEspera.setOidEspera(matar_espera_oid);
			RespuestaProcesarEspera respuestaProcesarEspera = y41bPlateaAdapterService
					.matarEspera(matarEspera);

			sendOK(response, respuestaProcesarEspera.toString());
			logger.debug("PlateaServiceTestController.testCrearEspera -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearEspera -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDatosHistorico'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosHistorico", method = RequestMethod.GET)
	public ModelAndView testDatosHistorico(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_datosHistorico", "model", model);
	}

	/**
	 * Method 'testRegistrarHistorico'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "registrarHistorico", method = RequestMethod.POST)
	public ModelAndView testRegistrarHistorico(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String registrar_historico_id_proc = request
					.getParameter("registrar_historico_id_proc") == null ? ""
					: request.getParameter("registrar_historico_id_proc");
			String registrar_historico_expediente_id = request
					.getParameter("registrar_historico_expediente_id") == null ? ""
					: request.getParameter("registrar_historico_expediente_id");
			String registrar_historico_ejercicio = request
					.getParameter("registrar_historico_ejercicio") == null ? ""
					: request.getParameter("registrar_historico_ejercicio");
			String registrar_historico_id_sol = request
					.getParameter("registrar_historico_id_sol") == null ? ""
					: request.getParameter("registrar_historico_id_sol");
			String registrar_historico_tit_nombre = request
					.getParameter("registrar_historico_tit_nombre") == null ? ""
					: request.getParameter("registrar_historico_tit_nombre");
			String registrar_historico_tit_dni = request
					.getParameter("registrar_historico_tit_dni") == null ? ""
					: request.getParameter("registrar_historico_tit_dni");
			String registrar_historico_id_historico = request
					.getParameter("registrar_historico_id_historico") == null ? ""
					: request.getParameter("registrar_historico_id_historico");
			String registrar_historico_acto_es = request
					.getParameter("registrar_historico_acto_es") == null ? ""
					: request.getParameter("registrar_historico_acto_es");
			String registrar_historico_acto_eu = request
					.getParameter("registrar_historico_acto_eu") == null ? ""
					: request.getParameter("registrar_historico_acto_eu");
			String registrar_historico_rdo_es = request
					.getParameter("registrar_historico_rdo_es") == null ? ""
					: request.getParameter("registrar_historico_rdo_es");
			String registrar_historico_rdo_eu = request
					.getParameter("registrar_historico_rdo_eu") == null ? ""
					: request.getParameter("registrar_historico_rdo_eu");

			Historico historico = new Historico();
			historico.setNumeroExpediente(registrar_historico_expediente_id);
			historico.setIdHistorico(registrar_historico_id_historico);
			historico.setEjercicio(registrar_historico_ejercicio);
			historico.setOidSolicitud(registrar_historico_id_sol);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(registrar_historico_id_proc);
			historico.setProcedure(procedure);
			DatosPersona titular = new DatosPersona();
			titular.setDni(registrar_historico_tit_dni);
			titular.setNombre(registrar_historico_tit_nombre);
			historico.setTitular(titular);
			historico.setActoEs(registrar_historico_acto_es);
			historico.setActoEu(registrar_historico_acto_eu);
			historico.setResultadoEs(registrar_historico_rdo_es);
			historico.setResultadoEu(registrar_historico_rdo_eu);

			RespuestaRegistrarHistorico respuestaRegistrarHistorico = y41bPlateaAdapterService
					.registrarHistorico(historico);

			sendOK(response, respuestaRegistrarHistorico.toString());
			logger.debug("PlateaServiceTestController.testRegistrarHistorico -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testRegistrarHistorico -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testEliminarHistorico'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "eliminarHistorico", method = RequestMethod.POST)
	public ModelAndView testEliminarHistorico(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String registrar_historico_id_proc = request
					.getParameter("registrar_historico_id_proc") == null ? ""
					: request.getParameter("registrar_historico_id_proc");
			String registrar_historico_expediente_id = request
					.getParameter("registrar_historico_expediente_id") == null ? ""
					: request.getParameter("registrar_historico_expediente_id");
			String registrar_historico_ejercicio = request
					.getParameter("registrar_historico_ejercicio") == null ? ""
					: request.getParameter("registrar_historico_ejercicio");
			String registrar_historico_id_sol = request
					.getParameter("registrar_historico_id_sol") == null ? ""
					: request.getParameter("registrar_historico_id_sol");
			String registrar_historico_tit_nombre = request
					.getParameter("registrar_historico_tit_nombre") == null ? ""
					: request.getParameter("registrar_historico_tit_nombre");
			String registrar_historico_tit_dni = request
					.getParameter("registrar_historico_tit_dni") == null ? ""
					: request.getParameter("registrar_historico_tit_dni");
			String registrar_historico_id_historico = request
					.getParameter("registrar_historico_id_historico") == null ? ""
					: request.getParameter("registrar_historico_id_historico");
			String registrar_historico_acto_es = request
					.getParameter("registrar_historico_acto_es") == null ? ""
					: request.getParameter("registrar_historico_acto_es");
			String registrar_historico_acto_eu = request
					.getParameter("registrar_historico_acto_eu") == null ? ""
					: request.getParameter("registrar_historico_acto_eu");
			String registrar_historico_rdo_es = request
					.getParameter("registrar_historico_rdo_es") == null ? ""
					: request.getParameter("registrar_historico_rdo_es");
			String registrar_historico_rdo_eu = request
					.getParameter("registrar_historico_rdo_eu") == null ? ""
					: request.getParameter("registrar_historico_rdo_eu");

			Historico historico = new Historico();
			historico.setNumeroExpediente(registrar_historico_expediente_id);
			historico.setIdHistorico(registrar_historico_id_historico);
			historico.setEjercicio(registrar_historico_ejercicio);
			historico.setOidSolicitud(registrar_historico_id_sol);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(registrar_historico_id_proc);
			historico.setProcedure(procedure);
			DatosPersona titular = new DatosPersona();
			titular.setDni(registrar_historico_tit_dni);
			titular.setNombre(registrar_historico_tit_nombre);
			historico.setTitular(titular);
			historico.setActoEs(registrar_historico_acto_es);
			historico.setActoEu(registrar_historico_acto_eu);
			historico.setResultadoEs(registrar_historico_rdo_es);
			historico.setResultadoEu(registrar_historico_rdo_eu);

			y41bPlateaAdapterService.eliminarHistorico(historico);

			sendOK(response, "El historico " + registrar_historico_id_historico
					+ " se ha eliminado.");
			logger.debug("PlateaServiceTestController.testEliminarHistorico -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testEliminarHistorico -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testCrearSolicitudPresencial'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "actualizarExpediente", method = RequestMethod.GET)
	public ModelAndView testActualizarExpediente(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

			Procedure procedure = new Procedure();
			procedure
					.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);

			actualizarExpediente.setProcedure(procedure);

			DatosPersona datosPersona = new DatosPersona();
			datosPersona.setDni("12435999Z");

			StringBuffer nombreCompleto = new StringBuffer();

			nombreCompleto.append("CIUDADANO");

			nombreCompleto.append(" ").append("PRUEBA");

			nombreCompleto.append(" ").append("DESARROLLO");

			datosPersona.setNombre(nombreCompleto.toString());

			actualizarExpediente.setSolicitante(datosPersona);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append("SOL-01A001-77-2016-1");
			// numeroExpediente.append("SOL-01A001-114-2016-1");

			actualizarExpediente.setEjercicio("2016");

			actualizarExpediente.setNumeroExpediente(numeroExpediente
					.toString());

			actualizarExpediente
					.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

			Calendar cal = Calendar.getInstance();

			List<Proceedings> listProceedings = new ArrayList<Proceedings>();
			Proceedings proceedings = new Proceedings();
			proceedings
					.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_PRESENCIAL);
			proceedings
					.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
			proceedings
					.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU);
			cal.setTime(new Date());
			proceedings.setTimestamp(cal);

			// Telematico
			/*
			 * proceedings
			 * .setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_TELEMATICO
			 * ); proceedings .setProceedingsDescriptionCast(Y41bConstantes.
			 * LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_ES); proceedings
			 * .setProceedingsDescriptionEus
			 * (Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_EU);
			 */
			List<Documento> documentos = new ArrayList<Documento>();
			Documento documento = new Documento();
			documento.setOidDokusi("1111");
			documento.setNombre("Documento1");
			documentos.add(documento);
			proceedings.setDocumentos(documentos);

			listProceedings.add(proceedings);
			proceedings = new Proceedings();
			proceedings
					.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
			proceedings
					.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
			proceedings
					.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);

			// Telematico
			/*
			 * proceedings
			 * .setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);
			 * proceedings .setProceedingsDescriptionCast(Y41bConstantes.
			 * LITERAL_APERTURA_TELEMATICO_ES); proceedings
			 * .setProceedingsDescriptionEus
			 * (Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
			 */
			proceedings.setTimestamp(cal);
			listProceedings.add(proceedings);

			proceedings = new Proceedings();
			proceedings.setProceedingsID("111111");
			proceedings
					.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
			proceedings
					.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);
			proceedings.setTimestamp(cal);
			listProceedings.add(proceedings);

			documentos = new ArrayList<Documento>();
			documento = new Documento();
			documento.setOidDokusi("22222");
			documento.setNombre("Documento2");
			documentos.add(documento);
			proceedings.setDocumentos(documentos);

			actualizarExpediente.setProceedings(listProceedings);

			y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);

			// Fin Bloque del Test
			sendOK(response, "");
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testCrearSolicitudPresencialSinDocumentos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'getRequestInformation'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "getRequestInformation", method = RequestMethod.GET)
	public ModelAndView testGetRequestInformation(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			String idSolicitud = "157243";

			String resultado = y41bPlateaAdapterService.getRequestInformation(
					idSolicitud, null);

			// Fin Bloque del Test
			sendOK(response, resultado);
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testSearchNotification'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "searchNotification", method = RequestMethod.GET)
	public ModelAndView testSearchNotification(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			TNotificationFilter filter = new TNotificationFilter();

			TStringList tStringList = new TStringList();
			List<String> listString = tStringList.getItem();
			listString.add("R02OB665F64068F7CBD183336F8F4F9BE0EE71DF3058");

			filter.setNotificationIDList(tStringList);

			TDocFieldList value = new TDocFieldList();
			List<TDocField> listTDocField = value.getItem();

			TDocField e = TDocField.ROLE_RECEIPT;
			listTDocField.add(e);
			e = TDocField.DOC_INFO;
			listTDocField.add(e);
			// TDocField e2 = TDocField.ROLE_ACCUSE;
			// listTDocField.add(e2);
			filter.setDocFieldList(value);

			TNotificationList tNotificationList = y41bPlateaAdapterService
					.searchNotification(filter, new AExtensionPoint());

			// Fin Bloque del Test
			sendOK(response, tNotificationList.toString());
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testSearchNotification'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "searchAcuse", method = RequestMethod.GET)
	public ModelAndView testSearchAcuse(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			TNotificationFilter filter = new TNotificationFilter();

			TStringList tStringList = new TStringList();
			List<String> listString = tStringList.getItem();
			listString.add("R02OB665F64068F7CBD183336F8F4F9BE0EE71DF3058");

			filter.setNotificationIDList(tStringList);

			TDocFieldList value = new TDocFieldList();
			List<TDocField> listTDocField = value.getItem();

			TDocField e = TDocField.ROLE_ACCUSE;
			listTDocField.add(e);
			e = TDocField.DOC_INFO;
			listTDocField.add(e);
			// TDocField e2 = TDocField.ROLE_ACCUSE;
			// listTDocField.add(e2);
			filter.setDocFieldList(value);

			TNotificationList tNotificationList = y41bPlateaAdapterService
					.searchNotification(filter, new AExtensionPoint());

			// Fin Bloque del Test
			sendOK(response, tNotificationList.toString());
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testGetRequestInformation -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testSearchDocument'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "searchDocument", method = RequestMethod.GET)
	public ModelAndView testSearchDocument(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			TDocumentFilter filter = new TDocumentFilter();

			TStringList tStringList = new TStringList();
			List<String> listString = tStringList.getItem();
			listString.add("R02O32F4DF5FE1BCD967C8CE281AE4A5CE87FD8738ED");

			filter.setDocumentIDList(tStringList);

			TDocFieldList value = new TDocFieldList();
			List<TDocField> listTDocField = value.getItem();

			TDocField e = TDocField.ROLE_NOTIFICATION;
			listTDocField.add(e);
			// TDocField e2 = TDocField.ROLE_ACCUSE;
			// listTDocField.add(e2);
			// filter.setDocFieldList(value);

			TDocumentList tDocumentList = y41bPlateaAdapterService
					.searchDocument(filter, new AExtensionPoint());

			// Fin Bloque del Test
			sendOK(response, tDocumentList.toString());
			logger.debug("PlateaServiceTestController.testSearchDocument -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testSearchDocument -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testGetCuentaInteresado'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "getCuentaInteresado", method = RequestMethod.GET)
	public ModelAndView testGetCuentaInteresado(Model model,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			String numIdentificacion = "12435999Z";
			// String numIdentificacion = "89898989Q";
			// String numIdentificacion = "91919191J";

			String canalNotificacion = y41bPlateaAdapterService
					.getCuentaInteresado(numIdentificacion);

			// Fin Bloque del Test
			sendOK(response, canalNotificacion);
			logger.debug("PlateaServiceTestController.testGetCuentaInteresado -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testGetCuentaInteresado -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}
}
