package com.ejie.y41b.control.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

import com.ejie.cp.xml.ProcedureDocument;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.pasarela.ConceptosPago;
import com.ejie.y41b.model.pasarela.ConstPasarela;
import com.ejie.y41b.model.pasarela.ObjPasarela;
import com.ejie.y41b.pasarela.Pasarela;

/**
 * Clase de Testing de Pasarela Pagos
 * 
 *  
 */
@Controller()
@RequestMapping(value = "/y41bPasarelaTest")
public class PasarelaTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory.getLogger(PasarelaTestController.class);

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'testEnvioPago'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "envioPago", method = RequestMethod.GET)
	public ModelAndView testEnvioPago(Model model, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		PasarelaTestController.logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Pasarela pasarela = new Pasarela();
			ConstPasarela constPasarela = new ConstPasarela(null, null, null);
			constPasarela.setUrlImagenCabecera(this.appConfiguration.getProperty("URL_IMAGEN_CABECERA"));
			constPasarela.setUrlImagenMedio(this.appConfiguration.getProperty("URL_IMAGEN_MEDIO"));
			constPasarela.setUrlVueltaApp("http://desarrollo.jakina.ejiedes.net:7001/y41bVistaWar/test");
			String tipoCanal = Y41bConstantes.PASARELA_CANAL_NOTIFICACION_POSTAL;
			List<PeticionPago> peticionPagoList = new ArrayList<PeticionPago>();

			com.ejie.y41b.model.platea.Procedure procedure = new com.ejie.y41b.model.platea.Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");
			ProcedureDocument procedureDocument = this.y41bPlateaAdapterService
					.obtenerDatosCatalogoProcedimientos(procedure);
			List<ConceptosPago> conceptosPagos = new ArrayList<ConceptosPago>();
			ConceptosPago conceptosPago = new ConceptosPago();
			conceptosPago.setAppPresupuestaria("2013024901000013915944320000I");
			conceptosPago.setTerritorioAppPresupuestaria("1");
			conceptosPago.setElementoPEP("");
			conceptosPago.setNumLinea(1);
			conceptosPago.setBackEndDataID("");
			conceptosPago.setBackEndDataValue("");
			conceptosPago.setImporteConcepto("100.01");
			conceptosPago.setDescConceptoCas("Desc concepto");
			conceptosPago.setDescConceptoEus("Desc concepto eus");
			conceptosPago.setCodigoIngreso("004009");
			conceptosPago.setImporteConceptoIVA("");
			conceptosPago.setTipoIVA("");
			conceptosPagos.add(conceptosPago);
			PeticionPago peticionPago = pasarela.composePeticionPago(crearObjetoPasarelaPrueba(),
					procedureDocument.getProcedure(), conceptosPagos);
			peticionPagoList.add(peticionPago);
			String resultado = pasarela.enviarPago(constPasarela, request, response, tipoCanal, peticionPagoList);
			// Fin Bloque del Test
			this.sendOK(response, resultado);
			PasarelaTestController.logger.debug("PasarelaTestController.testEnvioPago -> OK");
		} catch (Exception e) {
			this.sendError(response, e);
			PasarelaTestController.logger.debug("PasarelaTestController.testEnvioPago -> ERROR");
		} finally {
			PasarelaTestController.logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Objeto pasarela de prueba
	 * 
	 * @return ObjPasarela
	 */
	private ObjPasarela crearObjetoPasarelaPrueba() {
		ObjPasarela objetoPasarela = new ObjPasarela();

		objetoPasarela.setTipoAcceso(null); // 1-recibo Bancario 2- banca
											// electronica
		objetoPasarela.setIdioma(null); // 1-castellano 2- euskera
		objetoPasarela.setCodTasaCast(null); // (73.03) Tasa de ...
		objetoPasarela.setCodTasaEusk(null); // (73.03) Tasa de ...
		objetoPasarela.setReferencia("9104000000116"); // 9104000000112
		objetoPasarela.setIdentificacion("120214"); // 011204 ddMMyy
		objetoPasarela.setFechaIncioPago("150214"); // 311204 ddMMyy
		objetoPasarela.setFechaLimitePago("010314"); // 311204 ddMMyy
		objetoPasarela.setImporte("100,01"); // 12,50
		objetoPasarela.setSufijo("909"); // 909
		objetoPasarela.setNumExpFactura("SAN-01A106-104-2014");
		objetoPasarela.setNumFactura("");
		objetoPasarela.setFamiliaID(null);
		objetoPasarela.setFormato("507"); // TODO Que es esto?
		objetoPasarela.setTipoDevengo(PeticionPago.DEVENGO_EMISION);
		objetoPasarela.setTerritorioHist(null);
		objetoPasarela.setFechaLimiteAnul(null); // Fecha limite de anulación
													// del pago
		objetoPasarela.setImporteIVA("");
		objetoPasarela.setTipoIVA("");
		objetoPasarela.setBaseImponible("100,01");
		objetoPasarela.setCodigoConceptoIVA("");

		objetoPasarela.setFechaIncioPagoLiq("15/02/2014");
		objetoPasarela.setFechaLimitePagoLiq("01/03/2014"); // dd/MM/yyyy - es
															// la que se
		// guarda en BD
		objetoPasarela.setFechaLimiteAnulLiq("01/03/2014"); // dd/MM/yyyy - es
															// la que se
		// guarda en BD

		objetoPasarela.setCodigoRecaudacion(null); // 9050794

		objetoPasarela.setExentoPago(false); // true - exento de pago false - no
												// exento

		objetoPasarela.setEntidadEmisora("04833001"); // 04833001

		objetoPasarela.setEntidadEmisoraNombCast("KontsumoBIDE"); // "Direcci�n
																	// de
																	// Juventud"
		objetoPasarela.setEntidadEmisoraNombEusk("KontsumoBIDE"); // "Gazteria
																	// Zuzendaritza";

		objetoPasarela.setConceptoAplicPresupuestaria("2013024901000013915944320000I"); // 2001020914000043126232220000J

		objetoPasarela.setConceptoCodigoIngreso("004009"); // 622

		objetoPasarela.setDatosTerceroTipoIdentificacion("DNI");
		objetoPasarela.setDatosTerceroDni("72739384K"); // 14611614J 44100101Q
														// 72739383C
		objetoPasarela.setDatosTerceroNombreCompleto("CIUDADANO PRUEBAS DESARROLLO"); // Areizaga
																						// Sanchez,
		// Jorge

		objetoPasarela.setDatosTerceroDireccion("calle lacalle"); // avda
																	// madariaga
		objetoPasarela.setDatosTerceroMunicipio("Vitoria-Gasteiz"); // bilbao
		objetoPasarela.setDatosTerceroLocalidad("Vitoria-Gasteiz"); // Bilbao
		objetoPasarela.setDatosTerceroProvincia("Alava-Araba"); // Bizkaia
		objetoPasarela.setDatosTerceroPais("España"); // Espa�a
		objetoPasarela.setDatosTerceroCodigoPostal("01001"); // 48014
		objetoPasarela.setDatosTerceroCodMunicipio("059");
		objetoPasarela.setDatosTerceroCodLocalidad("10105900000734");
		objetoPasarela.setDatosTerceroCodProvincia("01");

		objetoPasarela.setDatosTerceroTelefono("945101010"); // 94125412
		objetoPasarela.setDatosTerceroTextoCastTelefono("Tfnoa."); // "Tfnoa."
		objetoPasarela.setDatosTerceroTextoEuskTelefono("Tfno."); // "Tfno."
		objetoPasarela.setDatosTerceroEmail("oscar.odei@gmail.com"); // jaraizaga@bilbomatica.es
		objetoPasarela.setDatosTerceroTextoCastEmail("e-mail"); // "e-mail"
		objetoPasarela.setDatosTerceroTextoEuskEmail("e-mail"); // "e-mail"
		objetoPasarela.setDatosTerceroTextoCastNumFactura("FACTURA");
		objetoPasarela.setDatosTerceroTextoCastNumExp("EXPEDIENTE");
		objetoPasarela.setDatosTerceroTextoEuskNumFactura("FAKTURA");
		objetoPasarela.setDatosTerceroTextoEuskNumExp("ESPEDIENTEA");
		objetoPasarela.setDatosTerceroApellido1("PRUEBAS");
		objetoPasarela.setDatosTerceroApellido2("DESARROLLO");
		objetoPasarela.setDatosTerceroNombre("CIUDADANO");
		objetoPasarela.setDatosTerceroDeudorApremiable(null);
		objetoPasarela.setDatosTerceroResidente(null);

		// objetoPasarela
		// .setMensajeCastCabecera("Los datos personales contenidos en esta
		// solicitud forman parte de un fichero automatizado propiedad de
		// KontsumoBIDE frente a la cual el interesado podrá en cualquier
		// momento ejercitar los derechos de acceso, rectificación,
		// cancelación y oposición, mediante escrito dirigido a la Dirección
		// de Vivienda, Obras Públicas y Transportes (calle Donostia-San
		// Sebastian, 1 - 01010 Vitoria-Gasteiz), conforme a lo establecido en
		// la Ley organica 15/1999, de 13 de diciembre, de Proteccion de Datos
		// de Carácter Personal");
		// objetoPasarela
		// .setMensajeEuskCabecera("Los datos personales contenidos en esta
		// solicitud forman parte de un fichero automatizado propiedad de
		// KontsumoBIDE frente a la cual el interesado podrá en cualquier
		// momento ejercitar los derechos de acceso, rectificación,
		// cancelación y oposición, mediante escrito dirigido a la Dirección
		// de Vivienda, Obras Públicas y Transportes (calle Donostia-San
		// Sebastian, 1 - 01010 Vitoria-Gasteiz), conforme a lo establecido en
		// la Ley organica 15/1999, de 13 de diciembre, de Proteccion de Datos
		// de Carácter Personal_EU");
		// objetoPasarela
		// .setMensajeCastMedio("La tasa objeto de esta liquidación está
		// sujeta a la Ley 13/1998 de 29 de mayo, de tasas y precios públicos
		// de la Administración de la Comunidad Autónoma del País Vasco.
		// Contra esta liquidación podrá interponerse, en el plazo de 15 días
		// desde su notificación, un recurso de resposición ante el órgano
		// que dictó la resolución, o, en su defecto o contra su resolución,
		// reclamación económico-administrativa ante el Tribunal
		// Económico-Administrativo de Euskadi, en el mismo plazo.");
		// objetoPasarela
		// .setMensajeEuskMedio("La tasa objeto de esta liquidación está
		// sujeta a la Ley 13/1998 de 29 de mayo, de tasas y precios públicos
		// de la Administración de la Comunidad Autónoma del País Vasco.
		// Contra esta liquidación podrá interponerse, en el plazo de 15 días
		// desde su notificación, un recurso de resposición ante el órgano
		// que dictó la resolución, o, en su defecto o contra su resolución,
		// reclamación económico-administrativa ante el Tribunal
		// Económico-Administrativo de Euskadi, en el mismo plazo._EU");
		// objetoPasarela
		// .setMensajeCastPie("El pago de esta liquidación se acredita mediante
		// validación mecánica o justificante del ingreso de la Entidad
		// Financiera colaboradora");
		// objetoPasarela
		// .setMensajeEuskPie("El pago de esta liquidación se acredita mediante
		// validación mecánica o justificante del ingreso de la Entidad
		// Financiera colaboradora_EU");
		// // 1254-04 . Para nosotros puede que no sea obligatorio.
		objetoPasarela.setNumeroLiquidacion(null);
		objetoPasarela.setCodAplicacion("y41b"); // q92b
		objetoPasarela.setNombreCastAplicacion("Gestion de Expedientes KontsumoBIDE"); // escuela
																						// de
																						// deportes
		objetoPasarela.setNombreEuskAplicacion("Gestion de Expedientes KontsumoBIDE_EU"); // Escuela
																							// de
																							// deportes
		objetoPasarela.setResponsableAplicacion("ejie"); // ejie
		objetoPasarela.setSessionID(null); // session id
		// numero de tercero de IKUS
		objetoPasarela.setTercero(null);

		/**
		 * Numero de cuenta
		 */
		objetoPasarela.setNumCuenta(null);
		/**
		 * Ejercicio contable
		 */
		objetoPasarela.setEjercicioContable("2013");

		/**
		 * Numero de referencia de la fianzas para la ejecucion
		 */
		objetoPasarela.setNumReferenciaAnticipoCuenta(null);

		return objetoPasarela;
	}
}
