package com.ejie.y41b.control.testing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.OutputSirServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.outputsir.ArrayOfSignatureDocuments;
import com.ejie.y41b.outputsir.ArrayOfWSParamPerson;
import com.ejie.y41b.outputsir.ArrayOfWSSirParamDocument;
import com.ejie.y41b.outputsir.DIR3Destination;
import com.ejie.y41b.outputsir.ObjectFactory;
import com.ejie.y41b.outputsir.Signatures;
import com.ejie.y41b.outputsir.WSOutputRegister;
import com.ejie.y41b.outputsir.WSParamPerson;
import com.ejie.y41b.outputsir.WSParamSIROutputRegister;
import com.ejie.y41b.outputsir.WSParamSignatureDocument;
import com.ejie.y41b.outputsir.WSSirParamDocument;
import com.ejie.y41b.utils.Y41bUtils;

import noNamespace.SignatureListDocument;

/**
 * Clase de Testing de OutputSirServiceImpl
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/y41bOutputSirServiceTest")
public class OuputSirServiceTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory.getLogger(OuputSirServiceTestController.class);

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	/**
	 * Method 'testWsNewSIROutputRegister'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "wsNewSIROutputRegister", method = RequestMethod.GET)
	public ModelAndView testWsNewSIROutputRegister(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {

			WSParamSIROutputRegister datas = new WSParamSIROutputRegister();

			datas.setUnitCode("2259");
			datas.setSender("2259");

			datas.setMatter("ASUNTO");

			ArrayOfWSParamPerson personList = new ArrayOfWSParamPerson();

			WSParamPerson wsParamPerson = new WSParamPerson();
			wsParamPerson.setPersonName("PRUEBA");
			personList.getWSParamPerson().add(wsParamPerson);

			datas.setPersons(personList);

			DIR3Destination dir3Destination = new DIR3Destination();
			dir3Destination.setOfficeCode("O00016732");
			dir3Destination.setUnitCode("A13010361");
			datas.setDIR3(dir3Destination);

			ObjectFactory objectFactory = new ObjectFactory();

			// DOCUMENTOS
			ArrayOfWSSirParamDocument arrayOfWSSirParamDocument = new ArrayOfWSSirParamDocument();
			List<WSSirParamDocument> listWSSirParamDocument = arrayOfWSSirParamDocument.getWSSirParamDocument();

			String oidDokusi = "09f4240180e3203f";
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
			documento.setProcedure(procedure);
			documento.setOidDokusi(oidDokusi);

			Documento documentoRdo = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

			String pathTo = "/y59/SIR/" + oidDokusi + ".pdf";

			Y31AttachmentBean y31AttachmentBeanDoc = y41bPifAdapterService.moveToPath(documentoRdo.getPifId(), pathTo,
					true);

			String documentName = Y41bUtils.getNameFileFromPath(y31AttachmentBeanDoc.getFilePath());

			WSSirParamDocument wSSirParamDocument = new WSSirParamDocument();
			wSSirParamDocument.setDocumentName(Y41bUtils.getNameFile(documentName));
			wSSirParamDocument.setFileName(documentName);
			wSSirParamDocument.setDocumentLocation(Y41bUtils.getNameFile(documentName) + "::pdf");
			wSSirParamDocument.setExtension("pdf");
			listWSSirParamDocument.add(wSSirParamDocument);

			datas.setDocuments(arrayOfWSSirParamDocument);

			// FIRMAS

			Documento documentoFiltro = new Documento();
			// 1.User
			documentoFiltro.setUser(user);
			documentoFiltro.setProcedure(procedure);
			documentoFiltro.setOidDokusi(oidDokusi);
			String firmasStr = y41bDokusiAdapterService.recuperarFirmarDocumentosDokusiString(documento);

			SignatureListDocument signatureListDocument = SignatureListDocument.Factory.parse(firmasStr);

			InputStream isXML = new ByteArrayInputStream(
					signatureListDocument.getSignatureList().getSignatureArray(0).getSignature().getBytes("UTF-8"));

			// Dejamos firma en pif (y59/SIR)
			String rutaFirma = "/y59/SIR/" + oidDokusi + "_firma.xml";

			String idPif = this.y41bPifAdapterService.putFileToPath(isXML, rutaFirma);

			Signatures signatures = new Signatures();

			ArrayOfSignatureDocuments arrayOfSignatureDocuments = new ArrayOfSignatureDocuments();
			List<WSParamSignatureDocument> listWSParamSignatureDocument = arrayOfSignatureDocuments
					.getWSParamSignatureDocument();

			WSParamSignatureDocument wSParamSignatureDocument = new WSParamSignatureDocument();
			wSParamSignatureDocument.setFileName(oidDokusi + "_firma.xml");
			wSParamSignatureDocument.setDocumentLocation(oidDokusi + "_firma::xml");
			wSParamSignatureDocument.setRelatedDocumentLocation(Y41bUtils.getNameFile(documentName) + "::pdf");

			JAXBElement<String> extension = objectFactory.createWSParamSignatureDocumentExtension("xml");
			wSParamSignatureDocument.setExtension(extension);
			listWSParamSignatureDocument.add(wSParamSignatureDocument);

			JAXBElement<ArrayOfSignatureDocuments> firmas = objectFactory
					.createSignaturesArrayOfSignatureDocuments(arrayOfSignatureDocuments);
			signatures.setArrayOfSignatureDocuments(firmas);

			datas.setSignatures(signatures);

			OutputSirServiceImpl outputSirServiceImpl = new OutputSirServiceImpl();
			WSOutputRegister wSOutputRegister = outputSirServiceImpl.wsNewSIROutputRegister(datas);

			// Fin Bloque del Test
			sendOK(response, wSOutputRegister.toString());
			logger.debug("PlateaServiceTestController.testObtenerDatosCatalogoProcedimientos -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("PlateaServiceTestController.testObtenerDatosCatalogoProcedimientos -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}
}
