package com.ejie.y41b.control.testing;

import java.util.Hashtable;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.notification.xml.NotificationBodyDocument;

import com.ejie.y41b.jms.Y41bTratamientoJMSService;
import com.ejie.y41b.utils.documentos.Y41bDocumento;

/**
 * Clase de Testing de Y41bTratamientoJMSService (Recepcion mensajes de Cola
 * JMS)
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/y41bJMSSinColaTest")
public class JMSSinColaTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(PlateaServiceTestController.class);

	@Autowired()
	private Y41bTratamientoJMSService y41bTratamientoJMSService;

	/**
	 * Method 'testTratamientoSolicitudes'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "tratamientoSolicitudes", method = RequestMethod.GET)
	public ModelAndView testTratamientoSolicitudes(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		logger.info("The request is a test. Test begin.");
		String registryNumber = request.getParameter("registryNumber") == null ? ""
				: request.getParameter("registryNumber");
		String expediente_id = request.getParameter("expediente_id") == null ? ""
				: request.getParameter("expediente_id");
		try {
			String msjQueue = new String(
					Y41bDocumento
							.leerArchivoOrigen("C:/datos/y41b/file/test/jms_solicitud_baja.xml"),
					"ISO-8859-1");
			msjQueue = msjQueue.replaceAll("REPLACE_REGISTRY_NUMBER",
					registryNumber);
			msjQueue = msjQueue.replaceAll("REPLACE_TEST_SIMULATE_NUM_EXP",
					expediente_id);
			NotificationBodyDocument xmlQueue = NotificationBodyDocument.Factory
					.parse(msjQueue);
			// Inicio Bloque del Test
			this.sendMessage(xmlQueue.xmlText());

			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSServiceTestController.testTratamientoSolicitudes -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSServiceTestController.testTratamientoSolicitudes -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testTratamientoNotificacionesDelivery'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "tratamientoNotificacionesDelivery", method = RequestMethod.POST)
	public ModelAndView testTratamientoNotificacionesDelivery(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String notificationId = request.getParameter("notificationId") == null ? ""
				: request.getParameter("notificationId");
		try {
			String msjQueue = new String(
					Y41bDocumento
							.leerArchivoOrigen("/datos/y41b/file/test/Q99D_PUBLISH_NOTIFICATION_DELIVERY.xml"),
					"ISO-8859-1");
			msjQueue = msjQueue.replaceAll("REPLACE_NOTIFICATION_ID",
					notificationId);
			NotificationBodyDocument xmlQueue = NotificationBodyDocument.Factory
					.parse(msjQueue);
			// Inicio Bloque del Test
			this.sendMessage(xmlQueue.xmlText());
			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSServiceTestController.testTratamientoNotificacionesDelivery -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSServiceTestController.testTratamientoNotificacionesDelivery -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testTratamientoNotificacionesExpiration'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "tratamientoNotificacionesExpiration", method = RequestMethod.POST)
	public ModelAndView testTratamientoNotificacionesExpiration(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String notificationId = request.getParameter("notificationId") == null ? ""
				: request.getParameter("notificationId");
		try {
			String msjQueue = new String(
					Y41bDocumento
							.leerArchivoOrigen("/datos/y41b/file/test/Q99D_PUBLISH_NOTIFICATION_EXPIRATION.xml"),
					"ISO-8859-1");
			msjQueue = msjQueue.replaceAll("REPLACE_NOTIFICATION_ID",
					notificationId);
			NotificationBodyDocument xmlQueue = NotificationBodyDocument.Factory
					.parse(msjQueue);
			// Inicio Bloque del Test
			this.sendMessage(xmlQueue.xmlText());
			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSServiceTestController.testTratamientoNotificacionesExpiration -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSServiceTestController.testTratamientoNotificacionesExpiration -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testTratamientoAportaDocumentacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "tratamientoAportaDocumentacion", method = RequestMethod.GET)
	public ModelAndView testTratamientoAportaDocumentacion(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			String msjQueue = new String(
					Y41bDocumento
							.leerArchivoOrigen("/datos/y41b/file/test/Q99D_APORTACION_DOCUMENTO.xml"),
					"ISO-8859-1");
			NotificationBodyDocument xmlQueue = NotificationBodyDocument.Factory
					.parse(msjQueue);
			// Inicio Bloque del Test
			this.sendMessage(xmlQueue.xmlText());
			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSServiceTestController.testTratamientoAportaDocumentacion -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSServiceTestController.testTratamientoAportaDocumentacion -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testTratamientoLocalizador'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "tratamientoLocalizador", method = RequestMethod.POST)
	public ModelAndView testTratamientoLocalizador(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String incorporar_localizador_idPeticion = request
				.getParameter("incorporar_localizador_idPeticion") == null ? ""
				: request.getParameter("incorporar_localizador_idPeticion");
		String incorporar_localizador_oid = request
				.getParameter("incorporar_localizador_oid") == null ? ""
				: request.getParameter("incorporar_localizador_oid");
		try {
			String msjQueue = new String(
					Y41bDocumento
							.leerArchivoOrigen("/datos/y41b/file/test/Q99D_LOCATOR.xml"),
					"ISO-8859-1");
			msjQueue = msjQueue.replaceAll("REPLACE_DOCUMENT_OID",
					incorporar_localizador_oid);
			msjQueue = msjQueue.replaceAll("REPLACE_PETICION_OID",
					incorporar_localizador_idPeticion);
			NotificationBodyDocument xmlQueue = NotificationBodyDocument.Factory
					.parse(msjQueue);
			// Inicio Bloque del Test
			this.sendMessage(xmlQueue.xmlText());
			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSServiceTestController.testTratamientoLocalizador -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSServiceTestController.testTratamientoLocalizador -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	private void sendMessage(String messageText) throws Throwable {
		InitialContext ctx = null;
		QueueConnectionFactory qcf = null;
		QueueConnection qc = null;
		QueueSession qsess = null;
		Queue q = null;
		QueueSender qsndr = null;
		TextMessage message = null;
		// NOTE: The next two lines set the name of the Queue Connection Factory
		// and the Queue that we want to use.
		String QCF_NAME = "jms/y41bMiddlewareJMSFactory";
		String QUEUE_NAME = "y41b.y41bMiddlewareJMSQueue";

		// create InitialContext
		Hashtable properties = new Hashtable();
		properties.put(Context.INITIAL_CONTEXT_FACTORY,
				"weblogic.jndi.WLInitialContextFactory");
		// NOTE: The port number of the server is provided in the next line,
		// followed by the userid and password on the next two lines.
		properties.put(Context.PROVIDER_URL, "t3://localhost:7001");
		properties.put(Context.SECURITY_PRINCIPAL, "weblogic11");
		properties.put(Context.SECURITY_CREDENTIALS, "weblogic11");
		try {
			ctx = new InitialContext(properties);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got InitialContext " + ctx.toString());
		// create QueueConnectionFactory
		try {
			qcf = (QueueConnectionFactory) ctx.lookup(QCF_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueConnectionFactory " + qcf.toString());
		// create QueueConnection
		try {
			qc = qcf.createQueueConnection();
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueConnection " + qc.toString());
		// create QueueSession
		try {
			qsess = qc.createQueueSession(false, 0);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueSession " + qsess.toString());
		// lookup Queue
		try {
			q = (Queue) ctx.lookup(QUEUE_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got Queue " + q.toString());
		// create QueueSender
		try {
			qsndr = qsess.createSender(q);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueSender " + qsndr.toString());
		// create TextMessage
		try {
			message = qsess.createTextMessage();
			message.setJMSExpiration(100000);
			message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got TextMessage " + message.toString());
		// set message text in TextMessage
		try {
			message.setText(messageText);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Set text in TextMessage " + message.toString());
		// send message
		try {
			// qsndr.send(message);
			y41bTratamientoJMSService.onMessage(message);

		} catch (Exception jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Sent message ");
		// clean up
		try {
			message = null;
			qsndr.close();
			qsndr = null;
			q = null;
			qsess.close();
			qsess = null;
			qc.close();
			qc = null;
			qcf = null;
			ctx = null;
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
		}
		logger.debug("Cleaned up and done.");
	}
}
