package com.ejie.y41b.control.testing;

import java.sql.Blob;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.report.Y41bReportGeneratorService;
import com.ejie.y41b.service.PlantillaTramiteService;

/**
 * Clase de Testing de JMSRemesaServiceTestController (Recepcion mensajes de
 * Cola JMS)
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/y41bJMSRemesaServiceTest")
public class JMSRemesaServiceTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(PlateaServiceTestController.class);

	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private Y41bReportGeneratorService reportGeneratorService;

	/**
	 * Method 'testInicioEmitirRemesa'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "inicioEmitirRemesa", method = RequestMethod.GET)
	public ModelAndView inicioEmitirRemesa(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		return new ModelAndView("test_emitir_remesa", "model", model);
	}

	/**
	 * Method 'testEmitirRemesa'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "emitirRemesa", method = RequestMethod.POST)
	public ModelAndView testEmitirRemesa(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String idRemesa = request.getParameter("idRemesa") == null ? ""
				: request.getParameter("idRemesa");
		try {
			// Inicio Bloque del Test
			this.sendMessage(idRemesa);
			// Fin Bloque del Test
			sendOK(response, "Mensaje enviado a la cola correctamente.");
			logger.debug("JMSRemesaServiceTestController.testTratamientoSolicitudes -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("JMSRemesaServiceTestController.testTratamientoSolicitudes -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testGenerarReport'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "generarReport", method = RequestMethod.POST)
	public ModelAndView testGenerarReport(Model model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		String tipoPlantilla = request.getParameter("tipoPlantilla") == null ? ""
				: request.getParameter("tipoPlantilla");
		String idPlantilla = "";
		String idPlantillaAcuse = request.getParameter("idPlantillaAcuse") == null ? ""
				: request.getParameter("idPlantillaAcuse");
		String idPlantillaCaratula = request
				.getParameter("idPlantillaCaratula") == null ? "" : request
				.getParameter("idPlantillaCaratula");
		String idPlantillaListado = request.getParameter("idPlantillaListado") == null ? ""
				: request.getParameter("idPlantillaListado");
		try {
			logger.info("tipoPlantilla:" + tipoPlantilla);
			if ("A".equals(tipoPlantilla)) {
				idPlantilla = idPlantillaAcuse;
			} else if ("C".equals(tipoPlantilla)) {
				idPlantilla = idPlantillaCaratula;
			} else if ("L".equals(tipoPlantilla)) {
				idPlantilla = idPlantillaListado;
			}

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(idPlantilla);
			plantillaTramite = this.plantillaTramiteService
					.obtenerDocumentoPlantilla(plantillaTramite);
			if (plantillaTramite == null) {
				throw new Exception(idPlantilla.toString());
			}

			Blob contenido = plantillaTramite.getPtplantilla();

			Map<String, Object> data = new HashMap<String, Object>();
			data.put("REMESA_NUMERO", "Esto es una prueba");
			reportGeneratorService.generate(contenido.getBinaryStream(), data,
					response.getOutputStream());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String fileName = "test.pdf";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(fileName) + "\"");
			response.setContentType("application/pdf");
			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idPlantilla.toString());
		}
		return null;
	}

	private void sendMessage(String messageText) {
		InitialContext ctx = null;
		QueueConnectionFactory qcf = null;
		QueueConnection qc = null;
		QueueSession qsess = null;
		Queue q = null;
		QueueSender qsndr = null;
		TextMessage message = null;
		// NOTE: The next two lines set the name of the Queue Connection Factory
		// and the Queue that we want to use.
		String QCF_NAME = "y41b.y41bRemesasFactory";
		String QUEUE_NAME = "y41b.y41bRemesasQueue";

		// create InitialContext
		Hashtable properties = new Hashtable();
		properties.put(Context.INITIAL_CONTEXT_FACTORY,
				"weblogic.jndi.WLInitialContextFactory");
		// NOTE: The port number of the server is provided in the next line,
		// followed by the userid and password on the next two lines.
		properties.put(Context.PROVIDER_URL, "t3://localhost:7001");
		properties.put(Context.SECURITY_PRINCIPAL, "weblogic11");
		properties.put(Context.SECURITY_CREDENTIALS, "weblogic11");
		try {
			ctx = new InitialContext(properties);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got InitialContext " + ctx.toString());
		// create QueueConnectionFactory
		try {
			qcf = (QueueConnectionFactory) ctx.lookup(QCF_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueConnectionFactory " + qcf.toString());
		// create QueueConnection
		try {
			qc = qcf.createQueueConnection();
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueConnection " + qc.toString());
		// create QueueSession
		try {
			qsess = qc.createQueueSession(false, 0);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueSession " + qsess.toString());
		// lookup Queue
		try {
			q = (Queue) ctx.lookup(QUEUE_NAME);
		} catch (NamingException ne) {
			ne.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got Queue " + q.toString());
		// create QueueSender
		try {
			qsndr = qsess.createSender(q);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got QueueSender " + qsndr.toString());
		// create TextMessage
		try {
			message = qsess.createTextMessage();
			message.setJMSExpiration(100000);
			message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Got TextMessage " + message.toString());
		// set message text in TextMessage
		try {
			message.setText(messageText);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Set text in TextMessage " + message.toString());
		// send message
		try {
			qsndr.send(message);
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
			System.exit(0);
		}
		logger.debug("Sent message ");
		// clean up
		try {
			message = null;
			qsndr.close();
			qsndr = null;
			q = null;
			qsess.close();
			qsess = null;
			qc.close();
			qc = null;
			qcf = null;
			ctx = null;
		} catch (JMSException jmse) {
			jmse.printStackTrace(System.err);
		}
		logger.debug("Cleaned up and done.");
	}
}
