package com.ejie.y41b.control.testing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.DocumentoBusqueda;
import com.ejie.y41b.model.dokusi.Firma;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.LocalizadorDocumento;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.dokusi.RespuestaEliminarDocumento;
import com.ejie.y41b.model.dokusi.RespuestaLocalizadorDocumento;
import com.ejie.y41b.model.dokusi.TransformarDocumento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * Clase de Testing de Y41bDokusiAdapterServiceTest (Adaptador DOKUSI)
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/y41bDokusiAdapterServiceTest")
public class DokusiServiceTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory.getLogger(DokusiServiceTestController.class);

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'testBuscarDocumentosDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "buscarDocumentosDokusi", method = RequestMethod.GET)
	public ModelAndView testBuscarDocumentosDokusi(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			DocumentoBusqueda documentoBusqueda = new DocumentoBusqueda();
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documentoBusqueda.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documentoBusqueda.setProcedure(procedure);

			// 2.Tipo Documental
			documentoBusqueda.setTipoDocumental("ejgv_d_solicitud");
			// 3.ReturnedAttributeKeysList
			List<Metadato> returnedAttributeKeysList = new ArrayList<Metadato>();
			// object_name
			Metadato medatadoReturned = new Metadato();
			medatadoReturned.setNombre("object_name");
			returnedAttributeKeysList.add(medatadoReturned);
			// ejgv_serie
			medatadoReturned = new Metadato();
			medatadoReturned.setNombre("ejgv_serie");
			returnedAttributeKeysList.add(medatadoReturned);
			// ejgv_origen
			medatadoReturned = new Metadato();
			medatadoReturned.setNombre("ejgv_origen");
			returnedAttributeKeysList.add(medatadoReturned);
			documentoBusqueda.setMetadatosResultado(returnedAttributeKeysList);
			// 4.SearchConditionsList
			List<Metadato> searchConditionsList = new ArrayList<Metadato>();
			// ejgv_serie
			Metadato medatadoFiltro = new Metadato();
			/*
			 * medatadoFiltro.setNombre("object_name");
			 * medatadoFiltro.setValor("Solicitud.html");
			 * medatadoFiltro.setOperador("=");
			 * searchConditionsList.add(medatadoFiltro);
			 */

			medatadoFiltro = new Metadato();
			medatadoFiltro.setNombre("ejgv_expediente");
			medatadoFiltro.setValor("SOL-48L021/129/2013/1");
			medatadoFiltro.setOperador("=");
			searchConditionsList.add(medatadoFiltro);

			documentoBusqueda.setMetadatosFiltro(searchConditionsList);
			// 5.boolAllVersions
			documentoBusqueda.setAllVersions(false);
			// 6.intMaxRows
			documentoBusqueda.setMaxRows(100);
			List<Documento> documentosRdo = y41bDokusiAdapterService.buscarDocumentosDokusi(documentoBusqueda);
			// Fin Bloque del Test
			sendOK(response, documentosRdo.toString());
			logger.debug("DokusiServiceTestController.testBuscarDocumentosDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testBuscarDocumentosDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testRegistrarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "registrarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testRegistrarDocumentoDokusi(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("V08AB");
			user.setDni("V08AB");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documento.setProcedure(procedure);
			// 2.Tipo Documental
			documento.setTipoDocumental("ejgv_d_archivo");

			documento.setIdDocumento("1");
			documento.setNombre("prueba");
			documento.setExtension("rtf");

			documento.setBytes(
					Y41bUtilsDokusi.encode(Y41bDocumento.leerArchivoOrigen("/datos/y41b/file/test/prueba.rtf")));

			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
			documento.setNumeroExpediente("SOL-48L021/129/2013/1");

			documento.setRegistryNumber("2013RTE00039033");
			documento.setRegistryTimestamp("24/09/2013 10:30:32");
			documento.setEntradaSalida("E");

			Documento documentoRdo = y41bDokusiAdapterService.registrarDocumentoDokusi(documento);
			// Fin Bloque del Test
			sendOK(response, documentoRdo.toString());
			logger.info("DokusiServiceTestController.testRegistrarDocumentoDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.info("DokusiServiceTestController.testRegistrarDocumentoDokusi -> ERROR");
		} finally {
			logger.info("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testRetramitarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "retramitarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testRetramitarDocumentoDokusi(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("Y41B");
			user.setDni("Y41B");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documento.setProcedure(procedure);
			// 2.Tipo Documental
			documento.setTipoDocumental("ejgv_d_informe");

			documento.setOidDokusi("09f4240180928bf4");

			documento.setIdDocumento("1");
			documento.setNombre("prueba");
			documento.setExtension("rtf");

			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
			documento.setNumeroExpediente("SOL-48L021/129/2013/1");

			documento.setRegistryNumber("2013RTE00039033");
			documento.setRegistryTimestamp("24/09/2013 10:30:32");
			documento.setEntradaSalida("E");

			String resultado = y41bDokusiAdapterService.retramitarDocumentoDokusi(documento);
			// Fin Bloque del Test
			sendOK(response, resultado);
			logger.info("DokusiServiceTestController.testRetramitarDocumentoDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.info("DokusiServiceTestController.testRetramitarDocumentoDokusi -> ERROR");
		} finally {
			logger.info("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDescargarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "descargarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testDescargarDocumentoDokusi(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("y41b");
			user.setDni("y41b");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documento.setProcedure(procedure);

			documento.setOidDokusi("09f4240180cd7675");

			Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);
			// Fin Bloque del Test
			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo

			sendOK(response, documentoRdo.toString());

			logger.debug("DokusiServiceTestController.testDescargarDocumentoDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testDescargarDocumentoDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testEliminarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "eliminarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testEliminarDocumentoDokusi(Model model, HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("V08AB");
			user.setDni("V08AB");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");
			documento.setProcedure(procedure);

			documento.setOidDokusi("09f424018055c873");
			documento.setBoolAllVersions("true");

			RespuestaEliminarDocumento respuestaEliminarDocumento = y41bDokusiAdapterService
					.eliminarDocumentoDokusi(documento);
			// Fin Bloque del Test
			sendOK(response, respuestaEliminarDocumento.toString());
			logger.debug("DokusiServiceTestController.testEliminarDocumentoDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testEliminarDocumentoDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testGetDocumentoDokusiAFirmar'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "getDocumentoDokusiAFirmar", method = RequestMethod.GET)
	public ModelAndView testGetDocumentoDokusiAFirmar(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			User user = new User();
			user.setNombre("NombreSolicitante");
			user.setDni("91919191J");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");
			documento.setProcedure(procedure);
			documento.setOidDokusi("09f424018055c873");
			documento.setNombre("prueba");
			documento.setExtension("rtf");
			documento.setBytes(new String(Y41bDocumento.leerArchivoOrigen("/datos/y41b/file/test/prueba.rtf")));
			String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
			// Fin Bloque del Test
			request.setAttribute("documentoFirmar_OID", documento.getOidDokusi());
			request.setAttribute("documentoFirmar_nombre", documento.getNombre());
			request.setAttribute("documentoFirmar_extension", documento.getExtension());
			request.setAttribute("documentoFirmar_ficheroHash", hashDocumento);
			logger.debug("DokusiServiceTestController.testGetDocumentoDokusiAFirmar -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testGetDocumentoDokusiAFirmar -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_firmar_documento", "model", model);
	}

	/**
	 * Method 'testFirmarDocumentosDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "firmarDocumentosDokusi", method = RequestMethod.POST)
	public ModelAndView testFirmarDocumentosDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			String firmaStr = request.getParameter("firma") == null ? "" : request.getParameter("firma");

			// Inicio Bloque del Test
			Documento documento = new Documento();
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
			documento.setProcedure(procedure);

			documento.setOidDokusi("08f42401800afa1c");
			documento.setNombre("RESOLUCION_INCOACCIONcasi vacio.doc");
			documento.setExtension("pdf");

			List<Firma> listaFirma = new ArrayList<Firma>();
			Firma firma = new Firma();
			firma.setFirma(firmaStr);
			listaFirma.add(firma);

			documento.setFirmas(listaFirma);

			String resultado = y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
			// Fin Bloque del Test
			// A continuacion valido que el documento en DOKUSI tenga la firma
			// que acabo de realizar
			Documento documentoFiltro = new Documento();
			// 1.User
			documentoFiltro.setUser(user);
			documentoFiltro.setProcedure(procedure);
			// Sin firmas
			documentoFiltro.setOidDokusi("08f42401800afa1c");
			documentoFiltro.setNombre("RESOLUCION_INCOACCIONcasi vacio.doc");
			documentoFiltro.setExtension("pdf");
			Documento documentosRdoFiltro = y41bDokusiAdapterService.recuperarFirmarDocumentosDokusi(documento);
			if (documentosRdoFiltro.getFirmas() != null) {
				for (int i = 0; i < documentosRdoFiltro.getFirmas().size(); i++) {
					if (firma.getFirma().equals(documentosRdoFiltro.getFirmas().get(i).getFirma())) {
						sendOK(response, resultado);
						return null;
					}
				}
			}
			sendError(response, new Exception("NO EXISTE LA FIRMA"));
			logger.debug("DokusiServiceTestController.testFirmarDocumentosDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testFirmarDocumentosDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testRecuperarFirmarDocumentosDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "recuperarFirmarDocumentosDokusi", method = RequestMethod.GET)
	public ModelAndView testRecuperarFirmarDocumentosDokusi(Model model, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("NombreSolicitante");
			user.setDni("91919191J");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("W92J_ESNETASA");
			documento.setProcedure(procedure);

			// Sin firmas
			// documento.setOidDokusi("09f424018055c873");
			// documento.setNombre("prueba");
			// documento.setExtension("rtf");

			// Con firmas
			documento.setOidDokusi("09f424018056bf1a");

			Documento documentosRdo = y41bDokusiAdapterService.recuperarFirmarDocumentosDokusi(documento);
			// Fin Bloque del Test
			sendOK(response, documentosRdo.toString());
			logger.debug("DokusiServiceTestController.testRecuperarFirmarDocumentosDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testRecuperarFirmarDocumentosDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDatosLocalizadorDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosLocalizadorDokusi", method = RequestMethod.GET)
	public ModelAndView testDatosLocalizadorDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_incorporarLocalizadorDokusi", "model", model);
	}

	/**
	 * Method 'testIncorporarLocalizadorDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "incorporarLocalizadorDokusi", method = RequestMethod.POST)
	public ModelAndView testIncorporarLocalizadorDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String incorporar_localizador_proc_id = request.getParameter("incorporar_localizador_proc_id") == null ? ""
					: request.getParameter("incorporar_localizador_proc_id");
			String incorporar_localizador_oid = request.getParameter("incorporar_localizador_oid") == null ? ""
					: request.getParameter("incorporar_localizador_oid");
			String incorporar_localizador_nombre = request.getParameter("incorporar_localizador_nombre") == null ? ""
					: request.getParameter("incorporar_localizador_nombre");
			String incorporar_localizador_nif = request.getParameter("incorporar_localizador_nif") == null ? ""
					: request.getParameter("incorporar_localizador_nif");

			LocalizadorDocumento incorporarLocalizador = new LocalizadorDocumento();
			incorporarLocalizador.setOidDocumento(incorporar_localizador_oid);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(incorporar_localizador_proc_id);
			incorporarLocalizador.setProcedure(procedure);
			User sender = new User();
			sender.setDni(incorporar_localizador_nif);
			sender.setNombre(incorporar_localizador_nombre);
			incorporarLocalizador.setUser(sender);
			incorporarLocalizador.setBoolVersion(true);
			incorporarLocalizador.setBoolReducir(false);
			incorporarLocalizador.setSede("");

			RespuestaLocalizadorDocumento respuestaLocalizadorDocumento = y41bDokusiAdapterService
					.incorporarLocalizadorDokusi(incorporarLocalizador);
			request.setAttribute("incorporar_localizador_idPeticion", respuestaLocalizadorDocumento.getOidPeticion());
			request.setAttribute("incorporar_localizador_oid", incorporar_localizador_oid);
			logger.debug("DokusiServiceTestController.testIncorporarLocalizadorDokusi -> OK");
		} catch (Y41bUDAException e_incorporarLocalizadorDokusi) {
			throw e_incorporarLocalizadorDokusi;
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testIncorporarLocalizadorDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return new ModelAndView("test_incorporarLocalizadorDokusiJMS", "model", model);
	}

	/**
	 * Method 'testTransformarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "transformarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testTransformarDocumentoDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre("V08AB");
			user.setDni("V08AB");
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documento.setProcedure(procedure);
			// 2.Tipo Documental
			documento.setTipoDocumental("ejgv_d_archivo");

			documento.setIdDocumento("1");
			documento.setNombre("prueba");
			documento.setExtension("rtf");

			documento.setBytes(
					Y41bUtilsDokusi.encode(Y41bDocumento.leerArchivoOrigen("/datos/y41b/file/test/prueba.rtf")));

			documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
			documento.setNumeroExpediente("SOL-48L021/129/2013/1");

			documento.setRegistryNumber("2013RTE00039033");
			documento.setRegistryTimestamp("24/09/2013 10:30:32");
			documento.setEntradaSalida("E");
			documento.setNolocalizable(Y41bConstantes.VALOR_SI);

			Documento documentoRdo = y41bDokusiAdapterService.registrarDocumentoDokusi(documento);

			TransformarDocumento transformarDocumento = new TransformarDocumento();
			transformarDocumento.setOidDocumento(documentoRdo.getOidDokusi());
			transformarDocumento.setProcedure(procedure);
			transformarDocumento.setUser(user);

			y41bDokusiAdapterService.transformarDocumentoDokusi(transformarDocumento);

			sendOK(response, documentoRdo.toString());
			logger.debug("DokusiServiceTestController.testTransformarDocumentoDokusi -> OK");
		} catch (Y41bUDAException e_incorporarLocalizadorDokusi) {
			throw e_incorporarLocalizadorDokusi;
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testTransformarDocumentoDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testDatosModificarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "datosModificarDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testDatosModificarDocumentoDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		logger.debug("The request is a test. Test end.");
		return new ModelAndView("test_modificar_documento", "model", model);
	}

	/**
	 * Method 'testModificarDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "modificarDocumentoDokusi", method = RequestMethod.POST)
	public ModelAndView testModificarDocumentoDokusi(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Recogemos Datos Formulario
			String modif_documento_proc_id = request.getParameter("modif_documento_proc_id") == null ? ""
					: request.getParameter("modif_documento_proc_id");
			String modif_documento_oid = request.getParameter("modif_documento_oid") == null ? ""
					: request.getParameter("modif_documento_oid");
			String modif_documento_nombre_sender = request.getParameter("modif_documento_nombre_sender") == null ? ""
					: request.getParameter("modif_documento_nombre_sender");
			String modif_documento_dni_sender = request.getParameter("modif_documento_dni_sender") == null ? ""
					: request.getParameter("modif_documento_dni_sender");
			String modif_documento_nombre = request.getParameter("modif_documento_nombre") == null ? ""
					: request.getParameter("modif_documento_nombre");
			String modif_documento_extension = request.getParameter("modif_documento_extension") == null ? ""
					: request.getParameter("modif_documento_extension");
			String modif_documento_path = request.getParameter("modif_documento_path") == null ? ""
					: request.getParameter("modif_documento_path");
			String modif_documento_isMetadatos = request.getParameter("modif_documento_isMetadatos") == null ? ""
					: request.getParameter("modif_documento_isMetadatos");

			Documento documento = new Documento();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(modif_documento_proc_id);
			documento.setProcedure(procedure);
			documento.setOidDokusi(modif_documento_oid);
			documento.setBoolSetCurrent(Boolean.TRUE.toString());
			documento.setSaveAsVersion(Y41bConstantes.VERSION_MAYOR);
			User user = new User();
			user.setDni(modif_documento_dni_sender);
			user.setNombre(modif_documento_nombre_sender);
			documento.setUser(user);
			if (Y41bConstantes.SI.equals(modif_documento_isMetadatos)) {
				List<Metadato> metadatos = new ArrayList<Metadato>();
				Metadato metadato1 = new Metadato();
				metadato1.setNombre(Y41bConstantes.METADATO_KEYWORDS);
				metadato1.setValor("SEC_E");
				metadatos.add(metadato1);
				documento.setMetadatos(metadatos);
			}

			if (!"".equals(modif_documento_path)) {
				documento.setNombre(modif_documento_nombre);
				documento.setExtension(modif_documento_extension);
				documento.setBytes(Y41bUtilsDokusi.encode(Y41bDocumento.leerArchivoOrigen(modif_documento_path)));
			}
			Documento respuestaModificarDocumento = y41bDokusiAdapterService.modificarDocumentoDokusi(documento);

			sendOK(response, respuestaModificarDocumento.toString());
			logger.debug("DokusiServiceTestController.testModificarDocumentoDokusi-> OK");
		} catch (Y41bUDAException e_testModificarDocumentoDokusi) {
			throw e_testModificarDocumentoDokusi;
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testModificarDocumentoDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

	/**
	 * Method 'testRecuperarFormatoDocumentoDokusi'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "recuperarFormatoDocumentoDokusi", method = RequestMethod.GET)
	public ModelAndView testRecuperarFormatoDocumentoDokusi(Model model, HttpServletResponse response)
			throws Exception {
		logger.info("The request is a test. Test begin.");
		try {
			// Inicio Bloque del Test
			Documento documento = new Documento();
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);
			documento.setUser(user);
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento("Y41B_RECLAMACION");
			documento.setProcedure(procedure);

			// CON Localizador
			documento.setOidDokusi("09f42401806bc828");
			// SIN Localizador
			// documento.setOidDokusi("09f4240180601b61");

			Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);
			// Fin Bloque del Test
			sendOK(response, formato.toString());
			logger.debug("DokusiServiceTestController.testRecuperarFormatoDocumentoDokusi -> OK");
		} catch (Throwable th) {
			sendError(response, th);
			logger.debug("DokusiServiceTestController.testRecuperarFormatoDocumentoDokusi -> ERROR");
		} finally {
			logger.debug("The request is a test. Test end.");
		}
		return null;
	}

}
