package com.ejie.y41b.control.testing;

import java.io.File;
import java.io.FileInputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.service.AlertaService;

/**
 * Clase de Testing de Alertas
 * 
 *  
 */
@Controller()
@RequestMapping(value = "/alertasTest")
public class AlertasTestController extends TestController {

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(AlertasTestController.class);

	@Autowired()
	private AlertaService alertaService;

	/**
	 * Method 'testAlertas'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "testAlertas", method = RequestMethod.GET)
	public ModelAndView testEnvioPago(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		AlertasTestController.logger.info("The request is a test. Test begin.");
		try {
			// String nombreFichero = "/datos/y41b/file/test/CCAA.xml";
			// String nombreFichero = "/datos/y41b/file/test/CCAA_36-18.xml";
			// String nombreFichero = "/datos/y41b/file/test/CCAA_14021-18.xml";
			// String nombreFichero = "/datos/y41b/file/test/CCAA_NC10-18.xml";
			// String nombreFichero = "/datos/y41b/file/test/UE.xml";
			// String nombreFichero = "/datos/y41b/file/test/CE_0158-18.xml";
			String nombreFichero = "/datos/y41b/file/test/CE_0187-18.xml";

			byte[] fichero = IOUtils.toByteArray(new FileInputStream(new File(
					nombreFichero)));

			Alerta alerta = alertaService.procesarFichero(fichero);

			// Fin Bloque del Test
			this.sendOK(response, alerta.toString());
			AlertasTestController.logger
					.debug("AlertasTestController.testAlertas -> OK");
		} catch (Exception e) {
			this.sendError(response, e);
			AlertasTestController.logger
					.debug("AlertasTestController.testAlertas -> ERROR");
		} finally {
			AlertasTestController.logger
					.debug("The request is a test. Test end.");
		}
		return null;
	}

}
