package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.services.Y41bSipcaService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteSANResolucionComplementaria;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ConceptopagoService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.PagosService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.utils.Y41bLiquidacionUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.validation.Y41bNieValidator;
import com.ejie.y41b.validation.Y41bNifValidator;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite)
@SessionAttributes({ Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, Y41bConstantes.MODOTRAMITES_TRAMITE_K31 })
public class TramiteSANResolucionComplementariaController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteGenericoController.class);

	private String tipo = Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA;

	private String modo = Y41bConstantes.MODOTRAMITES_TRAMITE_K31;

	@Autowired()
	private SantramexpService sanTramExpService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private PagosService pagosService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private SanexpService sanexpService;

	@Autowired()
	private Y41bSipcaService sipcaService;

	@Autowired()
	private ConceptopagoService conceptopagoService;

	@Autowired()
	private ExpedienService expedienService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	@Autowired()
	private SanintervService sanintervService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model, HttpServletRequest request) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(this.sanTramExpService.getNewPK().toString());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		tramiteComun.setIdTipoTramite(this.tipo);
		Expedien expediente = new Expedien();
		expediente.setExcodigo(tramiteComun.getIdExpediente());
		expediente = this.expedienService.find(expediente);
		tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, tramiteComun);

		model.addAttribute(this.modo, Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model, HttpServletRequest request) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		tramiteComun.setIdTipoTramite(this.tipo);
		Expedien expediente = new Expedien();
		expediente.setExcodigo(tramiteComun.getIdExpediente());
		expediente = this.expedienService.find(expediente);
		tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, tramiteComun);

		model.addAttribute(this.modo, Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, "model", model);
	}

	/**
	 * Method 'editTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionComplementaria
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANResolucionComplementaria
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteSANResolucionComplementaria editTramiteGenerico(
			@RequestBody() TramiteSANResolucionComplementaria tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31) String modo, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramite.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteResolucionComplementaria(tramite, tramiteComun, idioma, true, modo);
			}

			TramiteSANResolucionComplementariaController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionComplementaria
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANResolucionComplementaria
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteSANResolucionComplementaria addTramiteGenerico(
			@RequestBody() TramiteSANResolucionComplementaria tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31) String modo, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.sanTramExpService.addTramiteResolucionComplementaria(tramite, tramiteComun, idioma, false, modo);

			}

			TramiteSANResolucionComplementariaController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteSANResolucionComplementaria
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANResolucionComplementaria
	 */
	@RequestMapping(value = "/guardar2", method = RequestMethod.POST)
	public @ResponseBody() TramiteSANResolucionComplementaria addTramiteGenerico2(
			@RequestBody() TramiteSANResolucionComplementaria tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31) String modo, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.sanTramExpService.addTramiteResolucionComplementaria(tramite, tramiteComun, idioma, false, modo);
				Santramexp santramexp = new Santramexp();
				santramexp.setTrid(tramiteComun.getIdTramite());
				String referencia = tramite.getReferencia();
				if (referencia != null) {
					referencia = referencia.replace("\"", "");
				}
				santramexp.setTrreferencia(referencia);
				this.sanTramExpService.updateReferenciaLiquidacion(santramexp);
			}

			TramiteSANResolucionComplementariaController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANAcuerdoIncoacion
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteSANResolucionComplementaria getTramiteById(@PathVariable() String idTramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteSANResolucionComplementaria tramite = new TramiteSANResolucionComplementaria();
			tramite.setIdTramite(idTramite);
			tramite.setIdExpediente(tramiteComun.getIdExpediente());

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramite = this.sanTramExpService.findTramiteResolucionComplementaria(tramite, censoMonitor);
			}

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}

			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteSANResolucionComplementariaController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return this.appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/importeResolucion/{idExpediente}", method = RequestMethod.POST)
	public @ResponseBody() String getImporteResolucion(@PathVariable() String idExpediente,
			HttpServletRequest request) {
		try {
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(idExpediente);
			sanexp = this.sanexpService.find(sanexp);
			if (Y41bUtils.esNullOCadenaVacia(sanexp.getEximporte())) {
				return "";
			} else {
				return Y41bUtils.formatDouble2decimalesYcoma(new BigDecimal(sanexp.getEximporte()).doubleValue());
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsTramiteResolucionComplementaria'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramiteResolucionComplementaria(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasTramiteResolucionComplementaria'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasTramiteResolucionComplementaria(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RESOLUCIONCOMPLEMENTARIA);
			plantillaTramite.setTramite(tramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	// /**
	// * Method 'getByIdPlantillaResolucionComplementaria'.
	// *
	// * @param ptcodigo
	// * String
	// * @param tramiteComun
	// * TramiteComun
	// * @param response
	// * HttpServletResponse
	// * @param request
	// * HttpServletRequest
	// */
	// @RequestMapping(value =
	// "/findPlantillaResolucionComplementaria/{ptcodigo}", method =
	// RequestMethod.GET)
	// public @ResponseBody()
	// void getByIdPlantillaResolucionComplementaria(
	// @PathVariable() String ptcodigo,
	// @ModelAttribute(value =
	// Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun
	// tramiteComun,
	// HttpServletResponse response, HttpServletRequest request) {
	// try {
	//
	// PlantillaTramite plantillaTramite = new PlantillaTramite();
	// plantillaTramite.setPtcodigo(ptcodigo);
	//
	// String plantilla = this.sanexpService.findPlantilla(
	// plantillaTramite, tramiteComun);
	//
	// byte[] bContenido = plantilla.getBytes();
	//
	// plantillaTramite = this.plantillaTramiteService
	// .find(plantillaTramite);
	// String nombreFichero = new StringBuffer()
	// .append(plantillaTramite.getPtnombre().replaceAll(" ", "_"))
	// .append(".rtf").toString();
	//
	// response.setHeader("Content-Disposition", "attachment; filename="
	// + nombreFichero + "");
	// response.setContentType("application/msword");
	// response.setContentLength(bContenido.length);
	// response.getOutputStream().write(bContenido);
	//
	// // Vaciamos el stream
	// response.getOutputStream().flush();
	//
	// } catch (Y41bUDAException e) {
	// throw e;
	// } catch (Exception e) {
	// throw new Y41bUDAException("error.generico", true, e);
	// }
	// }

	/**
	 * Method 'getByIdDocumentoResolucionComplementaria'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoResolucionComplementaria(@PathVariable() String thcodocumento,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			//byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			//response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteResolucionComplementaria'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramiteResolucionComplementaria(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_SAN_RESOLUCION_COMPLEMENTARIA);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteSANResolucionComplementariaController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Fin
	 */

	/**
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'addPlantillaNotificacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void addPlantilla(@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanexpService.addPlantilla(adjuntardocs, tramiteComun,
						Y41bConstantes.TIPO_DOC_SAN_RESOLUCION_COMPLEMENTARIA);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormPasarela'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/inicioPasarela", method = RequestMethod.GET)
	public ModelAndView getCreateFormPasarela(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			Model model, HttpServletRequest request) {
		try {
			// simulamos que es una liquidacion
			model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite, tramiteComun);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			model.addAttribute("fechaLimitePasarela", Y41bLiquidacionUtils.fechaLimitePago(idioma));
			model.addAttribute("conceptoPago", Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION);
			model.addAttribute("conceptoPago", Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION);

			// Comprobar sancionado
			String nombreCompleto = "";
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			List<Saninterv> listaSancionado = this.sanintervService.findAll(sancionado, null);
			if (listaSancionado != null && listaSancionado.size() > 0) {
				sancionado = listaSancionado.get(0);
				Y41bNifValidator nifValidator = new Y41bNifValidator();
				Y41bNieValidator nieValidator = new Y41bNieValidator();
				if (nifValidator.isValid(sancionado.getUanif(), null)
						|| nieValidator.isValid(sancionado.getUanif(), null)) {
					if (Y41bUtils.esNullOCadenaVacia(sancionado.getUaapellido1())
							&& Y41bUtils.esNullOCadenaVacia(sancionado.getUaapellido2())) {
						nombreCompleto = sancionado.getUanombre();
					} else {
						nombreCompleto = sancionado.getUanombre().concat(" ").concat(sancionado.getUaapellido1())
								.concat(" ").concat(sancionado.getUaapellido2());
					}
				}
			}
			model.addAttribute("nombreCompleto", nombreCompleto);

			model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
			model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

			// Al guardar y generar la liquidacion se ha borrado la tabla
			// adjuntarDocs
			// como la modal no se ha cerrado hay que volver a volcar los
			// documentos
			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

			return new ModelAndView("tramiteSANResolucionComplementariaPasarela", "model", model);
		} catch (Exception e) {
			e.printStackTrace();
			TramiteSANResolucionComplementariaController.logger
					.error("Error producido en getCreateFormAlta: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'generarDocLiquidacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param concepto
	 *            String
	 * @param fecha
	 *            String
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return ModelAndView
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/generarDocResolucionComplementaria/{concepto}/{fecha}", method = RequestMethod.GET)
	public ModelAndView generarDocLiquidacion(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K31_idTramite) TramiteComun tramiteComun,
			@PathVariable() String concepto, @PathVariable() String fecha, @RequestParam() String nombre,
			@RequestParam() String apellido1, @RequestParam() String apellido2, Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		String conceptoAux = concepto;
		TramiteSANResolucionComplementariaController.logger.info(".LIQUIDACION.Inicio");
		try {
			// El usuario no quiere que le actualicemos el campo de la bd
			// Cuando se trata de un cif no se desglosa la razn social
			/*
			 * if (!"0".equals(nombre) && !"0".equals(apellido1) &&
			 * !"0".equals(apellido2)) { Saninterv sancionado = new Saninterv();
			 * sancionado.setExpedien(new Expedien(tramiteComun
			 * .getIdExpediente())); sancionado
			 * .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			 * List<Saninterv> listaSancionado = sanintervService.findAll(
			 * sancionado, null); if (listaSancionado != null &&
			 * listaSancionado.size() > 0) { sancionado =
			 * listaSancionado.get(0); sancionado.setUanombre(nombre);
			 * sancionado.setUaapellido1(apellido1);
			 * sancionado.setUaapellido2(apellido2);
			 * sanintervService.update(sancionado); } }
			 */
			this.sipcaService.generarDocResolucionComplementaria(tramiteComun, request, fecha, conceptoAux, response,
					PeticionPago.DEVENGO_EMISION, nombre, apellido1, apellido2); /* FIRME */
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			TramiteSANResolucionComplementariaController.logger
					.error(".LIQUIDACION. Pasarela EnvioPago -> ERROR" + e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		} finally {
			TramiteSANResolucionComplementariaController.logger.info(".LIQUIDACION.Fin");
		}
		return null;
	}

	/**
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/existeLiquidacionTramitada/{idExpediente}", method = RequestMethod.POST)
	public @ResponseBody() boolean existeLiquidacionTramitada(@PathVariable() String idExpediente,
			HttpServletRequest request) {
		try {

			Santramexp santramexp = new Santramexp();
			santramexp.setExpedien(new Expedien(idExpediente));
			santramexp.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
			List<Santramexp> listaTramites = this.sanTramExpService.findAll(santramexp, null);
			boolean resultado = false;
			if (listaTramites != null) {
				for (Santramexp tramite : listaTramites) {
					/* en teoria solo debería haber uno pero bueno */
					if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramite.getTrestado())) {
						resultado = true;
					}
				}
			}
			return resultado;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/tieneLiquidacionFirme/{idExpediente}", method = RequestMethod.POST)
	public @ResponseBody() boolean tieneLiquidacionFirmeExistente(@PathVariable() String idExpediente,
			HttpServletRequest request) {
		try {
			return this.pagosService.tieneLiquidacionFirmeNoAnulada(idExpediente);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/referenciaLiquidacionFirme/{idExpediente}", method = RequestMethod.POST)
	public @ResponseBody() String referenciaLiquidacionFirmeExistente(@PathVariable() String idExpediente,
			HttpServletRequest request) {
		try {
			return this.pagosService.referenciaLiquidacionFirmeNoAnulada(idExpediente);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param idExpediente
	 *            String
	 * @param referencia
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/existeCalendarioPagosFraccionamiento/{idExpediente}/{referencia}", method = RequestMethod.POST)
	public @ResponseBody() boolean existeCalendarioPagosFraccionamiento(@PathVariable() String idExpediente,
			@PathVariable() String referencia, HttpServletRequest request) {
		try {
			Pagos pagos = new Pagos();

			// si tiene una fraccion es que ha llegado el calendario de pagos
			pagos.setSgidexpediente(idExpediente);
			// pagos.setSgnumfraccion(new Long(1));
			// Viene la referencia junto con el digito de control
			if ("0".equals(referencia)) {
				return false;
			} else {
				pagos.setSgreferenciafracc(referencia.substring(0, referencia.length() - 2));
				List<Pagos> listaPagos = this.pagosService.findAll(pagos, null);
				return (listaPagos != null && listaPagos.size() > 0);
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param concepto
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/findAllConceptoPago/{concepto}", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> getAll(@PathVariable() String concepto) {
		TramiteSANResolucionComplementariaController.logger.info("[GET - find_ALL] : Obtener Conceptopago por filtro");
		Conceptopago filterConceptopago = new Conceptopago();
		filterConceptopago.setSdconceptoing(Integer.parseInt(concepto));
		filterConceptopago.setTipoconceptopago(
				new Tipoconceptopago(Y41bConstantes.TIPO_CONCEPTO_PAGO_SANCIONES, null, null, null));
		return this.conceptopagoService.findAllVigentes(filterConceptopago, null);
	}
}
