package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.services.Y41bSipcaService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteSANLiquidacion;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ConceptopagoService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.PagosService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.utils.Y41bLiquidacionUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.validation.Y41bNieValidator;
import com.ejie.y41b.validation.Y41bNifValidator;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite)
@SessionAttributes({ Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, Y41bConstantes.MODOTRAMITES_TRAMITE_K41 })
public class TramiteSANLiquidacionController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteGenericoController.class);

	private String tipo = Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION;

	private String modo = Y41bConstantes.MODOTRAMITES_TRAMITE_K41;

	@Autowired()
	private Y41bSipcaService sipcaService;

	@Autowired()
	private SantramexpService sanTramExpService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private ConceptopagoService conceptopagoService;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private ParametrosService parametrosService;
	@Autowired()
	private PagosService pagosService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model, HttpServletRequest request) {
		try {
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(idExpediente);
			tramiteComun.setIdTramite(this.sanTramExpService.getNewPK().toString());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(codProcedimiento);
			tramiteComun.setTipoProcedimiento(tipoProcedimiento);
			tramiteComun.setIdTipoTramite(this.tipo);
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
			model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, tramiteComun);

			model.addAttribute(this.modo, Y41bConstantes.MODO_POPUP_ALTA);

			model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
			model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

			return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, "model", model);
		} catch (Exception e) {
			e.printStackTrace();
			TramiteSANLiquidacionController.logger.error("Error producido en getCreateFormAlta: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model, HttpServletRequest request) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		tramiteComun.setIdTipoTramite(this.tipo);
		Expedien expediente = new Expedien();
		expediente.setExcodigo(tramiteComun.getIdExpediente());
		expediente = this.expedienService.find(expediente);
		tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, tramiteComun);

		model.addAttribute(this.modo, Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, "model", model);
	}

	/**
	 * Method 'editTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteSANLiquidacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANLiquidacion
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteSANLiquidacion editTramiteGenerico(@RequestBody() TramiteSANLiquidacion tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41) String modo, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramite.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteLiquidacion(tramite, tramiteComun, idioma, true, modo);
			}

			TramiteSANLiquidacionController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteSANLiquidacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANLiquidacion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteSANLiquidacion addTramiteGenerico(@RequestBody() TramiteSANLiquidacion tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41) String modo, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.sanTramExpService.addTramiteLiquidacion(tramite, tramiteComun, idioma, false, modo);

			}

			TramiteSANLiquidacionController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteSANAcuerdoIncoacion
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteSANLiquidacion getTramiteById(@PathVariable() String idTramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteSANLiquidacion tramite = new TramiteSANLiquidacion();
			tramite.setIdTramite(idTramite);
			tramite.setIdExpediente(tramiteComun.getIdExpediente());
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramite = this.sanTramExpService.findTramiteLiquidacion(tramite, censoMonitor);
			}

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}

			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteSANLiquidacionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return Properties
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'importeResolucion'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/datosReduccion/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody() Santramexp getDatosReduccion(@PathVariable() String idExpediente,
			HttpServletRequest request) {
		try {
			return this.sanTramExpService.getDatosSancion(idExpediente, Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsTramiteLiquidacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramiteLiquidacion(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoLiquidacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoLiquidacion(@PathVariable() String thcodocumento,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteLiquidacion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramiteLiquidacion(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				// si requiere firma, es el documento de la resolucion
				TipoDocumento tipoDocumento = new TipoDocumento();
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_SAN_RESOLUCION_EXP_SANC);
				adjuntardocsAux.setTipoDocumento(tipoDocumento);
			} else {
				// si no requiere firma, es el documento de la liquidacion
				TipoDocumento tipoDocumento = new TipoDocumento();
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_SAN_LIQUIDACION);
				adjuntardocsAux.setTipoDocumento(tipoDocumento);
			}

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteSANLiquidacionController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Fin
	 */

	/**
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getCreateFormPasarela'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/inicioPasarela", method = RequestMethod.GET)
	public ModelAndView getCreateFormPasarela(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			Model model, HttpServletRequest request) {
		try {

			model.addAttribute(Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite, tramiteComun);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			model.addAttribute("fechaLimitePasarela", Y41bLiquidacionUtils.fechaLimitePago(idioma));

			// Si el tramite relacionado es la orden del consejero, es sancion
			// firme
			Santramexp tramite = new Santramexp();
			tramite.setTrid(new String(tramiteComun.getIdTramite()));
			tramite = this.sanTramExpService.find(tramite);
			if (tramite != null && Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(tramite.getTrcodigorel())) {
				model.addAttribute("conceptoPago", Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOCOBRO);
			} else if (tramite != null
					&& Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO.equals(tramite.getTrcodigorel())) {
				model.addAttribute("conceptoPago", Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION);
			} else if (tramite != null
					&& Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONSOLICITUDREDUCCION.equals(tramite.getTrcodigorel())) {
				model.addAttribute("conceptoPago", Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOCOBRO);
			} else {
				model.addAttribute("conceptoPago", "0");
			}

			// Comprobar sancionado
			String nombreCompleto = "";
			Saninterv sancionado = new Saninterv();
			sancionado.setExpedien(new Expedien(tramiteComun.getIdExpediente()));
			sancionado.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			List<Saninterv> listaSancionado = this.sanintervService.findAll(sancionado, null);
			if (listaSancionado != null && listaSancionado.size() > 0) {
				sancionado = listaSancionado.get(0);
				Y41bNifValidator nifValidator = new Y41bNifValidator();
				Y41bNieValidator nieValidator = new Y41bNieValidator();
				if (nifValidator.isValid(sancionado.getUanif(), null)
						|| nieValidator.isValid(sancionado.getUanif(), null)) {
					if (Y41bUtils.esNullOCadenaVacia(sancionado.getUaapellido1())
							&& Y41bUtils.esNullOCadenaVacia(sancionado.getUaapellido2())) {
						nombreCompleto = sancionado.getUanombre();
					} else {
						nombreCompleto = sancionado.getUanombre().concat(" ").concat(sancionado.getUaapellido1())
								.concat(" ").concat(sancionado.getUaapellido2());
					}
				}
			}

			model.addAttribute("nombreCompleto", nombreCompleto);

			model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
			model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
			// Al guardar y generar la liquidacion se ha borrado la tabla
			// adjuntarDocs
			// como la modal no se ha cerrado hay que volver a volcar los
			// documentos
			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
			return new ModelAndView("tramiteSANLiquidacionPasarela", "model", model);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'generarDocLiquidacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param concepto
	 *            String
	 * @param fecha
	 *            String
	 * @param nombre
	 *            String
	 * @param apellido1
	 *            String
	 * @param apellido2
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return ModelAndView
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/generarDocLiquidacion/{concepto}/{fecha}", method = RequestMethod.GET)
	public ModelAndView generarDocLiquidacion(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			@PathVariable() String concepto, @PathVariable() String fecha, @RequestParam() String nombre,
			@RequestParam() String apellido1, @RequestParam() String apellido2, Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		String conceptoAux = concepto;
		TramiteSANLiquidacionController.logger.info(".LIQUIDACION.Inicio");
		try {
			// El usuario no quiere que le actualicemos el campo de la bd
			// Cuando se trata de un cif no se desglosa la razn social
			this.sipcaService.generarDocLiquidacion(tramiteComun, request, fecha, conceptoAux, response,
					PeticionPago.DEVENGO_PAGO, nombre, apellido1, apellido2); /* FIRME */

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			TramiteSANLiquidacionController.logger.error(".LIQUIDACION. Pasarela EnvioPago -> ERROR" + e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		} finally {
			TramiteSANLiquidacionController.logger.info(".LIQUIDACION.Fin");
		}
		return null;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param concepto
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/findAllConceptoPago/{concepto}", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> getAll(@PathVariable() String concepto) {
		TramiteSANLiquidacionController.logger.info("[GET - find_ALL] : Obtener Conceptopago por filtro");
		Conceptopago filterConceptopago = new Conceptopago();
		if (!"0".equals(concepto)) {
			filterConceptopago.setSdconceptoing(Integer.parseInt(concepto));
		}
		filterConceptopago.setTipoconceptopago(
				new Tipoconceptopago(Y41bConstantes.TIPO_CONCEPTO_PAGO_SANCIONES, null, null, null));
		return this.conceptopagoService.findAllVigentes(filterConceptopago, null);
	}

	/**
	 * Method 'importeResolucion'.
	 * 
	 * @param prontoPago
	 *            String
	 * @param reconocimiento
	 *            String
	 * @param importeInicial
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/calcularImporteReduccion/{prontoPago}/{reconocimiento}/{importeInicial}", method = RequestMethod.GET)
	public @ResponseBody() BigDecimal calcularImporteReduccion(@PathVariable() String prontoPago,
			@PathVariable() String reconocimiento, @PathVariable() String importeInicial, HttpServletRequest request) {
		try {
			BigDecimal importe = new BigDecimal(importeInicial.replace('\u002c', '\u002e'));
			Parametros parametros = new Parametros();
			BigDecimal reduccion1 = new BigDecimal(0);
			BigDecimal reduccion2 = new BigDecimal(0);
			if (Y41bConstantes.VALOR_SI.equals(prontoPago)) {
				parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_PRONTO_PAGO);
				parametros = this.parametrosService.find(parametros);
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					reduccion1 = importe.multiply(new BigDecimal(parametros.getValor()))
							.divide(new BigDecimal(Y41bConstantes.NUM_100));
				}
			}
			if (Y41bConstantes.VALOR_SI.equals(reconocimiento)) {
				parametros.setParametro(Y41bConstantes.PORCENTAJE_REDUCCION_RECONOCIMIENTO);
				parametros = this.parametrosService.find(parametros);
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					reduccion2 = importe.multiply(new BigDecimal(parametros.getValor()))
							.divide(new BigDecimal(Y41bConstantes.NUM_100));
				}
			}
			return importe.subtract(reduccion1).subtract(reduccion2).setScale(2, RoundingMode.DOWN);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormPasarela'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/existeLiquidacionActiva", method = RequestMethod.GET)
	public void existeLiquidacionActiva(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			Model model, HttpServletRequest request) {
		try {
			PagosBusqueda pagosBusqueda = new PagosBusqueda();
			pagosBusqueda.setSgidexpediente(tramiteComun.getIdExpediente());
			pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			List<Pagos> listaPagos = this.pagosService.findAllPagos(pagosBusqueda, null);
			Pagos pagos = null;
			if (listaPagos != null && listaPagos.size() > 0) {
				for (int i = 0; i < listaPagos.size(); i++) {
					pagos = listaPagos.get(i);
					if (pagos.getSgfechalimitepago().compareTo(Y41bUtils.hoy()) > 0) {
						if (!pagos.getEstadopago().getSacodigo().equals(Y41bConstantes.ESTADO_PAGO_PAGADO)
								&& !pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_PAGADO_DEFINITIVO)
								&& !pagos.getEstadopago().getSacodigo().equals(Y41bConstantes.ESTADO_PAGO_ANULADO)
								&& !pagos.getEstadopago().getSacodigo()
										.equals(Y41bConstantes.ESTADO_PAGO_ANULADO_VENCIMIENTO)) {
							throw new Y41bUDAException("pagos.avisoLiquidacionActiva", true, new Exception());
						}
					}
				}
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'existeLiquidacionPagadaMismoImporte'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/existeLiquidacionPagadaMismoImporte/{importe}", method = RequestMethod.GET)
	public void existeLiquidacionPagadaMismoImporte(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K41_idTramite) TramiteComun tramiteComun,
			Model model, @PathVariable() String importe, HttpServletRequest request) {
		try {
			PagosBusqueda pagosBusqueda = new PagosBusqueda();
			pagosBusqueda.setSgidexpediente(tramiteComun.getIdExpediente());
			pagosBusqueda.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			pagosBusqueda.setSgimporte(
					Y41bUtils.esNullOCadenaVacia(importe) ? null : new BigDecimal(importe.replace('\u002c', '\u002e')));
			List<Pagos> listaPagos = this.pagosService.findAllPagos(pagosBusqueda, null);
			Pagos pagos = null;
			if (listaPagos != null && listaPagos.size() > 0) {
				for (int i = 0; i < listaPagos.size(); i++) {
					pagos = listaPagos.get(i);
					if (pagos.getSgfechapago() != null) {
						throw new Y41bUDAException("pagos.liquidacionPagadaMismoImporte", true, new Exception());
					}
				}
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
