package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaDecisionBusqueda;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.TramiteRegistroDecision;
import com.ejie.y41b.service.AdjunInfraccHechoDenunService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.DecisionService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.PlantillaDecisionService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteRegistroDecision")
@SessionAttributes({ "tramiteRegistroDecision", "modoRegistroDecision" })
public class TramiteRegistroDecisionController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteRegistroDecisionController.class);

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private DecisionService decisionService;

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private PlantillaDecisionService plantillaDecisionService;

	@Autowired
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired
	private InspeccionService inspeccionService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			HttpServletRequest request, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarInfraccHechoDenunTableTemporal(tramiteComun);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			this.instramexpService.addTramiteAdjuntarActaInfraccTableTemporal(tramiteComun);

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));

			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTiatcodigo(idExpediente);
			tramiteInspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_REGISTRO_DECISION);

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (this.instramexpService.tratamientoSeguridad(tramiteInspeccion, censoMonitor)) {
				tramiteComun.setPermisoTramitar(Y41bConstantes.SI);
			} else {
				tramiteComun.setPermisoTramitar(Y41bConstantes.NO);
			}
		}

		model.addAttribute("tramiteRegistroDecision", tramiteComun);

		model.addAttribute("modoRegistroDecision", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteRegistroDecision", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteRegistroDecision", tramiteComun);

		model.addAttribute("modoRegistroDecision", Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
			this.soltramexpService.addTramiteAdjuntarInfraccHechoDenunTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
			this.instramexpService.addTramiteAdjuntarActaInfraccTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteRegistroDecision", "model", model);
	}

	/**
	 * Method 'addTramiteRegistroDecision'.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRegistroDecision
	 *            String
	 * @param model
	 *            Model
	 * @return TramiteRegistroDecision
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody TramiteRegistroDecision addTramiteRegistroDecision(
			@RequestBody TramiteRegistroDecision tramiteRegistroDecision,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRegistroDecision") String modoRegistroDecision, Model model,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRegistroDecision(tramiteRegistroDecision, tramiteComun, idioma, false,
						modoRegistroDecision, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteRegistroDecision(tramiteRegistroDecision, tramiteComun, idioma, false,
						modoRegistroDecision);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

			model.addAttribute("modoRegistroDecision", Y41bConstantes.MODO_POPUP_MODIFICACION);

			logger.info("Entity correctly inserted!");
			return tramiteRegistroDecision;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteRegistroDecision'.
	 * 
	 * @param tramiteRegistroDecision
	 *            TramiteRegistroDecision
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRegistroDecision
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRegistroDecision
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody TramiteRegistroDecision editTramiteRegistroDecision(
			@RequestBody TramiteRegistroDecision tramiteRegistroDecision,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRegistroDecision") String modoRegistroDecision, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteRegistroDecision.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteRegistroDecision.setFechaFin(todayWithZeroTime);
			// Monitor que ha ejecutado el tramite y su fecha fin (fin)

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRegistroDecision(tramiteRegistroDecision, tramiteComun, idioma, true,
						modoRegistroDecision, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteRegistroDecision(tramiteRegistroDecision, tramiteComun, idioma, true,
						modoRegistroDecision);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

			logger.info("Entity correctly inserted!");
			return tramiteRegistroDecision;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'comprobarPropuestaSancion'.
	 * 
	 * @param destinatario
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 * @return boolean
	 */
	@RequestMapping(value = "/comprobarPropuestaSancion/{destinatario}", method = RequestMethod.GET)
	public @ResponseBody boolean comprobarPropuestaSancion(@PathVariable String destinatario,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun) {
		TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

		boolean resultado = false;
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			resultado = this.soltramexpService.existePropuestaSancionOExpedienteSancionador(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			resultado = this.instramexpService.existePropuestaSancionOExpedienteSancionador(tramiteComun, destinatario);

		}
		return resultado;
	}

	/**
	 * Method 'getTramiteRegistroDecisionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRegistroDecision
	 */
	@RequestMapping(value = "/findTramiteRegistroDecision/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody TramiteRegistroDecision getTramiteRegistroDecisionById(@PathVariable String idTramite,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteRegistroDecision tramiteRegistroDecision = new TramiteRegistroDecision();
			tramiteRegistroDecision.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteRegistroDecision = this.soltramexpService.findTramiteRegistroDecision(tramiteRegistroDecision,
						censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteRegistroDecision = this.instramexpService.findTramiteRegistroDecision(tramiteRegistroDecision,
						censoMonitor);

			}

			if (tramiteRegistroDecision == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteRegistroDecision;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Infracciones
	 * 
	 */

	/**
	 * Method 'getAllInfraccionesTramiteRegistroDecision'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllInfraccionesTramiteRegistroDecision", method = RequestMethod.GET)
	public @ResponseBody Object getAllInfraccionesTramiteRegistroDecision(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(tramiteComun.getIdExpediente());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = null;

				listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService.findAll(adjunInfraccHechoDenunFilter,
						pagination);

				if (listAdjunInfraccHechoDenun == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjunInfraccHechoDenunService.findAllCount(adjunInfraccHechoDenunFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjunInfraccHechoDenun);
				return data;
			} else {
				List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = null;

				listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService.findAll(adjunInfraccHechoDenunFilter,
						pagination);

				if (listAdjunInfraccHechoDenun == null) {
					throw new Exception("No data Found.");
				}
				return listAdjunInfraccHechoDenun;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addInfraccionesTramiteRegistroDecision'.
	 * 
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return AdjunInfraccHechoDenun
	 */
	@RequestMapping(value = "/guardarInfraccionesTramiteRegistroDecision", method = RequestMethod.POST)
	public @ResponseBody AdjunInfraccHechoDenun addInfraccionesTramiteRegistroDecision(
			@RequestBody AdjunInfraccHechoDenun adjunInfraccHechoDenun,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjunInfraccHechoDenun.setHicohd(tramiteComun.getIdExpediente());

				String hiinexii = null;
				if (adjunInfraccHechoDenun.getHicotti() != null
						&& adjunInfraccHechoDenun.getHicotti().indexOf("N0") > -1) {
					// es un articulo
					hiinexii = "S";
				}
				adjunInfraccHechoDenun.setHiinexii(hiinexii);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				adjunInfraccHechoDenun.setHicohd(tramiteComun.getIdExpediente());

				String hiinexii = null;
				if (adjunInfraccHechoDenun.getHicotti() != null
						&& adjunInfraccHechoDenun.getHicotti().indexOf("N0") > -1) {
					// es un articulo
					hiinexii = "S";
				} else {
					hiinexii = "N";
				}
				adjunInfraccHechoDenun.setHiinexii(hiinexii);

			}

			// Se da de alta el interviniente
			this.adjunInfraccHechoDenunService.add(adjunInfraccHechoDenun);

			logger.info("Entity correctly inserted!");
			return adjunInfraccHechoDenun;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'removeInfracciones'.
	 * 
	 * @param hicodigo
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarInfraccionesTramiteRegistroDecision/{hicodigo}", method = RequestMethod.DELETE)
	public void removeInfracciones(@PathVariable String hicodigo,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunAux.setHicodigo(hicodigo);

			this.adjunInfraccHechoDenunService.remove(adjunInfraccHechoDenunAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Infracciones Fin
	 * 
	 */

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Ini
	 * 
	 */

	/**
	 * Method 'getAllDocsTramiteRegistroDecision'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocsTramiteRegistroDecision(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasTramiteRegistroDecision'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody Object getAllPlantillasTramiteRegistroDecision(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			PlantillaDecision plantillaDecision = new PlantillaDecision();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			String decodigo = request.getParameter("decodigo");
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				Decision decision = new Decision();
				decision.setDecodigo(decodigo);
				plantillaDecision.setDecision(decision);
				plantillaDecision.setPdcoor(Y41bConstantes.CODIGO_ORGANISMO_LAKUA);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				Decision decision = new Decision();
				decision.setDecodigo(decodigo);
				plantillaDecision.setDecision(decision);
				plantillaDecision.setPdcoor(Y41bConstantes.CODIGO_ORGANISMO_LAKUA);

			}

			List<PlantillaDecisionBusqueda> listPlantillaTramiteBusqueda = null;
			listPlantillaTramiteBusqueda = this.plantillaDecisionService
					.findAllPlantillaDecisionByDecision(plantillaDecision, null);

			if (listPlantillaTramiteBusqueda == null) {
				throw new Exception("No data Found.");
			}
			return listPlantillaTramiteBusqueda;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaRegistroDecision'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody void getByIdPlantillaRegistroDecision(@RequestBody Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.denunciaService.addPlantillaDecision(adjuntardocs, tramiteComun,
						Y41bConstantes.TIPO_DOC_RESOLUCION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.inspeccionService.addPlantillaDecision(adjuntardocs, tramiteComun,
						Y41bConstantes.TIPO_DOC_RESOLUCION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoRegistroDecision'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoRegistroDecision(@PathVariable String thcodocumento,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteRegistroDecision'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addDocsTramiteRegistroDecision(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");
			String thdestino = request.getParameter("thdestino");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_RESOLUCION);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);
			adjuntardocsAux.setThdestino(thdestino);

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String thcodocumento,
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteRegistroDecision/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/tramiteRegistroDecision/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'finddecisionalta'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/finddecisionalta", method = RequestMethod.GET)
	public @ResponseBody Object getDecisionAlta(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Decision filterDecision = null;
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				SolicitudDetalle solDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				String detiposolicitud = solDetalle.getHdcosc();
				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), detiposolicitud);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), null);

			} else {
				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), null);
			}
			Pagination pagination = null;
			List<Decision> decisions = null;

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				decisions = this.decisionService.findAllActivos(filterDecision, pagination);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(tramiteComun.getIdExpediente());
				tramiteInspeccionDetalle.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

				Long total = this.inspeccionService.findAllTramiteInspeccionCount(tramiteInspeccionDetalle);

				if (total > 0) {
					decisions = this.decisionService.findAllActivosNoTraslado(filterDecision, pagination);
				} else {
					decisions = this.decisionService.findAllActivosNoAIP(filterDecision, pagination);
				}

			} else {
				decisions = this.decisionService.findAllActivos(filterDecision, pagination);
			}

			if (decisions == null) {
				throw new Exception("No data Found.");
			}
			return decisions;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'finddecisionmodificacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/finddecisionmodificacion", method = RequestMethod.GET)
	public @ResponseBody Object getDecisionModificacion(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Decision filterDecision = null;
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				SolicitudDetalle solDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				String detiposolicitud = solDetalle.getHdcosc();
				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), detiposolicitud);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), null);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				filterDecision = new Decision(null, null, null, null, null,
						tramiteComun.getTipoProcedimiento().getPcodigo(), null);
			}
			Pagination pagination = null;
			List<Decision> decisions = this.decisionService.findAll(filterDecision, pagination);
			if (decisions == null) {
				throw new Exception("No data Found.");
			}
			return decisions;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// Recuperar Interesados Ini
	// FIXME: Se deja preparado estos metodos por si se necesitara modificar el
	// combo de destinatario para poner el interesado
	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody Object getAllIntervinientes(
			@ModelAttribute(value = "tramiteRegistroDecision") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			List<Intervinientes> listIntervinientes = null;
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, pagination);
					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					} else {
						listIntervinientes = this.getListDestinatarioDecision(listIntervinientes);
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listIntervinientes);
				return data;
			} else {
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				}
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				} else {
					listIntervinientes = this.getListDestinatarioDecision(listIntervinientes);
				}
				return listIntervinientes;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getListDestinatarioDecision'.
	 * 
	 * @param listAllIntervinientes
	 *            List<Intervinientes>
	 * 
	 * @return List<Intervinientes>
	 */
	private List<Intervinientes> getListDestinatarioDecision(List<Intervinientes> listAllIntervinientes) {
		List<Intervinientes> listDestinatarioDecision = new ArrayList<Intervinientes>();
		if (listAllIntervinientes != null && listAllIntervinientes.size() > 0) {
			for (Intervinientes interviniente : listAllIntervinientes) {
				if (interviniente.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)
						|| interviniente.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
					// Reclamante o Reclamado
					listDestinatarioDecision.add(interviniente);
				}
			}
		}
		return listDestinatarioDecision;
	}

	// Recuperar Interesados Fin

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
