package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteRecepcionTraslado;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteRecepcionTraslado")
@SessionAttributes({ "tramiteRecepcionTraslado", "modoRecepcionTraslado" })
public class TramiteRecepcionTrasladoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteRecepcionTrasladoController.class);

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private DenunciaService denunciaService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		}
		model.addAttribute("tramiteRecepcionTraslado", tramiteComun);

		model.addAttribute("modoRecepcionTraslado",
				Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteRecepcionTraslado", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, @PathVariable String idTramite,
			Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		}
		model.addAttribute("tramiteRecepcionTraslado", tramiteComun);

		model.addAttribute("modoRecepcionTraslado",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteRecepcionTraslado", "model", model);
	}

	/**
	 * Method 'editTramiteRecepcionTraslado'.
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionTraslado
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRecepcionTraslado
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody
	TramiteRecepcionTraslado editTramiteRecepcionTraslado(
			@RequestBody TramiteRecepcionTraslado tramiteRecepcionTraslado,
			@ModelAttribute(value = "tramiteRecepcionTraslado") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRecepcionTraslado") String modoRecepcionTraslado,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteRecepcionTraslado.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteRecepcionTraslado.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionTraslado(
						tramiteRecepcionTraslado, tramiteComun, idioma, true,
						modoRecepcionTraslado);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

			logger.info("Entity correctly inserted!");
			return tramiteRecepcionTraslado;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteRecepcionTraslado'.
	 * 
	 * @param tramiteRecepcionTraslado
	 *            TramiteRecepcionTraslado
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionTraslado
	 *            String
	 * @return TramiteRecepcionTraslado
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody
	TramiteRecepcionTraslado addTramiteRecepcionTraslado(
			@RequestBody TramiteRecepcionTraslado tramiteRecepcionTraslado,
			@ModelAttribute(value = "tramiteRecepcionTraslado") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRecepcionTraslado") String modoRecepcionTraslado) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionTraslado(
						tramiteRecepcionTraslado, tramiteComun, idioma, false,
						modoRecepcionTraslado);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

			logger.info("Entity correctly inserted!");
			return tramiteRecepcionTraslado;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteRecepcionTrasladoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRecepcionTraslado
	 */
	@RequestMapping(value = "/findTramiteRecepcionTraslado/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody
	TramiteRecepcionTraslado getTramiteRecepcionTrasladoById(
			@PathVariable String idTramite,
			@ModelAttribute(value = "tramiteRecepcionTraslado") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			TramiteRecepcionTraslado tramiteRecepcionTraslado = new TramiteRecepcionTraslado();
			tramiteRecepcionTraslado.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteRecepcionTraslado = this.soltramexpService
						.findTramiteRecepcionTraslado(tramiteRecepcionTraslado,
								censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

			if (tramiteRecepcionTraslado == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteRecepcionTraslado;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
