package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteRecepcionRequerimientoAcreditacionRepresentacion")
@SessionAttributes(value = { "tramiteRecepcionRequerimientoAcreditacionRepresentacion",
		"modoRecepcionRequerimientoAcreditacionRepresentacion" })
public class TramiteRecepcionRequerimientoAcreditacionRepresentacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteRecepcionRequerimientoAcreditacionRepresentacionController.class);

	private String tipoSAN = Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION;
	private String tipoARB = Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION;

	@Autowired()
	private SantramexpService sanTramExpService;

	@Autowired()
	private ArbtramexpService arbTramExpService;

	@Autowired()
	private Arbtramexp2Service arbTramExp2Service;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private InstramexpService instramexpService;

	// @Resource()
	// private ReloadableResourceBundleMessageSource appMessageSource;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			// Si el expediente es una sancion.
			tramiteComun.setIdTramite(this.sanTramExpService.getNewPK().toString());

			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			// Si el expediente es un arbitraje.
			tramiteComun.setIdTramite(this.arbTramExpService.getNewPK().toString());

			tramiteComun.setIdTipoTramite(this.tipoARB);

			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteRecepcionRequerimientoAcreditacionRepresentacion", tramiteComun);

		model.addAttribute("modoRecepcionRequerimientoAcreditacionRepresentacion", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteRecepcionRequerimientoAcreditacionRepresentacion", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			// Si el expediente es una sancion.
			tramiteComun.setIdTipoTramite(this.tipoSAN);
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());

			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			// Si el expediente es un arbitraje.
			tramiteComun.setIdTipoTramite(this.tipoARB);
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());

			this.arbTramExp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));

			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("tramiteRecepcionRequerimientoAcreditacionRepresentacion", tramiteComun);

		model.addAttribute("modoRecepcionRequerimientoAcreditacionRepresentacion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
		}

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteRecepcionRequerimientoAcreditacionRepresentacion", "model", model);
	}

	/**
	 * Method 'addTramiteRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionRequerimientoAcreditacionRepresentacion
	 *            String
	 * @param model
	 *            Model
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@RequestBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K113_K115_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K113_K115) String modoRecepcionRequerimientoAcreditacionRepresentacion,
			Model model) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, false,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, false,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbTramExp2Service.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, false,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, false,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			}

			model.addAttribute(modoRecepcionRequerimientoAcreditacionRepresentacion,
					Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteRecepcionRequerimientoAcreditacionRepresentacionController.logger.info("Entity correctly inserted!");
			return tramiteRecepcionRequerimientoAcreditacionRepresentacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionRequerimientoAcreditacionRepresentacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion editTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@RequestBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRecepcionRequerimientoAcreditacionRepresentacion") String modoRecepcionRequerimientoAcreditacionRepresentacion,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteRecepcionRequerimientoAcreditacionRepresentacion.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteRecepcionRequerimientoAcreditacionRepresentacion.setFechaFin(todayWithZeroTime);
			// Monitor que ha ejecutado el tramite y su fecha fin (fin)

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, true,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, true,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbTramExp2Service.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, true,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
						tramiteRecepcionRequerimientoAcreditacionRepresentacion, tramiteComun, idioma, true,
						modoRecepcionRequerimientoAcreditacionRepresentacion);
			}

			TramiteRecepcionRequerimientoAcreditacionRepresentacionController.logger.info("Entity correctly inserted!");
			return tramiteRecepcionRequerimientoAcreditacionRepresentacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteRecepcionRequerimientoAcreditacionRepresentacionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@RequestMapping(value = "/findTramiteRecepcionRequerimientoAcreditacionRepresentacion/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion getTramiteRecepcionRequerimientoAcreditacionRepresentacionById(
			@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion = new TramiteRecepcionRequerimientoAcreditacionRepresentacion();
			tramiteRecepcionRequerimientoAcreditacionRepresentacion.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteRecepcionRequerimientoAcreditacionRepresentacion = this.soltramexpService
						.findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
								tramiteRecepcionRequerimientoAcreditacionRepresentacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteRecepcionRequerimientoAcreditacionRepresentacion = this.sanTramExpService
						.findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
								tramiteRecepcionRequerimientoAcreditacionRepresentacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteRecepcionRequerimientoAcreditacionRepresentacion = this.arbTramExp2Service
						.findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
								tramiteRecepcionRequerimientoAcreditacionRepresentacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteRecepcionRequerimientoAcreditacionRepresentacion = this.instramexpService
						.findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
								tramiteRecepcionRequerimientoAcreditacionRepresentacion, censoMonitor);
			}

			if (tramiteRecepcionRequerimientoAcreditacionRepresentacion == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteRecepcionRequerimientoAcreditacionRepresentacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Ini
	 * 
	 */

	/**
	 * Method
	 * 'getAllDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method
	 * 'getAllPlantillasTramiteRecepcionRequerimientoAcreditacionRepresentacion'
	 * .
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				plantillaTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

				tramite.setTrcodigo(Y41bConstantes.TRAMITE_REQUERIMIENTO_ACREDITACION_REPRESENTACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ACREDITACION_REPRESENTACION);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void getByIdPlantillaRecepcionRequerimientoAcreditacionRepresentacion(
			@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.denunciaService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_REQUERIMIENTO);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method
	 * 'getByIdDocumentoRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoRecepcionRequerimientoAcreditacionRepresentacion(
			@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			// insertar los documentos en la tabla de documentos temporal
			TipoDocumento tipoDocumento = new TipoDocumento();
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_REQUERIMIENTO);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);

				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_REQUERIMIENTO);

			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION);
			}

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteRecepcionRequerimientoAcreditacionRepresentacionController.logger
					.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteRecepcionRequerimientoAcreditacionRepresentacion/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/tramiteRecepcionRequerimientoAcreditacionRepresentacion/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteRecepcionRequerimientoAcreditacionRepresentacionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method
	 * 'adjuntarDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion'.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			@RequestBody() TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteRecepcionRequerimientoAcreditacionRepresentacion,
			@ModelAttribute(value = "tramiteRecepcionRequerimientoAcreditacionRepresentacion") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteRecepcionRequerimientoAcreditacionRepresentacion
						.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteRecepcionRequerimientoAcreditacionRepresentacion
						.getDocumentosExpediente();
				this.sanTramExpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteRecepcionRequerimientoAcreditacionRepresentacion
						.getDocumentosExpediente();
				this.arbTramExp2Service.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteRecepcionRequerimientoAcreditacionRepresentacion
						.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			}

			TramiteRecepcionRequerimientoAcreditacionRepresentacionController.logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
