package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteRecepcionInspeccion;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteRecepcionInspeccion")
@SessionAttributes(value = { "tramiteRecepcionInspeccion",
		"modoRecepcionInspeccion" })
public class TramiteRecepcionInspeccionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteRecepcionInspeccionController.class);

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private DenunciaService denunciaService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		tramiteComun
				.setIdTipoTramite(Y41bConstantes.TRAMITE_RECEPCION_INSPECCION);

		model.addAttribute("tramiteRecepcionInspeccion", tramiteComun);

		model.addAttribute("modoRecepcionInspeccion",
				Y41bConstantes.MODO_POPUP_ALTA);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService
					.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

		}

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteRecepcionInspeccion", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

		}

		model.addAttribute("tramiteRecepcionInspeccion", tramiteComun);

		model.addAttribute("modoRecepcionInspeccion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService
					.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

		}

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteRecepcionInspeccion", "model", model);
	}

	/**
	 * Method 'editTramiteRecepcionInspeccion'.
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionInspeccion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody()
	TramiteRecepcionInspeccion editTramiteRecepcionInspeccion(
			@RequestBody() TramiteRecepcionInspeccion tramiteRecepcionInspeccion,
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRecepcionInspeccion") String modoRecepcionInspeccion,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteRecepcionInspeccion.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteRecepcionInspeccion.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionInspeccion(
						tramiteRecepcionInspeccion, tramiteComun, idioma, true,
						modoRecepcionInspeccion);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			}

			TramiteRecepcionInspeccionController.logger
					.info("Entity correctly inserted!");
			return tramiteRecepcionInspeccion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteRecepcionInspeccion'.
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoRecepcionInspeccion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	TramiteRecepcionInspeccion addTramiteRecepcionInspeccion(
			@RequestBody() TramiteRecepcionInspeccion tramiteRecepcionInspeccion,
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoRecepcionInspeccion") String modoRecepcionInspeccion,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteRecepcionInspeccion(
						tramiteRecepcionInspeccion, tramiteComun, idioma,
						false, modoRecepcionInspeccion);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			}

			TramiteRecepcionInspeccionController.logger
					.info("Entity correctly inserted!");
			return tramiteRecepcionInspeccion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteRecepcionInspeccionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRecepcionInspeccion
	 */
	@RequestMapping(value = "/findTramiteRecepcionInspeccion/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody()
	TramiteRecepcionInspeccion getTramiteRecepcionInspeccionById(
			@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			TramiteRecepcionInspeccion tramiteRecepcionInspeccion = new TramiteRecepcionInspeccion();
			tramiteRecepcionInspeccion.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteRecepcionInspeccion = this.soltramexpService
						.findTramiteRecepcionInspeccion(
								tramiteRecepcionInspeccion, censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			}

			if (tramiteRecepcionInspeccion == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteRecepcionInspeccion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TramiteRecepcionInspeccionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Ini
	 */

	/**
	 * Method 'getAllDocsTramiteRecepcionInspeccion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllDocsTramiteRecepcionInspeccion(
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento()
					.getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);
			Long total = new Long(0);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(
							adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService
							.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoRecepcionInspeccion'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody()
	void getByIdDocumentoRecepcionInspeccion(
			@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun
					.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService
					.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(adjuntardocsAux
									.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun
					.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'adjuntarDocsTramiteRecepcionInspeccion'.
	 * 
	 * @param tramiteRecepcionInspeccion
	 *            TramiteRecepcionInspeccion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteRecepcionInspeccion(
			@RequestBody() TramiteRecepcionInspeccion tramiteRecepcionInspeccion,
			@ModelAttribute(value = "tramiteRecepcionInspeccion") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteRecepcionInspeccion
						.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(
						listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			}

			TramiteRecepcionInspeccionController.logger
					.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Fin
	 */
}
