package com.ejie.y41b.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.net.io.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaNotificationDocument;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhdocService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp3Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;

/**
 * TramiteNotificacionController
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteNotificacion")
@SessionAttributes(value = { "tramiteNotificacion", "modoNotificacion" })
public class TramiteNotificacionController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteNotificacionController.class);

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private ActaService actaService;

	@Autowired()
	private SantramexpService santramexpService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired()
	private IntervinientesService intervinientesService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private SanexpService sanexpService;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private Arbtramexp3Service arbtramexp3Service;

	@Autowired()
	private ArbadhtramService arbadhtramService;

	@Autowired()
	private ArbadhsolService arbadhsolService;

	@Autowired()
	private ArbadhdocService arbadhdocService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(this.santramexpService.getNewPK().toString());
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			tramiteComun.setIdTramite(this.arbtramexpService.getNewPK().toString());
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			tramiteComun.setIdTramite(this.arbadhtramService.getNewPK().toString());
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteNotificacion", tramiteComun);
		model.addAttribute("modoNotificacion", Y41bConstantes.MODO_POPUP_ALTA);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES))) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			this.santramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteNotificacion", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteNotificacion", tramiteComun);
		model.addAttribute("modoNotificacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES))) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			this.santramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteNotificacion", "model", model);
	}

	/**
	 * Method 'addTramiteNotificacion'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteNotificacion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteNotificacion addTramiteNotificacion(
			@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, Model model,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, false,
						modoNotificacion, null, null, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.santramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, false,
						modoNotificacion, false, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp3Service.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, false,
						modoNotificacion, false, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, false,
						modoNotificacion, false, "", censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, false,
						modoNotificacion, null, null, censoMonitor);
			}

			model.addAttribute("modoNotificacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteNotificacionController.logger.info("Entity correctly inserted!");
			return tramiteNotificacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteNotificacion'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteNotificacion
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteNotificacion editTramiteNotificacion(
			@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, Model model,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteNotificacion.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteNotificacion.setFechaFin(todayWithZeroTime);
			String idioma = locale.getLanguage();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, null, null, censoMonitor);
			}

			model.addAttribute("modoNotificacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteNotificacionController.logger.info("Entity correctly inserted!");
			return tramiteNotificacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteNotificacionElectronica'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteNotificacion
	 */
	@RequestMapping(value = "/tramitarNotificacionElectronica", method = RequestMethod.PUT)
	public @ResponseBody() TramiteNotificacion editTramiteNotificacionElectronica(
			@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteNotificacion.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteNotificacion.setFechaFin(todayWithZeroTime);
			String idioma = locale.getLanguage();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA, null, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.santramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, true, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp3Service.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, true, "", censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, true, "", censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA, null, censoMonitor);
			}

			TramiteNotificacionController.logger.info("Entity correctly inserted!");
			return tramiteNotificacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteNotificacionElectronica'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 */
	@RequestMapping(value = "/crearEJGVDocumentNotificacion", method = RequestMethod.PUT)
	public @ResponseBody() RespuestaCrearEJGVDocumentNotificacion crearEJGVDocumentNotificacion(
			@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteNotificacion.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteNotificacion.setFechaFin(todayWithZeroTime);

			RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				respuestaEjgv = this.soltramexpService.createEJGVDocumentNotificacionComunicacion(
						tramiteNotificacion.getTextoComunicacion(), tramiteNotificacion.getDestinatario(),
						tramiteNotificacion.getTipoNotificacionPlatea(), tramiteNotificacion.getEnvRemesaNotificacion(),
						tramiteComun, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				expedien = this.expedienService.find(expedien);
				Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());

				Saninterv saninterv = new Saninterv();
				saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
				saninterv.setUaidinterv(new BigDecimal(tramiteNotificacion.getDestinatario()));
				saninterv = this.sanintervService.find(saninterv);
				// EVOLUTIVO 0135083 2.3
				// apertura, se pone primero la condicion de que si no est
				// abierto, tiene una notificacion de acuerdo de incoaacion y va
				// destinada al sancionado
				// lo demas se deja como estaba
				if (!Y41bConstantes.SI.equals(sanexp.getPlatea()) && saninterv != null
						&& ((Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
										.equals(saninterv.getUatipointerv()))
								&& Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
										.equals(tramiteNotificacion.getTipoNotificacionPlatea()))) {
					if (Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
						this.santramexpService.validarSiExisteSede(tramiteNotificacion.getDestinatario());
					}

					if (Y41bConstantes.TIPO_NOTIFICACION_SANCIONES_ACUERDO_INCOACCION
							.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
						this.santramexpService.validarSiExisteIncoacionTramitada(tramiteComun.getIdExpediente());
					}

					// 135083 2.3 28/10/2019 comentamos la apertura de platea en
					// este punto

					Sanexp sanexpPlatea = new Sanexp();
					sanexpPlatea.setExcodigo(expedien.getExcodigo());
					sanexpPlatea = this.sanexpService.find(sanexpPlatea);
					TramiteNotificacionController.logger
							.info("SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea");
					if (!Y41bConstantes.VALOR_SI.equals(sanexpPlatea.getPlatea())) {
						TramiteNotificacionController.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea Inicio");
						santramexpService.abrirSolicitudOficioPlatea(expedien);
						TramiteNotificacionController.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Apertura expediente Platea Fin");
						sanexpService.updateIndicadorPlatea(sanexpPlatea);
						TramiteNotificacionController.logger.info(
								"SantramexpServiceImpl - addTramiteAcuerdoIncoacion - Actualizacion indicador Platea");
					}

					// 135083 2.3 28/10/2019 comentamos la apertura de platea en
					// este punto
					respuestaEjgv = this.santramexpService.createEJGVDocumentNotificacion(tramiteNotificacion,
							tramiteComun, censoMonitor, tipoProcedimiento.getPcodigo());
					// EVOLUTIVO 0135083 2.3 hasta aqui es lo aniadido
				} else if (Y41bUtils.esNullOCadenaVacia(sanexp.getPlatea())
						|| Y41bConstantes.NO.equals(sanexp.getPlatea()) && saninterv != null
								&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
												.equals(saninterv.getUatipointerv()))) {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
				} else if (saninterv != null) {
					respuestaEjgv = this.santramexpService.createEJGVDocumentNotificacion(tramiteNotificacion,
							tramiteComun, censoMonitor, tipoProcedimiento.getPcodigo());
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				respuestaEjgv = this.arbtramexp3Service.createEJGVDocumentNotificacion(tramiteNotificacion,
						tramiteComun, censoMonitor, tipoProcedimiento.getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				respuestaEjgv = this.arbadhtramService.createEJGVDocumentNotificacion(tramiteNotificacion, tramiteComun,
						censoMonitor, tipoProcedimiento.getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				respuestaEjgv = this.instramexpService.createEJGVDocumentNotificacionComunicacion(
						tramiteNotificacion.getTextoComunicacion(), tramiteNotificacion.getDestinatario(),
						tramiteNotificacion.getTipoNotificacionPlatea(), tramiteNotificacion.getEnvRemesaNotificacion(),
						tramiteComun, censoMonitor);
			}

			TramiteNotificacionController.logger.info("Entity correctly inserted!");
			return respuestaEjgv;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteNotificacionElectronicaOrdinaria'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return String idZip
	 */
	@RequestMapping(value = "/tramitarNotificacionElectronicaOrdinaria", method = RequestMethod.PUT)
	public @ResponseBody() String editTramiteNotificacionElectronicaOrdinaria(
			@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteNotificacion.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteNotificacion.setFechaFin(todayWithZeroTime);

			String idioma = locale.getLanguage();

			// Creamos el ID del ZIP
			StringBuffer idZipFile = new StringBuffer();
			idZipFile.append(Calendar.getInstance().getTimeInMillis()).append("_")
					.append(tramiteComun.getIdExpediente());
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA, idZipFile.toString(),
						censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				this.santramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, false, idZipFile.toString(), censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				idZipFile.delete(0, idZipFile.length() - 1);
				idZipFile.append(Calendar.getInstance().getTimeInMillis()).append("_")
						.append(tramiteComun.getIdExpediente().replaceAll("/", "_"));
				this.arbtramexp3Service.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, false, idZipFile.toString(), censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, false, idZipFile.toString(), censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteNotificacion(tramiteNotificacion, tramiteComun, idioma, true,
						modoNotificacion, Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA, idZipFile.toString(),
						censoMonitor);
			}
			TramiteNotificacionController.logger.info("Entity correctly inserted!");
			return idZipFile.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoNotificacion'.
	 * 
	 * @param idzip
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findZipById/{idzip}", method = RequestMethod.GET)
	public @ResponseBody() void getZipById(@PathVariable() String idzip,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteNotificacionController.logger.info("Generado el zip. Continua con findZipById");
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteNotificacionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteNotificacion
	 */
	@RequestMapping(value = "/findTramiteNotificacion/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteNotificacion getTramiteNotificacionById(@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			TramiteNotificacion tramiteNotificacion = new TramiteNotificacion();
			tramiteNotificacion.setIdTramite(idTramite);
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteNotificacion = this.soltramexpService.findTramiteNotificacion(tramiteNotificacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteNotificacion = this.santramexpService.findTramiteNotificacion(tramiteNotificacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteNotificacion = this.arbtramexp3Service.findTramiteNotificacion(tramiteNotificacion,
						censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				tramiteNotificacion = this.arbadhtramService.findTramiteNotificacion(tramiteNotificacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteNotificacion = this.instramexpService.findTramiteNotificacion(tramiteNotificacion, censoMonitor);
			}

			if (tramiteNotificacion == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteNotificacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Ini
	 * 
	 */

	/**
	 * Method 'getAllDocsTramiteNotificacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramiteNotificacion(
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;
				Long total = new Long(0);
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasNotificacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasTramiteNotificacion(
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				plantillaTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

				tramite.setTrcodigo(Y41bConstantes.TRAMITE_NOTIFICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(tramiteComun.getIdTipoTramite());
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_NOTIFICACION);
				plantillaTramite.setTramite(tramite);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaNotificacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void addPlantillaNotificacion(@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.denunciaService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_SAN_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_ARB_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhsolService.addPlantilla(adjuntardocs, tramiteComun,
						Y41bConstantes.TIPO_DOC_ARB_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.inspeccionService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_NOTIFICACION);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoNotificacion'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoNotificacion(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteNotificacion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramiteNotificacion(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_NOTIFICACION);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_SAN_NOTIFICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_NOTIFICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				adjuntardocsAux.setThcodocumento(this.arbadhdocService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_NOTIFICACION);
			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteNotificacionController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteNotificacion'.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteNotificacion(@RequestBody() TramiteNotificacion tramiteNotificacion,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			this.adjuntardocsService.comprobarTipoDocumentoAcuse(tramiteNotificacion.getDocumentosExpediente());

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteNotificacion.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteNotificacion.getDocumentosExpediente();
				this.santramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteNotificacion.getDocumentosExpediente();
				this.arbtramexp2Service.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteNotificacion.getDocumentosExpediente();
				this.arbadhtramService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteNotificacion.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			}

			TramiteNotificacionController.logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */
	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */
	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoNotificacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody() Object getAllIntervinientes(
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoNotificacion") String modoNotificacion, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			List<Intervinientes> listIntervinientes = null;
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, pagination);
					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, pagination);
					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listIntervinientes);
				return data;
			} else {
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// EVOLUTIVO 0135083 2.2 se cambia el metodo find
					// findAllIntervinientes por el de
					// findAllIntervinientesConCIF
					listIntervinientes = this.sanintervService.findAllIntervinientesConCIF(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// intervinientes.setActivos(Y41bConstantes.VALOR_SI);
					// 0171878: Evolutivo Arbitraje Febrero 2021
					// sacamos solo los activos y ponemos aniadimos una A en los
					// nombres
					intervinientes.setActivos("S");

					listIntervinientes = this.arbintervService.findAllIntervinientes(intervinientes, null);

					for (Intervinientes intervinientesAux : listIntervinientes) {
						StringBuffer nombre = new StringBuffer();
						if (intervinientesAux.getNombre() != null && !intervinientesAux.getNombre().equals("")
								&& intervinientesAux.getTipoInterviniente().equals("B")) {
							nombre.append(intervinientesAux.getNombre());
							nombre.append(" (A)");
						} else {
							nombre.append(intervinientesAux.getNombre());
						}
						intervinientesAux.setNombre(nombre.toString());
					}
					// 0171878
					// listIntervinientes = this.arbintervService
					// .findAllIntervinientes(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					listIntervinientes = this.arbadhsolService.findAllIntervinientes(tramiteComun);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, null);
				}
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listIntervinientes;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getIntervinienteTramite'.
	 * 
	 * @param idInterviniente
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Object
	 */
	@RequestMapping(value = "/interviniente/{idInterviniente}", method = RequestMethod.GET)
	public @ResponseBody() Object getIntervinienteTramite(@PathVariable() String idInterviniente,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdinterviniente(idInterviniente);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				interviniente = this.denunciaService.findInterviniente(interviniente);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Saninterv saninterv = new Saninterv();
				saninterv = this.sanintervService
						.find(new Saninterv(new BigDecimal(interviniente.getIdinterviniente())));
				interviniente.setSanFormanotificacion(saninterv.getUaformanotificacion());
				if (Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO.equals(saninterv.getUatipointerv())) {
					Saninterv saninterv2 = this.sanintervService.dameSancionado(tramiteComun.getIdExpediente());
					if (saninterv2 != null) {
						interviniente.setSanFormanotificacion(saninterv2.getUaformanotificacion());
					}
				}
				interviniente.setDireccionCompleta(saninterv.getDireccionCompleta());
				interviniente.setTieneDireccionCompleta(saninterv.getTieneDireccionCompleta());
				interviniente.setTipoInterviniente(saninterv.getUatipointerv());
				interviniente.setNif(saninterv.getUanif());
				// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor
				// origen
				if (Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN.equals(saninterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO.equals(saninterv.getUatipointerv())) {
					Expedien expedien = new Expedien();
					expedien.setExcodigo(tramiteComun.getIdExpediente());
					expedien = this.expedienService.find(expedien);
					Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());
					interviniente.setExhdformanotiforigen(sanexp.getExhdformanotiforigen());
				}
				// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor
				// origen

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Arbinterv arbinterv = new Arbinterv();
				arbinterv = this.arbintervService
						.find(new Arbinterv(new BigDecimal(interviniente.getIdinterviniente())));
				interviniente.setDireccionCompleta(arbinterv.getDireccionCompleta());
				interviniente.setTieneDireccionCompleta(arbinterv.getTieneDireccionCompleta());
				interviniente.setTipoInterviniente(arbinterv.getUatipointerv());
				interviniente.setNif(arbinterv.getUanif());
				interviniente.setArbFormanotificacion(arbinterv.getUaformanotificacion());
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					Arbinterv arbinterv2 = this.arbintervService.dameInterviniente(tramiteComun.getIdExpediente(),
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
					if (arbinterv2 != null) {
						interviniente.setArbFormanotificacion(arbinterv2.getUaformanotificacion());
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
						.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					Arbinterv arbinterv2 = this.arbintervService.dameInterviniente(tramiteComun.getIdExpediente(),
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					if (arbinterv2 != null) {
						interviniente.setArbFormanotificacion(arbinterv2.getUaformanotificacion());
					}
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				interviniente = this.arbadhsolService.findInterviniente(tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				interviniente = this.denunciaService.findInterviniente(interviniente);

				if (interviniente.getIdinterviniente() != null) {
					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(interviniente.getIdExpediente());
					InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, null);
					String insFormanotificacion = null;

					if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoR() != null
							&& inspeccionDetalle.getEstablecimientoR().getIdinterviniente() != null
							&& inspeccionDetalle.getEstablecimientoR().getIdinterviniente()
									.equals(interviniente.getIdinterviniente())) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientore();
					} else if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoV() != null
							&& inspeccionDetalle.getEstablecimientoV().getIdinterviniente() != null
							&& inspeccionDetalle.getEstablecimientoV().getIdinterviniente()
									.equals(interviniente.getIdinterviniente())) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && (interviniente
							.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
							|| interviniente.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && (interviniente
							.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
							|| interviniente.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientore();
					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && interviniente
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO)) {
						insFormanotificacion = Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA;
					}

					interviniente.setInsFormanotificacion(insFormanotificacion);
				}
			}

			if (interviniente == null) {
				throw new Exception("No data Found. /interviniente/{idInterviniente}");
			} else {
				return interviniente;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /interviniente/{idInterviniente}");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteNotificacion/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/tramiteNotificacion/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteNotificacionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getByIdDocumentoJustificacionNotificacion'.
	 * 
	 * @param idnotificacionplatea
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findJustificanteNotificacion/{idnotificacionplatea}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoJustificacionNotificacion(@PathVariable() String idnotificacionplatea,
			@ModelAttribute(value = "tramiteNotificacion") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			TNotification tNotification = this.y41bPlateaAdapterService
					.getJustificanteNotificacion(idnotificacionplatea);

			PlantillaNotificationDocument plantillaNotificationDocument = new PlantillaNotificationDocument();
			plantillaNotificationDocument
					.setProcedimiento(tNotification.getProcedureName().getText().get(1).getValue());

			plantillaNotificationDocument
					.setProcedimientoEU(tNotification.getProcedureName().getText().get(0).getValue());

			plantillaNotificationDocument.setNumexpediente(tNotification.getFolderNumber());
			plantillaNotificationDocument.setAnoexpediente(tNotification.getYear());
			plantillaNotificationDocument
					.setActonotificacion(tNotification.getNotifiedActName().getText().get(1).getValue());
			plantillaNotificationDocument
					.setActonotificacionEU(tNotification.getNotifiedActName().getText().get(0).getValue());

			StringBuffer nomDestinatario = new StringBuffer();
			nomDestinatario.append(tNotification.getAddresseeID().getName());
			if (Y41bUtils.isFilled(tNotification.getAddresseeID().getFirstLastName())) {
				nomDestinatario.append(" ").append(tNotification.getAddresseeID().getFirstLastName());
			}
			if (Y41bUtils.isFilled(tNotification.getAddresseeID().getSecondLastName())) {
				nomDestinatario.append(" ").append(tNotification.getAddresseeID().getSecondLastName());
			}
			plantillaNotificationDocument.setNomdestinatario(nomDestinatario.toString());

			plantillaNotificationDocument.setDnidestinatario(tNotification.getAddresseeID().getID());

			plantillaNotificationDocument.setNumregistro(tNotification.getRegistryID().getRegistryNumber());

			// plantillaNotificationDocument.setFecharegistro(tNotification.getRegistryID().getRegistryDate());
			// plantillaNotificationDocument.setFecharegistroEU(tNotification.getRegistryID().getRegistryDate());

			Date fechaRegistro;
			fechaRegistro = Y41bUtils.convertFromSQLDateToJAVADate(Y41bUtils.formatearStringToDateFormato(
					tNotification.getRegistryID().getRegistryDate(), Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT));

			plantillaNotificationDocument.setFecharegistro(
					Y41bUtils.formatearDateToString(fechaRegistro, Y41bConstantes.FORMATO_FECHAHORA_ES));
			plantillaNotificationDocument.setFecharegistroEU(
					Y41bUtils.formatearDateToString(fechaRegistro, Y41bConstantes.FORMATO_FECHAHORA_EU));

			Date fechaPublicacion;
			fechaPublicacion = Y41bUtils.convertFromSQLDateToJAVADate(Y41bUtils.formatearStringToDateFormato(
					tNotification.getPublicationReceipt().getDate(), Y41bConstantes.FORMATO_FECHA_TOOLKIT));

			plantillaNotificationDocument.setFechapublicacion(
					Y41bUtils.formatearDateToString(fechaPublicacion, Y41bConstantes.FORMATO_FECHA_ES));
			plantillaNotificationDocument.setFechapublicacionEU(
					Y41bUtils.formatearDateToString(fechaPublicacion, Y41bConstantes.FORMATO_FECHA_EU));

			plantillaNotificationDocument.setDocumentos(this.generarTablaDocumentos(tramiteComun));

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_NOTIFICACION_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_NOTIFICACION_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaNotificationDocument, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_NOTIFICACION_RTF)
					+ "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Genera la tabla de documentos contenidos en la notificacin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 */
	private String generarTablaDocumentos(TramiteComun tramiteComun) {

		/*** Insertar TABLA ***/
		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");

		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh-500 ");

		// // Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\cellx8500");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
		adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

		List<Adjuntardocs> listAdjuntardocs = null;

		listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, null);

		if (listAdjuntardocs != null) {
			for (Adjuntardocs adjuntardocsAux : listAdjuntardocs) {
				stablaDoc.append("\\\\tab").append(" ").append(adjuntardocsAux.getThtedesfile()).append(" - ")
						.append(adjuntardocsAux.getThnofile());
				stablaDoc.append("\\\\cell");
				stablaDoc.append(" \\\\row ");
			}
		}

		stablaDoc.append(" \\\\pard ");
		// Cierre final
		stablaDoc.append("}");

		return stablaDoc.toString();
	}

}