package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.PlantillaLevantamientoActaDocument;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteINSLevantamientoActa;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteINSLevantamientoActa")
@SessionAttributes(value = { "tramiteINSLevantamientoActa", "modoINSLevantamientoActa" })
public class TramiteINSLevantamientoActaController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteINSLevantamientoActaController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private InstramexpService instramexpService;
	@Autowired()
	private AdjuntardocsService adjuntardocsService;
	@Autowired()
	private ActaService actaService;
	@Autowired
	private MessageSource messageSource;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteINSLevantamientoActa", tramiteComun);
		model.addAttribute("modoINSLevantamientoActa", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("y41bInspeccionLevantamientoActa", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(idExpediente);
		}

		tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
		tramiteComun.setOrigenInspeccion(this.instramexpService.findOrigenInspeccionPorIdTramite(idTramite));

		model.addAttribute("tramiteINSLevantamientoActa", tramiteComun);
		model.addAttribute("modoINSLevantamientoActa", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("y41bInspeccionLevantamientoActa", "model", model);
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteGenerico
	 */
	@RequestMapping(value = "/findTramiteLevantamientoActa/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteINSLevantamientoActa getTramiteLevantamientoActaById(@PathVariable() String idTramite,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteINSLevantamientoActa tramiteLevantamientoActa = new TramiteINSLevantamientoActa();
			tramiteLevantamientoActa.setIdTramite(idTramite);

			tramiteLevantamientoActa = this.instramexpService.findTramiteLevantamientoActa(tramiteLevantamientoActa,
					censoMonitor);

			if (tramiteLevantamientoActa == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteLevantamientoActa;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteINSLevantamientoActaController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getByIdDocumentoJustificanteLevantamientoActa'.
	 * 
	 * @param idnotificacionplatea
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findJustificanteLevantamientoActa", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoJustificanteLevantamientoActa(
			@ModelAttribute(value = "tramiteINSLevantamientoActa") TramiteComun tramiteComun,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			// PLANTILLA

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(tramiteComun.getIdExpediente());

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

			TramiteINSLevantamientoActa tramiteLevantamientoActa = new TramiteINSLevantamientoActa();
			tramiteLevantamientoActa.setIdTramite(tramiteComun.getIdTramite());

			tramiteLevantamientoActa = this.instramexpService.findTramiteLevantamientoActa(tramiteLevantamientoActa,
					censoMonitor);

			if (tramiteLevantamientoActa == null) {
				throw new Exception(tramiteComun.getIdTramite().toString());
			}

			PlantillaLevantamientoActaDocument plantillaLevantamientoActaDocument = new PlantillaLevantamientoActaDocument();
			plantillaLevantamientoActaDocument.setProcedimiento(
					messageSource.getMessage("levantamiento.procedimiento", null, LocaleContextHolder.getLocale()));
			plantillaLevantamientoActaDocument.setNumexpediente(tramiteComun.getNumExpediente());

			String[] parts = tramiteComun.getNumExpediente().split("-");
			plantillaLevantamientoActaDocument.setAnoexpediente(parts[3]);

			plantillaLevantamientoActaDocument.setEnvioacta(tramiteLevantamientoActa.getAncodigo());

			DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			String dateToStr = dateFormat.format(tramiteLevantamientoActa.getFechaInicio());

			plantillaLevantamientoActaDocument.setFechaenvio(dateToStr);

			plantillaLevantamientoActaDocument.setNomdestinatario(inspeccionDetalle.getEstablecimientoV().getNombre());

			plantillaLevantamientoActaDocument.setDnidestinatario(inspeccionDetalle.getEstablecimientoV().getNif());

			// DOCS
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdExpediente(tramiteComun.getIdExpediente());
			tramiteComunAux.setIdTramite(tramiteLevantamientoActa.getAccodigo());
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			tramiteComunAux.setTipoProcedimiento(tipoProcedimiento);

			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComunAux);

			plantillaLevantamientoActaDocument
					.setDocumentos(this.generarTablaDocumentosLevantamiento(tramiteLevantamientoActa));

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_LEVANTAMIENTO_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_LEVANTAMIENTO_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaLevantamientoActaDocument, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(Y41bConstantes.NOMBRE_PLANTILLA_PUBLICACION_LEVANTAMIENTO_RTF)
					+ "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Genera la tabla de documentos contenidos en la notificacin
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 */
	private String generarTablaDocumentosLevantamiento(TramiteINSLevantamientoActa tramiteLevantamientoActa) {

		/*** Insertar TABLA ***/
		StringBuffer stablaDoc = new StringBuffer(120);
		stablaDoc.append("{ ");
		// stablaDoc.append(" \\\\pard\\\\par");

		// Tabla: línea inicial
		stablaDoc.append(" \\\\trowd ");
		stablaDoc.append(" \\\\trgaph0 ");
		stablaDoc.append(" \\\\trrh-500 ");

		// // Bordes de la primera celda
		stablaDoc.append("\\\\clvertalc");
		stablaDoc.append("\\\\cellx8500");

		// Fin de la definición de fila
		stablaDoc.append(" \\\\pard ");

		Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
		adjuntardocsFilter.setThidTramite(tramiteLevantamientoActa.getAccodigo());

		List<Adjuntardocs> listAdjuntardocs = null;

		listAdjuntardocs = this.adjuntardocsService.findAllTipoDocInspecciones(adjuntardocsFilter, null);

		if (listAdjuntardocs != null) {
			for (Adjuntardocs adjuntardocsAux : listAdjuntardocs) {
				stablaDoc.append("\\\\tab").append(" ").append(adjuntardocsAux.getThtedesfile()).append(" - ")
						.append(adjuntardocsAux.getThnofile());
				stablaDoc.append("\\\\cell");
				stablaDoc.append(" \\\\row ");
			}
		}

		stablaDoc.append(" \\\\pard ");
		// Cierre final
		stablaDoc.append("}");

		return stablaDoc.toString();
	}
}
