package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteINSGenericoFirma;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InspeccionesTipoDocumentoService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteINSGenericoFirmaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteINSGenericoFirma")
@SessionAttributes(value = { "tramiteINSGenericoFirma", "modoINSGenericoFirma" })
public class TramiteINSGenericoFirmaController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteINSGenericoFirmaController.class);

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private InspeccionesTipoDocumentoService inspeccionesTipoDocumentoService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			String numExpediente = this.instramexpService
					.findNumExpedienteActuacion(idExpediente);
			tramiteComun.setNumExpediente(numExpediente);
			Locale locale = LocaleContextHolder.getLocale();
			String origen = this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale);
			tramiteComun.setOrigenInspeccion(origen);

		}
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteINSGenericoFirma", tramiteComun);

		model.addAttribute("modoINSGenericoFirma",
				Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("y41bInspeccionGenericoFirma", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			String numExpediente = this.instramexpService
					.findNumExpedienteActuacion(idExpediente);
			tramiteComun.setNumExpediente(numExpediente);
			Locale locale = LocaleContextHolder.getLocale();
			String origen = this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale);
			tramiteComun.setOrigenInspeccion(origen);

		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteINSGenericoFirma", tramiteComun);

		model.addAttribute("modoINSGenericoFirma",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService
					.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService
					.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("y41bInspeccionGenericoFirma", "model", model);
	}

	/**
	 * Method 'addTramiteINSGenericoFirma'.
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoINSGenericoFirma
	 *            String
	 * @param model
	 *            Model
	 * @return TramiteINSGenericoFirma
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	TramiteINSGenericoFirma addTramiteINSGenericoFirma(
			@RequestBody() TramiteINSGenericoFirma tramiteINSGenericoFirma,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSGenericoFirma") String modoINSGenericoFirma,
			Model model) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteGenericoFirma(
						tramiteINSGenericoFirma, tramiteComun, idioma, false,
						modoINSGenericoFirma);
			}

			model.addAttribute("modoINSGenericoFirma",
					Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteINSGenericoFirmaController.logger
					.info("Entity correctly inserted!");
			return tramiteINSGenericoFirma;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteINSGenericoFirma'.
	 * 
	 * @param tramiteINSGenericoFirma
	 *            TramiteINSGenericoFirma
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoINSGenericoFirma
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteINSGenericoFirma
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody()
	TramiteINSGenericoFirma editTramiteINSGenericoFirma(
			@RequestBody() TramiteINSGenericoFirma tramiteINSGenericoFirma,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSGenericoFirma") String modoINSGenericoFirma,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteINSGenericoFirma.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteINSGenericoFirma.setFechaFin(todayWithZeroTime);
			// Monitor que ha ejecutado el tramite y su fecha fin (fin)

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteGenericoFirma(
						tramiteINSGenericoFirma, tramiteComun, idioma, true,
						modoINSGenericoFirma);
			}
			TramiteINSGenericoFirmaController.logger
					.info("Entity correctly inserted!");
			return tramiteINSGenericoFirma;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoFirmaById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteINSGenericoFirma
	 */
	@RequestMapping(value = "/findTramiteGenericoFirma/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody()
	TramiteINSGenericoFirma getTramiteGenericoFirmaById(
			@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			TramiteINSGenericoFirma tramiteINSGenericoFirma = new TramiteINSGenericoFirma();
			tramiteINSGenericoFirma.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteINSGenericoFirma = this.instramexpService
						.findTramiteGenericoFirma(tramiteINSGenericoFirma,
								censoMonitor);
			}

			if (tramiteINSGenericoFirma == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteINSGenericoFirma;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Ini
	 * 
	 */

	/**
	 * Method 'getAllDocsTramiteGenericoFirma'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllDocsTramiteGenericoFirma(
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento()
					.getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService
						.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasTramiteGenericoFirma'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllPlantillasTramiteGenericoFirma(
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_GENERICO_FIRMA);
				plantillaTramite.setTramite(tramite);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramite(plantillaTramite, pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService
						.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramite(plantillaTramite, pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaTramiteGenericoFirma'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody()
	void addPlantillaTramiteGenericoFirma(
			@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
					adjuntardocs.setThfechasolfirma(Calendar.getInstance()
							.getTime());
					adjuntardocs
							.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}
				this.inspeccionService.addPlantilla(adjuntardocs, tramiteComun,
						adjuntardocs.getTipoDocumento().getIdTipodoc());

			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoTramiteGenericoFirma'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody()
	void getByIdDocumentoTramiteGenericoFirma(
			@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun
					.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService
					.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(adjuntardocsAux
									.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteGenericoFirma'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody()
	List<Map<String, Object>> addDocsTramiteGenericoFirma(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String idTipodoc = request.getParameter("idTipodoc");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService
						.getNewPKDocumentoHecho().toString());

				adjuntardocsAux
						.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance()
						.getTime());
				adjuntardocsAux
						.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(idTipodoc);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun
					.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteINSGenericoFirmaController.logger
					.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun
					.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteINSGenericoFirma/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"/y41bVistaWar/tramiteINSGenericoFirma/guardar/"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getAllTipoDocumentos'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List
	 */
	@RequestMapping(value = "/findAllTipoDocumento", method = RequestMethod.GET)
	public @ResponseBody
	List<TipoDocumento> getAllTipoDocumento(
			@ModelAttribute(value = "tramiteINSGenericoFirma") TramiteComun tramiteComun) {
		TipoProcedimiento tipoProcedimiento = tramiteComun
				.getTipoProcedimiento();
		if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return this.inspeccionesTipoDocumentoService.findAllTipoDocumento(
					new InspeccionesTipoDocumento(), null);
		}
		return null;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TramiteINSGenericoFirmaController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
