package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteINSEstablecimientoRelacionConCampana;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteINSEstablecimientoRelacionConCampanaController  
 * 05-mar-2012 9:11:48.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteINSEstablecimientoRelacionConCampana")
@SessionAttributes(value = { "tramiteINSEstablecimientoRelacionConCampana",
		"modoINSEstablecimientoRelacionConCampana" })
public class TramiteINSEstablecimientoRelacionConCampanaController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteINSEstablecimientoRelacionConCampanaController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private InstramexpService instramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteINSEstablecimientoRelacionConCampana", tramiteComun);
		model.addAttribute("modoINSEstablecimientoRelacionConCampana", Y41bConstantes.MODO_POPUP_ALTA);
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("y41bInspeccionEstablecimientoRelacionConCampana", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model, HttpServletRequest request) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteINSEstablecimientoRelacionConCampana", tramiteComun);
		model.addAttribute("modoINSEstablecimientoRelacionConCampana", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("y41bInspeccionEstablecimientoRelacionConCampana", "model", model);
	}

	/**
	 * Method 'getTramiteEstablecimientoRelacionConCampanaById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteINSEstablecimientoRelacionConCampana
	 */
	@RequestMapping(value = "/findTramiteEstablecimientoRelacionConCampana/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteINSEstablecimientoRelacionConCampana getTramiteEstablecimientoRelacionConCampanaById(
			@PathVariable() String idTramite, HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana = new TramiteINSEstablecimientoRelacionConCampana();
			tramiteINSEstablecimientoRelacionConCampana.setIdTramite(idTramite);

			tramiteINSEstablecimientoRelacionConCampana = this.instramexpService
					.findTramiteEstablecimientoRelacionConCampana(tramiteINSEstablecimientoRelacionConCampana,
							censoMonitor);

			if (tramiteINSEstablecimientoRelacionConCampana == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteINSEstablecimientoRelacionConCampana;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'tramitarCampana'.
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionConCampana
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoINSEstablecimientoRelacionConCampana
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return TramiteCierre
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody TramiteINSEstablecimientoRelacionConCampana tramitarCampana(
			@RequestBody TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			@ModelAttribute(value = "tramiteINSEstablecimientoRelacionConCampana") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSEstablecimientoRelacionConCampana") String modoINSEstablecimientoRelacionConCampana,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			tramiteINSEstablecimientoRelacionConCampana.setIdTramite(tramiteComun.getIdTramite());
			tramiteINSEstablecimientoRelacionConCampana.setIdExpediente(tramiteComun.getIdExpediente());

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteINSEstablecimientoRelacionConCampana.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteINSEstablecimientoRelacionConCampana.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteEstablecimientoRelacionConCampana(
						tramiteINSEstablecimientoRelacionConCampana, tramiteComun, idioma, true,
						modoINSEstablecimientoRelacionConCampana);
			}

			logger.info("Entity correctly inserted!" + tramiteINSEstablecimientoRelacionConCampana);
			return tramiteINSEstablecimientoRelacionConCampana;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addCampana'.
	 * 
	 * @param tramiteINSEstablecimientoRelacionConCampana
	 *            TramiteINSEstablecimientoRelacionConCampana
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoINSEstablecimientoRelacionConCampana
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return TramiteCierre
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody TramiteINSEstablecimientoRelacionConCampana addCampana(
			@RequestBody TramiteINSEstablecimientoRelacionConCampana tramiteINSEstablecimientoRelacionConCampana,
			@ModelAttribute(value = "tramiteINSEstablecimientoRelacionConCampana") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSEstablecimientoRelacionConCampana") String modoINSEstablecimientoRelacionConCampana,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			tramiteINSEstablecimientoRelacionConCampana.setIdTramite(tramiteComun.getIdTramite());
			tramiteINSEstablecimientoRelacionConCampana.setIdExpediente(tramiteComun.getIdExpediente());
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteEstablecimientoRelacionConCampana(
						tramiteINSEstablecimientoRelacionConCampana, tramiteComun, idioma, false,
						modoINSEstablecimientoRelacionConCampana);
			}

			logger.info("Entity correctly inserted!" + tramiteINSEstablecimientoRelacionConCampana);
			return tramiteINSEstablecimientoRelacionConCampana;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteINSEstablecimientoRelacionConCampanaController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
