package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteINSAceptacionInformeValoracion;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteINSAceptacionInformeValoracion")
@SessionAttributes(value = { "tramiteINSAceptacionInformeValoracion",
		"modoINSAceptacionInformeValoracion" })
public class TramiteINSAceptacionInformeValoracionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteINSAceptacionInformeValoracionController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private InstramexpService instramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteINSAceptacionInformeValoracion",
				tramiteComun);
		model.addAttribute("modoINSAceptacionInformeValoracion",
				Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("y41bInspeccionAceptacionInformeValoracion",
				"model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(idExpediente);
		}

		tramiteComun.setNumExpediente(this.instramexpService
				.findNumExpedienteActuacion(idExpediente));
		tramiteComun.setOrigenInspeccion(this.instramexpService
				.findOrigenInspeccionPorIdTramite(idTramite));

		model.addAttribute("tramiteINSAceptacionInformeValoracion",
				tramiteComun);
		model.addAttribute("modoINSAceptacionInformeValoracion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("y41bInspeccionAceptacionInformeValoracion",
				"model", model);
	}

	/**
	 * Method 'getTramiteAceptacionInformeValoracionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteGenerico
	 */
	@RequestMapping(value = "/findTramiteAceptacionInformeValoracion/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody()
	TramiteINSAceptacionInformeValoracion getTramiteAceptacionInformeValoracionById(
			@PathVariable() String idTramite, HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion = new TramiteINSAceptacionInformeValoracion();
			tramiteAceptacionInformeValoracion.setIdTramite(idTramite);

			censoMonitor.getConsultas();
			tramiteAceptacionInformeValoracion = this.instramexpService
					.findTramiteAceptacionInformeValoracion(
							tramiteAceptacionInformeValoracion, censoMonitor);

			if (tramiteAceptacionInformeValoracion == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteAceptacionInformeValoracion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteAceptacionInformeValoracion'.
	 * 
	 * @param tramiteAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAceptacionInformeValoracion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteINSAceptacionInformeValoracion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	TramiteINSAceptacionInformeValoracion addTramiteAceptacionInformeValoracion(
			@RequestBody() TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion,
			@ModelAttribute(value = "tramiteINSAceptacionInformeValoracion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSAceptacionInformeValoracion") String modoAceptacionInformeValoracion,
			Model model, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteAceptacionInformeValoracion(
						tramiteAceptacionInformeValoracion, tramiteComun,
						idioma, false, modoAceptacionInformeValoracion);
			}

			model.addAttribute("modoAceptacionInformeValoracion",
					Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteINSAceptacionInformeValoracionController.logger
					.info("Entity correctly inserted!");
			return tramiteAceptacionInformeValoracion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteAceptacionInformeValoracion'.
	 * 
	 * @param tramiteAceptacionInformeValoracion
	 *            TramiteINSAceptacionInformeValoracion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAceptacionInformeValoracion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteINSAceptacionInformeValoracion
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody()
	TramiteINSAceptacionInformeValoracion editTramiteAceptacionInformeValoracion(
			@RequestBody() TramiteINSAceptacionInformeValoracion tramiteAceptacionInformeValoracion,
			@ModelAttribute(value = "tramiteINSAceptacionInformeValoracion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoINSAceptacionInformeValoracion") String modoAceptacionInformeValoracion,
			Model model, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteAceptacionInformeValoracion
					.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			tramiteAceptacionInformeValoracion.setFechaFin(new Date());

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteAceptacionInformeValoracion(
						tramiteAceptacionInformeValoracion, tramiteComun,
						idioma, true, modoAceptacionInformeValoracion);
			}

			TramiteINSAceptacionInformeValoracionController.logger
					.info("Entity correctly inserted!");
			return tramiteAceptacionInformeValoracion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TramiteINSAceptacionInformeValoracionController.logger.warn(e
				.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
