package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.TramiteHechoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.TramiteHecho;

/**
 * TramiteHechoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/tramitehecho")

public class TramiteHechoController  {

	private static final Logger logger = LoggerFactory.getLogger(TramiteHechoController.class);

	@Autowired
	private TramiteHechoService tramiteHechoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TramiteHechoController.logger.info("[GET - View] : tramitehecho");
		return "tramitehecho";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param ehcodigo String
	 * @return tramiteHecho TramiteHecho
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody TramiteHecho getById(@PathVariable String ehcodigo) {
        TramiteHecho tramiteHecho = new TramiteHecho();
		tramiteHecho.setEhcodigo(ehcodigo);
        tramiteHecho = this.tramiteHechoService.find(tramiteHecho);
        TramiteHechoController.logger.info("[GET - findBy_PK] : Obtener TramiteHecho por PK");
        return tramiteHecho;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTramiteHecho TramiteHecho
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TramiteHecho> getAll(@ModelAttribute TramiteHecho filterTramiteHecho) {
		TramiteHechoController.logger.info("[GET - find_ALL] : Obtener TramiteHecho por filtro");
	    return this.tramiteHechoService.findAll(filterTramiteHecho, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tramiteHecho TramiteHecho 
	 * @return TramiteHecho
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TramiteHecho edit(@RequestBody TramiteHecho tramiteHecho) {		
        TramiteHecho tramiteHechoAux = this.tramiteHechoService.update(tramiteHecho);
		TramiteHechoController.logger.info("[PUT] : TramiteHecho actualizado correctamente");
        return tramiteHechoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tramiteHecho TramiteHecho 
	 * @return TramiteHecho
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TramiteHecho add(@RequestBody TramiteHecho tramiteHecho) {		
        TramiteHecho tramiteHechoAux = this.tramiteHechoService.add(tramiteHecho);
        TramiteHechoController.logger.info("[POST] : TramiteHecho insertado correctamente");
    	return tramiteHechoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param ehcodigo String
	 * @return tramiteHecho
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody TramiteHecho remove(@PathVariable String ehcodigo) {
        TramiteHecho tramiteHecho = new TramiteHecho();
        tramiteHecho.setEhcodigo(ehcodigo);
        this.tramiteHechoService.remove(tramiteHecho);
       	TramiteHechoController.logger.info("[DELETE] : TramiteHecho borrado correctamente");
       	return tramiteHecho;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tramiteHechoIds List
	 * @return tramiteHechoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tramiteHechoIds) {
        List<TramiteHecho> tramiteHechoList = new ArrayList<TramiteHecho>();
        for (List<String> tramiteHechoId:tramiteHechoIds) {
		    Iterator<String> iterator = tramiteHechoId.iterator();
		    TramiteHecho tramiteHecho = new TramiteHecho(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tramiteHecho.setEhcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    tramiteHechoList.add(tramiteHecho);
	    }
        this.tramiteHechoService.removeMultiple(tramiteHechoList);
		TramiteHechoController.logger.info("[POST - DELETE_ALL] : TramiteHecho borrados correctamente");
		return tramiteHechoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTramiteHecho TramiteHecho
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute TramiteHecho filterTramiteHecho, @ModelAttribute Pagination pagination) {
        List<TramiteHecho> tramiteHechos = this.tramiteHechoService.findAll(filterTramiteHecho, pagination);
        Long recordNum = this.tramiteHechoService.findAllCount(filterTramiteHecho);
        TramiteHechoController.logger.info("[GET - jqGrid] : Obtener TramiteHecho");
		return new JQGridJSONModel(pagination, recordNum, tramiteHechos);
	}
	
}	
