package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteGenerico")
@SessionAttributes({ "tramiteGenerico", "modoGenerico" })
public class TramiteGenericoController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteGenericoController.class);

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private SantramexpService sanTramExpService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ExpedienService expedienService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private ArbtramexpService arbtramexpService;
	@Autowired
	private SolarbService solarbService;
	@Autowired
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired
	private ArbadhtramService arbadhtramService;
	@Autowired
	private ArbadhsolService arbadhsolService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(sanTramExpService.getNewPK().toString());
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			tramiteComun.setIdTramite(arbadhtramService.getNewPK().toString());
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_GENERICO);

		model.addAttribute("tramiteGenerico", tramiteComun);

		model.addAttribute("modoGenerico", Y41bConstantes.MODO_POPUP_ALTA);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteGenerico", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());

		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteGenerico", tramiteComun);

		model.addAttribute("modoGenerico", Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteGenerico", "model", model);
	}

	/**
	 * Method 'editTramiteGenerico'.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoGenerico
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody TramiteGenerico editTramiteGenerico(@RequestBody TramiteGenerico tramiteGenerico,
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoGenerico") String modoGenerico, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteGenerico.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteGenerico.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true, modoGenerico);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				if (modoGenerico != null && modoGenerico.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
					// Se da de alta el tramite generico

					this.sanTramExpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true,
							modoGenerico);

				} else if (modoGenerico != null && modoGenerico.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
					// Se modifican los datos del tramite generico
					this.sanTramExpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true,
							modoGenerico);
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true, modoGenerico);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true, modoGenerico);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, true, modoGenerico);

			}

			logger.info("Entity correctly inserted!");
			return tramiteGenerico;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoGenerico
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody TramiteGenerico addTramiteGenerico(@RequestBody TramiteGenerico tramiteGenerico,
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoGenerico") String modoGenerico, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false, modoGenerico);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				if (modoGenerico != null && modoGenerico.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
					// Se da de alta el tramite generico

					this.sanTramExpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false,
							modoGenerico);

				} else if (modoGenerico != null && modoGenerico.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
					// Se modifican los datos del tramite generico
					this.sanTramExpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false,
							modoGenerico);
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false, modoGenerico);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false, modoGenerico);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteGenerico(tramiteGenerico, tramiteComun, idioma, false, modoGenerico);

			}

			logger.info("Entity correctly inserted!");
			return tramiteGenerico;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteGenerico
	 */
	@RequestMapping(value = "/findTramiteGenerico/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody TramiteGenerico getTramiteGenericoById(@PathVariable String idTramite,
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteGenerico = this.soltramexpService.findTramiteGenerico(tramiteGenerico, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteGenerico = this.sanTramExpService.findTramiteGenerico(tramiteGenerico, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteGenerico = this.arbtramexp4Service.findTramiteGenerico(tramiteGenerico, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				tramiteGenerico = this.arbadhtramService.findTramiteGenerico(tramiteGenerico, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteGenerico = this.instramexpService.findTramiteGenerico(tramiteGenerico, censoMonitor);
			}

			if (tramiteGenerico == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteGenerico;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Ini
	 */

	/**
	 * Method 'getAllDocsTramiteGenerico'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocsTramiteComunicacion(
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);
			Long total = new Long(0);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoGenerico'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoGenerico(@PathVariable String thcodocumento,
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'adjuntarDocsTramiteGenerico'.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteGenerico(@RequestBody TramiteGenerico tramiteGenerico,
			@ModelAttribute(value = "tramiteGenerico") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
				this.sanTramExpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
				this.arbtramexp2Service.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
				this.arbadhtramService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			}

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Fin
	 */
}
