package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteElaboracionBOPVAyto")
@SessionAttributes({ "tramiteElaboracionBOPVAyto", "modoElaboracionBOPVAyto" })
public class TramiteElaboracionBOPVAytoController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteElaboracionBOPVAytoController.class);

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private SanintervService sanintervService;

	@Autowired
	private SantramexpService sanTramExpService;

	@Autowired
	private SandoctempService sandoctempService;
	@Autowired
	private SanexpService sanexpService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private SolarbService solarbService;
	@Autowired
	private ArbexpService arbexpService;
	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired()
	private ArbdoctempService arbdoctempService;
	@Autowired()
	private ArbintervService arbintervService;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;
	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(santramexpService.getNewPK().toString());
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteElaboracionBOPVAyto", tramiteComun);

		model.addAttribute("modoElaboracionBOPVAyto", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteElaboracionBOPVAyto", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}
		model.addAttribute("tramiteElaboracionBOPVAyto", tramiteComun);

		model.addAttribute("modoElaboracionBOPVAyto", Y41bConstantes.MODO_POPUP_MODIFICACION);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			this.sanTramExpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteElaboracionBOPVAyto", "model", model);
	}

	/**
	 * Method 'addtramiteElaboracionBOPVAyto'.
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            tramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoElaboracionBOPVAyto
	 *            String
	 * @param model
	 *            Model
	 * @return tramiteElaboracionBOPVAyto
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody TramiteElaboracionBOPVAyto addTramiteElaboracionBOPVAyto(
			@RequestBody TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoElaboracionBOPVAyto") String modoElaboracionBOPVAyto, Model model) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, idioma,
						false, modoElaboracionBOPVAyto);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, false,
						modoElaboracionBOPVAyto);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, false,
						modoElaboracionBOPVAyto);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, idioma,
						false, modoElaboracionBOPVAyto);

			}

			model.addAttribute("modoElaboracionBOPVAyto", Y41bConstantes.MODO_POPUP_MODIFICACION);

			logger.info("Entity correctly inserted!");
			return tramiteElaboracionBOPVAyto;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'edittramiteElaboracionBOPVAyto'.
	 * 
	 * @param tramiteElaboracionBOPVAyto
	 *            tramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoElaboracionBOPVAyto
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return tramiteElaboracionBOPVAyto
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody TramiteElaboracionBOPVAyto edittramiteElaboracionBOPVAyto(
			@RequestBody TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoElaboracionBOPVAyto") String modoElaboracionBOPVAyto,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// Monitor que ha ejecutado el tramite y su fecha fin (ini)
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteElaboracionBOPVAyto.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteElaboracionBOPVAyto.setFechaFin(todayWithZeroTime);
			// Monitor que ha ejecutado el tramite y su fecha fin (fin)

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, idioma,
						true, modoElaboracionBOPVAyto);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanTramExpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, true,
						modoElaboracionBOPVAyto);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, true,
						modoElaboracionBOPVAyto);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, tramiteComun, idioma,
						true, modoElaboracionBOPVAyto);

			}
			logger.info("Entity correctly inserted!");
			return tramiteElaboracionBOPVAyto;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'gettramiteElaboracionBOPVAytoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return tramiteElaboracionBOPVAyto
	 */
	@RequestMapping(value = "/findtramiteElaboracionBOPVAyto/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody TramiteElaboracionBOPVAyto gettramiteElaboracionBOPVAytoById(@PathVariable String idTramite,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteElaboracionBOPVAyto tramiteElaboracionBOPVAyto = new TramiteElaboracionBOPVAyto();
			tramiteElaboracionBOPVAyto.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteElaboracionBOPVAyto = this.soltramexpService
						.findTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteElaboracionBOPVAyto = this.santramexpService
						.findTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteElaboracionBOPVAyto = this.arbtramexp4Service
						.findTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteElaboracionBOPVAyto = this.instramexpService
						.findTramiteElaboracionBOPVAyto(tramiteElaboracionBOPVAyto, censoMonitor);

			}

			if (tramiteElaboracionBOPVAyto == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteElaboracionBOPVAyto;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Ini
	 * 
	 */

	/**
	 * Method 'getAllDocstramiteElaboracionBOPVAyto'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody Object getAllDocstramiteElaboracionBOPVAyto(
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				Long total = new Long(0);
				List<Adjuntardocs> listAdjuntardocs = null;
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillastramiteElaboracionBOPVAyto'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody Object getAllPlantillastramiteElaboracionBOPVAyto(
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				plantillaTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ELABORACION_BOPV_AYUNTA);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				// SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				// solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				// CensoMonitor censoMonitor = (CensoMonitor)
				// request.getSession()
				// .getAttribute(
				// Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
				//
				// solicitudDetalle = this.denunciaService.findSolicitud(
				// solicitudDetalle, censoMonitor);
				//
				// plantillaTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

				tramite.setTrcodigo(
						Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_DOCUMENTACION_PARA_PUBLICACION_BOPV_BOE);
				plantillaTramite.setTramite(tramite);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaBOPVAyto'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody void addPlantillaBOPVAyto(@RequestBody Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
					adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
					adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}

				this.denunciaService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
					adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
					adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}
				this.sanexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_SAN_NOTIFICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				if (Y41bConstantes.SI.equals(adjuntardocs.getThrequierefirma())) {
					adjuntardocs.setThfechasolfirma(Calendar.getInstance().getTime());
					adjuntardocs.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}
				this.arbexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_ARB_NOTIFICACION);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoBOPVAyto'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoBOPVAyto(@PathVariable String thcodocumento,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocstramiteElaboracionBOPVAyto'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addDocstramiteElaboracionBOPVAyto(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}
			TipoDocumento tipoDocumento = new TipoDocumento();
			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_OTROS);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_OTROS);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);

				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);
			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteElaboracionBOPVAyto/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/tramiteElaboracionBOPVAyto/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoElaboracionBOPVAyto
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody Object getAllIntervinientes(
			@ModelAttribute(value = "tramiteElaboracionBOPVAyto") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoElaboracionBOPVAyto") String modoElaboracionBOPVAyto,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			List<Intervinientes> listIntervinientes = null;

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());

			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listIntervinientes = this.intervinientesService.findAll(intervinientes, pagination);

					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listIntervinientes);
				return data;
			} else {

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					listIntervinientes = this.sanintervService.findAllIntervinientes(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

					listIntervinientes = this.arbintervService.findAllIntervinientes(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				}

				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listIntervinientes;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
