package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.*;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.TramiteService;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramite")
public class TramiteController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteController.class);

	@Autowired()
	private TramiteService tramiteService;

	@Autowired()
	private SanexpService sanexpservice;

	@Autowired()
	private ArbexpService arbexpservice;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TramiteController.logger.info("[GET - View] : tramite");
		return "tramite";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return tramite Tramite
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Tramite getById(@PathVariable() String trcodigo) {
		Tramite tramite = new Tramite();
		tramite.setTrcodigo(trcodigo);
		tramite = this.tramiteService.find(tramite);
		TramiteController.logger
				.info("[GET - findBy_PK] : Obtener Tramite por PK");
		return tramite;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTramite
	 *            Tramite
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Tramite> getAll(@ModelAttribute() Tramite filterTramite) {
		TramiteController.logger
				.info("[GET - find_ALL] : Obtener Tramite por filtro");
		return this.tramiteService.findAll(filterTramite, null);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTramite
	 *            Tramite
	 * @return List
	 */
	@RequestMapping(value = "/tramiteKontsumonet", method = RequestMethod.GET)
	public @ResponseBody()
	List<Tramite> getAllKontsumonet(@ModelAttribute() Tramite filterTramite) {
		TramiteController.logger
				.info("[GET - find_ALL] : Obtener Tramite por filtro");
		return this.tramiteService.findAllKontsumonet(filterTramite, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Tramite edit(@RequestBody() Tramite tramite) {
		try {
			Tramite tramiteAux = this.tramiteService.update(tramite);
			TramiteController.logger
					.info("[PUT] : Tramite actualizado correctamente");
			return tramiteAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Tramite add(@RequestBody() Tramite tramite) {
		try {
			Tramite tramiteAux = this.tramiteService.add(tramite);
			TramiteController.logger
					.info("[POST] : Tramite insertado correctamente");
			return tramiteAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return tramite
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Tramite remove(@PathVariable() String trcodigo) {
		Tramite tramite = new Tramite();
		tramite.setTrcodigo(trcodigo);
		this.tramiteService.remove(tramite);
		TramiteController.logger
				.info("[DELETE] : Tramite borrado correctamente");
		return tramite;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tramiteIds
	 *            List
	 * @return tramiteList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> tramiteIds) {
		List<Tramite> tramiteList = new ArrayList<Tramite>();
		for (List<String> tramiteId : tramiteIds) {
			Iterator<String> iterator = tramiteId.iterator();
			Tramite tramite = new Tramite(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			tramite.setTrcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tramiteList.add(tramite);
		}
		this.tramiteService.removeMultiple(tramiteList);
		TramiteController.logger
				.info("[POST - DELETE_ALL] : Tramite borrados correctamente");
		return tramiteIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Tramite filterTramite,
			@ModelAttribute() Pagination pagination) {
		List<Tramite> tramites = this.tramiteService.findAll(filterTramite,
				pagination);
		Long recordNum = this.tramiteService.findAllCount(filterTramite);
		TramiteController.logger.info("[GET - jqGrid] : Obtener Tramite");
		return new JQGridJSONModel(pagination, recordNum, tramites);
	}

	/**
	 * Method 'getAllTramiteActivo'. Este metodo devuelve la lista de tramites
	 * activos. Se usa desde combos o desplegables.
	 * 
	 * @param pcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllTramiteActivo", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramiteActivo(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite();
			filterTramite.setPcodigo(pcodigo);
			return this.tramiteService.findAllActivos(filterTramite, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTramite'. Este metodo devuelve la lista de los tramites
	 * activos o no.
	 * 
	 * @param pcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllTramite", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramite(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite();
			filterTramite.setPcodigo(pcodigo);
			return this.tramiteService.findAll(filterTramite, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTramiteAdministrativo'. Este metodo devuelve la lista de
	 * los tramites activos o no.
	 * 
	 * @param pcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllTramiteAdministrativo", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramiteAdministrativo(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite();
			filterTramite.setPcodigo(pcodigo);
			filterTramite.setIdPerfil(Y41bConstantes.PERFIL_ADMINISTRATIVO);
			return this.tramiteService.findAll(filterTramite, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTramiteSin'. Este metodo devuelve la lista de los tramites
	 * activos o no. Sin el tramite de alegaciones
	 * 
	 * @param pcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllTramiteSinAlegaciones", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllTramiteSin(
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite();
			filterTramite.setPcodigo(pcodigo);
			return this.tramiteService.findAllSin(filterTramite, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'pCodigo'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboTramites", method = RequestMethod.GET)
	public @ResponseBody()
	List<Tramite> getComboTramites(HttpServletRequest request) {

		this.logger.info("[GET - find_ALL] : Obtener Fase por filtro");
		Tramite filterTramite = new Tramite();
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		/*
		 * desde la ficha de expedientes
		 */

		Pagination pagination = new Pagination();

		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			pagination.setSort("trnombre");
			pagination.setAscDsc("ASC");
		} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
			pagination.setSort("trnombree");
			pagination.setAscDsc("ASC");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("excodigo"))
				&& null != (String) request.getParameter("excodigo")) {
			String excodigo = (String) request.getParameter("excodigo");
			Sanexp sanexp = new Sanexp();
			sanexp.setExcodigo(excodigo);
			sanexp = this.sanexpservice.find(sanexp);
			Fase fase = sanexp.getFase();
			filterTramite.setFase(new Fase(fase.getFcodigo()));
		}
		/*
		 * desde el filtro
		 */
		if (!"".equalsIgnoreCase((String) request.getParameter("pCodigo"))
				&& null != (String) request.getParameter("pCodigo")) {
			String pCodigo = (String) request.getParameter("pCodigo");
			filterTramite.setPcodigo(pCodigo);
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("y41bBusquedaSancionFiltroFase"))
				&& null != (String) request
						.getParameter("y41bBusquedaSancionFiltroFase")) {
			String fCodigo = (String) request
					.getParameter("y41bBusquedaSancionFiltroFase");
			filterTramite.setFase(new Fase(fCodigo));
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("y41bBusquedaArbitrajeFiltroFase"))
				&& null != (String) request
						.getParameter("y41bBusquedaArbitrajeFiltroFase")) {
			String fCodigo = (String) request
					.getParameter("y41bBusquedaArbitrajeFiltroFase");
			filterTramite.setFase(new Fase(fCodigo));
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("y41bAdhsolicitudesDetalleTipoProcedimiento"))
				&& null != (String) request
						.getParameter("y41bAdhsolicitudesDetalleTipoProcedimiento")) {
			String pCodigo = (String) request
					.getParameter("y41bAdhsolicitudesDetalleTipoProcedimiento");
			filterTramite.setPcodigo(pCodigo);
		}

		/*
		 * filterTramite.setTipoProcedimiento(new TipoProcedimiento(pCodigo,
		 * null, null, null));
		 */

		return this.tramiteService.findTramitesFase(filterTramite, pagination);
	}

	/**
	 * Method 'pCodigo'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboTramitesGenerables", method = RequestMethod.GET)
	public @ResponseBody()
	List<Tramite> getComboTramitesGenerables(HttpServletRequest request) {

		TramiteController.logger
				.info("[GET - find_ALL] : Obtener Fase por filtro");
		Tramite filterTramite = new Tramite();
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		/*
		 * desde la ficha de expedientes
		 */
		List<Tramite> listaTramites = null;
		Pagination pagination = new Pagination();
		String excodigo = "";
		String tipoProc = (String) request.getParameter("tipoProcedimiento");
		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			pagination.setSort("trnombre");
			pagination.setAscDsc("ASC");
		} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
			pagination.setSort("trnombree");
			pagination.setAscDsc("ASC");
		}

		if (null != (String) request.getParameter("excodigo")
				&& !"".equals((String) request.getParameter("excodigo"))) {
			excodigo = (String) request.getParameter("excodigo");
			Fase fase = null;
			if (tipoProc != null && !tipoProc.equals("")
					&& tipoProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Sanexp sanexp = new Sanexp();
				sanexp.setExcodigo(excodigo);
				sanexp = this.sanexpservice.find(sanexp);
				fase = sanexp.getFase();
				filterTramite.setFase(new Fase(fase.getFcodigo()));
				if (tipoProc != null && !tipoProc.equals("")) {
					filterTramite.setPcodigo(tipoProc);
				}
				listaTramites = this.tramiteService.findTramitesFaseGenerables(
						filterTramite, pagination, excodigo);
				listaTramites = this.sanexpservice
						.tramitesGenerablesProntoPago(listaTramites, excodigo);
			} else if (tipoProc != null && !tipoProc.equals("")
					&& tipoProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(excodigo);
				arbexp = this.arbexpservice.find(arbexp);
				fase = arbexp.getFase();
				filterTramite.setFase(new Fase(fase.getFcodigo()));
				if (tipoProc != null && !tipoProc.equals("")) {
					filterTramite.setPcodigo(tipoProc);
				}
				listaTramites = this.tramiteService.findTramitesFaseGenerables(
						filterTramite, pagination, excodigo);
			}
		}
		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		List<Tramite> listaTramitesFinal = new ArrayList<Tramite>();

		if (tipoProc != null && !tipoProc.equals("")
				&& tipoProc.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			if (censoMonitor.getPerfilSanciones().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
				// El instructor no crea liquidaciones
				for (int i = 0; i < listaTramites.size(); i++) {
					if (!Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
							.equals(listaTramites.get(i).getTrcodigo())) {
						listaTramitesFinal.add(listaTramites.get(i));
					} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
							.equals(listaTramites.get(i).getTrcodigo())
							&& Y41bConstantes.VALOR_SI.equals(censoMonitor
									.getMoadmiliquidacion())) {
						listaTramitesFinal.add(listaTramites.get(i));
					}
				}
			} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {
				// El administrativo slo puede crear Aportes, notificaciones y
				// comunicaciones
				for (int i = 0; i < listaTramites.size(); i++) {
					if (Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION
							.equals(listaTramites.get(i).getTrcodigo())
							|| Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
									.equals(listaTramites.get(i).getTrcodigo())
							|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION
									.equals(listaTramites.get(i).getTrcodigo())) {
						listaTramitesFinal.add(listaTramites.get(i));
					} else if (Y41bConstantes.TRAMITE_SANCIONES_LIQUIDACION
							.equals(listaTramites.get(i).getTrcodigo())
							&& Y41bConstantes.VALOR_SI.equals(censoMonitor
									.getMoadmiliquidacion())) {
						listaTramitesFinal.add(listaTramites.get(i));
					}
				}
			} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilSanciones().getIdPerfil()
							.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
				listaTramitesFinal = listaTramites;
			}
		} else if (tipoProc != null && !tipoProc.equals("")
				&& tipoProc.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			if (censoMonitor.getPerfilArbitraje().getIdPerfil()
					.equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {
				// El administrativo slo puede crear Aportes, notificaciones y
				// comunicaciones
				for (int i = 0; i < listaTramites.size(); i++) {
					if (Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION
							.equals(listaTramites.get(i).getTrcodigo())
							|| Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION
									.equals(listaTramites.get(i).getTrcodigo())
							|| Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION
									.equals(listaTramites.get(i).getTrcodigo())) {
						listaTramitesFinal.add(listaTramites.get(i));
					}
				}
			} else {
				listaTramitesFinal = listaTramites;
			}
		} else {
			listaTramitesFinal = listaTramites;
		}

		return listaTramitesFinal;

	}
}