package com.ejie.y41b.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.net.io.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DatosMailEstablecimiento;
import com.ejie.y41b.model.DatosMailOrigen;
import com.ejie.y41b.model.DatosMailSede;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhdocService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp3Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.TramiteHechoService;
import com.ejie.y41b.service.TramiteInspeccionService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TramiteComunicacionController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteComunicacion")
@SessionAttributes(value = { "tramiteComunicacion", "modoComunicacion" })
public class TramiteComunicacionController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteComunicacionController.class);

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired()
	private ActaService actaService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private IntervinientesService intervinientesService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private SantramexpService santramexpService;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private SandoctempService sandoctempService;

	@Autowired()
	private SanexpService sanexpService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private SolarbService solarbService;

	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired()
	private Arbtramexp3Service arbtramexp3Service;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private ArbadhtramService arbadhtramService;

	@Autowired()
	private ArbadhsolService arbadhsolService;

	@Autowired()
	private ArbadhdocService arbadhdocService;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(this.santramexpService.getNewPK().toString());
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			tramiteComun.setIdTramite(this.arbtramexpService.getNewPK().toString());
			Solarb solarb = new Solarb();
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && (codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
				|| codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			tramiteComun.setIdTramite(this.arbadhtramService.getNewPK().toString());
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteComunicacion", tramiteComun);
		model.addAttribute("modoComunicacion", Y41bConstantes.MODO_POPUP_ALTA);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			this.santramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteComunicacion", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String codProcedimiento, @PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		// Insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());

			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
			this.santramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));

			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
		}

		model.addAttribute("tramiteComunicacion", tramiteComun);
		model.addAttribute("modoComunicacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteComunicacion", "model", model);
	}

	/**
	 * Method 'addTramiteComunicacion'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteComunicacion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteComunicacion addTramiteComunicacion(
			@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, Model model,
			HttpServletResponse response, HttpServletRequest request) {

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, false,
						modoComunicacion, null, null, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				// COMUNICACION ELECTRONICA
				this.santramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, false,
						modoComunicacion, false, true, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				// COMUNICACION ELECTRONICA
				this.arbtramexp3Service.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, false,
						modoComunicacion, false, true, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, false,
						modoComunicacion, false, true, "", censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, false,
						modoComunicacion, null, null, censoMonitor);
			}

			model.addAttribute("modoComunicacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteComunicacionController.logger.info("Entity correctly inserted!");
			return tramiteComunicacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteComunicacionElectronica'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteComunicacion
	 */
	@RequestMapping(value = "/tramitarComunicacionElectronica", method = RequestMethod.PUT)
	public @ResponseBody() TramiteComunicacion editTramiteComunicacionElectronica(
			@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteComunicacion.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteComunicacion.setFechaFin(todayWithZeroTime);

			String idioma = locale.getLanguage();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_TELEMATICA, null, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				// ELECTRONICA
				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				expedien = this.expedienService.find(expedien);
				Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());

				if (Y41bConstantes.SI.equals(sanexp.getPlatea())) {
					this.santramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
							modoComunicacion, false, true, "", censoMonitor);
				} else {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				// ELECTRONICA
				this.arbtramexp3Service.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, false, true, "", censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, false, true, "", censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_TELEMATICA, null, censoMonitor);
			}

			TramiteComunicacionController.logger.info("Entity correctly inserted!");
			return tramiteComunicacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteComunicacionElectronica'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 */
	@RequestMapping(value = "/crearEJGVDocumentComunicacion", method = RequestMethod.PUT)
	public @ResponseBody() RespuestaCrearEJGVDocumentNotificacion crearEJGVDocumentComunicacion(
			@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteComunicacion.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteComunicacion.setFechaFin(todayWithZeroTime);

			RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				respuestaEjgv = this.soltramexpService.createEJGVDocumentNotificacionComunicacion(
						tramiteComunicacion.getTextoComunicacion(), tramiteComunicacion.getDestinatario(), null,
						tramiteComunicacion.getEnvRemesaComunicacion(), tramiteComun, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				expedien = this.expedienService.find(expedien);
				Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());

				if (Y41bConstantes.SI.equals(sanexp.getPlatea())) {
					respuestaEjgv = this.santramexpService.createEJGVDocumentComunicacion(tramiteComunicacion,
							tramiteComun, censoMonitor, tipoProcedimiento.getPcodigo());
				} else {
					throw new Y41bUDAException("error.notramitable", true, new Exception());
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				respuestaEjgv = this.arbtramexp3Service.createEJGVDocumentComunicacion(tramiteComunicacion,
						tramiteComun, censoMonitor, tipoProcedimiento.getPcodigo());

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				respuestaEjgv = this.arbadhtramService.createEJGVDocumentComunicacion(tramiteComunicacion, tramiteComun,
						censoMonitor, tipoProcedimiento.getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				respuestaEjgv = this.instramexpService.createEJGVDocumentNotificacionComunicacion(
						tramiteComunicacion.getTextoComunicacion(), tramiteComunicacion.getDestinatario(), null,
						tramiteComunicacion.getEnvRemesaComunicacion(), tramiteComun, censoMonitor);
			}
			TramiteComunicacionController.logger.info("Entity correctly inserted!");
			return respuestaEjgv;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteComunicacionMail'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteComunicacion
	 */
	@RequestMapping(value = "/tramitarComunicacionMail", method = RequestMethod.PUT)
	public @ResponseBody() TramiteComunicacion editTramiteComunicacionMail(
			@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramiteComunicacion.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteComunicacion.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO, null, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				expedien = this.expedienService.find(expedien);
				Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());

				if (Y41bConstantes.SI.equals(sanexp.getPlatea())) {
					this.santramexpService.addTramiteComunicacionMail(tramiteComunicacion, tramiteComun,
							modoComunicacion, censoMonitor);
				} else {
					Saninterv saninterv = new Saninterv();
					saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
					saninterv.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
					saninterv = this.sanintervService.find(saninterv);

					if (saninterv != null
							&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
											.equals(saninterv.getUatipointerv()))) {
						throw new Y41bUDAException("error.notramitable", true, new Exception());
					} else if (saninterv != null) {
						this.santramexpService.addTramiteComunicacionMail(tramiteComunicacion, tramiteComun,
								modoComunicacion, censoMonitor);
					}
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp3Service.addTramiteComunicacionMail(tramiteComunicacion, tramiteComun, modoComunicacion,
						censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteComunicacionMail(tramiteComunicacion, tramiteComun, modoComunicacion,
						censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO, null, censoMonitor);
			}

			TramiteComunicacionController.logger.info("Entity correctly inserted!");
			return tramiteComunicacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editTramiteComunicacionOrdinaria'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return String idZip
	 */
	@RequestMapping(value = "/tramitarComunicacionOrdinaria", method = RequestMethod.PUT)
	public @ResponseBody() String editTramiteComunicacionOrdinaria(
			@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteComunicacion.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteComunicacion.setFechaFin(todayWithZeroTime);

			String idioma = locale.getLanguage();

			// Creamos el ID del ZIP
			StringBuffer idZipFile = new StringBuffer();
			idZipFile.append(Calendar.getInstance().getTimeInMillis()).append("_")
					.append(tramiteComun.getIdExpediente());
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO, idZipFile.toString(),
						censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				// COMUNICACION ORDINARIA

				Expedien expedien = new Expedien();
				expedien.setExcodigo(tramiteComun.getIdExpediente());
				expedien = this.expedienService.find(expedien);
				Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());

				if (Y41bConstantes.SI.equals(sanexp.getPlatea())) {
					this.santramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
							modoComunicacion, true, false, idZipFile.toString(), censoMonitor);
				} else {
					Saninterv saninterv = new Saninterv();
					saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
					saninterv.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
					saninterv = this.sanintervService.find(saninterv);

					if (saninterv != null
							&& (Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO.equals(saninterv.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
											.equals(saninterv.getUatipointerv()))) {
						throw new Y41bUDAException("error.notramitable", true, new Exception());
					} else if (saninterv != null) {
						this.santramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
								modoComunicacion, true, false, idZipFile.toString(), censoMonitor);
					}
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				// COMUNICACION ORDINARIA
				this.arbtramexp3Service.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, true, false, idZipFile.toString(), censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhtramService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, true, false, idZipFile.toString(), censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteComunicacion(tramiteComunicacion, tramiteComun, idioma, true,
						modoComunicacion, Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO, idZipFile.toString(),
						censoMonitor);
			}
			TramiteComunicacionController.logger.info("Entity correctly inserted!");
			return idZipFile.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param idzip
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findZipById/{idzip}", method = RequestMethod.GET)
	public @ResponseBody() void getZipById(@PathVariable() String idzip,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
				// Se mira si se ha creado ZIP
				String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP");
				File zipFile = new File(strTmpZipDirectory + idzip + Y41bConstantes.EXTENSION_ZIP);
				if (zipFile.exists()) {
					// Cambiamos el objeto Response para visualizar el contenido
					// del archivo
					response.setHeader("Content-Disposition",
							"attachment; filename=\"" + idzip + Y41bConstantes.EXTENSION_ZIP + "\"");
					response.setContentType(Y41bConstantes.CONTENT_TYPE_ZIP);
					File fileZip = new File(zipFile.getPath());
					FileInputStream fileInputStreamZip = new FileInputStream(fileZip);
					Util.copyStream(fileInputStreamZip, response.getOutputStream());
					// response.setContentLength(fileZip.length());
					// Vaciamos el stream
					response.getOutputStream().flush();
					fileInputStreamZip.close();
					// Eliminamos el fichero zip
					zipFile.delete();
				}
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteComunicacionById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteComunicacion
	 */
	@RequestMapping(value = "/findTramiteComunicacion/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteComunicacion getTramiteComunicacionById(@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteComunicacion tramiteComunicacion = new TramiteComunicacion();
			tramiteComunicacion.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteComunicacion = this.soltramexpService.findTramiteComunicacion(tramiteComunicacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteComunicacion = this.santramexpService.findTramiteComunicacion(tramiteComunicacion, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteComunicacion = this.arbtramexp3Service.findTramiteComunicacion(tramiteComunicacion,
						censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				tramiteComunicacion = this.arbadhtramService.findTramiteComunicacion(tramiteComunicacion, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteComunicacion = this.instramexpService.findTramiteComunicacion(tramiteComunicacion, censoMonitor);
			}

			if (tramiteComunicacion == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteComunicacion;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Ini
	 */

	/**
	 * Method 'getAllDocsTramiteComunicacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramiteComunicacion(
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);
			Long total = new Long(0);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

					if (listAdjuntardocs == null) {
						throw new Exception("No data Found.");
					}

					total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasComunicacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasTramiteComunicacion(
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				plantillaTramite.setTiposolicitud(solicitudDetalle.getHdcosc());

				tramite.setTrcodigo(Y41bConstantes.TRAMITE_COMUNICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(tramiteComun.getIdTipoTramite());
				plantillaTramite.setTramite(tramite);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
				tramite.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICACION);
				plantillaTramite.setTramite(tramite);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaComunicacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void addPlantillaComunicacion(@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.denunciaService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_COMUNICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.sanexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_SAN_COMUNICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				this.arbadhsolService.addPlantilla(adjuntardocs, tramiteComun,
						Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.inspeccionService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_COMUNICACION);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacion'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoComunicacion(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramiteComunicacion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramiteComunicacion(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			TipoDocumento tipoDocumento = new TipoDocumento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_COMUNICACION);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_SAN_COMUNICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				adjuntardocsAux.setThcodocumento(this.arbadhdocService.getNewPK().toString());
				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_COMUNICACION);
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_COMUNICACION);
			}

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteComunicacionController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'adjuntarDocsTramiteComunicacion'.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteComunicacion(@RequestBody() TramiteComunicacion tramiteComunicacion,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			this.adjuntardocsService.comprobarTipoDocumentoAcuse(tramiteComunicacion.getDocumentosExpediente());

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// insertar los documento en la tabla intermedia de hechos.
				List<DocumentoExpediente> listDocumentoExpediente = tramiteComunicacion.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				List<DocumentoExpediente> listDocumentoExpediente = tramiteComunicacion.getDocumentosExpediente();
				this.santramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				List<DocumentoExpediente> listDocumentoExpediente = tramiteComunicacion.getDocumentosExpediente();
				this.arbtramexp2Service.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteComunicacion.getDocumentosExpediente();
				this.arbadhtramService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				List<DocumentoExpediente> listDocumentoExpediente = tramiteComunicacion.getDocumentosExpediente();
				this.soltramexpService.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);
			}

			TramiteComunicacionController.logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Metodos para la Gestion de Tabla de Docs Fin
	 */
	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoComunicacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody() Object getAllIntervinientes(
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoComunicacion") String modoComunicacion, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			List<Intervinientes> listIntervinientes = null;

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());

			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listIntervinientes = this.intervinientesService.findAll(intervinientes, pagination);

					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, pagination);

					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);

				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listIntervinientes);
				return data;
			} else {

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// EVOLUTIVO 0135083 2.2 se cambia el metodo find
					// findAllIntervinientes por el de
					// findAllIntervinientesConCIF
					listIntervinientes = this.sanintervService.findAllIntervinientesConCIF(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// 0171878: Evolutivo Arbitraje Febrero 2021
					// sacamos solo los activos y ponemos aniadimos una A en los
					// nombres
					intervinientes.setActivos("S");

					listIntervinientes = this.arbintervService.findAllIntervinientes(intervinientes, null);

					for (Intervinientes intervinientesAux : listIntervinientes) {
						StringBuffer nombre = new StringBuffer();
						if (intervinientesAux.getNombre() != null && !intervinientesAux.getNombre().equals("")
								&& intervinientesAux.getTipoInterviniente().equals("B")) {
							nombre.append(intervinientesAux.getNombre());
							nombre.append(" (A)");
						} else {
							nombre.append(intervinientesAux.getNombre());
						}
						intervinientesAux.setNombre(nombre.toString());
					}
					// 0171878
					// listIntervinientes = this.arbintervService
					// .findAllIntervinientes(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					listIntervinientes = this.arbadhsolService.findAllIntervinientes(tramiteComun);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, null);
				}

				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listIntervinientes;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAsuntoDefectoTramiteComunicacion'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param tramiteComun
	 *            the tramite comun
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAsuntoDefectoTramiteComunicacion/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody() Object getAsuntoDefectoTramiteComunicacion(@PathVariable() String idExpediente,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request,
			Model model) {
		try {
			// Obtener el numero de expediente

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			StringBuffer numeroExpediente = new StringBuffer();
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(idExpediente);

				SolicitudDetalle solDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-").append(solDetalle.getDecoor())
						.append("-").append(solDetalle.getDenror()).append("-").append(solDetalle.getDenran())
						.append("-").append(solDetalle.getHdnror());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Expedien expedien = new Expedien();
				expedien.setExcodigo(idExpediente);

				expedien = this.expedienService.find(expedien);

				numeroExpediente.append(expedien.damecodCompletoPlatea());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Solarb solarb = new Solarb();
				solarb.setSacodigo(new String(Y41bUtilsDokusi.decode(idExpediente)));
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
				model.addAttribute("tramiteComunicacion", tramiteComun);
				solarb = this.solarbService.find(solarb);

				numeroExpediente.append(solarb.damecodCompletoPlatea());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				Arbadhsol arbadhsol = new Arbadhsol();
				arbadhsol.setAdhid(idExpediente);
				arbadhsol = this.arbadhsolService.find(arbadhsol);
				numeroExpediente.append(arbadhsol.getNumExpediente());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				numeroExpediente = new StringBuffer();
				numeroExpediente.append(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			}

			return numeroExpediente.toString();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getIntervinienteTramite'.
	 * 
	 * @param idInterviniente
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/interviniente/{idInterviniente}", method = RequestMethod.GET)
	public @ResponseBody() Object getIntervinienteTramite(@PathVariable() String idInterviniente,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdinterviniente(idInterviniente);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				interviniente = this.denunciaService.findInterviniente(interviniente);

				// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
				// Recuperar la solicitud
				HttpServletRequest httpRequest = (HttpServletRequest) request;
				HttpSession httpSession = httpRequest.getSession(false);
				CensoMonitor censoMonitor = (CensoMonitor) httpSession
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
				solicitudDetalle.setHdcodigo(tramiteComun.getIdExpediente());
				solicitudDetalle = this.denunciaService.findSolicitud(solicitudDetalle, censoMonitor);

				// si es AACCEmpresas y telematica e interesado
				if (solicitudDetalle.getHddenunciaaaccempresas() != null
						&& solicitudDetalle.getHddenunciaaaccempresas().equalsIgnoreCase(Y41bConstantes.VALOR_SI)
						&& solicitudDetalle.getHdformanotificacion() != null
						&& solicitudDetalle.getHdformanotificacion()
								.equalsIgnoreCase(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {

					String solFormanotificacion = null;

					// recuperar tramite de comunicacion generado
					// automaticamente
					TramiteComunicacion tramiteComunicacion = new TramiteComunicacion();
					tramiteComunicacion.setIdTramite(tramiteComun.getIdTramite());

					try {
						tramiteComunicacion = this.soltramexpService.findTramiteComunicacion(tramiteComunicacion,
								censoMonitor);
					} catch (Exception e) {

					}

					// Recuperar tramite padre de la comunicacion
					// si es req de subsanacion cosas
					TramiteHecho tramiteHecho = new TramiteHecho();
					tramiteHecho.setEhcodigo(tramiteComunicacion.getIdTramite());
					tramiteHecho = this.tramiteHechoService.find(tramiteHecho);

					if (tramiteHecho != null && tramiteHecho.getTramiteHecho() != null
							&& tramiteHecho.getTramiteHecho().getEhcodigo() != null) {
						// K04 - Requerimiento subsanacin de documentacin al
						// reclamante
						// K03 - Requerimiento de informacion

						TramiteHecho tramiteHechoAux = new TramiteHecho();
						tramiteHechoAux.setEhcodigo(tramiteHecho.getTramiteHecho().getEhcodigo());

						tramiteHechoAux = this.tramiteHechoService.find(tramiteHechoAux);

						if (interviniente != null && interviniente.getTipoInterviniente() != null && (interviniente
								.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO))) {

							if (Y41bConstantes.TRAMITE_REQUERIMIENTO_SUBSANACION.equals(tramiteHechoAux.getEhcotee())) {
								solFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
							} else {
								solFormanotificacion = solicitudDetalle.getHdformanotificacion();
							}

							interviniente.setSolFormanotificacion(solFormanotificacion);

						} else if (interviniente != null && interviniente.getTipoInterviniente() != null
								&& (interviniente.getTipoInterviniente()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO))) {

							if (Y41bConstantes.TRAMITE_REQUERIMIENTO_INFORMACION.equals(tramiteHechoAux.getEhcotee())) {
								solFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
							} else {
								solFormanotificacion = solicitudDetalle.getHdformanotificacionestablecimiento();
							}
							interviniente.setSolFormanotificacion(solFormanotificacion);
						}

					}

				}
				// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				Saninterv saninterv = new Saninterv();
				saninterv = this.sanintervService
						.find(new Saninterv(new BigDecimal(interviniente.getIdinterviniente())));
				interviniente.setSanFormanotificacion(saninterv.getUaformanotificacion());
				if (Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO.equals(saninterv.getUatipointerv())) {
					Saninterv saninterv2 = this.sanintervService.dameSancionado(tramiteComun.getIdExpediente());
					if (saninterv2 != null) {
						interviniente.setSanFormanotificacion(saninterv2.getUaformanotificacion());
					}
				}
				// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor
				// origen
				if (Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN.equals(saninterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO.equals(saninterv.getUatipointerv())) {
					Expedien expedien = new Expedien();
					expedien.setExcodigo(tramiteComun.getIdExpediente());
					expedien = this.expedienService.find(expedien);
					Sanexp sanexp = this.sanexpService.find(expedien.getSanexp());
					interviniente.setExhdformanotiforigen(sanexp.getExhdformanotiforigen());
				}
				// 0159290: Acuerdo de incoaccin. Comunicacin al consumidor
				// origen
				interviniente.setDireccionCompleta(saninterv.getDireccionCompleta());
				interviniente.setTipoInterviniente(saninterv.getUatipointerv());
				interviniente.setNif(saninterv.getUanif());
				interviniente.setCoem(saninterv.getUacoem());
				interviniente.setTieneDireccionCompleta(saninterv.getTieneDireccionCompleta());

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				Arbinterv arbinterv = new Arbinterv();
				arbinterv = this.arbintervService
						.find(new Arbinterv(new BigDecimal(interviniente.getIdinterviniente())));
				interviniente.setDireccionCompleta(arbinterv.getDireccionCompleta());
				interviniente.setTipoInterviniente(arbinterv.getUatipointerv());
				interviniente.setNif(arbinterv.getUanif());
				interviniente.setArbFormanotificacion(arbinterv.getUaformanotificacion());
				interviniente.setCoem(arbinterv.getUacoem());
				interviniente.setTieneDireccionCompleta(arbinterv.getTieneDireccionCompleta());

				if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					Arbinterv arbinterv2 = this.arbintervService.dameInterviniente(tramiteComun.getIdExpediente(),
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
					if (arbinterv2 != null) {
						interviniente.setArbFormanotificacion(arbinterv2.getUaformanotificacion());
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
						.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					Arbinterv arbinterv2 = this.arbintervService.dameInterviniente(tramiteComun.getIdExpediente(),
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					if (arbinterv2 != null) {
						interviniente.setArbFormanotificacion(arbinterv2.getUaformanotificacion());
					}
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				interviniente = this.arbadhsolService.findInterviniente(tramiteComun);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				interviniente = this.denunciaService.findInterviniente(interviniente);

				if (interviniente.getIdinterviniente() != null) {
					Actuacion actuacion = new Actuacion();
					actuacion.setAtcodigo(interviniente.getIdExpediente());
					InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, null);
					String insFormanotificacion = null;

					if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoR() != null
							&& inspeccionDetalle.getEstablecimientoR().getIdinterviniente() != null
							&& inspeccionDetalle.getEstablecimientoR().getIdinterviniente()
									.equals(interviniente.getIdinterviniente())) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientore();
					} else if (inspeccionDetalle != null && inspeccionDetalle.getEstablecimientoV() != null
							&& inspeccionDetalle.getEstablecimientoV().getIdinterviniente() != null
							&& inspeccionDetalle.getEstablecimientoV().getIdinterviniente()
									.equals(interviniente.getIdinterviniente())) {

						TramiteComunicacion tramiteComunicacion = new TramiteComunicacion();
						tramiteComunicacion.setIdTramite(tramiteComun.getIdTramite());

						HttpServletRequest httpRequest = (HttpServletRequest) request;
						HttpSession httpSession = httpRequest.getSession(false);
						CensoMonitor censoMonitor = (CensoMonitor) httpSession
								.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

						try {
							tramiteComunicacion = this.instramexpService.findTramiteComunicacion(tramiteComunicacion,
									censoMonitor);
						} catch (Exception e) {
							insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
						}

						TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
						tramiteInspeccion.setTicodigo(tramiteComun.getIdTramite());
						tramiteInspeccion = this.tramiteInspeccionService.find(tramiteInspeccion);

						if (tramiteInspeccion != null && tramiteInspeccion.getTramiteInspeccion() != null
								&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null) {
							TramiteInspeccion tramiteInspeccionAux2 = new TramiteInspeccion();
							tramiteInspeccionAux2.setTicodigo(tramiteInspeccion.getTramiteInspeccion().getTicodigo());

							tramiteInspeccionAux2 = this.tramiteInspeccionService.find(tramiteInspeccionAux2);

							// Si la comunicacion se ha generado desde un
							// acuerdo de inicio procedimiento, se realiza de
							// forma postal
							if (Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO
									.equals(tramiteInspeccionAux2.getTicotee())) {
								insFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
							} else {
								if (Y41bUtils.isFilled(tramiteComunicacion.getAccodigo())) {
									insFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
								} else {
									insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
								}

							}
						} else {
							if (Y41bUtils.isFilled(tramiteComunicacion.getAccodigo())) {
								insFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
							} else {
								insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
							}
						}

					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && (interviniente
							.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)
							|| interviniente.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO_NO_VALIDADO))) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientovi();
					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && (interviniente
							.getTipoInterviniente()
							.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)
							|| interviniente.getTipoInterviniente().equals(
									Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE_NO_VALIDADO))) {
						insFormanotificacion = inspeccionDetalle.getAtformanotifestablecimientore();
					} else if (interviniente != null && interviniente.getTipoInterviniente() != null && interviniente
							.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_LABORATORIO)) {
						insFormanotificacion = Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO;
					}

					interviniente.setInsFormanotificacion(insFormanotificacion);
				}
			}

			if (interviniente == null) {
				throw new Exception("No data Found. /interviniente/{idInterviniente}");
			} else {
				return interviniente;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /interviniente/{idInterviniente}");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteComunicacion/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/tramiteComunicacion/guardar/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		TramiteComunicacionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getAllOrigenMail'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllOrigenMail", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrigenMail(
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				List<DatosMailOrigen> listDatosMailOrigen = null;

				listDatosMailOrigen = this.denunciaService.findAllMailOrigen(tramiteComun, null);

				if (listDatosMailOrigen == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailOrigen;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DatosMailOrigen> listDatosMailOrigen = null;

				listDatosMailOrigen = this.sanexpService.findAllMailOrigen(tramiteComun, null);

				if (listDatosMailOrigen == null) {
					throw new Exception("No data Found.");
				}

				return listDatosMailOrigen;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DatosMailOrigen> listDatosMailOrigen = null;

				listDatosMailOrigen = this.arbexpService.findAllMailOrigen(tramiteComun.getIdExpediente());

				if (listDatosMailOrigen == null) {
					throw new Exception("No data Found.");
				}

				return listDatosMailOrigen;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DatosMailOrigen> listDatosMailOrigen = null;

				listDatosMailOrigen = this.arbadhsolService.findAllMailOrigen(tramiteComun.getIdExpediente());

				if (listDatosMailOrigen == null) {
					throw new Exception("No data Found.");
				}

				return listDatosMailOrigen;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				List<DatosMailOrigen> listDatosMailOrigen = null;

				listDatosMailOrigen = this.instramexpService.findAllMailOrigen(tramiteComun, null);

				if (listDatosMailOrigen == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailOrigen;
			} else {
				List<DatosMailOrigen> listDatosMailOrigen = null;

				return listDatosMailOrigen;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getOrigenMail'.
	 * 
	 * @param idDatomail
	 *            String
	 * @param mocodigoActual
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/origenmail/{idDatomail}/{mocodigoActual}", method = RequestMethod.GET)
	public @ResponseBody() Object getOrigenMail(@PathVariable() String idDatomail,
			@PathVariable() String mocodigoActual,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			DatosMailOrigen datosMailOrigen = new DatosMailOrigen();
			datosMailOrigen.setIdDatomail(idDatomail);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				datosMailOrigen = this.denunciaService.findMailOrigen(tramiteComun, datosMailOrigen);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				datosMailOrigen = this.sanexpService.findMailOrigen(tramiteComun, datosMailOrigen);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				datosMailOrigen = this.arbexpService.findMailOrigen(tramiteComun.getIdExpediente(), datosMailOrigen);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				datosMailOrigen = this.arbadhsolService.findMailOrigen(tramiteComun.getIdExpediente(), datosMailOrigen,
						mocodigoActual);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				datosMailOrigen = this.instramexpService.findMailOrigen(tramiteComun, datosMailOrigen);
			}

			if (datosMailOrigen == null) {
				throw new Exception("No data Found. /origenmail/{idDatomail}");
			} else {
				return datosMailOrigen;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /origenmail/{idDatomail}");
		}
	}

	/**
	 * Method 'getAllEstablecimientoMail'.
	 * 
	 * @param idInterviniente
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllEstablecimientoMail/{idInterviniente}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllEstablecimientoMail(@PathVariable() String idInterviniente,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(idInterviniente);

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = null;

				listDatosMailEstablecimiento = this.denunciaService.findAllMailEstablecimiento(tramiteComun,
						intervinientes, null);

				if (listDatosMailEstablecimiento == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailEstablecimiento;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = null;

				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(new BigDecimal(idInterviniente));

				listDatosMailEstablecimiento = this.sanexpService.findAllMailEstablecimiento(tramiteComun, saninterv,
						null);

				if (listDatosMailEstablecimiento == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailEstablecimiento;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = null;

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(new BigDecimal(idInterviniente));

				listDatosMailEstablecimiento = this.arbexpService.findAllMailEstablecimiento(tramiteComun, arbinterv,
						null);

				if (listDatosMailEstablecimiento == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailEstablecimiento;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = this.arbadhsolService
						.findAllMailEstablecimiento(tramiteComun, idInterviniente, null);

				if (listDatosMailEstablecimiento == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailEstablecimiento;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = null;

				listDatosMailEstablecimiento = this.instramexpService.findAllMailEstablecimiento(tramiteComun,
						intervinientes, null);

				if (listDatosMailEstablecimiento == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailEstablecimiento;
			} else {
				List<DatosMailEstablecimiento> listDatosMailEstablecimiento = null;

				return listDatosMailEstablecimiento;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEstablecimientoMail'.
	 * 
	 * @param idDestinatario
	 *            String
	 * @param idDatomail
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/establecimientomail/{idDestinatario}/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody() Object getEstablecimientoMail(@PathVariable() String idDestinatario,
			@PathVariable() String idDatomail, @ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {

			DatosMailEstablecimiento datosMailEstablecimiento = new DatosMailEstablecimiento();
			datosMailEstablecimiento.setIdDatomail(idDatomail);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				datosMailEstablecimiento = this.denunciaService.findMailEstablecimiento(idDestinatario, tramiteComun,
						datosMailEstablecimiento);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				datosMailEstablecimiento = this.sanexpService.findMailEstablecimiento(idDestinatario, tramiteComun,
						datosMailEstablecimiento);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				datosMailEstablecimiento = this.arbexpService.findMailEstablecimiento(idDestinatario, tramiteComun,
						datosMailEstablecimiento);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				datosMailEstablecimiento = this.arbadhsolService.findMailEstablecimiento(idDestinatario, tramiteComun,
						datosMailEstablecimiento);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				datosMailEstablecimiento = this.instramexpService.findMailEstablecimiento(idDestinatario, tramiteComun,
						datosMailEstablecimiento);
			}

			if (datosMailEstablecimiento == null) {
				throw new Exception("No data Found. /establecimientomail/{idDatomail}");
			} else {
				return datosMailEstablecimiento;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /establecimientomail/{idDatomail}");
		}
	}

	/**
	 * Method 'getAllEstablecimientoSedeMail'.
	 * 
	 * @param escodigo
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllEstablecimientoSedeMail/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllEstablecimientoSedeMail(@PathVariable() String escodigo,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				List<DatosMailSede> listDatosMailSede = null;

				listDatosMailSede = this.denunciaService.findAllMailEstablecimientoSede(tramiteComun, intervinientes,
						null);

				if (listDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailSede;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				List<DatosMailSede> listDatosMailSede = null;

				Saninterv saninterv = new Saninterv();
				saninterv.setUaescodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

				listDatosMailSede = this.sanexpService.findAllMailEstablecimientoSede(tramiteComun, saninterv, null);

				if (listDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailSede;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				List<DatosMailSede> listDatosMailSede = null;

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaescodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

				listDatosMailSede = this.arbexpService.findAllMailEstablecimientoSede(tramiteComun, arbinterv, null);

				if (listDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailSede;

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				List<DatosMailSede> listDatosMailSede = this.arbadhsolService.findAllMailEstablecimientoSede(
						tramiteComun, new String(Y41bUtilsDokusi.decode(escodigo)), null);

				if (listDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailSede;
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				List<DatosMailSede> listDatosMailSede = null;

				listDatosMailSede = this.denunciaService.findAllMailEstablecimientoSede(tramiteComun, intervinientes,
						null);

				if (listDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listDatosMailSede;
			} else {
				List<DatosMailSede> listDatosMailSede = null;

				return listDatosMailSede;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEstablecimientoSedeMail'.
	 * 
	 * @param escodigo
	 *            String
	 * @param idDatomail
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/establecimientosedemail/{escodigo}/{idDatomail}", method = RequestMethod.GET)
	public @ResponseBody() Object getEstablecimientoSedeMail(@PathVariable() String escodigo,
			@PathVariable() String idDatomail, @ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {

			DatosMailSede datosMailSede = new DatosMailSede();
			datosMailSede.setIdDatomail(idDatomail);
			datosMailSede.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				datosMailSede = this.denunciaService.findMailEstablecimientoSede(tramiteComun, datosMailSede);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				datosMailSede = this.sanexpService.findMailEstablecimientoSede(tramiteComun, datosMailSede);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				datosMailSede = this.arbexpService.findMailEstablecimientoSede(tramiteComun, datosMailSede);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				datosMailSede = this.arbadhsolService.findMailEstablecimientoSede(tramiteComun, datosMailSede);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				datosMailSede = this.instramexpService.findMailEstablecimientoSede(tramiteComun, datosMailSede);
			}

			if (datosMailSede == null) {
				throw new Exception("No data Found. /establecimientomail/{idDatomail}");
			} else {
				return datosMailSede;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /establecimientomail/{idDatomail}");
		}
	}

	// EVOLUTIVO 134898 2.2
	@RequestMapping(value = "/textoObservaciones/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody() String getTextoObservaciones(@PathVariable() String sacodigo,
			@ModelAttribute(value = "tramiteComunicacion") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			Arbexp arbexp = new Arbexp(sacodigo);
			arbexp = this.arbexpService.find(arbexp);

			if (arbexp != null && arbexp.getExdesces() != null) {
				return arbexp.getExdesces();
			} else {
				return "";
			}
		} catch (Exception e) {
			throw new Y41bUDAException();
		}
	}
}
