package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteCierre")
@SessionAttributes({ "tramiteCierre", "modoCierre" })
public class TramiteCierreController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteCierreController.class);

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ExpedienService expedienService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private ArbtramexpService arbtramexpService;
	@Autowired
	private SolarbService solarbService;
	@Autowired
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired
	private ArbtramexpDao arbtramexpDao;
	@Autowired
	private ArbadhtramService arbadhtramService;
	@Autowired
	private ArbadhsolService arbadhsolService;
	@Autowired
	private ArbdoctempService arbdoctempService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(santramexpService.getNewPK().toString());
			tramiteComun
					.setIdTipoTramite(Y41bConstantes.TRAMITE_SANCIONES_CIERRE);
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun
					.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null
				&& codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi
						.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
			tramiteComun
					.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());

			// Validacin: si existe tramite de audiencia, debe existir tramite
			// de
			// pago laudo
			Arbtramexp tramiteAudiencia = new Arbtramexp();
			tramiteAudiencia.setSolarb(new Solarb(tramiteComun
					.getIdExpediente()));
			tramiteAudiencia
					.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			tramiteAudiencia
					.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			long cont = this.arbtramexpDao.findAllCount(tramiteAudiencia);
			if (cont > 0L) {
				Arbtramexp tramitePagoLaudo = new Arbtramexp();
				tramitePagoLaudo.setSolarb(new Solarb(tramiteComun
						.getIdExpediente()));
				tramitePagoLaudo
						.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
				tramitePagoLaudo
						.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				cont = this.arbtramexpDao.findAllCount(tramitePagoLaudo);
				if (cont > 0L) {
					model.addAttribute("audienciaSinPagoLaudo",
							Y41bConstantes.VALOR_NO);
				} else {
					model.addAttribute("audienciaSinPagoLaudo",
							Y41bConstantes.VALOR_SI);
				}
			} else {
				model.addAttribute("audienciaSinPagoLaudo",
						Y41bConstantes.VALOR_NO);
			}

			if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
				// Validacin: si existe tramite de recepcion informe pericial
				// aportado por un arbitro, debe existir tramite
				// de pago pericial colegio
				String tipoDocumento = "";
				Arbdoctemp arbdoc = null;
				boolean hayDocArbitro = false;
				List<Arbdoctemp> documentosAportados = this.arbdoctempService
						.findAllDocumentosTramite(tramiteComun, null);
				if (documentosAportados != null) {
					for (int i = 0; i < documentosAportados.size(); i++) {
						arbdoc = (Arbdoctemp) documentosAportados.get(i);
						tipoDocumento = arbdoc.getX5tipodocumento();
						if (Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL
								.equals(tipoDocumento)
								&& Y41bConstantes.ORIGEN_ARB_APORTADO_ARBITRO
										.equals(arbdoc.getX5origen())) {
							hayDocArbitro = true;
						}
					}
				}

				if (hayDocArbitro) {
					Arbtramexp tramiteRecepInfPericial = new Arbtramexp();
					tramiteRecepInfPericial.setSolarb(new Solarb(tramiteComun
							.getIdExpediente()));
					tramiteRecepInfPericial
							.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL);
					tramiteRecepInfPericial
							.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					cont = this.arbtramexpDao
							.findAllCount(tramiteRecepInfPericial);
					if (cont > 0L) {
						Arbtramexp tramitePagoPericialColegio = new Arbtramexp();
						tramitePagoPericialColegio.setSolarb(new Solarb(
								tramiteComun.getIdExpediente()));
						tramitePagoPericialColegio
								.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO);
						tramitePagoPericialColegio
								.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
						cont = this.arbtramexpDao
								.findAllCount(tramitePagoPericialColegio);
						if (cont > 0L) {
							model.addAttribute(
									"recepcionSinPagoPericialColegio",
									Y41bConstantes.VALOR_NO);
						} else {
							model.addAttribute(
									"recepcionSinPagoPericialColegio",
									Y41bConstantes.VALOR_SI);
						}
					} else {
						model.addAttribute("recepcionSinPagoPericialColegio",
								Y41bConstantes.VALOR_NO);
					}
				} else {
					model.addAttribute("recepcionSinPagoPericialColegio",
							Y41bConstantes.VALOR_NO);
				}
			}
		} else if (codProcedimiento != null
				&& (codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| codProcedimiento
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			tramiteComun.setIdTramite(arbadhtramService.getNewPK().toString());
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteCierre", tramiteComun);
		model.addAttribute("modoCierre", Y41bConstantes.MODO_POPUP_ALTA);
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteCierre", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, @PathVariable String idTramite,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun
					.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (tipoProcedimiento != null
				&& tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(
						Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi
						.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
			// Validacin: si existe tramite de audiencia, debe existir tramite
			// de
			// pago laudo
			Arbtramexp tramiteAudiencia = new Arbtramexp();
			tramiteAudiencia.setSolarb(new Solarb(tramiteComun
					.getIdExpediente()));
			tramiteAudiencia
					.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			tramiteAudiencia
					.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			long cont = this.arbtramexpDao.findAllCount(tramiteAudiencia);
			if (cont > 0L) {
				Arbtramexp tramitePagoLaudo = new Arbtramexp();
				tramitePagoLaudo.setSolarb(new Solarb(tramiteComun
						.getIdExpediente()));
				tramitePagoLaudo
						.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
				tramitePagoLaudo
						.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				cont = this.arbtramexpDao.findAllCount(tramitePagoLaudo);
				if (cont > 0L) {
					model.addAttribute("audienciaSinPagoLaudo",
							Y41bConstantes.VALOR_NO);
				} else {
					model.addAttribute("audienciaSinPagoLaudo",
							Y41bConstantes.VALOR_SI);
				}
			} else {
				model.addAttribute("audienciaSinPagoLaudo",
						Y41bConstantes.VALOR_NO);
			}

			if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
				// Validacin: si existe tramite de recepcion informe pericial
				// aportado por un arbitro, debe existir tramite
				// de pago pericial colegio
				Arbtramexp tramiteRecepInfPericial = new Arbtramexp();
				tramiteRecepInfPericial.setSolarb(new Solarb(tramiteComun
						.getIdExpediente()));
				tramiteRecepInfPericial
						.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL);
				tramiteRecepInfPericial
						.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				cont = this.arbtramexpDao.findAllCount(tramiteRecepInfPericial);
				if (cont > 0L) {
					Arbtramexp tramitePagoPericialColegio = new Arbtramexp();
					tramitePagoPericialColegio.setSolarb(new Solarb(
							tramiteComun.getIdExpediente()));
					tramitePagoPericialColegio
							.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO);
					tramitePagoPericialColegio
							.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					cont = this.arbtramexpDao
							.findAllCount(tramitePagoPericialColegio);
					if (cont > 0L) {
						model.addAttribute("recepcionSinPagoPericialColegio",
								Y41bConstantes.VALOR_NO);
					} else {
						model.addAttribute("recepcionSinPagoPericialColegio",
								Y41bConstantes.VALOR_SI);
					}
				} else {
					model.addAttribute("recepcionSinPagoPericialColegio",
							Y41bConstantes.VALOR_NO);
				}
			}
		} else if (codProcedimiento != null
				&& (codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| codProcedimiento
								.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteCierre", tramiteComun);
		model.addAttribute("modoCierre", Y41bConstantes.MODO_POPUP_MODIFICACION);
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteCierre", "model", model);
	}

	/**
	 * Method 'addCierre'.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoCierre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return TramiteCierre
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody
	TramiteCierre addCierre(@RequestBody TramiteCierre tramiteCierre,
			@ModelAttribute(value = "tramiteCierre") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoCierre") String modoCierre,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			tramiteCierre.setIdTramite(tramiteComun.getIdTramite());
			tramiteCierre.setIdExpediente(tramiteComun.getIdExpediente());
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, false, modoCierre);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.santramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, false, modoCierre);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, false, modoCierre);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, false, modoCierre);
			}

			logger.info("Entity correctly inserted!" + tramiteCierre);
			return tramiteCierre;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'editCierre'.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoCierre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return TramiteCierre
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody
	TramiteCierre editCierre(@RequestBody TramiteCierre tramiteCierre,
			@ModelAttribute(value = "tramiteCierre") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoCierre") String modoCierre,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteCierre.setInstructorEjecucion(censoMonitor);
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteCierre.setFechaFin(todayWithZeroTime);
			tramiteCierre.setIdTramite(tramiteComun.getIdTramite());
			tramiteCierre.setIdExpediente(tramiteComun.getIdExpediente());
			String idioma = locale.getLanguage();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, true, modoCierre);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.santramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, true, modoCierre);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, true, modoCierre);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteCierre(tramiteCierre,
						tramiteComun, idioma, true, modoCierre);

			}
			logger.info("Entity correctly inserted!" + tramiteCierre);
			return tramiteCierre;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteCierreById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteCierre
	 */
	@RequestMapping(value = "/findTramiteCierre/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody
	TramiteCierre getTramiteCierreById(@PathVariable String idTramite,
			@ModelAttribute(value = "tramiteCierre") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			TramiteCierre tramiteCierre = new TramiteCierre();
			tramiteCierre.setIdTramite(idTramite);
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteCierre = this.soltramexpService.findTramiteCierre(
						tramiteCierre, censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {

				tramiteCierre = this.santramexpService.findTramiteCierre(
						tramiteCierre, censoMonitor);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteCierre = this.arbtramexp4Service.findTramiteCierre(
						tramiteCierre, censoMonitor);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_MOD) || tipoProcedimiento
							.getPcodigo().equals(
									Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				tramiteCierre = this.arbadhtramService.findTramiteCierre(
						tramiteCierre, censoMonitor);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo()
							.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES))) {

				tramiteCierre = this.instramexpService.findTramiteCierre(
						tramiteCierre, censoMonitor);

			}
			if (tramiteCierre == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteCierre;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
