package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteAsignacionInstructor;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteAsignacionInstructor")
@SessionAttributes(value = { "tramiteAsignacionInstructor",
		"modoAsignacionInstructor" })
public class TramiteAsignacionInstructorController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteAsignacionInstructorController.class);

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private ActaService actaService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
			model.addAttribute("tipoTramite",
					Y41bConstantes.TIPO_PROC_SOLICITUDES);

		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
			model.addAttribute("tipoTramite",
					Y41bConstantes.TIPO_PROC_INSPECCIONES);

		}
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteAsignacionInstructor", tramiteComun);

		model.addAttribute("modoAsignacionInstructor",
				Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteAsignacionInstructor", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);
		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
			model.addAttribute("tipoTramite",
					Y41bConstantes.TIPO_PROC_SOLICITUDES);

		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
			model.addAttribute("tipoTramite",
					Y41bConstantes.TIPO_PROC_INSPECCIONES);

		}
		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteAsignacionInstructor", tramiteComun);

		model.addAttribute("modoAsignacionInstructor",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteAsignacionInstructor", "model", model);
	}

	/**
	 * Method 'getCreateFormCargaTrabajo'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintCargaTrabajo", method = RequestMethod.GET)
	public ModelAndView getCreateFormCargaTrabajo(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteAsignacionInstructorCargaTrabajo",
				"model", model);
	}

	/**
	 * Method 'editTramiteAsignacionInstructor'.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAsignacionInstructor
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAsignacionInstructor
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody()
	TramiteAsignacionInstructor editTramiteAsignacionInstructor(
			@RequestBody() TramiteAsignacionInstructor tramiteAsignacionInstructor,
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAsignacionInstructor") String modoAsignacionInstructor,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteAsignacionInstructor.setInstructorEjecucion(censoMonitor);

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteAsignacionInstructor.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteAsignacionInstructor(
						tramiteAsignacionInstructor, tramiteComun, idioma,
						true, modoAsignacionInstructor);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				tramiteAsignacionInstructor.setInstructorAsignado(censoMonitor);

				this.instramexpService.addTramiteAsignacionInstructor(
						tramiteAsignacionInstructor, tramiteComun, true,
						modoAsignacionInstructor);
			}

			TramiteAsignacionInstructorController.logger
					.info("Entity correctly inserted!");
			return tramiteAsignacionInstructor;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteAsignacionInstructor'.
	 * 
	 * @param tramiteAsignacionInstructor
	 *            TramiteAsignacionInstructor
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAsignacionInstructor
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAsignacionInstructor
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	TramiteAsignacionInstructor addTramiteAsignacionInstructor(
			@RequestBody() TramiteAsignacionInstructor tramiteAsignacionInstructor,
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAsignacionInstructor") String modoAsignacionInstructor,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteAsignacionInstructor(
						tramiteAsignacionInstructor, tramiteComun, idioma,
						false, modoAsignacionInstructor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				HttpServletRequest httpRequest = (HttpServletRequest) request;
				HttpSession httpSession = httpRequest.getSession(false);
				CensoMonitor censoMonitor = (CensoMonitor) httpSession
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
				tramiteAsignacionInstructor.setInstructorAsignado(censoMonitor);

				this.instramexpService.addTramiteAsignacionInstructor(
						tramiteAsignacionInstructor, tramiteComun, false,
						modoAsignacionInstructor);
			}

			TramiteAsignacionInstructorController.logger
					.info("Entity correctly inserted!");
			return tramiteAsignacionInstructor;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteAsignacionInstructorById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAsignacionInstructor
	 */
	@RequestMapping(value = "/findTramiteAsignacionInstructor/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody()
	TramiteAsignacionInstructor getTramiteAsignacionInstructorById(
			@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			TramiteAsignacionInstructor tramiteAsignacionInstructor = new TramiteAsignacionInstructor();
			tramiteAsignacionInstructor.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				tramiteAsignacionInstructor = this.soltramexpService
						.findTramiteAsignacionInstructor(
								tramiteAsignacionInstructor, censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				tramiteAsignacionInstructor = this.instramexpService
						.findTramiteAsignacionInstructor(
								tramiteAsignacionInstructor, censoMonitor);
			}

			if (tramiteAsignacionInstructor == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteAsignacionInstructor;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCargaTrabajo'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllCargaTrabajo", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllCargaTrabajo(
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {

				List<CargaTrabajo> listCargaTrabajo = null;

				if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listCargaTrabajo = this.soltramexpService
							.getCargatrabajo(censoMonitor);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SANCIONES)) {

				}

				if (listCargaTrabajo == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();
				data.setRows(listCargaTrabajo);
				return data;
			} else {
				List<CargaTrabajo> listCargaTrabajo = null;

				if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listCargaTrabajo = this.soltramexpService
							.getCargatrabajo(censoMonitor);
				} else if (tipoProcedimiento != null
						&& tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(
								Y41bConstantes.TIPO_PROC_SANCIONES)) {

				}

				if (listCargaTrabajo == null) {
					throw new Exception("No data Found.");
				}
				return listCargaTrabajo;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllCensoMonitorAltas'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllCensoMonitorAltas", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllCensoMonitorAltas(
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String organismoCodOrg = censoMonitor.getOrganismo().getCodOrg();

			List<CensoMonitor> censoMonitors = null;

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				if (censoMonitor.getPerfilSolicitudes() != null
						&& censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
						&& censoMonitor.getPerfilSolicitudes().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
					SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
					solicitudDetalle
							.setHdcodigo(tramiteComun.getIdExpediente());

					solicitudDetalle = this.denunciaService.findSolicitud(
							solicitudDetalle, censoMonitor);

					organismoCodOrg = solicitudDetalle.getHccoor();
				}

				CensoMonitor filterCensoMonitor = new CensoMonitor(null, null,
						null, null, null, null, null, new Organismo(
								organismoCodOrg), null, null, null, null, null,
						null, null, null, null, null, null, null, null, null);

				censoMonitors = this.censoMonitorService
						.findAllCensoMonitorAltaAsignacionInstructor(filterCensoMonitor);

			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				if (censoMonitor.getPerfilInspecciones() != null
						&& censoMonitor.getPerfilInspecciones().getIdPerfil() != null
						&& censoMonitor.getPerfilInspecciones().getIdPerfil()
								.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
					Actdec actdec = new Actdec();
					actdec.setAdcoat(tramiteComun.getIdExpediente());
					actdec = this.actaService.findDecisionInspeccion(actdec);

					organismoCodOrg = actdec.getAdcoor();
				}

				CensoMonitor filterCensoMonitor = new CensoMonitor(null, null,
						null, null, null, null, null, new Organismo(
								organismoCodOrg), null, null, null, null, null,
						null, null, null, null, null, null, null, null, null);

				censoMonitors = this.censoMonitorService
						.findAllCensoMonitorAltaSolicitudInspeccion(filterCensoMonitor);
			}

			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCensoMonitorAltas'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllCensoMonitor", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllCensoMonitor(
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor();

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAll(filterCensoMonitor, null);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getTipoSolicitud'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getTipoSolicitud", method = RequestMethod.GET)
	public @ResponseBody()
	SolicitudDetalle getTipoSolicitud(
			@ModelAttribute(value = "tramiteAsignacionInstructor") TramiteComun tramiteComun,
			HttpServletRequest request) {

		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				SolicitudDetalle solicitudDetalleAux = new SolicitudDetalle();
				solicitudDetalleAux.setHdcodigo(tramiteComun.getIdExpediente());

				solicitudDetalleAux = this.denunciaService.findSolicitud(
						solicitudDetalleAux, censoMonitor);
				SolicitudDetalle solicitudDetalleResultado = new SolicitudDetalle();
				solicitudDetalleResultado.setHdcodigo(solicitudDetalleAux
						.getHdcodigo());

				solicitudDetalleResultado.setHdcosc(solicitudDetalleAux
						.getHdcosc());
				return solicitudDetalleResultado;
			} else {
				return null;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TramiteAsignacionInstructorController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
