package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteAnulacionPropuestaSancion;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteAnulacionPropuestaSancionController  
 * 9:11:48.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tramiteAnulacionPropuestaSancion")
@SessionAttributes({ "tramiteAnulacionPropuestaSancion",
		"modoAnulacionPropuestaSancion" })
public class TramiteAnulacionPropuestaSancionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteGenericoController.class);

	@Autowired()
	private SoltramexpService solTramExpService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private InstramexpService instramexpService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente, Model model) {
		TramiteComun tramiteComun = new TramiteComun();

		tramiteComun.setIdExpediente(idExpediente);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			// Si el expediente es una solicitud.
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			// Si el expediente es una inspeccion.
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance()
					.generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteAnulacionPropuestaSancion", tramiteComun);

		model.addAttribute("modoAnulacionPropuestaSancion",
				Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("codProcedimiento", codProcedimiento);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteAnulacionPropuestaSancion", "model",
				model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String idExpediente,
			@PathVariable() String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			// Si el expediente es una solicitud.
			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService
					.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null
				&& codProcedimiento
						.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setNumExpediente(this.instramexpService
					.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(this.instramexpService
					.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("tramiteAnulacionPropuestaSancion", tramiteComun);

		model.addAttribute("modoAnulacionPropuestaSancion",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("codProcedimiento", codProcedimiento);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteAnulacionPropuestaSancion", "model",
				model);
	}

	/**
	 * Method 'editTramiteAnulacionPropuestaSancion'.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteRequerimientoAcreditacionRepresentacion
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody()
	TramiteAnulacionPropuestaSancion editTramiteAnulacionPropuestaSancion(
			@RequestBody() TramiteAnulacionPropuestaSancion tramite,
			@ModelAttribute(value = "tramiteAnulacionPropuestaSancion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAnulacionPropuestaSancion") String modo,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramite.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.solTramExpService.addTramiteAnulacionPropuestaSancion(
						tramite, tramiteComun, idioma, true, modo);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteAnulacionPropuestaSancion(
						tramite, tramiteComun, idioma, true, modo);
			}

			TramiteAnulacionPropuestaSancionController.logger
					.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteAnulacionPropuestaSancion'.
	 * 
	 * @param tramite
	 *            TramiteAnulacionPropuestaSancion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return TramiteRequerimientoAcreditacionRepresentacion
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody()
	TramiteAnulacionPropuestaSancion addTramiteAnulacionPropuestaSancion(
			@RequestBody() TramiteAnulacionPropuestaSancion tramite,
			@ModelAttribute(value = "tramiteAnulacionPropuestaSancion") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAnulacionPropuestaSancion") String modo,
			HttpServletRequest request, Model model) {
		try {

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				this.solTramExpService.addTramiteAnulacionPropuestaSancion(
						tramite, tramiteComun, idioma, false, modo);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				this.instramexpService.addTramiteAnulacionPropuestaSancion(
						tramite, tramiteComun, idioma, false, modo);
			}

			model.addAttribute("modoAnulacionPropuestaSancion",
					Y41bConstantes.MODO_POPUP_MODIFICACION);

			TramiteAnulacionPropuestaSancionController.logger
					.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAnulacionPropuestaSancion
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody()
	TramiteAnulacionPropuestaSancion getTramiteById(
			@PathVariable() String idTramite,
			@ModelAttribute(value = "tramiteAnulacionPropuestaSancion") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();

			TramiteAnulacionPropuestaSancion tramite = new TramiteAnulacionPropuestaSancion();
			tramite.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				tramite = this.solTramExpService
						.findTramiteAnulacionPropuestaSancion(tramite,
								censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				tramite = this.instramexpService
						.findTramiteAnulacionPropuestaSancion(tramite,
								censoMonitor);
			}

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TramiteAnulacionPropuestaSancionController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
