package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbadhtramService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.ArbtipdocService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InspeccionesTipoDocumentoService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.SandoctempService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SantipdocService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.TipoDocumentoService;
import com.ejie.y41b.service.TramiteHechoService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramiteAdjuntarDocs")
@SessionAttributes({ "adjuntardocs", "modoAdjuntarDocs" })
public class TramiteAdjuntarDocsController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteAdjuntarDocsController.class);

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private DenunciaService denunciaService;

	// TipoDocumentoService propio de Solicitudes
	@Autowired
	private TipoDocumentoService tipoDocumentoService;

	@Autowired
	private SantramexpService santramexpService;

	// TipoDocumentoService propio de Sanciones
	@Autowired
	private SantipdocService santipdocService;

	@Autowired
	private AdjuntardocsService adjuntardocsService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private InspeccionesTipoDocumentoService inspeccionesTipoDocumentoService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	@Autowired
	private SanintervService sanintervService;

	@Autowired
	private SandoctempService sandoctempService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired()
	private ArbtramexpService arbtramexpService;

	@Autowired()
	private SolarbService solarbService;
	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired()
	private ArbintervService arbintervService;
	@Autowired()
	private ArbtipdocService arbtipdocService;
	@Autowired()
	private ArbdoctempService arbdoctempService;
	@Autowired()
	private ArbadhsolService arbadhsolService;
	@Autowired()
	private ArbadhtramService arbadhtramService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(santramexpService.getNewPK().toString());
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION);
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("adjuntardocs", tramiteComun);

		model.addAttribute("modoAdjuntarDocs", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteAdjuntarDocs", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		// insertar los documentos en la tabla de documentos temporal
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			this.soltramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(idExpediente);
			solicitudDetalle = this.denunciaService.findNumExpedienteSolicitud(solicitudDetalle);
			tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
			this.santramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

			Expedien expediente = new Expedien();
			expediente.setExcodigo(tramiteComun.getIdExpediente());
			expediente = this.expedienService.find(expediente);
			tramiteComun.setNumExpediente(expediente.getCodCompletoConPrefijo());
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION);
			this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
			try {
				tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbService.find(solarb);
			tramiteComun.setNumExpediente(solarb.getCodCompletoConPrefijo());
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			this.arbadhtramService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);
			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(tramiteComun.getIdExpediente());
			arbadhsol = this.arbadhsolService.find(arbadhsol);
			tramiteComun.setNumExpediente(arbadhsol.getNumExpediente());
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

			tramiteComun.setNumExpediente(this.instramexpService.findNumExpedienteActuacion(idExpediente));
			Locale locale = LocaleContextHolder.getLocale();
			tramiteComun.setOrigenInspeccion(
					this.instramexpService.findOrigenInspeccionPorIdExpediente(idExpediente, locale));
		}

		model.addAttribute("adjuntardocs", tramiteComun);

		model.addAttribute("modoAdjuntarDocs", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("tramiteAdjuntarDocs", "model", model);
	}

	/**
	 * Method 'getCreateFormAdjuntarDocs'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaAdjuntarDocs", method = RequestMethod.GET)
	public ModelAndView getCreateFormAdjuntarDocs(Model model, HttpServletRequest request) {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		// FIXME
		// if (codProcedimiento != null
		// && codProcedimiento
		// .equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
		// SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		// solicitudDetalle.setHdcodigo(idExpediente);
		// solicitudDetalle = this.denunciaService
		// .findNumExpedienteSolicitud(solicitudDetalle);
		// tramiteComun.setNumExpediente(solicitudDetalle.getNumExpediente());
		// }
		model.addAttribute("adjuntardocs", tramiteComun);

		model.addAttribute("modoAdjuntarDocs", Y41bConstantes.MODO_APORTACION_DOCUMENTOS);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("tramiteAdjuntarDocsNormal", "model", model);
	}

	/**
	 * Method 'guardarIdExpediente'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @throws Exception
	 */
	@RequestMapping(value = "/guardarIdExpediente/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public void guardarIdExpediente(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			HttpServletRequest request, Model model) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();

		if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setIdExpediente(idExpediente);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			tramiteComun.setIdTramite(santramexpService.getNewPK().toString());
			tramiteComun.setIdExpediente(idExpediente);
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			tramiteComun.setIdTramite(arbtramexpService.getNewPK().toString());
			tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
		} else if (codProcedimiento != null && codProcedimiento.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			tramiteComun.setIdTramite(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteComun.setIdExpediente(idExpediente);
		}

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("adjuntardocs", tramiteComun);
	}

	/**
	 * Method 'editTramiteAdjuntarDocs'.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAdjuntarDocs
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody TramiteAdjuntarDocs editTramiteAdjuntarDocs(
			@RequestBody TramiteAdjuntarDocs tramiteAdjuntarDocs,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAdjuntarDocs") String modoAdjuntarDocs, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramiteAdjuntarDocs.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramiteAdjuntarDocs.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, true,
						modoAdjuntarDocs);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				this.santramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, true,
						modoAdjuntarDocs);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp2Service.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, true,
						modoAdjuntarDocs);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, true,
						modoAdjuntarDocs);

			}

			logger.info("Entity correctly inserted!");
			return tramiteAdjuntarDocs;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteAdjuntarDocs'.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAdjuntarDocs
	 *            String
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody TramiteAdjuntarDocs addTramiteAdjuntarDocs(
			@RequestBody TramiteAdjuntarDocs tramiteAdjuntarDocs,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAdjuntarDocs") String modoAdjuntarDocs) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				this.soltramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, false,
						modoAdjuntarDocs);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
				this.santramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, false,
						modoAdjuntarDocs);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION);
				this.arbtramexp2Service.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, false,
						modoAdjuntarDocs);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				this.instramexpService.addTramiteAdjuntarDocs(tramiteAdjuntarDocs, tramiteComun, idioma, false,
						modoAdjuntarDocs);

			}

			logger.info("Entity correctly inserted!");
			return tramiteAdjuntarDocs;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteAdjuntarDocsById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findTramiteAdjuntarDocs/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody TramiteAdjuntarDocs getTramiteAdjuntarDocsById(@PathVariable String idTramite,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteAdjuntarDocs tramiteAdjuntarDocs = new TramiteAdjuntarDocs();
			tramiteAdjuntarDocs.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				tramiteAdjuntarDocs = this.soltramexpService.findTramiteAdjuntarDocs(tramiteAdjuntarDocs, censoMonitor);

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
				tramiteAdjuntarDocs = this.santramexpService.findTramiteAdjuntarDocs(tramiteAdjuntarDocs, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramiteAdjuntarDocs = this.arbtramexp2Service.findTramiteAdjuntarDocs(tramiteAdjuntarDocs,
						censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
				tramiteAdjuntarDocs = this.arbadhtramService.findTramiteAdjuntarDocs(tramiteAdjuntarDocs, censoMonitor);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				tramiteAdjuntarDocs = this.instramexpService.findTramiteAdjuntarDocs(tramiteAdjuntarDocs, censoMonitor);

			}

			if (tramiteAdjuntarDocs == null) {
				throw new Exception(idTramite.toString());
			}
			return tramiteAdjuntarDocs;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllAdjuntardocs'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllAdjuntarDocs", method = RequestMethod.GET)
	public @ResponseBody Object getAllAdjuntardocs(@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			// adjuntardocsFilter.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			// adjuntardocsFilter.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);
				}

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocNuevo(adjuntardocsFilter, pagination);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					adjuntardocsFilter.setTrpcodigo(tipoProcedimiento.getPcodigo());
					listAdjuntardocs = this.adjuntardocsService.findAllTipoDocArb(adjuntardocsFilter, pagination);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

					listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				}

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addAdjuntarDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirAdjuntarDocs", method = RequestMethod.POST)
	public @ResponseBody List<Map<String, Object>> addAdjuntarDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String idInterviniente = request.getParameter("idInterviniente");
			String thnumregistroentrada = request.getParameter("thnumregistroentrada");
			String thfechaentrada = request.getParameter("thfecharegentrada");
			String thnumregistroorigen = request.getParameter("thnumregistroorigen");
			String thfecharegistroorigen = request.getParameter("thfecharegistroorigen");
			String idTipodoc = request.getParameter("idTipodoc");
			String thtedesfile = request.getParameter("thtedesfile");

			// insertar los documentos en la tabla de documentos temporal
			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES))) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setIdInterviniente(idInterviniente);
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(idInterviniente);

				intervinientes = this.intervinientesService.find(intervinientes);

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO);
				} else {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS);
				}

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				adjuntardocsAux.setThcodocumento(this.sandoctempService.getNewPK().toString());
				adjuntardocsAux.setIdInterviniente(idInterviniente);
				Saninterv saninterv = new Saninterv();
				saninterv.setUaidinterv(new BigDecimal(idInterviniente));
				saninterv = this.sanintervService.find(saninterv);
				if (saninterv != null
						&& saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE);
				} else if (saninterv != null
						&& saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO);
				} else if (saninterv != null
						&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_OTRO) || saninterv
								.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS_ORIGEN))) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS);
				} else if (saninterv != null
						&& saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE2);
				} else if (saninterv != null
						&& (saninterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO)
								|| saninterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN))) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_ESTABLECIMIENTO);
				} else if (saninterv != null
						&& (saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO)
								|| saninterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO))
						|| saninterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO);
				} else if (saninterv != null && saninterv.getUatipointerv() != null) {
					throw new Y41bUDAException("error.adjuntardocs.origenIncorrecto", true, new Exception());
				}
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				adjuntardocsAux.setIdInterviniente(idInterviniente);
				adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(new BigDecimal(idInterviniente));
				arbinterv = this.arbintervService.find(arbinterv);
				if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_OTRO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE2);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ESTABLECIMIENTO);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_PERITO);
				} else if (arbinterv != null
						&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ARBITRO);
				} else if (arbinterv != null && (arbinterv.getUatipointerv()
						.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
						|| arbinterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
						|| arbinterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR))) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO);
				} else if (arbinterv != null && (arbinterv.getUatipointerv()
						.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
						|| arbinterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)
						|| arbinterv.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR))) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE);
				}
				adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES))) {
				adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

				adjuntardocsAux.setIdInterviniente(idInterviniente);
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(idInterviniente);

				intervinientes = this.intervinientesService.find(intervinientes);

				if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null && intervinientes
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
						&& intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_ADMINISTRACION)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_ADMINISTRACION);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
						&& intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO);
				} else if (intervinientes != null && intervinientes.getTipoInterviniente() != null
						&& intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)) {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE);
				} else {
					adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_INS_APORTADO_OTROS);
				}

			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(idTipodoc);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThnumregistroentrada(thnumregistroentrada);

			Locale locale = LocaleContextHolder.getLocale();
			adjuntardocsAux.setThfechaentrada(Y41bUtils.parseDate(thfechaentrada, locale));

			adjuntardocsAux.setThnumregistroorigen(thnumregistroorigen);
			adjuntardocsAux.setThfecharegistroorigen(Y41bUtils.parseDate(thfecharegistroorigen, locale));

			adjuntardocsAux.setThtedesfile(thtedesfile);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setIdInterviniente(idInterviniente);

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarAdjuntarDocs/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			// j 26/03 realizar un control para comprobar si el documento tiene
			// oid de
			// dokusi, si es asi no dejar eliminarlo
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(thcodocumento);

			try {
				documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);
			} catch (Exception e) {
				documentoHechoDetalle = null;
			}

			if (documentoHechoDetalle != null && documentoHechoDetalle.getQ5iddocumentum() != null
					&& !documentoHechoDetalle.getQ5iddocumentum().equals("")) {
				throw new Y41bUDAException("error.solicitud.documentoRegistroException", true, new Exception());
			}

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteAdjuntarDocs/anyadirAdjuntarDocs/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/tramiteAdjuntarDocs/anyadirAdjuntarDocs/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumentoAdjuntarDocs'.
	 * 
	 * @param thcodocumento
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findAdjuntarDocs/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoAdjuntarDocs(@PathVariable String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento);
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocsSinDocumento(adjuntardocsAux);

			// si est en dokusi, descargar de dokusi
			if (adjuntardocsAux != null && adjuntardocsAux.getThiddocumentum() != null
					&& !adjuntardocsAux.getThiddocumentum().equals("")) {
				// DESCARGA EL DOCUMENTO DEL PIF
				BufferedInputStream bIS = this.y41bPifAdapterService.getFile(adjuntardocsAux.getRutaPif());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
				response.setContentType(adjuntardocsAux.getThcontenttypefile());
				response.setContentLength(adjuntardocsAux.getThsizefile());

				InputStream is = new BufferedInputStream(bIS);

				int read = 0;
				byte[] bytes = new byte[Y41bConstantes.NUM_1024];
				OutputStream os = response.getOutputStream();

				while ((read = is.read(bytes)) != -1) {
					os.write(bytes, 0, read);
				}

				os.flush();
				os.close();
			} else {
				Blob contenido = adjuntardocsAux.getThdatafile();
				// byte[] bContenido = contenido.getBytes(1, (int)
				// contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader("Content-Disposition", "attachment; filename=\""
						+ StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
				response.setContentType(adjuntardocsAux.getThcontenttypefile());
				response.setContentLength(adjuntardocsAux.getThsizefile());
				// response.getOutputStream().write(bContenido);
				Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getRegistroEntrada'.
	 * 
	 * @param idInterviniente
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @return String
	 */
	@RequestMapping(value = "/getRegistroentrada/{idInterviniente}", method = RequestMethod.GET)
	public @ResponseBody RegistroEntrada getRegistroEntrada(@PathVariable String idInterviniente,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			RegistroEntrada registroEntrada = null;

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(idInterviniente);

				registroEntrada = this.soltramexpService.getRegistroEntrada(tramiteComun, intervinientes);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

				registroEntrada = this.santramexpService.getRegistroEntrada(tramiteComun, idInterviniente);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

				registroEntrada = this.arbtramexp2Service.getRegistroEntrada(tramiteComun, idInterviniente);
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(idInterviniente);

				registroEntrada = this.instramexpService.getRegistroEntrada(tramiteComun, intervinientes);
			}

			if (registroEntrada == null) {
				throw new Exception("");
			}
			return registroEntrada;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAdjuntarDocs
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody Object getAllIntervinientes(@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun,
			@ModelAttribute(value = "modoAdjuntarDocs") String modoAdjuntarDocs, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			List<Intervinientes> listIntervinientes = null;

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());

			Pagination pagination = null;
			Long total = new Long(0);
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, pagination);
					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

					/*
					 * listIntervinientes = this.sanintervService
					 * .findAllIntervinientes(intervinientes, pagination); if
					 * (listIntervinientes == null) { throw new
					 * Exception("No data Found."); } total =
					 * this.intervinientesService .findAllCount(intervinientes);
					 */

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, pagination);
					if (listIntervinientes == null) {
						throw new Exception("No data Found.");
					}
					total = this.intervinientesService.findAllCount(intervinientes);
				}
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listIntervinientes);
				return data;
			} else {
				if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

					listIntervinientes = this.sanintervService.findAllIntervinientes(intervinientes, null);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

					// 0171878: Evolutivo Arbitraje Febrero 2021
					// sacamos solo los activos y ponemos aniadimos una A en los
					// nombres
					intervinientes.setActivos("S");

					listIntervinientes = this.arbintervService.findAllIntervinientes(intervinientes, null);

					for (Intervinientes intervinientesAux : listIntervinientes) {
						StringBuffer nombre = new StringBuffer();
						if (intervinientesAux.getNombre() != null && !intervinientesAux.getNombre().equals("")
								&& intervinientesAux.getTipoInterviniente().equals("B")) {
							nombre.append(intervinientesAux.getNombre());
							nombre.append(" (A)");
						} else {
							nombre.append(intervinientesAux.getNombre());
						}
						intervinientesAux.setNombre(nombre.toString());
					}
					// 0171878

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
					listIntervinientes = this.arbadhsolService.findAllIntervinientes(tramiteComun);

				} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
						&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					listIntervinientes = this.intervinientesService.findAllInspecciones(intervinientes, null);
				}
				if (listIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listIntervinientes;
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTipoDocumentos'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List
	 */
	@RequestMapping(value = "/findAllTipoDocumento", method = RequestMethod.GET)
	public @ResponseBody List<TipoDocumento> getAllTipoDocumento(
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun) {
		TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
		if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			return this.tipoDocumentoService.findAll(new TipoDocumento(), null);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			Santipdoc santipdoc = new Santipdoc();
			santipdoc.setTdtipo(Y41bConstantes.TIPO_DOCUMENTO_SANCIONES_ENTRADA);
			return this.santipdocService.findAllTipoDocumento(santipdoc, null);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			Arbtipdoc arbtipdoc = new Arbtipdoc();
			arbtipdoc.setTdtipo(Y41bConstantes.TIPO_DOCUMENTO_ARBITRAJE_ENTRADA);
			arbtipdoc.setTdpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			return this.arbtipdocService.findAllTipoDocumento(arbtipdoc, null);
		} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
				&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return this.inspeccionesTipoDocumentoService.findAllTipoDocumento(new InspeccionesTipoDocumento(), null);
		}
		return null;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'comprobarOrganismoAdministracion'.
	 * 
	 * @param idInterviniente
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/comprobarOrganismoAdministracion/{idInterviniente}", method = RequestMethod.GET)
	public @ResponseBody() boolean comprobarOrganismoAdministracion(@PathVariable() String idInterviniente,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			boolean resultado = false;

			Intervinientes interviniente = new Intervinientes();
			interviniente.setIdinterviniente(idInterviniente);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				interviniente = this.denunciaService.findInterviniente(interviniente);

				if (interviniente != null && interviniente.getTipoInterviniente() != null && interviniente
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTESOL_ADMINISTRACION)) {
					resultado = true;
				}
			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& (tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
							|| tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

			} else if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				interviniente = this.denunciaService.findInterviniente(interviniente);

				if (interviniente != null && interviniente.getTipoInterviniente() != null && interviniente
						.getTipoInterviniente().equals(Y41bConstantes.TIPO_INTERVINIENTE_INS_ADMINISTRACION)) {
					resultado = true;
				}
			}

			return resultado;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /interviniente/{idInterviniente}");
		}
	}

	/**
	 * Method 'findEstadoRegistroSolicitud'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/findEstadoRegistroSolicitud/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody() TramiteHecho findEstadoRegistroSolicitud(@PathVariable() String hdcodigo,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletRequest request) {
		try {

			TramiteHecho tramitehecho = new TramiteHecho();

			tramitehecho.setEhcohd(hdcodigo);
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);

			return this.tramiteHechoService.findTramiteRegistroSolicitud(tramitehecho);

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found. /findEstadoRegistroSolicitud/{hdcodigo}");
		}
	}

}
