package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteARBRecepcionSubsanacion;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite)
@SessionAttributes({ Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite, Y41bConstantes.MODOTRAMITES_TRAMITE_K54 })
public class TramiteARBRecepcionSubsanacionController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteARBRecepcionSubsanacionController.class);

	@Autowired
	private ArbtramexpService arbtramexpService;

	@Autowired
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired()
	private SolarbService solarbService;

	@Autowired
	private Properties appConfiguration;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private ArbintervService arbintervService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) throws Exception {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
		tramiteComun.setIdTramite(this.arbtramexpService.getNewPK().toString());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbService.find(solarb);
		tramiteComun.setNumExpediente(solarb.damecodCompletoPlatea());
		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION);

		model.addAttribute("tramiteARBRecepcionSubsanacion", tramiteComun);

		model.addAttribute("modoARBRecepcionSubsanacion", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite, "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbService.find(solarb);
		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION);
		tramiteComun.setNumExpediente(solarb.damecodCompletoPlatea());

		model.addAttribute("tramiteARBRecepcionSubsanacion", tramiteComun);

		model.addAttribute("modoARBRecepcionSubsanacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite, "model", model);
	}

	/**
	 * Method 'editTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteARBRecepcionSubsanacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoARBRecepcionSubsanacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteARBRecepcionSubsanacion editTramite(
			@RequestBody() TramiteARBRecepcionSubsanacion tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54) String modoARBRecepcionSubsanacion,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramite.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexpService.addTramiteRecepcionSubsanacion(tramite, tramiteComun, idioma, true,
						modoARBRecepcionSubsanacion);
			}

			TramiteARBRecepcionSubsanacionController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteARBRecepcionSubsanacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoARBRecepcionSubsanacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteARBRecepcionSubsanacion addTramite(
			@RequestBody() TramiteARBRecepcionSubsanacion tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54) String modoARBRecepcionSubsanacion,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramite.setInstructorEjecucion(censoMonitor);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexpService.addTramiteRecepcionSubsanacion(tramite, tramiteComun, idioma, false,
						modoARBRecepcionSubsanacion);
			}

			TramiteARBRecepcionSubsanacionController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteARBRecepcionSubsanacion
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteARBRecepcionSubsanacion getTramiteById(@PathVariable() String idTramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteARBRecepcionSubsanacion tramite = new TramiteARBRecepcionSubsanacion();
			tramite.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramite = this.arbtramexpService.findTramiteRecepcionSubsanacion(tramite, censoMonitor);
			}

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramite(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String thcodocumento,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllIntervinientes'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoAdjuntarDocs
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllIntervinientes", method = RequestMethod.GET)
	public @ResponseBody Object getAllIntervinientes(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
		StringBuffer tipo = new StringBuffer("");
		tipo.append("'").append(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE).append("',");
		tipo.append("'").append(Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR);
		tipo.append("'");
		intervinientes.setTipoInterviniente(tipo.toString());
		return this.arbintervService.findAllIntervinientes(intervinientes, null);
	}

	/**
	 * Method 'adjuntarDocsTramiteRecepcionOrdenConsejero'.
	 * 
	 * @param tramiteSANRecepcionOrdenConsejero
	 *            TramiteSANRecepcionOrdenConsejero
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramite(@RequestBody() TramiteARBRecepcionSubsanacion tramiteARBRecepcionSubsanacion,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K54_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			List<DocumentoExpediente> listDocumentoExpediente = tramiteARBRecepcionSubsanacion
					.getDocumentosExpediente();
			this.arbtramexp2Service.addDocumentosTableTemporal(listDocumentoExpediente, tramiteComun);

			TramiteARBRecepcionSubsanacionController.logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
