package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.BandejaFirmaArbitrajeDao;

import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;

import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentosFirmaArbitros;
import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteARBLaudo;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ArbdoctempService;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.ArbitroService;
import com.ejie.y41b.service.Arbtramexp2Service;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.BandejaFirmaService;
import com.ejie.y41b.service.DocumentosFirmaArbitrosService;
import com.ejie.y41b.service.DocumentosFirmaArbitrosTempService;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.service.SolarbService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite)
@SessionAttributes({ Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite, Y41bConstantes.MODOTRAMITES_TRAMITE_K70 })
public class TramiteARBLaudoController {

	private static final Logger logger = LoggerFactory.getLogger(TramiteARBLaudoController.class);

	@Autowired
	private ArbtramexpService arbtramexpService;

	@Autowired
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired
	private Arbtramexp4Service arbtramexp4Service;

	@Autowired()
	private SolarbService solarbService;

	@Autowired
	private Properties appConfiguration;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired()
	private ArbdoctempService arbdoctempService;

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private OrganismoDao organismoDao;

	@Autowired()
	private BandejaFirmaArbitrajeDao bandejaFirmaArbitrajeService;

	@Autowired()
	private ArbitroService arbitroService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;
	@Autowired
	private ArbexpService arbexpService;

	@Autowired
	private DocumentosFirmaArbitrosTempService documentosFirmaArbitrosTempService;

	@Autowired
	private DocumentosFirmaArbitrosService documentosFirmaArbitrosService;

	@Autowired
	private BandejaFirmaService bandejaFirmaService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			Model model) throws Exception {
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
		tramiteComun.setIdTramite(this.arbtramexpService.getNewPK().toString());

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbService.find(solarb);
		tramiteComun.setNumExpediente(solarb.damecodCompletoPlatea());
		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);

		model.addAttribute("tramiteARBLaudo", tramiteComun);

		model.addAttribute("modoARBLaudo", Y41bConstantes.MODO_POPUP_ALTA);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		String valor = Y41bConstantes.NO;
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpService.find(arbexp);

		Organismo orgOrigen = new Organismo();
		if (arbexp != null && arbexp.getExcoorg() != null) {
			orgOrigen.setCodOrg(arbexp.getExcoorg());

			orgOrigen = this.organismoDao.findOrganismoByCodOrg(orgOrigen);

			if (orgOrigen != null) {
				arbinterv.setUaentidadId(orgOrigen.getEntidadId());
			}

			Arbinterv arbintervAux = arbinterv;
			arbintervAux = this.arbintervDao.findOrganismoOrigen(arbintervAux);
			if (arbintervAux == null) {
				// Se aade el organismo origen a intervinientes para poder
				// notificar/comunicar
				// arbinterv.setUanombre(orgOrigen.getNombreEs());
				// arbinterv.setUanif(orgOrigen.getCif());
				// arbinterv.setUanrtel(orgOrigen.getTelefono());
				// arbinterv.setUanrtel2(null);
				// arbinterv.setUaprovId(orgOrigen.getNoraProvinciaId());
				// arbinterv.setUamunId(orgOrigen.getNoraMunicipioId());
				// arbinterv.setUalocId(orgOrigen.getNoraLocalidadId());
				// arbinterv.setUacalleId(orgOrigen.getNoraCalleId());
				// arbinterv.setUacpId(orgOrigen.getNombreCp());
				// arbinterv.setUaportalId(orgOrigen.getNoraPortalId());
				// arbinterv.setUanombrePiso(orgOrigen.getCompleDirec());
				// if (Y41bUtils
				// .esNullOCadenaVacia(orgOrigen.getNoraProvinciaId())
				// || (!Y41bConstantes.ARABA.equals(orgOrigen
				// .getNoraProvinciaId())
				// && !Y41bConstantes.BIZKAIA.equals(orgOrigen
				// .getNoraProvinciaId()) && !Y41bConstantes.GIPUZKOA
				// .equals(orgOrigen.getNoraProvinciaId()))) {
				// arbinterv.setUadireNocapv(orgOrigen.getNombreCalle());
				// }
				// arbinterv.setUadireAnt(orgOrigen.getCompleDirec());
				// if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraPaisId()))
				// {
				// arbinterv.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
				// } else {
				// arbinterv.setUapaisId(orgOrigen.getNoraPaisId());
				// }
				// arbinterv.setUaurl(orgOrigen.getUrl());
				// arbinterv.setUacoem(orgOrigen.getEmail());
				//
				// arbinterv = this.arbintervDao.add(arbinterv);
			} else {
				arbinterv = arbintervAux;
			}

			if (arbinterv != null) {
				if (!(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI.equals(orgOrigen.getCodOrg()))) {
					valor = Y41bConstantes.SI;
				}
			}
		}

		// List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv,
		// null);
		// if (larbinterv != null && larbinterv.size() > 0) {
		// Organismo organismo = new Organismo();
		// for (int i = 0; i < larbinterv.size(); i++) {
		// arbinterv = larbinterv.get(i);
		// organismo.setEntidadId(arbinterv.getUaentidadId());
		// organismo = this.organismoDao.findOrganismoById(organismo);
		// if (!(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA
		// .equals(organismo.getEntidadId()) ||
		// Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI
		// .equals(organismo.getCodOrg()))) {
		// valor = Y41bConstantes.SI;
		// break;
		// }
		// }
		// }
		model.addAttribute("mostrarDivNotComOtros", valor);

		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite, "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "maintMod/{codProcedimiento}/{idExpediente}/{idTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable String codProcedimiento, @PathVariable String idExpediente,
			@PathVariable String idTramite, Model model) throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(new String(Y41bUtilsDokusi.decode(idExpediente)));
		tramiteComun.setIdTramite(idTramite);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);
		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbService.find(solarb);
		tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
		tramiteComun.setNumExpediente(solarb.damecodCompletoPlatea());

		model.addAttribute("tramiteARBLaudo", tramiteComun);

		model.addAttribute("modoARBLaudo", Y41bConstantes.MODO_POPUP_MODIFICACION);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		String valor = Y41bConstantes.NO;
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpService.find(arbexp);

		Organismo orgOrigen = new Organismo();
		if (arbexp != null && arbexp.getExcoorg() != null) {
			orgOrigen.setCodOrg(arbexp.getExcoorg());

			orgOrigen = this.organismoDao.findOrganismoByCodOrg(orgOrigen);

			if (orgOrigen != null) {
				arbinterv.setUaentidadId(orgOrigen.getEntidadId());
			}

			Arbinterv arbintervAux = arbinterv;
			arbintervAux = this.arbintervDao.findOrganismoOrigen(arbintervAux);
			if (arbintervAux == null) {
				// Se aade el organismo origen a intervinientes para poder
				// notificar/comunicar
				// arbinterv.setUanombre(orgOrigen.getNombreEs());
				// arbinterv.setUanif(orgOrigen.getCif());
				// arbinterv.setUanrtel(orgOrigen.getTelefono());
				// arbinterv.setUanrtel2(null);
				// arbinterv.setUaprovId(orgOrigen.getNoraProvinciaId());
				// arbinterv.setUamunId(orgOrigen.getNoraMunicipioId());
				// arbinterv.setUalocId(orgOrigen.getNoraLocalidadId());
				// arbinterv.setUacalleId(orgOrigen.getNoraCalleId());
				// arbinterv.setUacpId(orgOrigen.getNombreCp());
				// arbinterv.setUaportalId(orgOrigen.getNoraPortalId());
				// arbinterv.setUanombrePiso(orgOrigen.getCompleDirec());
				// if (Y41bUtils
				// .esNullOCadenaVacia(orgOrigen.getNoraProvinciaId())
				// || (!Y41bConstantes.ARABA.equals(orgOrigen
				// .getNoraProvinciaId())
				// && !Y41bConstantes.BIZKAIA.equals(orgOrigen
				// .getNoraProvinciaId()) && !Y41bConstantes.GIPUZKOA
				// .equals(orgOrigen.getNoraProvinciaId()))) {
				// arbinterv.setUadireNocapv(orgOrigen.getNombreCalle());
				// }
				// arbinterv.setUadireAnt(orgOrigen.getCompleDirec());
				// if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraPaisId()))
				// {
				// arbinterv.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
				// } else {
				// arbinterv.setUapaisId(orgOrigen.getNoraPaisId());
				// }
				// arbinterv.setUaurl(orgOrigen.getUrl());
				// arbinterv.setUacoem(orgOrigen.getEmail());
				//
				// arbinterv = this.arbintervDao.add(arbinterv);
			} else {
				arbinterv = arbintervAux;
			}

			if (arbinterv != null) {
				if (!(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA.equals(orgOrigen.getEntidadId())
						|| Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI.equals(orgOrigen.getCodOrg()))) {
					valor = Y41bConstantes.SI;
				}
			}
		}

		// List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv,
		// null);
		// if (larbinterv != null && larbinterv.size() > 0) {
		// Organismo organismo = new Organismo();
		// for (int i = 0; i < larbinterv.size(); i++) {
		// arbinterv = larbinterv.get(i);
		// organismo.setEntidadId(arbinterv.getUaentidadId());
		// organismo = this.organismoDao.findOrganismoById(organismo);
		// if (!(Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA
		// .equals(organismo.getEntidadId())
		// || Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA
		// .equals(organismo.getEntidadId()) ||
		// Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI
		// .equals(organismo.getCodOrg()))) {
		// valor = Y41bConstantes.SI;
		// break;
		// }
		// }
		// }
		model.addAttribute("mostrarDivNotComOtros", valor);

		this.arbtramexp2Service.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

		// 0155021 tratamos los documentos a firmar de arbitros temporales
		this.arbtramexp2Service.addTramiteAdjuntarDocsFirmaArbitrosTemporal(tramiteComun);
		// 0155021
		return new ModelAndView(Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite, "model", model);
	}

	/**
	 * Method 'editTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteARBLaudo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoARBLaudo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/tramitar", method = RequestMethod.PUT)
	public @ResponseBody() TramiteARBLaudo editTramite(@RequestBody() TramiteARBLaudo tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70) String modoARBLaudo,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			tramite.setInstructorEjecucion(censoMonitor);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			tramite.setFechaFin(todayWithZeroTime);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteLaudo(tramite, tramiteComun, idioma, true, modoARBLaudo);
			}

			TramiteARBLaudoController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addTramiteGenerico'.
	 * 
	 * @param tramite
	 *            TramiteARBLaudo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoARBLaudo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteAdjuntarDocs
	 */
	@RequestMapping(value = "/guardar", method = RequestMethod.POST)
	public @ResponseBody() TramiteARBLaudo addTramite(@RequestBody() TramiteARBLaudo tramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70) String modoARBLaudo,
			HttpServletRequest request) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			tramite.setInstructorEjecucion(censoMonitor);

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbtramexp4Service.addTramiteLaudo(tramite, tramiteComun, idioma, false, modoARBLaudo);
			}

			TramiteARBLaudoController.logger.info("Entity correctly inserted!");
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getTramiteGenericoById'.
	 * 
	 * @param idTramite
	 *            String
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return TramiteARBLaudo
	 */
	@RequestMapping(value = "/findTramite/{idTramite}", method = RequestMethod.GET)
	public @ResponseBody() TramiteARBLaudo getTramiteById(@PathVariable() String idTramite,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			TramiteARBLaudo tramite = new TramiteARBLaudo();
			tramite.setIdTramite(idTramite);

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				tramite = this.arbtramexp4Service.findTramiteLaudo(tramite, censoMonitor);
			}

			if (tramite == null) {
				throw new Exception(idTramite.toString());
			}
			return tramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllDocsTramiteAcuerdoIncoacion'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsTramite(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsFilter.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				// 0155021 miramos por cada linea que se pinta si es instructor,
				// si lo
				// es y el documento esta en las tablas de Documentos
				// FirmaArbitros cambiamos el perfil por el de arbitros solo
				// para
				// mostrar
				if (listAdjuntardocs != null) {
					for (Adjuntardocs linea : listAdjuntardocs) {
						if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(linea.getPerfil().getIdPerfil())) {
							DocumentosFirmaArbitros doc1 = new DocumentosFirmaArbitros();
							doc1.setIddocumentosfirmaarb(linea.getThcodocumento());
							doc1 = this.documentosFirmaArbitrosService.find(doc1);
							DocumentosFirmaArbitrosTemp doc2 = new DocumentosFirmaArbitrosTemp();
							doc2.setIddocumentosfirmaarbtemp(linea.getThcodocumento());
							doc2 = this.documentosFirmaArbitrosTempService.find(doc2);
							if (null != doc1 || null != doc2) {
								BandejaFirmaArbitraje bandeja = new BandejaFirmaArbitraje();
								bandeja.setCodocumento(linea.getThcodocumento());
								bandeja.setIdtramitehecho(tramiteComun.getIdTramite());

								List<BandejaFirmaArbitraje> listaFirmas = this.bandejaFirmaArbitrajeService
										.findAllLike(bandeja, null, false);

								if (listaFirmas.isEmpty()) {
									linea.setPerfil(
											new Perfil(Y41bConstantes.PERFIL_FIRMA_ARBITRO, "Arbitros", "Arbitroak"));
								} else {
									linea.setPerfil(
											new Perfil(Y41bConstantes.PERFIL_FIRMA_ARBITRO, "ArbitrosC", "ArbitroakC"));
								}

								// metemos la observacion para poder sacarla en
								// el tittle del grid
								String observacion = this.bandejaFirmaService.findObservacionesBandejaFirmaArbitraje(
										linea.getThcodocumento(), tramiteComun.getIdTramite());
								linea.setThcontenttypefile(observacion);

							}
						}
					}
				}
				// 0155021

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPlantillasTramite'.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllPlantilla", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPlantillasTramite(
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();

			Tramite tramite = new Tramite();

			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			plantillaTramite.setPcodigo(tipoProcedimiento.getPcodigo());
			tramite.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
			plantillaTramite.setTramite(tramite);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.plantillaTramiteService.findAllPlantillaTramiteCount(plantillaTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listPlantillaTramiteBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = null;

				listPlantillaTramiteBusqueda = this.plantillaTramiteService.findAllPlantillaTramite(plantillaTramite,
						pagination);

				if (listPlantillaTramiteBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return listPlantillaTramiteBusqueda;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaNotificacion'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/addPlantilla", method = RequestMethod.POST)
	public @ResponseBody() void addPlantilla(@RequestBody() Adjuntardocs adjuntardocs,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			TipoProcedimiento tipoProcedimiento = tramiteComun.getTipoProcedimiento();

			if (tipoProcedimiento != null && tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				adjuntardocs.setThdestino(adjuntardocs.getThdestino().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_TODOS)
						? "" : adjuntardocs.getThdestino());
				this.arbexpService.addPlantilla(adjuntardocs, tramiteComun, Y41bConstantes.TIPO_DOC_ARB_LAUDO);
			}

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoAcuerdoIncoacion'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDoc/{thcodocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumento(@PathVariable() String thcodocumento,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			// byte[] bContenido = contenido.getBytes(1, (int)
			// contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			// response.getOutputStream().write(bContenido);
			Y41bUtils.copyStream(contenido.getBinaryStream(), response.getOutputStream());

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addDocsTramite'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/anyadirDocsTramite", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addDocsTramite(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite) TramiteComun tramiteComun,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String thtedesfile = request.getParameter("thtedesfile");
			String thdestino = (request.getParameter("thdestino").equals(Y41bConstantes.TIPO_INTERVINIENTEARB_TODOS))
					? "" : request.getParameter("thdestino");

			String requiereFirma = request.getParameter("requiereFirma");
			String rolFirma = null;
			if (requiereFirma != null && requiereFirma.equals("on")) {
				rolFirma = request.getParameter("rolFirma");
				requiereFirma = Y41bConstantes.SI;
			} else {
				requiereFirma = Y41bConstantes.NO;
			}

			adjuntardocsAux.setThcodocumento(this.arbdoctempService.getNewPK().toString());
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);

			if (Y41bConstantes.SI.equals(requiereFirma)) {
				// 0155021 aadimos un registro a la tabla temporal
				if (Y41bConstantes.PERFIL_FIRMA_ARBITRO.equals(rolFirma)) {
					DocumentosFirmaArbitrosTemp documento = new DocumentosFirmaArbitrosTemp();
					documento.setIddocumentosfirmaarbtemp(adjuntardocsAux.getThcodocumento());
					this.documentosFirmaArbitrosTempService.add(documento);
					rolFirma = Y41bConstantes.PERFIL_INSTRUCTOR;
				}
				// 0155021

				Perfil perfilFirma = new Perfil();
				perfilFirma.setIdPerfil(rolFirma);
				adjuntardocsAux.setPerfil(perfilFirma);
				adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
				adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			}

			TipoDocumento tipoDocumento = new TipoDocumento();
			tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ARB_LAUDO);

			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			adjuntardocsAux.setThtedesfile(thtedesfile);
			adjuntardocsAux.setThdestino(thdestino);

			// Blob blob = new SerialBlob(file.getBytes());
			// adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThdatafileinputstream(file.getInputStream());
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());
			adjuntardocsAux.setThfecha(new Date());
			adjuntardocsAux.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			TramiteARBLaudoController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param thcodocumento
	 *            Long
	 * @param tramiteComun
	 *            TramiteComun
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarDocsTramite/{thcodocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String thcodocumento,
			@ModelAttribute(value = "adjuntardocs") TramiteComun tramiteComun, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThidExpediente(tramiteComun.getIdExpediente());
			adjuntardocsAux.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocsAux.setThcodocumento(thcodocumento.toString());
			adjuntardocsAux.setTipoProcedimiento(tramiteComun.getTipoProcedimiento());

			this.adjuntardocsService.remove(adjuntardocsAux);

			// 0155021 eliminamos de la tabla temporal solo si estan pendientes,
			// si no que no puedan descargarse el documento
			if (Y41bConstantes.PORTAFIRMAS_ARBITROS_HABILITADO) {
				DocumentosFirmaArbitrosTemp documento = new DocumentosFirmaArbitrosTemp();
				documento.setIddocumentosfirmaarbtemp(adjuntardocsAux.getThcodocumento());
				this.documentosFirmaArbitrosTempService.remove(documento);

			}
			// 0155021
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * Metodos para la Gestion de Tabla de Docs Fin
	 * 
	 */

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41bVistaWar/" + Y41bConstantes.MODOTRAMITES_TRAMITE_K70_idTramite + "/guardar/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	@RequestMapping(value = "/verFirmas/{thccodocumento}/{thidTramite}", method = RequestMethod.GET)
	public ModelAndView getCreateVerFirmasMod(@PathVariable String thccodocumento, @PathVariable String thidTramite,
			Model model) throws Exception {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		BandejaFirmaArbitraje bandeja = new BandejaFirmaArbitraje();
		bandeja.setCodocumento(thccodocumento);
		bandeja.setIdtramitehecho(thidTramite);

		List<BandejaFirmaArbitraje> listaFirmas = this.bandejaFirmaArbitrajeService.findAllLike(bandeja, null, false);

		if (!listaFirmas.isEmpty()) {
			bandeja = listaFirmas.get(0);

			Solarb expDetalle = new Solarb();
			expDetalle.setSacodigo(bandeja.getIdexpediente());

			BandejaFirmaArbitraje bandejaArbitro = new BandejaFirmaArbitraje();
			bandejaArbitro.setCodocumento(thccodocumento);
			bandejaArbitro.setIdtramitehecho(thidTramite);

			expDetalle = this.solarbService.find(expDetalle);
			Arbtramexp organoColegioArbitral = new Arbtramexp();
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			Map<String, Object> mapaOrganoColegioArbitral = new HashMap<String, Object>();
			String dateFormat = "";
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				dateFormat = Y41bConstantes.FORMATO_FECHA_EU;
			} else {
				dateFormat = Y41bConstantes.FORMATO_FECHA_ES;
			}
			// sacar los datos del ltimo que est resuelto
			organoColegioArbitral.setSolarb(expDetalle);

			organoColegioArbitral.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			organoColegioArbitral.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			Pagination pagination = new Pagination();
			pagination.setSort("trfecfin");
			pagination.setAscDsc("desc");

			List<Arbtramexp> lista = this.arbtramexpService.findAll(organoColegioArbitral, pagination);

			if (lista != null && lista.size() > 0) {
				mapaOrganoColegioArbitral = this.arbtramexp2Service.cargaDatosColegioArbitral(expDetalle,
						organoColegioArbitral, lista, mapaOrganoColegioArbitral, dateFormat);
			}
			String trintica = "";
			String activo = "";
			for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
				if ("trintica".equals(entry.getKey())) {
					trintica = entry.getValue().toString();
				}
			}
			// dependiendo de si es 1 arbitro o 3
			// si es 3 cojo el presi el consumidor y el
			// empresarial
			// si es 1 solo cojo el presi
			// hay que mirar a ver si esta activo o no oara
			// cojer el
			// titular o el suplente
			if ("3".equals(trintica)) {
				for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
					if ("activopresi".equals(entry.getKey())) {
						activo = entry.getValue().toString();
						if ("S".equals(activo)) {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codpresi".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						} else {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codpresisupl".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						}
					}
				}
				Arbitro arbitro1 = new Arbitro();
				arbitro1.setArcodigo(bandejaArbitro.getArcodigo());
				arbitro1 = this.arbitroService.find(arbitro1);
				if (null != arbitro1) {
					model.addAttribute("nombreArbitro1", arbitro1.getArnombre());

					List<BandejaFirmaArbitraje> listaArbitro = this.bandejaFirmaArbitrajeService
							.findAllLike(bandejaArbitro, null, false);

					if (!listaArbitro.isEmpty()) {
						bandejaArbitro = listaArbitro.get(0);
						model.addAttribute("estadoArbitro1", bandejaArbitro.getEstado());
						model.addAttribute("observacionesArbitro1", bandejaArbitro.getObservaciones());
					}
				}
				bandejaArbitro = new BandejaFirmaArbitraje();
				bandejaArbitro.setCodocumento(thccodocumento);
				bandejaArbitro.setIdtramitehecho(thidTramite);

				for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
					if ("activoarbcons".equals(entry.getKey())) {
						activo = entry.getValue().toString();
						if ("S".equals(activo)) {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codcons".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						} else {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codarbconssupl".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						}
					}
				}
				Arbitro arbitro2 = new Arbitro();
				arbitro2.setArcodigo(bandejaArbitro.getArcodigo());
				arbitro2 = this.arbitroService.find(arbitro2);
				if (null != arbitro2) {
					model.addAttribute("nombreArbitro2", arbitro2.getArnombre());

					List<BandejaFirmaArbitraje> listaArbitro = this.bandejaFirmaArbitrajeService
							.findAllLike(bandejaArbitro, null, false);

					if (!listaArbitro.isEmpty()) {
						bandejaArbitro = listaArbitro.get(0);
						model.addAttribute("estadoArbitro2", bandejaArbitro.getEstado());
						model.addAttribute("observacionesArbitro2", bandejaArbitro.getObservaciones());
					}

				}

				bandejaArbitro = new BandejaFirmaArbitraje();
				bandejaArbitro.setCodocumento(thccodocumento);
				bandejaArbitro.setIdtramitehecho(thidTramite);
				for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
					if ("activoarbemp".equals(entry.getKey())) {
						activo = entry.getValue().toString();
						if ("S".equals(activo)) {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codarbemp".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						} else {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codarbempsupl".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						}
					}
				}

				Arbitro arbitro3 = new Arbitro();
				arbitro3.setArcodigo(bandejaArbitro.getArcodigo());
				arbitro3 = this.arbitroService.find(arbitro3);
				if (null != arbitro3) {
					model.addAttribute("nombreArbitro3", arbitro3.getArnombre());

					List<BandejaFirmaArbitraje> listaArbitro = this.bandejaFirmaArbitrajeService
							.findAllLike(bandejaArbitro, null, false);

					if (!listaArbitro.isEmpty()) {
						bandejaArbitro = listaArbitro.get(0);
						model.addAttribute("estadoArbitro3", bandejaArbitro.getEstado());
						model.addAttribute("observacionesArbitro3", bandejaArbitro.getObservaciones());
					}

				}
			} else {
				for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
					if ("activopresi".equals(entry.getKey())) {
						activo = entry.getValue().toString();
						if ("S".equals(activo)) {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codpresi".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						} else {
							for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral.entrySet()) {
								if ("codpresisupl".equals(entry2.getKey())) {
									bandejaArbitro.setArcodigo(entry2.getValue().toString());
								}
							}
						}
					}
				}
				Arbitro arbitro1 = new Arbitro();
				arbitro1.setArcodigo(bandejaArbitro.getArcodigo());
				arbitro1 = this.arbitroService.find(arbitro1);
				if (null != arbitro1) {
					model.addAttribute("nombreArbitro1", arbitro1.getArnombre());

					List<BandejaFirmaArbitraje> listaArbitro = this.bandejaFirmaArbitrajeService
							.findAllLike(bandejaArbitro, null, false);

					if (!listaArbitro.isEmpty()) {
						bandejaArbitro = listaArbitro.get(0);
						model.addAttribute("estadoArbitro1", bandejaArbitro.getEstado());
						model.addAttribute("observacionesArbitro1", bandejaArbitro.getObservaciones());
					}

				}
			}
		}

		bandeja = new BandejaFirmaArbitraje();
		bandeja.setCodocumento(thccodocumento);
		bandeja.setIdtramitehecho(thidTramite);

		List<BandejaFirmaArbitraje> listaFirmasEstado = this.bandejaFirmaArbitrajeService.findAllLikeEstado(bandeja,
				null, false);

		if (!listaFirmasEstado.isEmpty()) {
			model.addAttribute("estadoResponsable", "F");
		} else {
			model.addAttribute("estadoResponsable", "P");
		}

		return new ModelAndView("firmasArbitros", "model", model);
	}
}
